/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.emr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.emr.CfnInstanceGroupConfig;
import software.amazon.awscdk.services.emr.CfnInstanceGroupConfigProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig")
public class CfnInstanceGroupConfig
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInstanceGroupConfig.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInstanceGroupConfig(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstanceGroupConfig(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInstanceGroupConfig(@NotNull Construct scope, @NotNull String id, @NotNull CfnInstanceGroupConfigProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Number getInstanceCount() {
        return (Number)Kernel.get((Object)this, (String)"instanceCount", (NativeType)NativeType.forClass(Number.class));
    }

    public void setInstanceCount(@NotNull Number value) {
        Kernel.set((Object)this, (String)"instanceCount", (Object)Objects.requireNonNull(value, "instanceCount is required"));
    }

    @NotNull
    public String getInstanceRole() {
        return (String)Kernel.get((Object)this, (String)"instanceRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceRole", (Object)Objects.requireNonNull(value, "instanceRole is required"));
    }

    @NotNull
    public String getInstanceType() {
        return (String)Kernel.get((Object)this, (String)"instanceType", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceType(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceType", (Object)Objects.requireNonNull(value, "instanceType is required"));
    }

    @NotNull
    public String getJobFlowId() {
        return (String)Kernel.get((Object)this, (String)"jobFlowId", (NativeType)NativeType.forClass(String.class));
    }

    public void setJobFlowId(@NotNull String value) {
        Kernel.set((Object)this, (String)"jobFlowId", (Object)Objects.requireNonNull(value, "jobFlowId is required"));
    }

    @Nullable
    public Object getAutoScalingPolicy() {
        return Kernel.get((Object)this, (String)"autoScalingPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoScalingPolicy(@Nullable AutoScalingPolicyProperty value) {
        Kernel.set((Object)this, (String)"autoScalingPolicy", (Object)value);
    }

    public void setAutoScalingPolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoScalingPolicy", (Object)value);
    }

    @Nullable
    public String getBidPrice() {
        return (String)Kernel.get((Object)this, (String)"bidPrice", (NativeType)NativeType.forClass(String.class));
    }

    public void setBidPrice(@Nullable String value) {
        Kernel.set((Object)this, (String)"bidPrice", (Object)value);
    }

    @Nullable
    public Object getConfigurations() {
        return Kernel.get((Object)this, (String)"configurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"configurations", (Object)value);
    }

    public void setConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"configurations", value);
    }

    @Nullable
    public String getCustomAmiId() {
        return (String)Kernel.get((Object)this, (String)"customAmiId", (NativeType)NativeType.forClass(String.class));
    }

    public void setCustomAmiId(@Nullable String value) {
        Kernel.set((Object)this, (String)"customAmiId", (Object)value);
    }

    @Nullable
    public Object getEbsConfiguration() {
        return Kernel.get((Object)this, (String)"ebsConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEbsConfiguration(@Nullable EbsConfigurationProperty value) {
        Kernel.set((Object)this, (String)"ebsConfiguration", (Object)value);
    }

    public void setEbsConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ebsConfiguration", (Object)value);
    }

    @Nullable
    public String getMarket() {
        return (String)Kernel.get((Object)this, (String)"market", (NativeType)NativeType.forClass(String.class));
    }

    public void setMarket(@Nullable String value) {
        Kernel.set((Object)this, (String)"market", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInstanceGroupConfig> {
        private final Construct scope;
        private final String id;
        private final CfnInstanceGroupConfigProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInstanceGroupConfigProps.Builder();
        }

        public Builder instanceCount(Number instanceCount) {
            this.props.instanceCount(instanceCount);
            return this;
        }

        public Builder instanceRole(String instanceRole) {
            this.props.instanceRole(instanceRole);
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder jobFlowId(String jobFlowId) {
            this.props.jobFlowId(jobFlowId);
            return this;
        }

        public Builder autoScalingPolicy(AutoScalingPolicyProperty autoScalingPolicy) {
            this.props.autoScalingPolicy(autoScalingPolicy);
            return this;
        }

        public Builder autoScalingPolicy(IResolvable autoScalingPolicy) {
            this.props.autoScalingPolicy(autoScalingPolicy);
            return this;
        }

        public Builder bidPrice(String bidPrice) {
            this.props.bidPrice(bidPrice);
            return this;
        }

        public Builder configurations(IResolvable configurations) {
            this.props.configurations(configurations);
            return this;
        }

        public Builder configurations(List<? extends Object> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        public Builder customAmiId(String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
            this.props.ebsConfiguration(ebsConfiguration);
            return this;
        }

        public Builder ebsConfiguration(IResolvable ebsConfiguration) {
            this.props.ebsConfiguration(ebsConfiguration);
            return this;
        }

        public Builder market(String market) {
            this.props.market(market);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public CfnInstanceGroupConfig build() {
            return new CfnInstanceGroupConfig(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSizeInGb();

        @NotNull
        public String getVolumeType();

        @Nullable
        default public Number getIops() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            Number sizeInGb;
            String volumeType;
            Number iops;

            public Builder sizeInGb(Number sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public VolumeSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SimpleScalingPolicyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getScalingAdjustment();

        @Nullable
        default public String getAdjustmentType() {
            return null;
        }

        @Nullable
        default public Number getCoolDown() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SimpleScalingPolicyConfigurationProperty> {
            Number scalingAdjustment;
            String adjustmentType;
            Number coolDown;

            public Builder scalingAdjustment(Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            public Builder adjustmentType(String adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            public Builder coolDown(Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingTriggerProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCloudWatchAlarmDefinition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingTriggerProperty> {
            Object cloudWatchAlarmDefinition;

            public Builder cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            public Builder cloudWatchAlarmDefinition(IResolvable cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            public ScalingTriggerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAction();

        @NotNull
        public String getName();

        @NotNull
        public Object getTrigger();

        @Nullable
        default public String getDescription() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingRuleProperty> {
            Object action;
            String name;
            Object trigger;
            String description;

            public Builder action(ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            public Builder action(IResolvable action) {
                this.action = action;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder trigger(ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            public Builder trigger(IResolvable trigger) {
                this.trigger = trigger;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public ScalingRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingConstraintsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxCapacity();

        @NotNull
        public Number getMinCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingConstraintsProperty> {
            Number maxCapacity;
            Number minCapacity;

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder minCapacity(Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            public ScalingConstraintsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSimpleScalingPolicyConfiguration();

        @Nullable
        default public String getMarket() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingActionProperty> {
            Object simpleScalingPolicyConfiguration;
            String market;

            public Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            public Builder simpleScalingPolicyConfiguration(IResolvable simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            public Builder market(String market) {
                this.market = market;
                return this;
            }

            public ScalingActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.MetricDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDimensionProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MetricDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEbsBlockDeviceConfigs() {
            return null;
        }

        @Nullable
        default public Object getEbsOptimized() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            Object ebsBlockDeviceConfigs;
            Object ebsOptimized;

            public Builder ebsBlockDeviceConfigs(IResolvable ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsBlockDeviceConfigs(List<? extends Object> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public EbsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsBlockDeviceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getVolumeSpecification();

        @Nullable
        default public Number getVolumesPerInstance() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            Object volumeSpecification;
            Number volumesPerInstance;

            public Builder volumeSpecification(VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumeSpecification(IResolvable volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumesPerInstance(Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            public EbsBlockDeviceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClassification() {
            return null;
        }

        @Nullable
        default public Object getConfigurationProperties() {
            return null;
        }

        @Nullable
        default public Object getConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationProperty> {
            String classification;
            Object configurationProperties;
            Object configurations;

            public Builder classification(String classification) {
                this.classification = classification;
                return this;
            }

            public Builder configurationProperties(IResolvable configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            public Builder configurationProperties(Map<String, String> configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            public Builder configurations(IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder configurations(List<? extends Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            public ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchAlarmDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparisonOperator();

        @NotNull
        public String getMetricName();

        @NotNull
        public Number getPeriod();

        @NotNull
        public Number getThreshold();

        @Nullable
        default public Object getDimensions() {
            return null;
        }

        @Nullable
        default public Number getEvaluationPeriods() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public String getStatistic() {
            return null;
        }

        @Nullable
        default public String getUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchAlarmDefinitionProperty> {
            String comparisonOperator;
            String metricName;
            Number period;
            Number threshold;
            Object dimensions;
            Number evaluationPeriods;
            String namespace;
            String statistic;
            String unit;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder period(Number period) {
                this.period = period;
                return this;
            }

            public Builder threshold(Number threshold) {
                this.threshold = threshold;
                return this;
            }

            public Builder dimensions(IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder dimensions(List<? extends Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder evaluationPeriods(Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder statistic(String statistic) {
                this.statistic = statistic;
                return this;
            }

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConstraints();

        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            Object constraints;
            Object rules;

            public Builder constraints(ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder constraints(IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public AutoScalingPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

