/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticsearch;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.SecretValue;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions;
import software.amazon.awscdk.services.elasticsearch.CapacityConfig;
import software.amazon.awscdk.services.elasticsearch.CognitoOptions;
import software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions;
import software.amazon.awscdk.services.elasticsearch.DomainAttributes;
import software.amazon.awscdk.services.elasticsearch.DomainProps;
import software.amazon.awscdk.services.elasticsearch.EbsOptions;
import software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion;
import software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions;
import software.amazon.awscdk.services.elasticsearch.IDomain;
import software.amazon.awscdk.services.elasticsearch.LoggingOptions;
import software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy;
import software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticsearch.Domain")
public class Domain
extends Resource
implements IDomain,
IConnectable {
    protected Domain(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Domain(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Domain(@NotNull Construct scope, @NotNull String id, @NotNull DomainProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDomain fromDomainAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DomainAttributes attrs) {
        return (IDomain)JsiiObject.jsiiStaticCall(Domain.class, (String)"fromDomainAttributes", (NativeType)NativeType.forClass(IDomain.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IDomain fromDomainEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull String domainEndpoint) {
        return (IDomain)JsiiObject.jsiiStaticCall(Domain.class, (String)"fromDomainEndpoint", (NativeType)NativeType.forClass(IDomain.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(domainEndpoint, "domainEndpoint is required")});
    }

    @Override
    @NotNull
    public Grant grantIndexRead(@NotNull String index, @NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantIndexRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(index, "index is required"), Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantIndexReadWrite(@NotNull String index, @NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantIndexReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(index, "index is required"), Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantIndexWrite(@NotNull String index, @NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantIndexWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(index, "index is required"), Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantPathRead(@NotNull String path, @NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPathRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantPathReadWrite(@NotNull String path, @NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPathReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantPathWrite(@NotNull String path, @NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPathWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required"), Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricAutomatedSnapshotFailure(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricAutomatedSnapshotFailure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricAutomatedSnapshotFailure() {
        return (Metric)Kernel.call((Object)this, (String)"metricAutomatedSnapshotFailure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricClusterIndexWritesBlocked(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricClusterIndexWritesBlocked", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricClusterIndexWritesBlocked() {
        return (Metric)Kernel.call((Object)this, (String)"metricClusterIndexWritesBlocked", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricClusterStatusRed(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricClusterStatusRed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricClusterStatusRed() {
        return (Metric)Kernel.call((Object)this, (String)"metricClusterStatusRed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricClusterStatusYellow(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricClusterStatusYellow", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricClusterStatusYellow() {
        return (Metric)Kernel.call((Object)this, (String)"metricClusterStatusYellow", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricCPUUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCPUUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricCPUUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricCPUUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricFreeStorageSpace(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricFreeStorageSpace", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricFreeStorageSpace() {
        return (Metric)Kernel.call((Object)this, (String)"metricFreeStorageSpace", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIndexingLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIndexingLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIndexingLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricIndexingLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricJVMMemoryPressure(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricJVMMemoryPressure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricJVMMemoryPressure() {
        return (Metric)Kernel.call((Object)this, (String)"metricJVMMemoryPressure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricKMSKeyError(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricKMSKeyError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricKMSKeyError() {
        return (Metric)Kernel.call((Object)this, (String)"metricKMSKeyError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricKMSKeyInaccessible(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricKMSKeyInaccessible", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricKMSKeyInaccessible() {
        return (Metric)Kernel.call((Object)this, (String)"metricKMSKeyInaccessible", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricMasterCPUUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricMasterCPUUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricMasterCPUUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricMasterCPUUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricMasterJVMMemoryPressure(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricMasterJVMMemoryPressure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricMasterJVMMemoryPressure() {
        return (Metric)Kernel.call((Object)this, (String)"metricMasterJVMMemoryPressure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNodes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNodes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNodes() {
        return (Metric)Kernel.call((Object)this, (String)"metricNodes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSearchableDocuments(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSearchableDocuments", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSearchableDocuments() {
        return (Metric)Kernel.call((Object)this, (String)"metricSearchableDocuments", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSearchLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSearchLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSearchLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricSearchLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getDomainArn() {
        return (String)Kernel.get((Object)this, (String)"domainArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDomainEndpoint() {
        return (String)Kernel.get((Object)this, (String)"domainEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public ILogGroup getAppLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"appLogGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Nullable
    public ILogGroup getAuditLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"auditLogGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Nullable
    public SecretValue getMasterUserPassword() {
        return (SecretValue)Kernel.get((Object)this, (String)"masterUserPassword", (NativeType)NativeType.forClass(SecretValue.class));
    }

    @Nullable
    public ILogGroup getSlowIndexLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"slowIndexLogGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Nullable
    public ILogGroup getSlowSearchLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"slowSearchLogGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Domain> {
        private final Construct scope;
        private final String id;
        private final DomainProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DomainProps.Builder();
        }

        public Builder version(ElasticsearchVersion version) {
            this.props.version(version);
            return this;
        }

        public Builder accessPolicies(List<? extends PolicyStatement> accessPolicies) {
            this.props.accessPolicies(accessPolicies);
            return this;
        }

        public Builder advancedOptions(Map<String, String> advancedOptions) {
            this.props.advancedOptions(advancedOptions);
            return this;
        }

        public Builder automatedSnapshotStartHour(Number automatedSnapshotStartHour) {
            this.props.automatedSnapshotStartHour(automatedSnapshotStartHour);
            return this;
        }

        public Builder capacity(CapacityConfig capacity) {
            this.props.capacity(capacity);
            return this;
        }

        public Builder cognitoKibanaAuth(CognitoOptions cognitoKibanaAuth) {
            this.props.cognitoKibanaAuth(cognitoKibanaAuth);
            return this;
        }

        public Builder customEndpoint(CustomEndpointOptions customEndpoint) {
            this.props.customEndpoint(customEndpoint);
            return this;
        }

        public Builder domainName(String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder ebs(EbsOptions ebs) {
            this.props.ebs(ebs);
            return this;
        }

        public Builder enableVersionUpgrade(Boolean enableVersionUpgrade) {
            this.props.enableVersionUpgrade(enableVersionUpgrade);
            return this;
        }

        public Builder encryptionAtRest(EncryptionAtRestOptions encryptionAtRest) {
            this.props.encryptionAtRest(encryptionAtRest);
            return this;
        }

        public Builder enforceHttps(Boolean enforceHttps) {
            this.props.enforceHttps(enforceHttps);
            return this;
        }

        public Builder fineGrainedAccessControl(AdvancedSecurityOptions fineGrainedAccessControl) {
            this.props.fineGrainedAccessControl(fineGrainedAccessControl);
            return this;
        }

        public Builder logging(LoggingOptions logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder nodeToNodeEncryption(Boolean nodeToNodeEncryption) {
            this.props.nodeToNodeEncryption(nodeToNodeEncryption);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder tlsSecurityPolicy(TLSSecurityPolicy tlsSecurityPolicy) {
            this.props.tlsSecurityPolicy(tlsSecurityPolicy);
            return this;
        }

        public Builder useUnsignedBasicAuth(Boolean useUnsignedBasicAuth) {
            this.props.useUnsignedBasicAuth(useUnsignedBasicAuth);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder vpcSubnets(List<? extends SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder zoneAwareness(ZoneAwarenessConfig zoneAwareness) {
            this.props.zoneAwareness(zoneAwareness);
            return this;
        }

        public Domain build() {
            return new Domain(this.scope, this.id, this.props.build());
        }
    }
}

