/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codeartifact;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.codeartifact.CfnRepositoryProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codeartifact.CfnRepository")
public class CfnRepository
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRepository.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnRepository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRepository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRepository(@NotNull Construct scope, @NotNull String id, @NotNull CfnRepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDomainName() {
        return (String)Kernel.get((Object)this, (String)"attrDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDomainOwner() {
        return (String)Kernel.get((Object)this, (String)"attrDomainOwner", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainName(@NotNull String value) {
        Kernel.set((Object)this, (String)"domainName", (Object)Objects.requireNonNull(value, "domainName is required"));
    }

    @NotNull
    public Object getPermissionsPolicyDocument() {
        return Kernel.get((Object)this, (String)"permissionsPolicyDocument", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPermissionsPolicyDocument(@NotNull Object value) {
        Kernel.set((Object)this, (String)"permissionsPolicyDocument", (Object)Objects.requireNonNull(value, "permissionsPolicyDocument is required"));
    }

    @NotNull
    public String getRepositoryName() {
        return (String)Kernel.get((Object)this, (String)"repositoryName", (NativeType)NativeType.forClass(String.class));
    }

    public void setRepositoryName(@NotNull String value) {
        Kernel.set((Object)this, (String)"repositoryName", (Object)Objects.requireNonNull(value, "repositoryName is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getDomainOwner() {
        return (String)Kernel.get((Object)this, (String)"domainOwner", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainOwner(@Nullable String value) {
        Kernel.set((Object)this, (String)"domainOwner", (Object)value);
    }

    @Nullable
    public List<String> getExternalConnections() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"externalConnections", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setExternalConnections(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"externalConnections", value);
    }

    @Nullable
    public List<String> getUpstreams() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"upstreams", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setUpstreams(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"upstreams", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnRepository> {
        private final Construct scope;
        private final String id;
        private final CfnRepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnRepositoryProps.Builder();
        }

        public Builder domainName(String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder repositoryName(String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder domainOwner(String domainOwner) {
            this.props.domainOwner(domainOwner);
            return this;
        }

        public Builder externalConnections(List<String> externalConnections) {
            this.props.externalConnections(externalConnections);
            return this;
        }

        public Builder permissionsPolicyDocument(Object permissionsPolicyDocument) {
            this.props.permissionsPolicyDocument(permissionsPolicyDocument);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder upstreams(List<String> upstreams) {
            this.props.upstreams(upstreams);
            return this;
        }

        public CfnRepository build() {
            return new CfnRepository(this.scope, this.id, this.props.build());
        }
    }
}

