/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ecr.CfnRepository;
import software.amazon.awscdk.services.ecr.CfnRepositoryProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecr.CfnRepository")
public class CfnRepository
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRepository.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnRepository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRepository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRepository(@NotNull Construct scope, @NotNull String id, @Nullable CfnRepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnRepository(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrRepositoryUri() {
        return (String)Kernel.get((Object)this, (String)"attrRepositoryUri", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getRepositoryPolicyText() {
        return Kernel.get((Object)this, (String)"repositoryPolicyText", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRepositoryPolicyText(@NotNull Object value) {
        Kernel.set((Object)this, (String)"repositoryPolicyText", (Object)Objects.requireNonNull(value, "repositoryPolicyText is required"));
    }

    @Nullable
    public Object getEncryptionConfiguration() {
        return Kernel.get((Object)this, (String)"encryptionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"encryptionConfiguration", (Object)value);
    }

    public void setEncryptionConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"encryptionConfiguration", (Object)value);
    }

    @Nullable
    public Object getImageScanningConfiguration() {
        return Kernel.get((Object)this, (String)"imageScanningConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setImageScanningConfiguration(@Nullable ImageScanningConfigurationProperty value) {
        Kernel.set((Object)this, (String)"imageScanningConfiguration", (Object)value);
    }

    public void setImageScanningConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"imageScanningConfiguration", (Object)value);
    }

    @Nullable
    public String getImageTagMutability() {
        return (String)Kernel.get((Object)this, (String)"imageTagMutability", (NativeType)NativeType.forClass(String.class));
    }

    public void setImageTagMutability(@Nullable String value) {
        Kernel.set((Object)this, (String)"imageTagMutability", (Object)value);
    }

    @Nullable
    public Object getLifecyclePolicy() {
        return Kernel.get((Object)this, (String)"lifecyclePolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLifecyclePolicy(@Nullable LifecyclePolicyProperty value) {
        Kernel.set((Object)this, (String)"lifecyclePolicy", (Object)value);
    }

    public void setLifecyclePolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lifecyclePolicy", (Object)value);
    }

    @Nullable
    public String getRepositoryName() {
        return (String)Kernel.get((Object)this, (String)"repositoryName", (NativeType)NativeType.forClass(String.class));
    }

    public void setRepositoryName(@Nullable String value) {
        Kernel.set((Object)this, (String)"repositoryName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnRepository> {
        private final Construct scope;
        private final String id;
        private CfnRepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
            this.props().encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
            this.props().encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        public Builder imageScanningConfiguration(ImageScanningConfigurationProperty imageScanningConfiguration) {
            this.props().imageScanningConfiguration(imageScanningConfiguration);
            return this;
        }

        public Builder imageScanningConfiguration(IResolvable imageScanningConfiguration) {
            this.props().imageScanningConfiguration(imageScanningConfiguration);
            return this;
        }

        public Builder imageTagMutability(String imageTagMutability) {
            this.props().imageTagMutability(imageTagMutability);
            return this;
        }

        public Builder lifecyclePolicy(LifecyclePolicyProperty lifecyclePolicy) {
            this.props().lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        public Builder lifecyclePolicy(IResolvable lifecyclePolicy) {
            this.props().lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        public Builder repositoryName(String repositoryName) {
            this.props().repositoryName(repositoryName);
            return this;
        }

        public Builder repositoryPolicyText(Object repositoryPolicyText) {
            this.props().repositoryPolicyText(repositoryPolicyText);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnRepository build() {
            return new CfnRepository(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnRepositoryProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnRepositoryProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecr.CfnRepository.LifecyclePolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecyclePolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLifecyclePolicyText() {
            return null;
        }

        @Nullable
        default public String getRegistryId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecyclePolicyProperty> {
            String lifecyclePolicyText;
            String registryId;

            public Builder lifecyclePolicyText(String lifecyclePolicyText) {
                this.lifecyclePolicyText = lifecyclePolicyText;
                return this;
            }

            public Builder registryId(String registryId) {
                this.registryId = registryId;
                return this;
            }

            public LifecyclePolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecr.CfnRepository.ImageScanningConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImageScanningConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getScanOnPush() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImageScanningConfigurationProperty> {
            Object scanOnPush;

            public Builder scanOnPush(Boolean scanOnPush) {
                this.scanOnPush = scanOnPush;
                return this;
            }

            public Builder scanOnPush(IResolvable scanOnPush) {
                this.scanOnPush = scanOnPush;
                return this;
            }

            public ImageScanningConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecr.CfnRepository.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEncryptionType();

        @Nullable
        default public String getKmsKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            String encryptionType;
            String kmsKey;

            public Builder encryptionType(String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            public Builder kmsKey(String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

