/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.resourcegroups;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.resourcegroups.CfnGroup;
import software.amazon.awscdk.services.resourcegroups.CfnGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_resourcegroups.CfnGroup")
public class CfnGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getConfiguration() {
        return Kernel.get((Object)this, (String)"configuration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"configuration", (Object)value);
    }

    public void setConfiguration(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"configuration", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getResourceQuery() {
        return Kernel.get((Object)this, (String)"resourceQuery", (NativeType)NativeType.forClass(Object.class));
    }

    public void setResourceQuery(@Nullable ResourceQueryProperty value) {
        Kernel.set((Object)this, (String)"resourceQuery", (Object)value);
    }

    public void setResourceQuery(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"resourceQuery", (Object)value);
    }

    @Nullable
    public List<String> getResources() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"resources", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setResources(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"resources", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnGroup> {
        private final Construct scope;
        private final String id;
        private final CfnGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnGroupProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder configuration(IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder configuration(List<? extends Object> configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder resourceQuery(ResourceQueryProperty resourceQuery) {
            this.props.resourceQuery(resourceQuery);
            return this;
        }

        public Builder resourceQuery(IResolvable resourceQuery) {
            this.props.resourceQuery(resourceQuery);
            return this;
        }

        public Builder resources(List<String> resources) {
            this.props.resources(resources);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnGroup build() {
            return new CfnGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_resourcegroups.CfnGroup.TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagFilterProperty> {
            String key;
            List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_resourcegroups.CfnGroup.ResourceQueryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceQueryProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getQuery() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceQueryProperty> {
            Object query;
            String type;

            public Builder query(QueryProperty query) {
                this.query = query;
                return this;
            }

            public Builder query(IResolvable query) {
                this.query = query;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ResourceQueryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_resourcegroups.CfnGroup.QueryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QueryProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getResourceTypeFilters() {
            return null;
        }

        @Nullable
        default public String getStackIdentifier() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<QueryProperty> {
            List<String> resourceTypeFilters;
            String stackIdentifier;
            Object tagFilters;

            public Builder resourceTypeFilters(List<String> resourceTypeFilters) {
                this.resourceTypeFilters = resourceTypeFilters;
                return this;
            }

            public Builder stackIdentifier(String stackIdentifier) {
                this.stackIdentifier = stackIdentifier;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<? extends Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public QueryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_resourcegroups.CfnGroup.ConfigurationParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationParameterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationParameterProperty> {
            String name;
            List<String> values;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public ConfigurationParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_resourcegroups.CfnGroup.ConfigurationItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationItemProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getParameters() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationItemProperty> {
            Object parameters;
            String type;

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(List<? extends Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ConfigurationItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

