package software.amazon.awscdk;

/**
 * A CloudFormation `AWS::CloudFormation::StackSet`.
 * <p>
 * The <code>AWS::CloudFormation::StackSet</code> enables you to provision stacks into AWS accounts and across Regions by using a single CloudFormation template. In the stack set, you specify the template to use, in addition to any parameters and capabilities that the template requires.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Object managedExecution;
 * CfnStackSet cfnStackSet = CfnStackSet.Builder.create(this, "MyCfnStackSet")
 *         .permissionModel("permissionModel")
 *         .stackSetName("stackSetName")
 *         // the properties below are optional
 *         .administrationRoleArn("administrationRoleArn")
 *         .autoDeployment(AutoDeploymentProperty.builder()
 *                 .enabled(false)
 *                 .retainStacksOnAccountRemoval(false)
 *                 .build())
 *         .callAs("callAs")
 *         .capabilities(List.of("capabilities"))
 *         .description("description")
 *         .executionRoleName("executionRoleName")
 *         .managedExecution(managedExecution)
 *         .operationPreferences(OperationPreferencesProperty.builder()
 *                 .failureToleranceCount(123)
 *                 .failureTolerancePercentage(123)
 *                 .maxConcurrentCount(123)
 *                 .maxConcurrentPercentage(123)
 *                 .regionConcurrencyType("regionConcurrencyType")
 *                 .regionOrder(List.of("regionOrder"))
 *                 .build())
 *         .parameters(List.of(ParameterProperty.builder()
 *                 .parameterKey("parameterKey")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .stackInstancesGroup(List.of(StackInstancesProperty.builder()
 *                 .deploymentTargets(DeploymentTargetsProperty.builder()
 *                         .accountFilterType("accountFilterType")
 *                         .accounts(List.of("accounts"))
 *                         .organizationalUnitIds(List.of("organizationalUnitIds"))
 *                         .build())
 *                 .regions(List.of("regions"))
 *                 // the properties below are optional
 *                 .parameterOverrides(List.of(ParameterProperty.builder()
 *                         .parameterKey("parameterKey")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .templateBody("templateBody")
 *         .templateUrl("templateUrl")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:34:59.748Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnStackSet")
public class CfnStackSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnStackSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStackSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.CfnStackSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFormation::StackSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStackSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnStackSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the stack that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStackSetId() {
        return software.amazon.jsii.Kernel.get(this, "attrStackSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The key-value pairs to associate with this stack set and the stacks created from it.
     * <p>
     * AWS CloudFormation also propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * <p>
     * When active, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
     * <p>
     * <blockquote>
     * <p>
     * If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
     * <p>
     * You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.
     * <p>
     * </blockquote>
     * <p>
     * When inactive (default), StackSets performs one operation at a time in request order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getManagedExecution() {
        return software.amazon.jsii.Kernel.get(this, "managedExecution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * <p>
     * When active, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
     * <p>
     * <blockquote>
     * <p>
     * If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
     * <p>
     * You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.
     * <p>
     * </blockquote>
     * <p>
     * When inactive (default), StackSets performs one operation at a time in request order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedExecution(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "managedExecution", java.util.Objects.requireNonNull(value, "managedExecution is required"));
    }

    /**
     * Describes how the IAM roles required for stack set operations are created.
     * <p>
     * <ul>
     * <li>With <code>SELF_MANAGED</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a> .</li>
     * <li>With <code>SERVICE_MANAGED</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations . For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a> .</li>
     * </ul>
     * <p>
     * <em>Allowed Values</em> : <code>SERVICE_MANAGED</code> | <code>SELF_MANAGED</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>PermissionModel</code> property is required.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPermissionModel() {
        return software.amazon.jsii.Kernel.get(this, "permissionModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Describes how the IAM roles required for stack set operations are created.
     * <p>
     * <ul>
     * <li>With <code>SELF_MANAGED</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a> .</li>
     * <li>With <code>SERVICE_MANAGED</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations . For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a> .</li>
     * </ul>
     * <p>
     * <em>Allowed Values</em> : <code>SERVICE_MANAGED</code> | <code>SELF_MANAGED</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>PermissionModel</code> property is required.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionModel(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "permissionModel", java.util.Objects.requireNonNull(value, "permissionModel is required"));
    }

    /**
     * The name to associate with the stack set.
     * <p>
     * The name must be unique in the Region where you create your stack set.
     * <p>
     * <em>Maximum</em> : <code>128</code>
     * <p>
     * <em>Pattern</em> : <code>^[a-zA-Z][a-zA-Z0-9-]{0,127}$</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>StackSetName</code> property is required.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackSetName() {
        return software.amazon.jsii.Kernel.get(this, "stackSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name to associate with the stack set.
     * <p>
     * The name must be unique in the Region where you create your stack set.
     * <p>
     * <em>Maximum</em> : <code>128</code>
     * <p>
     * <em>Pattern</em> : <code>^[a-zA-Z][a-zA-Z0-9-]{0,127}$</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>StackSetName</code> property is required.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStackSetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stackSetName", java.util.Objects.requireNonNull(value, "stackSetName is required"));
    }

    /**
     * The Amazon Resource Number (ARN) of the IAM role to use to create this stack set.
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account.
     * <p>
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <em>Minimum</em> : <code>20</code>
     * <p>
     * <em>Maximum</em> : <code>2048</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAdministrationRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "administrationRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Number (ARN) of the IAM role to use to create this stack set.
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account.
     * <p>
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <em>Minimum</em> : <code>20</code>
     * <p>
     * <em>Maximum</em> : <code>2048</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdministrationRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "administrationRoleArn", value);
    }

    /**
     * [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoDeployment() {
        return software.amazon.jsii.Kernel.get(this, "autoDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoDeployment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoDeployment", value);
    }

    /**
     * [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoDeployment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnStackSet.AutoDeploymentProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoDeployment", value);
    }

    /**
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * <p>
     * <ul>
     * <li>To create a stack set with service-managed permissions while signed in to the management account, specify <code>SELF</code> .</li>
     * <li>To create a stack set with service-managed permissions while signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code> .</li>
     * </ul>
     * <p>
     * Your AWS account must be registered as a delegated admin in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are created by delegated administrators.
     * <p>
     * <em>Valid Values</em> : <code>SELF</code> | <code>DELEGATED_ADMIN</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCallAs() {
        return software.amazon.jsii.Kernel.get(this, "callAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * <p>
     * <ul>
     * <li>To create a stack set with service-managed permissions while signed in to the management account, specify <code>SELF</code> .</li>
     * <li>To create a stack set with service-managed permissions while signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code> .</li>
     * </ul>
     * <p>
     * Your AWS account must be registered as a delegated admin in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are created by delegated administrators.
     * <p>
     * <em>Valid Values</em> : <code>SELF</code> | <code>DELEGATED_ADMIN</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCallAs(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "callAs", value);
    }

    /**
     * The capabilities that are allowed in the stack set.
     * <p>
     * Some stack set templates might include resources that can affect permissions in your AWS account —for example, by creating new AWS Identity and Access Management ( IAM ) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCapabilities() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "capabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The capabilities that are allowed in the stack set.
     * <p>
     * Some stack set templates might include resources that can affect permissions in your AWS account —for example, by creating new AWS Identity and Access Management ( IAM ) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapabilities(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "capabilities", value);
    }

    /**
     * A description of the stack set.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>1024</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the stack set.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>1024</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the IAM execution role to use to create the stack set.
     * <p>
     * If you don't specify an execution role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>64</code>
     * <p>
     * <em>Pattern</em> : <code>[a-zA-Z_0-9+=,.&#64;-]+</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleName() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the IAM execution role to use to create the stack set.
     * <p>
     * If you don't specify an execution role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>64</code>
     * <p>
     * <em>Pattern</em> : <code>[a-zA-Z_0-9+=,.&#64;-]+</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleName", value);
    }

    /**
     * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOperationPreferences() {
        return software.amazon.jsii.Kernel.get(this, "operationPreferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperationPreferences(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "operationPreferences", value);
    }

    /**
     * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperationPreferences(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnStackSet.OperationPreferencesProperty value) {
        software.amazon.jsii.Kernel.set(this, "operationPreferences", value);
    }

    /**
     * The input parameters for the stack set template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The input parameters for the stack set template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The input parameters for the stack set template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnStackSet.ParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnStackSet.ParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A group of stack instances with parameters in some specific accounts and Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStackInstancesGroup() {
        return software.amazon.jsii.Kernel.get(this, "stackInstancesGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A group of stack instances with parameters in some specific accounts and Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStackInstancesGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stackInstancesGroup", value);
    }

    /**
     * A group of stack instances with parameters in some specific accounts and Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStackInstancesGroup(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnStackSet.StackInstancesProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnStackSet.StackInstancesProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "stackInstancesGroup", value);
    }

    /**
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     * <p>
     * You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both. Dynamic references in the <code>TemplateBody</code> may not work correctly in all cases. It's recommended to pass templates containing dynamic references through <code>TemplateUrl</code> instead.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>51200</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateBody() {
        return software.amazon.jsii.Kernel.get(this, "templateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     * <p>
     * You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both. Dynamic references in the <code>TemplateBody</code> may not work correctly in all cases. It's recommended to pass templates containing dynamic references through <code>TemplateUrl</code> instead.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>51200</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateBody(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateBody", value);
    }

    /**
     * Location of file containing the template body.
     * <p>
     * The URL must point to a template (max size: 460,800 bytes) that's located in an Amazon S3 bucket.
     * <p>
     * You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>1024</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateUrl() {
        return software.amazon.jsii.Kernel.get(this, "templateUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Location of file containing the template body.
     * <p>
     * The URL must point to a template (max size: 460,800 bytes) that's located in an Amazon S3 bucket.
     * <p>
     * You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>1024</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateUrl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateUrl", value);
    }
    /**
     * [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organizational unit (OU).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * AutoDeploymentProperty autoDeploymentProperty = AutoDeploymentProperty.builder()
     *         .enabled(false)
     *         .retainStacksOnAccountRemoval(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnStackSet.AutoDeploymentProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoDeploymentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoDeploymentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If set to `true` , StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions.
         * <p>
         * If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * If set to `true` , stack resources are retained when an account is removed from a target organization or OU.
         * <p>
         * If set to <code>false</code> , stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetainStacksOnAccountRemoval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoDeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoDeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoDeploymentProperty> {
            java.lang.Object enabled;
            java.lang.Object retainStacksOnAccountRemoval;

            /**
             * Sets the value of {@link AutoDeploymentProperty#getEnabled}
             * @param enabled If set to `true` , StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions.
             *                If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoDeploymentProperty#getEnabled}
             * @param enabled If set to `true` , StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions.
             *                If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoDeploymentProperty#getRetainStacksOnAccountRemoval}
             * @param retainStacksOnAccountRemoval If set to `true` , stack resources are retained when an account is removed from a target organization or OU.
             *                                     If set to <code>false</code> , stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainStacksOnAccountRemoval(java.lang.Boolean retainStacksOnAccountRemoval) {
                this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
                return this;
            }

            /**
             * Sets the value of {@link AutoDeploymentProperty#getRetainStacksOnAccountRemoval}
             * @param retainStacksOnAccountRemoval If set to `true` , stack resources are retained when an account is removed from a target organization or OU.
             *                                     If set to <code>false</code> , stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainStacksOnAccountRemoval(software.amazon.awscdk.IResolvable retainStacksOnAccountRemoval) {
                this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoDeploymentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoDeploymentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoDeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoDeploymentProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object retainStacksOnAccountRemoval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retainStacksOnAccountRemoval = software.amazon.jsii.Kernel.get(this, "retainStacksOnAccountRemoval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.retainStacksOnAccountRemoval = builder.retainStacksOnAccountRemoval;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getRetainStacksOnAccountRemoval() {
                return this.retainStacksOnAccountRemoval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getRetainStacksOnAccountRemoval() != null) {
                    data.set("retainStacksOnAccountRemoval", om.valueToTree(this.getRetainStacksOnAccountRemoval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnStackSet.AutoDeploymentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoDeploymentProperty.Jsii$Proxy that = (AutoDeploymentProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.retainStacksOnAccountRemoval != null ? this.retainStacksOnAccountRemoval.equals(that.retainStacksOnAccountRemoval) : that.retainStacksOnAccountRemoval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.retainStacksOnAccountRemoval != null ? this.retainStacksOnAccountRemoval.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The AWS OrganizationalUnitIds or Accounts for which to create stack instances in the specified Regions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * DeploymentTargetsProperty deploymentTargetsProperty = DeploymentTargetsProperty.builder()
     *         .accountFilterType("accountFilterType")
     *         .accounts(List.of("accounts"))
     *         .organizationalUnitIds(List.of("organizationalUnitIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnStackSet.DeploymentTargetsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentTargetsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentTargetsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStackSet.DeploymentTargetsProperty.AccountFilterType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountFilterType() {
            return null;
        }

        /**
         * The names of one or more AWS accounts for which you want to deploy stack set updates.
         * <p>
         * <em>Pattern</em> : <code>^[0-9]{12}$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAccounts() {
            return null;
        }

        /**
         * The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
         * <p>
         * <em>Pattern</em> : <code>^(ou-[a-z0-9]{4,32}-[a-z0-9]{8,32}|r-[a-z0-9]{4,32})$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationalUnitIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentTargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentTargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentTargetsProperty> {
            java.lang.String accountFilterType;
            java.util.List<java.lang.String> accounts;
            java.util.List<java.lang.String> organizationalUnitIds;

            /**
             * Sets the value of {@link DeploymentTargetsProperty#getAccountFilterType}
             * @param accountFilterType `CfnStackSet.DeploymentTargetsProperty.AccountFilterType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountFilterType(java.lang.String accountFilterType) {
                this.accountFilterType = accountFilterType;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentTargetsProperty#getAccounts}
             * @param accounts The names of one or more AWS accounts for which you want to deploy stack set updates.
             *                 <em>Pattern</em> : <code>^[0-9]{12}$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accounts(java.util.List<java.lang.String> accounts) {
                this.accounts = accounts;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentTargetsProperty#getOrganizationalUnitIds}
             * @param organizationalUnitIds The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
             *                              <em>Pattern</em> : <code>^(ou-[a-z0-9]{4,32}-[a-z0-9]{8,32}|r-[a-z0-9]{4,32})$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnitIds(java.util.List<java.lang.String> organizationalUnitIds) {
                this.organizationalUnitIds = organizationalUnitIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentTargetsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentTargetsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentTargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentTargetsProperty {
            private final java.lang.String accountFilterType;
            private final java.util.List<java.lang.String> accounts;
            private final java.util.List<java.lang.String> organizationalUnitIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountFilterType = software.amazon.jsii.Kernel.get(this, "accountFilterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accounts = software.amazon.jsii.Kernel.get(this, "accounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.organizationalUnitIds = software.amazon.jsii.Kernel.get(this, "organizationalUnitIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountFilterType = builder.accountFilterType;
                this.accounts = builder.accounts;
                this.organizationalUnitIds = builder.organizationalUnitIds;
            }

            @Override
            public final java.lang.String getAccountFilterType() {
                return this.accountFilterType;
            }

            @Override
            public final java.util.List<java.lang.String> getAccounts() {
                return this.accounts;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationalUnitIds() {
                return this.organizationalUnitIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccountFilterType() != null) {
                    data.set("accountFilterType", om.valueToTree(this.getAccountFilterType()));
                }
                if (this.getAccounts() != null) {
                    data.set("accounts", om.valueToTree(this.getAccounts()));
                }
                if (this.getOrganizationalUnitIds() != null) {
                    data.set("organizationalUnitIds", om.valueToTree(this.getOrganizationalUnitIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnStackSet.DeploymentTargetsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentTargetsProperty.Jsii$Proxy that = (DeploymentTargetsProperty.Jsii$Proxy) o;

                if (this.accountFilterType != null ? !this.accountFilterType.equals(that.accountFilterType) : that.accountFilterType != null) return false;
                if (this.accounts != null ? !this.accounts.equals(that.accounts) : that.accounts != null) return false;
                return this.organizationalUnitIds != null ? this.organizationalUnitIds.equals(that.organizationalUnitIds) : that.organizationalUnitIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountFilterType != null ? this.accountFilterType.hashCode() : 0;
                result = 31 * result + (this.accounts != null ? this.accounts.hashCode() : 0);
                result = 31 * result + (this.organizationalUnitIds != null ? this.organizationalUnitIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
     * <p>
     * For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * OperationPreferencesProperty operationPreferencesProperty = OperationPreferencesProperty.builder()
     *         .failureToleranceCount(123)
     *         .failureTolerancePercentage(123)
     *         .maxConcurrentCount(123)
     *         .maxConcurrentPercentage(123)
     *         .regionConcurrencyType("regionConcurrencyType")
     *         .regionOrder(List.of("regionOrder"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnStackSet.OperationPreferencesProperty")
    @software.amazon.jsii.Jsii.Proxy(OperationPreferencesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OperationPreferencesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
         * <p>
         * If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.
         * <p>
         * Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFailureToleranceCount() {
            return null;
        }

        /**
         * The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
         * <p>
         * If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds <em>down</em> to the next whole number.
         * <p>
         * Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> , but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFailureTolerancePercentage() {
            return null;
        }

        /**
         * The maximum number of accounts in which to perform this operation at one time.
         * <p>
         * This is dependent on the value of <code>FailureToleranceCount</code> . <code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code> .
         * <p>
         * Note that this setting lets you specify the <em>maximum</em> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         * <p>
         * Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code> , but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentCount() {
            return null;
        }

        /**
         * The maximum percentage of accounts in which to perform this operation at one time.
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.
         * <p>
         * Note that this setting lets you specify the <em>maximum</em> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         * <p>
         * Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code> , but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentPercentage() {
            return null;
        }

        /**
         * The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
         * <p>
         * <em>Allowed values</em> : <code>SEQUENTIAL</code> | <code>PARALLEL</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegionConcurrencyType() {
            return null;
        }

        /**
         * The order of the Regions where you want to perform the stack operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegionOrder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OperationPreferencesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OperationPreferencesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OperationPreferencesProperty> {
            java.lang.Number failureToleranceCount;
            java.lang.Number failureTolerancePercentage;
            java.lang.Number maxConcurrentCount;
            java.lang.Number maxConcurrentPercentage;
            java.lang.String regionConcurrencyType;
            java.util.List<java.lang.String> regionOrder;

            /**
             * Sets the value of {@link OperationPreferencesProperty#getFailureToleranceCount}
             * @param failureToleranceCount The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
             *                              If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.
             *                              <p>
             *                              Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureToleranceCount(java.lang.Number failureToleranceCount) {
                this.failureToleranceCount = failureToleranceCount;
                return this;
            }

            /**
             * Sets the value of {@link OperationPreferencesProperty#getFailureTolerancePercentage}
             * @param failureTolerancePercentage The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
             *                                   If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.
             *                                   <p>
             *                                   When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds <em>down</em> to the next whole number.
             *                                   <p>
             *                                   Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureTolerancePercentage(java.lang.Number failureTolerancePercentage) {
                this.failureTolerancePercentage = failureTolerancePercentage;
                return this;
            }

            /**
             * Sets the value of {@link OperationPreferencesProperty#getMaxConcurrentCount}
             * @param maxConcurrentCount The maximum number of accounts in which to perform this operation at one time.
             *                           This is dependent on the value of <code>FailureToleranceCount</code> . <code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code> .
             *                           <p>
             *                           Note that this setting lets you specify the <em>maximum</em> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
             *                           <p>
             *                           Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentCount(java.lang.Number maxConcurrentCount) {
                this.maxConcurrentCount = maxConcurrentCount;
                return this;
            }

            /**
             * Sets the value of {@link OperationPreferencesProperty#getMaxConcurrentPercentage}
             * @param maxConcurrentPercentage The maximum percentage of accounts in which to perform this operation at one time.
             *                                When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.
             *                                <p>
             *                                Note that this setting lets you specify the <em>maximum</em> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
             *                                <p>
             *                                Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentPercentage(java.lang.Number maxConcurrentPercentage) {
                this.maxConcurrentPercentage = maxConcurrentPercentage;
                return this;
            }

            /**
             * Sets the value of {@link OperationPreferencesProperty#getRegionConcurrencyType}
             * @param regionConcurrencyType The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
             *                              <em>Allowed values</em> : <code>SEQUENTIAL</code> | <code>PARALLEL</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionConcurrencyType(java.lang.String regionConcurrencyType) {
                this.regionConcurrencyType = regionConcurrencyType;
                return this;
            }

            /**
             * Sets the value of {@link OperationPreferencesProperty#getRegionOrder}
             * @param regionOrder The order of the Regions where you want to perform the stack operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionOrder(java.util.List<java.lang.String> regionOrder) {
                this.regionOrder = regionOrder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OperationPreferencesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OperationPreferencesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OperationPreferencesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OperationPreferencesProperty {
            private final java.lang.Number failureToleranceCount;
            private final java.lang.Number failureTolerancePercentage;
            private final java.lang.Number maxConcurrentCount;
            private final java.lang.Number maxConcurrentPercentage;
            private final java.lang.String regionConcurrencyType;
            private final java.util.List<java.lang.String> regionOrder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureToleranceCount = software.amazon.jsii.Kernel.get(this, "failureToleranceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.failureTolerancePercentage = software.amazon.jsii.Kernel.get(this, "failureTolerancePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxConcurrentCount = software.amazon.jsii.Kernel.get(this, "maxConcurrentCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxConcurrentPercentage = software.amazon.jsii.Kernel.get(this, "maxConcurrentPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.regionConcurrencyType = software.amazon.jsii.Kernel.get(this, "regionConcurrencyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.regionOrder = software.amazon.jsii.Kernel.get(this, "regionOrder", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureToleranceCount = builder.failureToleranceCount;
                this.failureTolerancePercentage = builder.failureTolerancePercentage;
                this.maxConcurrentCount = builder.maxConcurrentCount;
                this.maxConcurrentPercentage = builder.maxConcurrentPercentage;
                this.regionConcurrencyType = builder.regionConcurrencyType;
                this.regionOrder = builder.regionOrder;
            }

            @Override
            public final java.lang.Number getFailureToleranceCount() {
                return this.failureToleranceCount;
            }

            @Override
            public final java.lang.Number getFailureTolerancePercentage() {
                return this.failureTolerancePercentage;
            }

            @Override
            public final java.lang.Number getMaxConcurrentCount() {
                return this.maxConcurrentCount;
            }

            @Override
            public final java.lang.Number getMaxConcurrentPercentage() {
                return this.maxConcurrentPercentage;
            }

            @Override
            public final java.lang.String getRegionConcurrencyType() {
                return this.regionConcurrencyType;
            }

            @Override
            public final java.util.List<java.lang.String> getRegionOrder() {
                return this.regionOrder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureToleranceCount() != null) {
                    data.set("failureToleranceCount", om.valueToTree(this.getFailureToleranceCount()));
                }
                if (this.getFailureTolerancePercentage() != null) {
                    data.set("failureTolerancePercentage", om.valueToTree(this.getFailureTolerancePercentage()));
                }
                if (this.getMaxConcurrentCount() != null) {
                    data.set("maxConcurrentCount", om.valueToTree(this.getMaxConcurrentCount()));
                }
                if (this.getMaxConcurrentPercentage() != null) {
                    data.set("maxConcurrentPercentage", om.valueToTree(this.getMaxConcurrentPercentage()));
                }
                if (this.getRegionConcurrencyType() != null) {
                    data.set("regionConcurrencyType", om.valueToTree(this.getRegionConcurrencyType()));
                }
                if (this.getRegionOrder() != null) {
                    data.set("regionOrder", om.valueToTree(this.getRegionOrder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnStackSet.OperationPreferencesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OperationPreferencesProperty.Jsii$Proxy that = (OperationPreferencesProperty.Jsii$Proxy) o;

                if (this.failureToleranceCount != null ? !this.failureToleranceCount.equals(that.failureToleranceCount) : that.failureToleranceCount != null) return false;
                if (this.failureTolerancePercentage != null ? !this.failureTolerancePercentage.equals(that.failureTolerancePercentage) : that.failureTolerancePercentage != null) return false;
                if (this.maxConcurrentCount != null ? !this.maxConcurrentCount.equals(that.maxConcurrentCount) : that.maxConcurrentCount != null) return false;
                if (this.maxConcurrentPercentage != null ? !this.maxConcurrentPercentage.equals(that.maxConcurrentPercentage) : that.maxConcurrentPercentage != null) return false;
                if (this.regionConcurrencyType != null ? !this.regionConcurrencyType.equals(that.regionConcurrencyType) : that.regionConcurrencyType != null) return false;
                return this.regionOrder != null ? this.regionOrder.equals(that.regionOrder) : that.regionOrder == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureToleranceCount != null ? this.failureToleranceCount.hashCode() : 0;
                result = 31 * result + (this.failureTolerancePercentage != null ? this.failureTolerancePercentage.hashCode() : 0);
                result = 31 * result + (this.maxConcurrentCount != null ? this.maxConcurrentCount.hashCode() : 0);
                result = 31 * result + (this.maxConcurrentPercentage != null ? this.maxConcurrentPercentage.hashCode() : 0);
                result = 31 * result + (this.regionConcurrencyType != null ? this.regionConcurrencyType.hashCode() : 0);
                result = 31 * result + (this.regionOrder != null ? this.regionOrder.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Parameter data type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * ParameterProperty parameterProperty = ParameterProperty.builder()
     *         .parameterKey("parameterKey")
     *         .parameterValue("parameterValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnStackSet.ParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key associated with the parameter.
         * <p>
         * If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that's specified in your template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterKey();

        /**
         * The input value associated with the parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterValue();

        /**
         * @return a {@link Builder} of {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterProperty> {
            java.lang.String parameterKey;
            java.lang.String parameterValue;

            /**
             * Sets the value of {@link ParameterProperty#getParameterKey}
             * @param parameterKey The key associated with the parameter. This parameter is required.
             *                     If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that's specified in your template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterKey(java.lang.String parameterKey) {
                this.parameterKey = parameterKey;
                return this;
            }

            /**
             * Sets the value of {@link ParameterProperty#getParameterValue}
             * @param parameterValue The input value associated with the parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterValue(java.lang.String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterProperty {
            private final java.lang.String parameterKey;
            private final java.lang.String parameterValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterKey = software.amazon.jsii.Kernel.get(this, "parameterKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterValue = software.amazon.jsii.Kernel.get(this, "parameterValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterKey = java.util.Objects.requireNonNull(builder.parameterKey, "parameterKey is required");
                this.parameterValue = java.util.Objects.requireNonNull(builder.parameterValue, "parameterValue is required");
            }

            @Override
            public final java.lang.String getParameterKey() {
                return this.parameterKey;
            }

            @Override
            public final java.lang.String getParameterValue() {
                return this.parameterValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameterKey", om.valueToTree(this.getParameterKey()));
                data.set("parameterValue", om.valueToTree(this.getParameterValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnStackSet.ParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterProperty.Jsii$Proxy that = (ParameterProperty.Jsii$Proxy) o;

                if (!parameterKey.equals(that.parameterKey)) return false;
                return this.parameterValue.equals(that.parameterValue);
            }

            @Override
            public final int hashCode() {
                int result = this.parameterKey.hashCode();
                result = 31 * result + (this.parameterValue.hashCode());
                return result;
            }
        }
    }
    /**
     * Stack instances in some specific accounts and Regions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * StackInstancesProperty stackInstancesProperty = StackInstancesProperty.builder()
     *         .deploymentTargets(DeploymentTargetsProperty.builder()
     *                 .accountFilterType("accountFilterType")
     *                 .accounts(List.of("accounts"))
     *                 .organizationalUnitIds(List.of("organizationalUnitIds"))
     *                 .build())
     *         .regions(List.of("regions"))
     *         // the properties below are optional
     *         .parameterOverrides(List.of(ParameterProperty.builder()
     *                 .parameterKey("parameterKey")
     *                 .parameterValue("parameterValue")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnStackSet.StackInstancesProperty")
    @software.amazon.jsii.Jsii.Proxy(StackInstancesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StackInstancesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDeploymentTargets();

        /**
         * The names of one or more Regions where you want to create stack instances using the specified AWS accounts .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegions();

        /**
         * A list of stack set parameters whose values you want to override in the selected stack instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameterOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StackInstancesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StackInstancesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StackInstancesProperty> {
            java.lang.Object deploymentTargets;
            java.util.List<java.lang.String> regions;
            java.lang.Object parameterOverrides;

            /**
             * Sets the value of {@link StackInstancesProperty#getDeploymentTargets}
             * @param deploymentTargets The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentTargets(software.amazon.awscdk.IResolvable deploymentTargets) {
                this.deploymentTargets = deploymentTargets;
                return this;
            }

            /**
             * Sets the value of {@link StackInstancesProperty#getDeploymentTargets}
             * @param deploymentTargets The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentTargets(software.amazon.awscdk.CfnStackSet.DeploymentTargetsProperty deploymentTargets) {
                this.deploymentTargets = deploymentTargets;
                return this;
            }

            /**
             * Sets the value of {@link StackInstancesProperty#getRegions}
             * @param regions The names of one or more Regions where you want to create stack instances using the specified AWS accounts . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regions(java.util.List<java.lang.String> regions) {
                this.regions = regions;
                return this;
            }

            /**
             * Sets the value of {@link StackInstancesProperty#getParameterOverrides}
             * @param parameterOverrides A list of stack set parameters whose values you want to override in the selected stack instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterOverrides(software.amazon.awscdk.IResolvable parameterOverrides) {
                this.parameterOverrides = parameterOverrides;
                return this;
            }

            /**
             * Sets the value of {@link StackInstancesProperty#getParameterOverrides}
             * @param parameterOverrides A list of stack set parameters whose values you want to override in the selected stack instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterOverrides(java.util.List<? extends java.lang.Object> parameterOverrides) {
                this.parameterOverrides = parameterOverrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StackInstancesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StackInstancesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StackInstancesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackInstancesProperty {
            private final java.lang.Object deploymentTargets;
            private final java.util.List<java.lang.String> regions;
            private final java.lang.Object parameterOverrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentTargets = software.amazon.jsii.Kernel.get(this, "deploymentTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.parameterOverrides = software.amazon.jsii.Kernel.get(this, "parameterOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentTargets = java.util.Objects.requireNonNull(builder.deploymentTargets, "deploymentTargets is required");
                this.regions = java.util.Objects.requireNonNull(builder.regions, "regions is required");
                this.parameterOverrides = builder.parameterOverrides;
            }

            @Override
            public final java.lang.Object getDeploymentTargets() {
                return this.deploymentTargets;
            }

            @Override
            public final java.util.List<java.lang.String> getRegions() {
                return this.regions;
            }

            @Override
            public final java.lang.Object getParameterOverrides() {
                return this.parameterOverrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deploymentTargets", om.valueToTree(this.getDeploymentTargets()));
                data.set("regions", om.valueToTree(this.getRegions()));
                if (this.getParameterOverrides() != null) {
                    data.set("parameterOverrides", om.valueToTree(this.getParameterOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnStackSet.StackInstancesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StackInstancesProperty.Jsii$Proxy that = (StackInstancesProperty.Jsii$Proxy) o;

                if (!deploymentTargets.equals(that.deploymentTargets)) return false;
                if (!regions.equals(that.regions)) return false;
                return this.parameterOverrides != null ? this.parameterOverrides.equals(that.parameterOverrides) : that.parameterOverrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deploymentTargets.hashCode();
                result = 31 * result + (this.regions.hashCode());
                result = 31 * result + (this.parameterOverrides != null ? this.parameterOverrides.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.CfnStackSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.CfnStackSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.CfnStackSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.CfnStackSetProps.Builder();
        }

        /**
         * Describes how the IAM roles required for stack set operations are created.
         * <p>
         * <ul>
         * <li>With <code>SELF_MANAGED</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a> .</li>
         * <li>With <code>SERVICE_MANAGED</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations . For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a> .</li>
         * </ul>
         * <p>
         * <em>Allowed Values</em> : <code>SERVICE_MANAGED</code> | <code>SELF_MANAGED</code>
         * <p>
         * <blockquote>
         * <p>
         * The <code>PermissionModel</code> property is required.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param permissionModel Describes how the IAM roles required for stack set operations are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionModel(final java.lang.String permissionModel) {
            this.props.permissionModel(permissionModel);
            return this;
        }

        /**
         * The name to associate with the stack set.
         * <p>
         * The name must be unique in the Region where you create your stack set.
         * <p>
         * <em>Maximum</em> : <code>128</code>
         * <p>
         * <em>Pattern</em> : <code>^[a-zA-Z][a-zA-Z0-9-]{0,127}$</code>
         * <p>
         * <blockquote>
         * <p>
         * The <code>StackSetName</code> property is required.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param stackSetName The name to associate with the stack set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetName(final java.lang.String stackSetName) {
            this.props.stackSetName(stackSetName);
            return this;
        }

        /**
         * The Amazon Resource Number (ARN) of the IAM role to use to create this stack set.
         * <p>
         * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account.
         * <p>
         * Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * <em>Minimum</em> : <code>20</code>
         * <p>
         * <em>Maximum</em> : <code>2048</code>
         * <p>
         * @return {@code this}
         * @param administrationRoleArn The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder administrationRoleArn(final java.lang.String administrationRoleArn) {
            this.props.administrationRoleArn(administrationRoleArn);
            return this;
        }

        /**
         * [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
         * <p>
         * @return {@code this}
         * @param autoDeployment [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeployment(final software.amazon.awscdk.IResolvable autoDeployment) {
            this.props.autoDeployment(autoDeployment);
            return this;
        }
        /**
         * [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
         * <p>
         * @return {@code this}
         * @param autoDeployment [ `Service-managed` permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeployment(final software.amazon.awscdk.CfnStackSet.AutoDeploymentProperty autoDeployment) {
            this.props.autoDeployment(autoDeployment);
            return this;
        }

        /**
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
         * <p>
         * <ul>
         * <li>To create a stack set with service-managed permissions while signed in to the management account, specify <code>SELF</code> .</li>
         * <li>To create a stack set with service-managed permissions while signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code> .</li>
         * </ul>
         * <p>
         * Your AWS account must be registered as a delegated admin in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * Stack sets with service-managed permissions are created in the management account, including stack sets that are created by delegated administrators.
         * <p>
         * <em>Valid Values</em> : <code>SELF</code> | <code>DELEGATED_ADMIN</code>
         * <p>
         * @return {@code this}
         * @param callAs [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder callAs(final java.lang.String callAs) {
            this.props.callAs(callAs);
            return this;
        }

        /**
         * The capabilities that are allowed in the stack set.
         * <p>
         * Some stack set templates might include resources that can affect permissions in your AWS account —for example, by creating new AWS Identity and Access Management ( IAM ) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
         * <p>
         * @return {@code this}
         * @param capabilities The capabilities that are allowed in the stack set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilities(final java.util.List<java.lang.String> capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }

        /**
         * A description of the stack set.
         * <p>
         * <em>Minimum</em> : <code>1</code>
         * <p>
         * <em>Maximum</em> : <code>1024</code>
         * <p>
         * @return {@code this}
         * @param description A description of the stack set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the IAM execution role to use to create the stack set.
         * <p>
         * If you don't specify an execution role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
         * <p>
         * <em>Minimum</em> : <code>1</code>
         * <p>
         * <em>Maximum</em> : <code>64</code>
         * <p>
         * <em>Pattern</em> : <code>[a-zA-Z_0-9+=,.&#64;-]+</code>
         * <p>
         * @return {@code this}
         * @param executionRoleName The name of the IAM execution role to use to create the stack set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleName(final java.lang.String executionRoleName) {
            this.props.executionRoleName(executionRoleName);
            return this;
        }

        /**
         * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
         * <p>
         * When active, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
         * <p>
         * <blockquote>
         * <p>
         * If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
         * <p>
         * You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.
         * <p>
         * </blockquote>
         * <p>
         * When inactive (default), StackSets performs one operation at a time in request order.
         * <p>
         * @return {@code this}
         * @param managedExecution Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedExecution(final java.lang.Object managedExecution) {
            this.props.managedExecution(managedExecution);
            return this;
        }

        /**
         * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
         * <p>
         * @return {@code this}
         * @param operationPreferences The user-specified preferences for how AWS CloudFormation performs a stack set operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationPreferences(final software.amazon.awscdk.IResolvable operationPreferences) {
            this.props.operationPreferences(operationPreferences);
            return this;
        }
        /**
         * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
         * <p>
         * @return {@code this}
         * @param operationPreferences The user-specified preferences for how AWS CloudFormation performs a stack set operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationPreferences(final software.amazon.awscdk.CfnStackSet.OperationPreferencesProperty operationPreferences) {
            this.props.operationPreferences(operationPreferences);
            return this;
        }

        /**
         * The input parameters for the stack set template.
         * <p>
         * @return {@code this}
         * @param parameters The input parameters for the stack set template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * The input parameters for the stack set template.
         * <p>
         * @return {@code this}
         * @param parameters The input parameters for the stack set template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.List<? extends java.lang.Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * A group of stack instances with parameters in some specific accounts and Regions.
         * <p>
         * @return {@code this}
         * @param stackInstancesGroup A group of stack instances with parameters in some specific accounts and Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstancesGroup(final software.amazon.awscdk.IResolvable stackInstancesGroup) {
            this.props.stackInstancesGroup(stackInstancesGroup);
            return this;
        }
        /**
         * A group of stack instances with parameters in some specific accounts and Regions.
         * <p>
         * @return {@code this}
         * @param stackInstancesGroup A group of stack instances with parameters in some specific accounts and Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstancesGroup(final java.util.List<? extends java.lang.Object> stackInstancesGroup) {
            this.props.stackInstancesGroup(stackInstancesGroup);
            return this;
        }

        /**
         * The key-value pairs to associate with this stack set and the stacks created from it.
         * <p>
         * AWS CloudFormation also propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be specified.
         * <p>
         * @return {@code this}
         * @param tags The key-value pairs to associate with this stack set and the stacks created from it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * <p>
         * You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both. Dynamic references in the <code>TemplateBody</code> may not work correctly in all cases. It's recommended to pass templates containing dynamic references through <code>TemplateUrl</code> instead.
         * <p>
         * <em>Minimum</em> : <code>1</code>
         * <p>
         * <em>Maximum</em> : <code>51200</code>
         * <p>
         * @return {@code this}
         * @param templateBody The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateBody(final java.lang.String templateBody) {
            this.props.templateBody(templateBody);
            return this;
        }

        /**
         * Location of file containing the template body.
         * <p>
         * The URL must point to a template (max size: 460,800 bytes) that's located in an Amazon S3 bucket.
         * <p>
         * You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both.
         * <p>
         * <em>Minimum</em> : <code>1</code>
         * <p>
         * <em>Maximum</em> : <code>1024</code>
         * <p>
         * @return {@code this}
         * @param templateUrl Location of file containing the template body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateUrl(final java.lang.String templateUrl) {
            this.props.templateUrl(templateUrl);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.CfnStackSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.CfnStackSet build() {
            return new software.amazon.awscdk.CfnStackSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
