package software.amazon.awscdk;

/**
 * Customization properties for an Intrinsic token.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * IntrinsicProps intrinsicProps = IntrinsicProps.builder()
 *         .stackTrace(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:34:59.815Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.IntrinsicProps")
@software.amazon.jsii.Jsii.Proxy(IntrinsicProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntrinsicProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Capture the stack trace of where this token is created.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStackTrace() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntrinsicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntrinsicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntrinsicProps> {
        java.lang.Boolean stackTrace;

        /**
         * Sets the value of {@link IntrinsicProps#getStackTrace}
         * @param stackTrace Capture the stack trace of where this token is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTrace(java.lang.Boolean stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntrinsicProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntrinsicProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntrinsicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntrinsicProps {
        private final java.lang.Boolean stackTrace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stackTrace = software.amazon.jsii.Kernel.get(this, "stackTrace", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stackTrace = builder.stackTrace;
        }

        @Override
        public final java.lang.Boolean getStackTrace() {
            return this.stackTrace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getStackTrace() != null) {
                data.set("stackTrace", om.valueToTree(this.getStackTrace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.IntrinsicProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntrinsicProps.Jsii$Proxy that = (IntrinsicProps.Jsii$Proxy) o;

            return this.stackTrace != null ? this.stackTrace.equals(that.stackTrace) : that.stackTrace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stackTrace != null ? this.stackTrace.hashCode() : 0;
            return result;
        }
    }
}
