package software.amazon.awscdk;

/**
 * Rounding behaviour when converting between units of `Size`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Size.mebibytes(2).toKibibytes(); // yields 2048
 * Size.kibibytes(2050).toMebibytes(SizeConversionOptions.builder().rounding(SizeRoundingBehavior.FLOOR).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:34:59.836Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.SizeRoundingBehavior")
public enum SizeRoundingBehavior {
    /**
     * Fail the conversion if the result is not an integer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FAIL,
    /**
     * If the result is not an integer, round it to the closest integer less than the result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FLOOR,
    /**
     * Don't round.
     * <p>
     * Return even if the result is a fraction.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
