package software.amazon.awscdk.cloudassembly.schema;

/**
 * Filters for selecting load balancers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * LoadBalancerFilter loadBalancerFilter = LoadBalancerFilter.builder()
 *         .loadBalancerType(LoadBalancerType.NETWORK)
 *         // the properties below are optional
 *         .loadBalancerArn("loadBalancerArn")
 *         .loadBalancerTags(List.of(Tag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.LoadBalancerFilter")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerFilter.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerFilter extends software.amazon.jsii.JsiiSerializable {

    /**
     * Filter load balancers by their type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.LoadBalancerType getLoadBalancerType();

    /**
     * Find by load balancer's ARN.
     * <p>
     * Default: - does not search by load balancer arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerArn() {
        return null;
    }

    /**
     * Match load balancer tags.
     * <p>
     * Default: - does not match load balancers by tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> getLoadBalancerTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerFilter> {
        software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        java.lang.String loadBalancerArn;
        java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;

        /**
         * Sets the value of {@link LoadBalancerFilter#getLoadBalancerType}
         * @param loadBalancerType Filter load balancers by their type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerType(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType) {
            this.loadBalancerType = loadBalancerType;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getLoadBalancerArn}
         * @param loadBalancerArn Find by load balancer's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getLoadBalancerTags}
         * @param loadBalancerTags Match load balancer tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder loadBalancerTags(java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags) {
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)loadBalancerTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerFilter}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerFilter build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerFilter {
        private final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        private final java.lang.String loadBalancerArn;
        private final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loadBalancerType = software.amazon.jsii.Kernel.get(this, "loadBalancerType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType.class));
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerTags = software.amazon.jsii.Kernel.get(this, "loadBalancerTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.Tag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancerType = java.util.Objects.requireNonNull(builder.loadBalancerType, "loadBalancerType is required");
            this.loadBalancerArn = builder.loadBalancerArn;
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)builder.loadBalancerTags;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> getLoadBalancerTags() {
            return this.loadBalancerTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loadBalancerType", om.valueToTree(this.getLoadBalancerType()));
            if (this.getLoadBalancerArn() != null) {
                data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            }
            if (this.getLoadBalancerTags() != null) {
                data.set("loadBalancerTags", om.valueToTree(this.getLoadBalancerTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.LoadBalancerFilter"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerFilter.Jsii$Proxy that = (LoadBalancerFilter.Jsii$Proxy) o;

            if (!loadBalancerType.equals(that.loadBalancerType)) return false;
            if (this.loadBalancerArn != null ? !this.loadBalancerArn.equals(that.loadBalancerArn) : that.loadBalancerArn != null) return false;
            return this.loadBalancerTags != null ? this.loadBalancerTags.equals(that.loadBalancerTags) : that.loadBalancerTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loadBalancerType.hashCode();
            result = 31 * result + (this.loadBalancerArn != null ? this.loadBalancerArn.hashCode() : 0);
            result = 31 * result + (this.loadBalancerTags != null ? this.loadBalancerTags.hashCode() : 0);
            return result;
        }
    }
}
