package software.amazon.awscdk.customresources;

/**
 * Defines a custom resource that is materialized using specific AWS API calls.
 * <p>
 * These calls are created using
 * a singleton Lambda function.
 * <p>
 * Use this to bridge any gap that might exist in the CloudFormation Coverage.
 * You can specify exactly which calls are invoked for the 'CREATE', 'UPDATE' and 'DELETE' life cycle events.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource getParameter = AwsCustomResource.Builder.create(this, "GetParameter")
 *         .onUpdate(AwsSdkCall.builder() // will also be called for a CREATE event
 *                 .service("SSM")
 *                 .action("getParameter")
 *                 .parameters(Map.of(
 *                         "Name", "my-parameter",
 *                         "WithDecryption", true))
 *                 .physicalResourceId(PhysicalResourceId.of(Date.now().toString())).build())
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * // Use the value in another construct with
 * getParameter.getResponseField("Parameter.Value");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.922Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.AwsCustomResource")
public class AwsCustomResource extends software.constructs.Construct implements software.amazon.awscdk.services.iam.IGrantable {

    protected AwsCustomResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsCustomResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AwsCustomResource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.AwsCustomResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns response data for the AWS SDK call as string.
     * <p>
     * Example for S3 / listBucket : 'Buckets.0.Name'
     * <p>
     * Note that you cannot use this method if <code>ignoreErrorCodesMatching</code>
     * is configured for any of the SDK calls. This is because in such a case,
     * the response data might not exist, and will cause a CloudFormation deploy time error.
     * <p>
     * @param dataPath the path to the data. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResponseField(final @org.jetbrains.annotations.NotNull java.lang.String dataPath) {
        return software.amazon.jsii.Kernel.call(this, "getResponseField", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(dataPath, "dataPath is required") });
    }

    /**
     * Returns response data for the AWS SDK call.
     * <p>
     * Example for S3 / listBucket : 'Buckets.0.Name'
     * <p>
     * Use <code>Token.asXxx</code> to encode the returned <code>Reference</code> as a specific type or
     * use the convenience <code>getDataString</code> for string attributes.
     * <p>
     * Note that you cannot use this method if <code>ignoreErrorCodesMatching</code>
     * is configured for any of the SDK calls. This is because in such a case,
     * the response data might not exist, and will cause a CloudFormation deploy time error.
     * <p>
     * @param dataPath the path to the data. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Reference getResponseFieldReference(final @org.jetbrains.annotations.NotNull java.lang.String dataPath) {
        return software.amazon.jsii.Kernel.call(this, "getResponseFieldReference", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Reference.class), new Object[] { java.util.Objects.requireNonNull(dataPath, "dataPath is required") });
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.customresources.AwsCustomResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.customresources.AwsCustomResource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.customresources.AwsCustomResourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.customresources.AwsCustomResourceProps.Builder();
        }

        /**
         * A name for the singleton Lambda function implementing this custom resource.
         * <p>
         * The function name will remain the same after the first AwsCustomResource is created in a stack.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that
         * ID for the function's name. For more information, see Name Type.
         * <p>
         * @return {@code this}
         * @param functionName A name for the singleton Lambda function implementing this custom resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * Whether to install the latest AWS SDK v2. Allows to use the latest API calls documented at https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html.
         * <p>
         * The installation takes around 60 seconds.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param installLatestAwsSdk Whether to install the latest AWS SDK v2. Allows to use the latest API calls documented at https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installLatestAwsSdk(final java.lang.Boolean installLatestAwsSdk) {
            this.props.installLatestAwsSdk(installLatestAwsSdk);
            return this;
        }

        /**
         * The number of days log events of the singleton Lambda function implementing this custom resource are kept in CloudWatch Logs.
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @param logRetention The number of days log events of the singleton Lambda function implementing this custom resource are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * The AWS SDK call to make when the resource is created.
         * <p>
         * Default: - the call when the resource is updated
         * <p>
         * @return {@code this}
         * @param onCreate The AWS SDK call to make when the resource is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onCreate(final software.amazon.awscdk.customresources.AwsSdkCall onCreate) {
            this.props.onCreate(onCreate);
            return this;
        }

        /**
         * The AWS SDK call to make when the resource is deleted.
         * <p>
         * Default: - no call
         * <p>
         * @return {@code this}
         * @param onDelete The AWS SDK call to make when the resource is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDelete(final software.amazon.awscdk.customresources.AwsSdkCall onDelete) {
            this.props.onDelete(onDelete);
            return this;
        }

        /**
         * The AWS SDK call to make when the resource is updated.
         * <p>
         * Default: - no call
         * <p>
         * @return {@code this}
         * @param onUpdate The AWS SDK call to make when the resource is updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onUpdate(final software.amazon.awscdk.customresources.AwsSdkCall onUpdate) {
            this.props.onUpdate(onUpdate);
            return this;
        }

        /**
         * The policy that will be added to the execution role of the Lambda function implementing this custom resource provider.
         * <p>
         * The custom resource also implements <code>iam.IGrantable</code>, making it possible
         * to use the <code>grantXxx()</code> methods.
         * <p>
         * As this custom resource uses a singleton Lambda function, it's important
         * to note the that function's role will eventually accumulate the
         * permissions/grants from all resources.
         * <p>
         * Note that a policy must be specified if <code>role</code> is not provided, as
         * by default a new role is created which requires policy changes to access
         * resources.
         * <p>
         * Default: - no policy added
         * <p>
         * @return {@code this}
         * @see <a href="Policy.fromSdkCalls">Policy.fromSdkCalls</a>
         * @param policy The policy that will be added to the execution role of the Lambda function implementing this custom resource provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * Cloudformation Resource type.
         * <p>
         * Default: - Custom::AWS
         * <p>
         * @return {@code this}
         * @param resourceType Cloudformation Resource type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * The execution role for the singleton Lambda function implementing this custom resource provider.
         * <p>
         * This role will apply to all <code>AwsCustomResource</code>
         * instances in the stack. The role must be assumable by the
         * <code>lambda.amazonaws.com</code> service principal.
         * <p>
         * Default: - a new role is created
         * <p>
         * @return {@code this}
         * @param role The execution role for the singleton Lambda function implementing this custom resource provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The timeout for the singleton Lambda function implementing this custom resource.
         * <p>
         * Default: Duration.minutes(2)
         * <p>
         * @return {@code this}
         * @param timeout The timeout for the singleton Lambda function implementing this custom resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The vpc to provision the lambda function in.
         * <p>
         * Default: - the function is not provisioned inside a vpc.
         * <p>
         * @return {@code this}
         * @param vpc The vpc to provision the lambda function in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Which subnets from the VPC to place the lambda function in.
         * <p>
         * Only used if 'vpc' is supplied. Note: internet access for Lambdas
         * requires a NAT gateway, so picking Public subnets is not allowed.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets from the VPC to place the lambda function in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.customresources.AwsCustomResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.customresources.AwsCustomResource build() {
            return new software.amazon.awscdk.customresources.AwsCustomResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
