package software.amazon.awscdk.services.amplifyuibuilder;

/**
 * Properties for defining a `CfnComponent`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplifyuibuilder.*;
 * Object bindings;
 * ComponentChildProperty componentChildProperty_;
 * ComponentPropertyProperty componentPropertyProperty_;
 * Object events;
 * Object fields;
 * Object overrides;
 * PredicateProperty predicateProperty_;
 * Object properties;
 * Object variantValues;
 * CfnComponentProps cfnComponentProps = CfnComponentProps.builder()
 *         .bindingProperties(Map.of(
 *                 "bindingPropertiesKey", ComponentBindingPropertiesValueProperty.builder()
 *                         .bindingProperties(ComponentBindingPropertiesValuePropertiesProperty.builder()
 *                                 .bucket("bucket")
 *                                 .defaultValue("defaultValue")
 *                                 .field("field")
 *                                 .key("key")
 *                                 .model("model")
 *                                 .predicates(List.of(PredicateProperty.builder()
 *                                         .and(List.of(predicateProperty_))
 *                                         .field("field")
 *                                         .operand("operand")
 *                                         .operator("operator")
 *                                         .or(List.of(predicateProperty_))
 *                                         .build()))
 *                                 .userAttribute("userAttribute")
 *                                 .build())
 *                         .defaultValue("defaultValue")
 *                         .type("type")
 *                         .build()))
 *         .componentType("componentType")
 *         .name("name")
 *         .overrides(Map.of(
 *                 "overridesKey", overrides))
 *         .properties(Map.of(
 *                 "propertiesKey", ComponentPropertyProperty.builder()
 *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                 .property("property")
 *                                 // the properties below are optional
 *                                 .field("field")
 *                                 .build())
 *                         .bindings(bindings)
 *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                 .property("property")
 *                                 // the properties below are optional
 *                                 .field("field")
 *                                 .build())
 *                         .componentName("componentName")
 *                         .concat(List.of(componentPropertyProperty_))
 *                         .condition(ComponentConditionPropertyProperty.builder()
 *                                 .else(componentPropertyProperty_)
 *                                 .field("field")
 *                                 .operand("operand")
 *                                 .operandType("operandType")
 *                                 .operator("operator")
 *                                 .property("property")
 *                                 .then(componentPropertyProperty_)
 *                                 .build())
 *                         .configured(false)
 *                         .defaultValue("defaultValue")
 *                         .event("event")
 *                         .importedValue("importedValue")
 *                         .model("model")
 *                         .property("property")
 *                         .type("type")
 *                         .userAttribute("userAttribute")
 *                         .value("value")
 *                         .build()))
 *         .variants(List.of(ComponentVariantProperty.builder()
 *                 .overrides(overrides)
 *                 .variantValues(variantValues)
 *                 .build()))
 *         // the properties below are optional
 *         .children(List.of(ComponentChildProperty.builder()
 *                 .componentType("componentType")
 *                 .name("name")
 *                 .properties(properties)
 *                 // the properties below are optional
 *                 .children(List.of(componentChildProperty_))
 *                 .events(events)
 *                 .build()))
 *         .collectionProperties(Map.of(
 *                 "collectionPropertiesKey", ComponentDataConfigurationProperty.builder()
 *                         .model("model")
 *                         // the properties below are optional
 *                         .identifiers(List.of("identifiers"))
 *                         .predicate(PredicateProperty.builder()
 *                                 .and(List.of(predicateProperty_))
 *                                 .field("field")
 *                                 .operand("operand")
 *                                 .operator("operator")
 *                                 .or(List.of(predicateProperty_))
 *                                 .build())
 *                         .sort(List.of(SortPropertyProperty.builder()
 *                                 .direction("direction")
 *                                 .field("field")
 *                                 .build()))
 *                         .build()))
 *         .events(Map.of(
 *                 "eventsKey", ComponentEventProperty.builder()
 *                         .action("action")
 *                         .parameters(ActionParametersProperty.builder()
 *                                 .anchor(ComponentPropertyProperty.builder()
 *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .bindings(bindings)
 *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .componentName("componentName")
 *                                         .concat(List.of(componentPropertyProperty_))
 *                                         .condition(ComponentConditionPropertyProperty.builder()
 *                                                 .else(componentPropertyProperty_)
 *                                                 .field("field")
 *                                                 .operand("operand")
 *                                                 .operandType("operandType")
 *                                                 .operator("operator")
 *                                                 .property("property")
 *                                                 .then(componentPropertyProperty_)
 *                                                 .build())
 *                                         .configured(false)
 *                                         .defaultValue("defaultValue")
 *                                         .event("event")
 *                                         .importedValue("importedValue")
 *                                         .model("model")
 *                                         .property("property")
 *                                         .type("type")
 *                                         .userAttribute("userAttribute")
 *                                         .value("value")
 *                                         .build())
 *                                 .fields(fields)
 *                                 .global(ComponentPropertyProperty.builder()
 *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .bindings(bindings)
 *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .componentName("componentName")
 *                                         .concat(List.of(componentPropertyProperty_))
 *                                         .condition(ComponentConditionPropertyProperty.builder()
 *                                                 .else(componentPropertyProperty_)
 *                                                 .field("field")
 *                                                 .operand("operand")
 *                                                 .operandType("operandType")
 *                                                 .operator("operator")
 *                                                 .property("property")
 *                                                 .then(componentPropertyProperty_)
 *                                                 .build())
 *                                         .configured(false)
 *                                         .defaultValue("defaultValue")
 *                                         .event("event")
 *                                         .importedValue("importedValue")
 *                                         .model("model")
 *                                         .property("property")
 *                                         .type("type")
 *                                         .userAttribute("userAttribute")
 *                                         .value("value")
 *                                         .build())
 *                                 .id(ComponentPropertyProperty.builder()
 *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .bindings(bindings)
 *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .componentName("componentName")
 *                                         .concat(List.of(componentPropertyProperty_))
 *                                         .condition(ComponentConditionPropertyProperty.builder()
 *                                                 .else(componentPropertyProperty_)
 *                                                 .field("field")
 *                                                 .operand("operand")
 *                                                 .operandType("operandType")
 *                                                 .operator("operator")
 *                                                 .property("property")
 *                                                 .then(componentPropertyProperty_)
 *                                                 .build())
 *                                         .configured(false)
 *                                         .defaultValue("defaultValue")
 *                                         .event("event")
 *                                         .importedValue("importedValue")
 *                                         .model("model")
 *                                         .property("property")
 *                                         .type("type")
 *                                         .userAttribute("userAttribute")
 *                                         .value("value")
 *                                         .build())
 *                                 .model("model")
 *                                 .state(MutationActionSetStateParameterProperty.builder()
 *                                         .componentName("componentName")
 *                                         .property("property")
 *                                         .set(ComponentPropertyProperty.builder()
 *                                                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                         .property("property")
 *                                                         // the properties below are optional
 *                                                         .field("field")
 *                                                         .build())
 *                                                 .bindings(bindings)
 *                                                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                         .property("property")
 *                                                         // the properties below are optional
 *                                                         .field("field")
 *                                                         .build())
 *                                                 .componentName("componentName")
 *                                                 .concat(List.of(componentPropertyProperty_))
 *                                                 .condition(ComponentConditionPropertyProperty.builder()
 *                                                         .else(componentPropertyProperty_)
 *                                                         .field("field")
 *                                                         .operand("operand")
 *                                                         .operandType("operandType")
 *                                                         .operator("operator")
 *                                                         .property("property")
 *                                                         .then(componentPropertyProperty_)
 *                                                         .build())
 *                                                 .configured(false)
 *                                                 .defaultValue("defaultValue")
 *                                                 .event("event")
 *                                                 .importedValue("importedValue")
 *                                                 .model("model")
 *                                                 .property("property")
 *                                                 .type("type")
 *                                                 .userAttribute("userAttribute")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build())
 *                                 .target(ComponentPropertyProperty.builder()
 *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .bindings(bindings)
 *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .componentName("componentName")
 *                                         .concat(List.of(componentPropertyProperty_))
 *                                         .condition(ComponentConditionPropertyProperty.builder()
 *                                                 .else(componentPropertyProperty_)
 *                                                 .field("field")
 *                                                 .operand("operand")
 *                                                 .operandType("operandType")
 *                                                 .operator("operator")
 *                                                 .property("property")
 *                                                 .then(componentPropertyProperty_)
 *                                                 .build())
 *                                         .configured(false)
 *                                         .defaultValue("defaultValue")
 *                                         .event("event")
 *                                         .importedValue("importedValue")
 *                                         .model("model")
 *                                         .property("property")
 *                                         .type("type")
 *                                         .userAttribute("userAttribute")
 *                                         .value("value")
 *                                         .build())
 *                                 .type(ComponentPropertyProperty.builder()
 *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .bindings(bindings)
 *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .componentName("componentName")
 *                                         .concat(List.of(componentPropertyProperty_))
 *                                         .condition(ComponentConditionPropertyProperty.builder()
 *                                                 .else(componentPropertyProperty_)
 *                                                 .field("field")
 *                                                 .operand("operand")
 *                                                 .operandType("operandType")
 *                                                 .operator("operator")
 *                                                 .property("property")
 *                                                 .then(componentPropertyProperty_)
 *                                                 .build())
 *                                         .configured(false)
 *                                         .defaultValue("defaultValue")
 *                                         .event("event")
 *                                         .importedValue("importedValue")
 *                                         .model("model")
 *                                         .property("property")
 *                                         .type("type")
 *                                         .userAttribute("userAttribute")
 *                                         .value("value")
 *                                         .build())
 *                                 .url(ComponentPropertyProperty.builder()
 *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .bindings(bindings)
 *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
 *                                                 .property("property")
 *                                                 // the properties below are optional
 *                                                 .field("field")
 *                                                 .build())
 *                                         .componentName("componentName")
 *                                         .concat(List.of(componentPropertyProperty_))
 *                                         .condition(ComponentConditionPropertyProperty.builder()
 *                                                 .else(componentPropertyProperty_)
 *                                                 .field("field")
 *                                                 .operand("operand")
 *                                                 .operandType("operandType")
 *                                                 .operator("operator")
 *                                                 .property("property")
 *                                                 .then(componentPropertyProperty_)
 *                                                 .build())
 *                                         .configured(false)
 *                                         .defaultValue("defaultValue")
 *                                         .event("event")
 *                                         .importedValue("importedValue")
 *                                         .model("model")
 *                                         .property("property")
 *                                         .type("type")
 *                                         .userAttribute("userAttribute")
 *                                         .value("value")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *         .schemaVersion("schemaVersion")
 *         .sourceId("sourceId")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:34:59.954Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponentProps")
@software.amazon.jsii.Jsii.Proxy(CfnComponentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComponentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The information to connect a component's properties to data at runtime.
     * <p>
     * You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getBindingProperties();

    /**
     * The type of the component.
     * <p>
     * This can be an Amplify custom UI component or another custom component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComponentType();

    /**
     * The name of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Describes the component's properties that can be overriden in a customized instance of the component.
     * <p>
     * You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOverrides();

    /**
     * Describes the component's properties.
     * <p>
     * You can't specify <code>tags</code> as a valid property for <code>properties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProperties();

    /**
     * A list of the component's variants.
     * <p>
     * A variant is a unique style configuration of a main component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVariants();

    /**
     * A list of the component's `ComponentChild` instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChildren() {
        return null;
    }

    /**
     * The data binding configuration for the component's properties.
     * <p>
     * Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCollectionProperties() {
        return null;
    }

    /**
     * Describes the events that can be raised on the component.
     * <p>
     * Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
        return null;
    }

    /**
     * The schema version of the component when it was imported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchemaVersion() {
        return null;
    }

    /**
     * The unique ID of the component in its original source system, such as Figma.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceId() {
        return null;
    }

    /**
     * One or more key-value pairs to use when tagging the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComponentProps> {
        java.lang.Object bindingProperties;
        java.lang.String componentType;
        java.lang.String name;
        java.lang.Object overrides;
        java.lang.Object properties;
        java.lang.Object variants;
        java.lang.Object children;
        java.lang.Object collectionProperties;
        java.lang.Object events;
        java.lang.String schemaVersion;
        java.lang.String sourceId;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnComponentProps#getBindingProperties}
         * @param bindingProperties The information to connect a component's properties to data at runtime. This parameter is required.
         *                          You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bindingProperties(software.amazon.awscdk.IResolvable bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getBindingProperties}
         * @param bindingProperties The information to connect a component's properties to data at runtime. This parameter is required.
         *                          You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bindingProperties(java.util.Map<java.lang.String, ? extends java.lang.Object> bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getComponentType}
         * @param componentType The type of the component. This parameter is required.
         *                      This can be an Amplify custom UI component or another custom component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentType(java.lang.String componentType) {
            this.componentType = componentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getName}
         * @param name The name of the component. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getOverrides}
         * @param overrides Describes the component's properties that can be overriden in a customized instance of the component. This parameter is required.
         *                  You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrides(software.amazon.awscdk.IResolvable overrides) {
            this.overrides = overrides;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getOverrides}
         * @param overrides Describes the component's properties that can be overriden in a customized instance of the component. This parameter is required.
         *                  You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrides(java.util.Map<java.lang.String, ? extends java.lang.Object> overrides) {
            this.overrides = overrides;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getProperties}
         * @param properties Describes the component's properties. This parameter is required.
         *                   You can't specify <code>tags</code> as a valid property for <code>properties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(software.amazon.awscdk.IResolvable properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getProperties}
         * @param properties Describes the component's properties. This parameter is required.
         *                   You can't specify <code>tags</code> as a valid property for <code>properties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getVariants}
         * @param variants A list of the component's variants. This parameter is required.
         *                 A variant is a unique style configuration of a main component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(software.amazon.awscdk.IResolvable variants) {
            this.variants = variants;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getVariants}
         * @param variants A list of the component's variants. This parameter is required.
         *                 A variant is a unique style configuration of a main component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(java.util.List<? extends java.lang.Object> variants) {
            this.variants = variants;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getChildren}
         * @param children A list of the component's `ComponentChild` instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder children(software.amazon.awscdk.IResolvable children) {
            this.children = children;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getChildren}
         * @param children A list of the component's `ComponentChild` instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder children(java.util.List<? extends java.lang.Object> children) {
            this.children = children;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getCollectionProperties}
         * @param collectionProperties The data binding configuration for the component's properties.
         *                             Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionProperties(software.amazon.awscdk.IResolvable collectionProperties) {
            this.collectionProperties = collectionProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getCollectionProperties}
         * @param collectionProperties The data binding configuration for the component's properties.
         *                             Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionProperties(java.util.Map<java.lang.String, ? extends java.lang.Object> collectionProperties) {
            this.collectionProperties = collectionProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getEvents}
         * @param events Describes the events that can be raised on the component.
         *               Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(software.amazon.awscdk.IResolvable events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getEvents}
         * @param events Describes the events that can be raised on the component.
         *               Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getSchemaVersion}
         * @param schemaVersion The schema version of the component when it was imported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaVersion(java.lang.String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getSourceId}
         * @param sourceId The unique ID of the component in its original source system, such as Figma.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceId(java.lang.String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getTags}
         * @param tags One or more key-value pairs to use when tagging the component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComponentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComponentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComponentProps {
        private final java.lang.Object bindingProperties;
        private final java.lang.String componentType;
        private final java.lang.String name;
        private final java.lang.Object overrides;
        private final java.lang.Object properties;
        private final java.lang.Object variants;
        private final java.lang.Object children;
        private final java.lang.Object collectionProperties;
        private final java.lang.Object events;
        private final java.lang.String schemaVersion;
        private final java.lang.String sourceId;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bindingProperties = software.amazon.jsii.Kernel.get(this, "bindingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.componentType = software.amazon.jsii.Kernel.get(this, "componentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.variants = software.amazon.jsii.Kernel.get(this, "variants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.children = software.amazon.jsii.Kernel.get(this, "children", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.collectionProperties = software.amazon.jsii.Kernel.get(this, "collectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schemaVersion = software.amazon.jsii.Kernel.get(this, "schemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceId = software.amazon.jsii.Kernel.get(this, "sourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bindingProperties = java.util.Objects.requireNonNull(builder.bindingProperties, "bindingProperties is required");
            this.componentType = java.util.Objects.requireNonNull(builder.componentType, "componentType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.overrides = java.util.Objects.requireNonNull(builder.overrides, "overrides is required");
            this.properties = java.util.Objects.requireNonNull(builder.properties, "properties is required");
            this.variants = java.util.Objects.requireNonNull(builder.variants, "variants is required");
            this.children = builder.children;
            this.collectionProperties = builder.collectionProperties;
            this.events = builder.events;
            this.schemaVersion = builder.schemaVersion;
            this.sourceId = builder.sourceId;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getBindingProperties() {
            return this.bindingProperties;
        }

        @Override
        public final java.lang.String getComponentType() {
            return this.componentType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOverrides() {
            return this.overrides;
        }

        @Override
        public final java.lang.Object getProperties() {
            return this.properties;
        }

        @Override
        public final java.lang.Object getVariants() {
            return this.variants;
        }

        @Override
        public final java.lang.Object getChildren() {
            return this.children;
        }

        @Override
        public final java.lang.Object getCollectionProperties() {
            return this.collectionProperties;
        }

        @Override
        public final java.lang.Object getEvents() {
            return this.events;
        }

        @Override
        public final java.lang.String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final java.lang.String getSourceId() {
            return this.sourceId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bindingProperties", om.valueToTree(this.getBindingProperties()));
            data.set("componentType", om.valueToTree(this.getComponentType()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("overrides", om.valueToTree(this.getOverrides()));
            data.set("properties", om.valueToTree(this.getProperties()));
            data.set("variants", om.valueToTree(this.getVariants()));
            if (this.getChildren() != null) {
                data.set("children", om.valueToTree(this.getChildren()));
            }
            if (this.getCollectionProperties() != null) {
                data.set("collectionProperties", om.valueToTree(this.getCollectionProperties()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getSchemaVersion() != null) {
                data.set("schemaVersion", om.valueToTree(this.getSchemaVersion()));
            }
            if (this.getSourceId() != null) {
                data.set("sourceId", om.valueToTree(this.getSourceId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComponentProps.Jsii$Proxy that = (CfnComponentProps.Jsii$Proxy) o;

            if (!bindingProperties.equals(that.bindingProperties)) return false;
            if (!componentType.equals(that.componentType)) return false;
            if (!name.equals(that.name)) return false;
            if (!overrides.equals(that.overrides)) return false;
            if (!properties.equals(that.properties)) return false;
            if (!variants.equals(that.variants)) return false;
            if (this.children != null ? !this.children.equals(that.children) : that.children != null) return false;
            if (this.collectionProperties != null ? !this.collectionProperties.equals(that.collectionProperties) : that.collectionProperties != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.schemaVersion != null ? !this.schemaVersion.equals(that.schemaVersion) : that.schemaVersion != null) return false;
            if (this.sourceId != null ? !this.sourceId.equals(that.sourceId) : that.sourceId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bindingProperties.hashCode();
            result = 31 * result + (this.componentType.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.overrides.hashCode());
            result = 31 * result + (this.properties.hashCode());
            result = 31 * result + (this.variants.hashCode());
            result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
            result = 31 * result + (this.collectionProperties != null ? this.collectionProperties.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.schemaVersion != null ? this.schemaVersion.hashCode() : 0);
            result = 31 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
