package software.amazon.awscdk.services.apigateway;

/**
 * Properties for RequestAuthorizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function authFn;
 * Resource books;
 * RequestAuthorizer auth = RequestAuthorizer.Builder.create(this, "booksAuthorizer")
 *         .handler(authFn)
 *         .identitySources(List.of(IdentitySource.header("Authorization")))
 *         .build();
 * books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizer(auth)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:00.097Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.RequestAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(RequestAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RequestAuthorizerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.LambdaAuthorizerProps {

    /**
     * An array of request header mapping expressions for identities.
     * <p>
     * Supported parameter types are
     * Header, Query String, Stage Variable, and Context. For instance, extracting an authorization
     * token from a header would use the identity source <code>IdentitySource.header('Authorizer')</code>.
     * <p>
     * Note: API Gateway uses the specified identity sources as the request authorizer caching key. When caching is
     * enabled, API Gateway calls the authorizer's Lambda function only after successfully verifying that all the
     * specified identity sources are present at runtime. If a specified identify source is missing, null, or empty,
     * API Gateway returns a 401 Unauthorized response without calling the authorizer Lambda function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource">https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIdentitySources();

    /**
     * @return a {@link Builder} of {@link RequestAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RequestAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RequestAuthorizerProps> {
        java.util.List<java.lang.String> identitySources;
        software.amazon.awscdk.services.lambda.IFunction handler;
        software.amazon.awscdk.services.iam.IRole assumeRole;
        java.lang.String authorizerName;
        software.amazon.awscdk.Duration resultsCacheTtl;

        /**
         * Sets the value of {@link RequestAuthorizerProps#getIdentitySources}
         * @param identitySources An array of request header mapping expressions for identities. This parameter is required.
         *                        Supported parameter types are
         *                        Header, Query String, Stage Variable, and Context. For instance, extracting an authorization
         *                        token from a header would use the identity source <code>IdentitySource.header('Authorizer')</code>.
         *                        <p>
         *                        Note: API Gateway uses the specified identity sources as the request authorizer caching key. When caching is
         *                        enabled, API Gateway calls the authorizer's Lambda function only after successfully verifying that all the
         *                        specified identity sources are present at runtime. If a specified identify source is missing, null, or empty,
         *                        API Gateway returns a 401 Unauthorized response without calling the authorizer Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySources(java.util.List<java.lang.String> identitySources) {
            this.identitySources = identitySources;
            return this;
        }

        /**
         * Sets the value of {@link RequestAuthorizerProps#getHandler}
         * @param handler The handler for the authorizer lambda function. This parameter is required.
         *                The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
         *                API Gateway has documented the handler's input specification
         *                {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
         *                {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(software.amazon.awscdk.services.lambda.IFunction handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of {@link RequestAuthorizerProps#getAssumeRole}
         * @param assumeRole An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.
         *                   The IAM role must be
         *                   assumable by 'apigateway.amazonaws.com'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRole(software.amazon.awscdk.services.iam.IRole assumeRole) {
            this.assumeRole = assumeRole;
            return this;
        }

        /**
         * Sets the value of {@link RequestAuthorizerProps#getAuthorizerName}
         * @param authorizerName An optional human friendly name for the authorizer.
         *                       Note that, this is not the primary identifier of the authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link RequestAuthorizerProps#getResultsCacheTtl}
         * @param resultsCacheTtl How long APIGateway should cache the results.
         *                        Max 1 hour.
         *                        Disable caching by setting this to 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(software.amazon.awscdk.Duration resultsCacheTtl) {
            this.resultsCacheTtl = resultsCacheTtl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RequestAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RequestAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RequestAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestAuthorizerProps {
        private final java.util.List<java.lang.String> identitySources;
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private final software.amazon.awscdk.services.iam.IRole assumeRole;
        private final java.lang.String authorizerName;
        private final software.amazon.awscdk.Duration resultsCacheTtl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identitySources = software.amazon.jsii.Kernel.get(this, "identitySources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.assumeRole = software.amazon.jsii.Kernel.get(this, "assumeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultsCacheTtl = software.amazon.jsii.Kernel.get(this, "resultsCacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identitySources = java.util.Objects.requireNonNull(builder.identitySources, "identitySources is required");
            this.handler = java.util.Objects.requireNonNull(builder.handler, "handler is required");
            this.assumeRole = builder.assumeRole;
            this.authorizerName = builder.authorizerName;
            this.resultsCacheTtl = builder.resultsCacheTtl;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentitySources() {
            return this.identitySources;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getHandler() {
            return this.handler;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAssumeRole() {
            return this.assumeRole;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final software.amazon.awscdk.Duration getResultsCacheTtl() {
            return this.resultsCacheTtl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identitySources", om.valueToTree(this.getIdentitySources()));
            data.set("handler", om.valueToTree(this.getHandler()));
            if (this.getAssumeRole() != null) {
                data.set("assumeRole", om.valueToTree(this.getAssumeRole()));
            }
            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getResultsCacheTtl() != null) {
                data.set("resultsCacheTtl", om.valueToTree(this.getResultsCacheTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.RequestAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RequestAuthorizerProps.Jsii$Proxy that = (RequestAuthorizerProps.Jsii$Proxy) o;

            if (!identitySources.equals(that.identitySources)) return false;
            if (!handler.equals(that.handler)) return false;
            if (this.assumeRole != null ? !this.assumeRole.equals(that.assumeRole) : that.assumeRole != null) return false;
            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            return this.resultsCacheTtl != null ? this.resultsCacheTtl.equals(that.resultsCacheTtl) : that.resultsCacheTtl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identitySources.hashCode();
            result = 31 * result + (this.handler.hashCode());
            result = 31 * result + (this.assumeRole != null ? this.assumeRole.hashCode() : 0);
            result = 31 * result + (this.authorizerName != null ? this.authorizerName.hashCode() : 0);
            result = 31 * result + (this.resultsCacheTtl != null ? this.resultsCacheTtl.hashCode() : 0);
            return result;
        }
    }
}
