package software.amazon.awscdk.services.appmesh;

/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 * <p>
 * Creates a virtual node within a service mesh.
 * <p>
 * A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your task group, and whether the proxy running in a task group will communicate with other proxies using Transport Layer Security (TLS).
 * <p>
 * You define a <code>listener</code> for any inbound traffic that your virtual node expects. Any virtual service that your virtual node expects to communicate to is specified as a <code>backend</code> .
 * <p>
 * The response metadata for your new virtual node contains the <code>arn</code> that is associated with the virtual node. Set this value to the full ARN; for example, <code>arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp</code> ) as the <code>APPMESH_RESOURCE_ARN</code> environment variable for your task group's Envoy proxy container in your task definition or pod spec. This is then mapped to the <code>node.id</code> and <code>node.cluster</code> Envoy parameters.
 * <p>
 * <blockquote>
 * <p>
 * By default, App Mesh uses the name of the resource you specified in <code>APPMESH_RESOURCE_ARN</code> when Envoy is referring to itself in metrics and traces. You can override this behavior by setting the <code>APPMESH_RESOURCE_CLUSTER</code> environment variable with your own name.
 * <p>
 * </blockquote>
 * <p>
 * For more information about virtual nodes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes</a> . You must be using <code>1.15.0</code> or later of the Envoy image when setting these variables. For more information about App Mesh Envoy variables, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html">Envoy image</a> in the AWS App Mesh User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnVirtualNode cfnVirtualNode = CfnVirtualNode.Builder.create(this, "MyCfnVirtualNode")
 *         .meshName("meshName")
 *         .spec(VirtualNodeSpecProperty.builder()
 *                 .backendDefaults(BackendDefaultsProperty.builder()
 *                         .clientPolicy(ClientPolicyProperty.builder()
 *                                 .tls(ClientPolicyTlsProperty.builder()
 *                                         .validation(TlsValidationContextProperty.builder()
 *                                                 .trust(TlsValidationContextTrustProperty.builder()
 *                                                         .acm(TlsValidationContextAcmTrustProperty.builder()
 *                                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 *                                                                 .build())
 *                                                         .file(TlsValidationContextFileTrustProperty.builder()
 *                                                                 .certificateChain("certificateChain")
 *                                                                 .build())
 *                                                         .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                                 .secretName("secretName")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                         .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                                 .exact(List.of("exact"))
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .certificate(ClientTlsCertificateProperty.builder()
 *                                                 .file(ListenerTlsFileCertificateProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .privateKey("privateKey")
 *                                                         .build())
 *                                                 .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         .enforce(false)
 *                                         .ports(List.of(123))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .backends(List.of(BackendProperty.builder()
 *                         .virtualService(VirtualServiceBackendProperty.builder()
 *                                 .virtualServiceName("virtualServiceName")
 *                                 // the properties below are optional
 *                                 .clientPolicy(ClientPolicyProperty.builder()
 *                                         .tls(ClientPolicyTlsProperty.builder()
 *                                                 .validation(TlsValidationContextProperty.builder()
 *                                                         .trust(TlsValidationContextTrustProperty.builder()
 *                                                                 .acm(TlsValidationContextAcmTrustProperty.builder()
 *                                                                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 *                                                                         .build())
 *                                                                 .file(TlsValidationContextFileTrustProperty.builder()
 *                                                                         .certificateChain("certificateChain")
 *                                                                         .build())
 *                                                                 .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                                         .secretName("secretName")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                                         .exact(List.of("exact"))
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .certificate(ClientTlsCertificateProperty.builder()
 *                                                         .file(ListenerTlsFileCertificateProperty.builder()
 *                                                                 .certificateChain("certificateChain")
 *                                                                 .privateKey("privateKey")
 *                                                                 .build())
 *                                                         .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                                                 .secretName("secretName")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .enforce(false)
 *                                                 .ports(List.of(123))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .listeners(List.of(ListenerProperty.builder()
 *                         .portMapping(PortMappingProperty.builder()
 *                                 .port(123)
 *                                 .protocol("protocol")
 *                                 .build())
 *                         // the properties below are optional
 *                         .connectionPool(VirtualNodeConnectionPoolProperty.builder()
 *                                 .grpc(VirtualNodeGrpcConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .http(VirtualNodeHttpConnectionPoolProperty.builder()
 *                                         .maxConnections(123)
 *                                         // the properties below are optional
 *                                         .maxPendingRequests(123)
 *                                         .build())
 *                                 .http2(VirtualNodeHttp2ConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .tcp(VirtualNodeTcpConnectionPoolProperty.builder()
 *                                         .maxConnections(123)
 *                                         .build())
 *                                 .build())
 *                         .healthCheck(HealthCheckProperty.builder()
 *                                 .healthyThreshold(123)
 *                                 .intervalMillis(123)
 *                                 .protocol("protocol")
 *                                 .timeoutMillis(123)
 *                                 .unhealthyThreshold(123)
 *                                 // the properties below are optional
 *                                 .path("path")
 *                                 .port(123)
 *                                 .build())
 *                         .outlierDetection(OutlierDetectionProperty.builder()
 *                                 .baseEjectionDuration(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .interval(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .maxEjectionPercent(123)
 *                                 .maxServerErrors(123)
 *                                 .build())
 *                         .timeout(ListenerTimeoutProperty.builder()
 *                                 .grpc(GrpcTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .perRequest(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .http(HttpTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .perRequest(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .http2(HttpTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .perRequest(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .tcp(TcpTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .tls(ListenerTlsProperty.builder()
 *                                 .certificate(ListenerTlsCertificateProperty.builder()
 *                                         .acm(ListenerTlsAcmCertificateProperty.builder()
 *                                                 .certificateArn("certificateArn")
 *                                                 .build())
 *                                         .file(ListenerTlsFileCertificateProperty.builder()
 *                                                 .certificateChain("certificateChain")
 *                                                 .privateKey("privateKey")
 *                                                 .build())
 *                                         .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                                 .secretName("secretName")
 *                                                 .build())
 *                                         .build())
 *                                 .mode("mode")
 *                                 // the properties below are optional
 *                                 .validation(ListenerTlsValidationContextProperty.builder()
 *                                         .trust(ListenerTlsValidationContextTrustProperty.builder()
 *                                                 .file(TlsValidationContextFileTrustProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .build())
 *                                                 .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                         .exact(List.of("exact"))
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .logging(LoggingProperty.builder()
 *                         .accessLog(AccessLogProperty.builder()
 *                                 .file(FileAccessLogProperty.builder()
 *                                         .path("path")
 *                                         // the properties below are optional
 *                                         .format(LoggingFormatProperty.builder()
 *                                                 .json(List.of(JsonFormatRefProperty.builder()
 *                                                         .key("key")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .text("text")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .serviceDiscovery(ServiceDiscoveryProperty.builder()
 *                         .awsCloudMap(AwsCloudMapServiceDiscoveryProperty.builder()
 *                                 .namespaceName("namespaceName")
 *                                 .serviceName("serviceName")
 *                                 // the properties below are optional
 *                                 .attributes(List.of(AwsCloudMapInstanceAttributeProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .ipPreference("ipPreference")
 *                                 .build())
 *                         .dns(DnsServiceDiscoveryProperty.builder()
 *                                 .hostname("hostname")
 *                                 // the properties below are optional
 *                                 .ipPreference("ipPreference")
 *                                 .responseType("responseType")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .meshOwner("meshOwner")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualNodeName("virtualNodeName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:00.395Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode")
public class CfnVirtualNode extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnVirtualNode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVirtualNode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appmesh.CfnVirtualNode.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppMesh::VirtualNode`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVirtualNode(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualNodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The full Amazon Resource Name (ARN) for the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh that the virtual node resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshName() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the resource owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUid() {
        return software.amazon.jsii.Kernel.get(this, "attrUid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVirtualNodeName() {
        return software.amazon.jsii.Kernel.get(this, "attrVirtualNodeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Optional metadata that you can apply to the virtual node to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the service mesh to create the virtual node in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMeshName() {
        return software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh to create the virtual node in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshName", java.util.Objects.requireNonNull(value, "meshName is required"));
    }

    /**
     * The virtual node specification to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSpec() {
        return software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The virtual node specification to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeSpecProperty value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The virtual node specification to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshOwner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshOwner", value);
    }

    /**
     * The name to use for the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVirtualNodeName() {
        return software.amazon.jsii.Kernel.get(this, "virtualNodeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name to use for the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVirtualNodeName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "virtualNodeName", value);
    }
    /**
     * An object that represents the access logging information for a virtual node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * AccessLogProperty accessLogProperty = AccessLogProperty.builder()
     *         .file(FileAccessLogProperty.builder()
     *                 .path("path")
     *                 // the properties below are optional
     *                 .format(LoggingFormatProperty.builder()
     *                         .json(List.of(JsonFormatRefProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .text("text")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.AccessLogProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessLogProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file object to send virtual node access logs to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessLogProperty> {
            java.lang.Object file;

            /**
             * Sets the value of {@link AccessLogProperty#getFile}
             * @param file The file object to send virtual node access logs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualNode.FileAccessLogProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link AccessLogProperty#getFile}
             * @param file The file object to send virtual node access logs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessLogProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogProperty {
            private final java.lang.Object file;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = builder.file;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.AccessLogProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogProperty.Jsii$Proxy that = (AccessLogProperty.Jsii$Proxy) o;

                return this.file != null ? this.file.equals(that.file) : that.file == null;
            }

            @Override
            public final int hashCode() {
                int result = this.file != null ? this.file.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the AWS Cloud Map attribute information for your virtual node.
     * <p>
     * <blockquote>
     * <p>
     * AWS Cloud Map is not available in the eu-south-1 Region.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * AwsCloudMapInstanceAttributeProperty awsCloudMapInstanceAttributeProperty = AwsCloudMapInstanceAttributeProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.AwsCloudMapInstanceAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsCloudMapInstanceAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsCloudMapInstanceAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an AWS Cloud Map service instance attribute key.
         * <p>
         * Any AWS Cloud Map service instance that contains the specified key and value is returned.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of an AWS Cloud Map service instance attribute key.
         * <p>
         * Any AWS Cloud Map service instance that contains the specified key and value is returned.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link AwsCloudMapInstanceAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsCloudMapInstanceAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsCloudMapInstanceAttributeProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link AwsCloudMapInstanceAttributeProperty#getKey}
             * @param key The name of an AWS Cloud Map service instance attribute key. This parameter is required.
             *            Any AWS Cloud Map service instance that contains the specified key and value is returned.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link AwsCloudMapInstanceAttributeProperty#getValue}
             * @param value The value of an AWS Cloud Map service instance attribute key. This parameter is required.
             *              Any AWS Cloud Map service instance that contains the specified key and value is returned.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsCloudMapInstanceAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsCloudMapInstanceAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsCloudMapInstanceAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCloudMapInstanceAttributeProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.AwsCloudMapInstanceAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsCloudMapInstanceAttributeProperty.Jsii$Proxy that = (AwsCloudMapInstanceAttributeProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the AWS Cloud Map service discovery information for your virtual node.
     * <p>
     * <blockquote>
     * <p>
     * AWS Cloud Map is not available in the eu-south-1 Region.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * AwsCloudMapServiceDiscoveryProperty awsCloudMapServiceDiscoveryProperty = AwsCloudMapServiceDiscoveryProperty.builder()
     *         .namespaceName("namespaceName")
     *         .serviceName("serviceName")
     *         // the properties below are optional
     *         .attributes(List.of(AwsCloudMapInstanceAttributeProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .ipPreference("ipPreference")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsCloudMapServiceDiscoveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsCloudMapServiceDiscoveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AWS Cloud Map namespace to use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespaceName();

        /**
         * The name of the AWS Cloud Map service to use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

        /**
         * A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
         * <p>
         * Only instances that match all of the specified key/value pairs will be returned.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * The preferred IP version that this virtual node uses.
         * <p>
         * Setting the IP preference on the virtual node only overrides the IP preference set for the mesh on this specific node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpPreference() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsCloudMapServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsCloudMapServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsCloudMapServiceDiscoveryProperty> {
            java.lang.String namespaceName;
            java.lang.String serviceName;
            java.lang.Object attributes;
            java.lang.String ipPreference;

            /**
             * Sets the value of {@link AwsCloudMapServiceDiscoveryProperty#getNamespaceName}
             * @param namespaceName The name of the AWS Cloud Map namespace to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceName(java.lang.String namespaceName) {
                this.namespaceName = namespaceName;
                return this;
            }

            /**
             * Sets the value of {@link AwsCloudMapServiceDiscoveryProperty#getServiceName}
             * @param serviceName The name of the AWS Cloud Map service to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Sets the value of {@link AwsCloudMapServiceDiscoveryProperty#getAttributes}
             * @param attributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
             *                   Only instances that match all of the specified key/value pairs will be returned.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link AwsCloudMapServiceDiscoveryProperty#getAttributes}
             * @param attributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
             *                   Only instances that match all of the specified key/value pairs will be returned.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.List<? extends java.lang.Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link AwsCloudMapServiceDiscoveryProperty#getIpPreference}
             * @param ipPreference The preferred IP version that this virtual node uses.
             *                     Setting the IP preference on the virtual node only overrides the IP preference set for the mesh on this specific node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipPreference(java.lang.String ipPreference) {
                this.ipPreference = ipPreference;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsCloudMapServiceDiscoveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsCloudMapServiceDiscoveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsCloudMapServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCloudMapServiceDiscoveryProperty {
            private final java.lang.String namespaceName;
            private final java.lang.String serviceName;
            private final java.lang.Object attributes;
            private final java.lang.String ipPreference;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.namespaceName = software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipPreference = software.amazon.jsii.Kernel.get(this, "ipPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespaceName = java.util.Objects.requireNonNull(builder.namespaceName, "namespaceName is required");
                this.serviceName = java.util.Objects.requireNonNull(builder.serviceName, "serviceName is required");
                this.attributes = builder.attributes;
                this.ipPreference = builder.ipPreference;
            }

            @Override
            public final java.lang.String getNamespaceName() {
                return this.namespaceName;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.String getIpPreference() {
                return this.ipPreference;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("namespaceName", om.valueToTree(this.getNamespaceName()));
                data.set("serviceName", om.valueToTree(this.getServiceName()));
                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getIpPreference() != null) {
                    data.set("ipPreference", om.valueToTree(this.getIpPreference()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsCloudMapServiceDiscoveryProperty.Jsii$Proxy that = (AwsCloudMapServiceDiscoveryProperty.Jsii$Proxy) o;

                if (!namespaceName.equals(that.namespaceName)) return false;
                if (!serviceName.equals(that.serviceName)) return false;
                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                return this.ipPreference != null ? this.ipPreference.equals(that.ipPreference) : that.ipPreference == null;
            }

            @Override
            public final int hashCode() {
                int result = this.namespaceName.hashCode();
                result = 31 * result + (this.serviceName.hashCode());
                result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
                result = 31 * result + (this.ipPreference != null ? this.ipPreference.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the default properties for a backend.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * BackendDefaultsProperty backendDefaultsProperty = BackendDefaultsProperty.builder()
     *         .clientPolicy(ClientPolicyProperty.builder()
     *                 .tls(ClientPolicyTlsProperty.builder()
     *                         .validation(TlsValidationContextProperty.builder()
     *                                 .trust(TlsValidationContextTrustProperty.builder()
     *                                         .acm(TlsValidationContextAcmTrustProperty.builder()
     *                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                                 .build())
     *                                         .file(TlsValidationContextFileTrustProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .build())
     *                                         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                 .exact(List.of("exact"))
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .certificate(ClientTlsCertificateProperty.builder()
     *                                 .file(ListenerTlsFileCertificateProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .privateKey("privateKey")
     *                                         .build())
     *                                 .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         .enforce(false)
     *                         .ports(List.of(123))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.BackendDefaultsProperty")
    @software.amazon.jsii.Jsii.Proxy(BackendDefaultsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BackendDefaultsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a client policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BackendDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BackendDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BackendDefaultsProperty> {
            java.lang.Object clientPolicy;

            /**
             * Sets the value of {@link BackendDefaultsProperty#getClientPolicy}
             * @param clientPolicy A reference to an object that represents a client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientPolicy(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ClientPolicyProperty clientPolicy) {
                this.clientPolicy = clientPolicy;
                return this;
            }

            /**
             * Sets the value of {@link BackendDefaultsProperty#getClientPolicy}
             * @param clientPolicy A reference to an object that represents a client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientPolicy(software.amazon.awscdk.IResolvable clientPolicy) {
                this.clientPolicy = clientPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BackendDefaultsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BackendDefaultsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BackendDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackendDefaultsProperty {
            private final java.lang.Object clientPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientPolicy = software.amazon.jsii.Kernel.get(this, "clientPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientPolicy = builder.clientPolicy;
            }

            @Override
            public final java.lang.Object getClientPolicy() {
                return this.clientPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientPolicy() != null) {
                    data.set("clientPolicy", om.valueToTree(this.getClientPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.BackendDefaultsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BackendDefaultsProperty.Jsii$Proxy that = (BackendDefaultsProperty.Jsii$Proxy) o;

                return this.clientPolicy != null ? this.clientPolicy.equals(that.clientPolicy) : that.clientPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientPolicy != null ? this.clientPolicy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the backends that a virtual node is expected to send outbound traffic to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * BackendProperty backendProperty = BackendProperty.builder()
     *         .virtualService(VirtualServiceBackendProperty.builder()
     *                 .virtualServiceName("virtualServiceName")
     *                 // the properties below are optional
     *                 .clientPolicy(ClientPolicyProperty.builder()
     *                         .tls(ClientPolicyTlsProperty.builder()
     *                                 .validation(TlsValidationContextProperty.builder()
     *                                         .trust(TlsValidationContextTrustProperty.builder()
     *                                                 .acm(TlsValidationContextAcmTrustProperty.builder()
     *                                                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                                         .build())
     *                                                 .file(TlsValidationContextFileTrustProperty.builder()
     *                                                         .certificateChain("certificateChain")
     *                                                         .build())
     *                                                 .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                                         .secretName("secretName")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                         .exact(List.of("exact"))
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .certificate(ClientTlsCertificateProperty.builder()
     *                                         .file(ListenerTlsFileCertificateProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .privateKey("privateKey")
     *                                                 .build())
     *                                         .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 .enforce(false)
     *                                 .ports(List.of(123))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.BackendProperty")
    @software.amazon.jsii.Jsii.Proxy(BackendProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BackendProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a virtual service to use as a backend.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVirtualService() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BackendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BackendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BackendProperty> {
            java.lang.Object virtualService;

            /**
             * Sets the value of {@link BackendProperty#getVirtualService}
             * @param virtualService Specifies a virtual service to use as a backend.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualService(software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualServiceBackendProperty virtualService) {
                this.virtualService = virtualService;
                return this;
            }

            /**
             * Sets the value of {@link BackendProperty#getVirtualService}
             * @param virtualService Specifies a virtual service to use as a backend.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualService(software.amazon.awscdk.IResolvable virtualService) {
                this.virtualService = virtualService;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BackendProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BackendProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BackendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackendProperty {
            private final java.lang.Object virtualService;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.virtualService = software.amazon.jsii.Kernel.get(this, "virtualService", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.virtualService = builder.virtualService;
            }

            @Override
            public final java.lang.Object getVirtualService() {
                return this.virtualService;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVirtualService() != null) {
                    data.set("virtualService", om.valueToTree(this.getVirtualService()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.BackendProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BackendProperty.Jsii$Proxy that = (BackendProperty.Jsii$Proxy) o;

                return this.virtualService != null ? this.virtualService.equals(that.virtualService) : that.virtualService == null;
            }

            @Override
            public final int hashCode() {
                int result = this.virtualService != null ? this.virtualService.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a client policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ClientPolicyProperty clientPolicyProperty = ClientPolicyProperty.builder()
     *         .tls(ClientPolicyTlsProperty.builder()
     *                 .validation(TlsValidationContextProperty.builder()
     *                         .trust(TlsValidationContextTrustProperty.builder()
     *                                 .acm(TlsValidationContextAcmTrustProperty.builder()
     *                                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                         .build())
     *                                 .file(TlsValidationContextFileTrustProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .build())
     *                                 .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                         .exact(List.of("exact"))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .certificate(ClientTlsCertificateProperty.builder()
     *                         .file(ListenerTlsFileCertificateProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .privateKey("privateKey")
     *                                 .build())
     *                         .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 .enforce(false)
     *                 .ports(List.of(123))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ClientPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a Transport Layer Security (TLS) client policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientPolicyProperty> {
            java.lang.Object tls;

            /**
             * Sets the value of {@link ClientPolicyProperty#getTls}
             * @param tls A reference to an object that represents a Transport Layer Security (TLS) client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ClientPolicyTlsProperty tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyProperty#getTls}
             * @param tls A reference to an object that represents a Transport Layer Security (TLS) client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.IResolvable tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientPolicyProperty {
            private final java.lang.Object tls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tls = builder.tls;
            }

            @Override
            public final java.lang.Object getTls() {
                return this.tls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTls() != null) {
                    data.set("tls", om.valueToTree(this.getTls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ClientPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientPolicyProperty.Jsii$Proxy that = (ClientPolicyProperty.Jsii$Proxy) o;

                return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tls != null ? this.tls.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A reference to an object that represents a Transport Layer Security (TLS) client policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ClientPolicyTlsProperty clientPolicyTlsProperty = ClientPolicyTlsProperty.builder()
     *         .validation(TlsValidationContextProperty.builder()
     *                 .trust(TlsValidationContextTrustProperty.builder()
     *                         .acm(TlsValidationContextAcmTrustProperty.builder()
     *                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                 .build())
     *                         .file(TlsValidationContextFileTrustProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .build())
     *                         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                 .exact(List.of("exact"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .certificate(ClientTlsCertificateProperty.builder()
     *                 .file(ListenerTlsFileCertificateProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .privateKey("privateKey")
     *                         .build())
     *                 .sds(ListenerTlsSdsCertificateProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         .enforce(false)
     *         .ports(List.of(123))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ClientPolicyTlsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientPolicyTlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientPolicyTlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a TLS validation context.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValidation();

        /**
         * A reference to an object that represents a client's TLS certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCertificate() {
            return null;
        }

        /**
         * Whether the policy is enforced.
         * <p>
         * The default is <code>True</code> , if a value isn't specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforce() {
            return null;
        }

        /**
         * One or more ports that the policy is enforced for.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPorts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientPolicyTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientPolicyTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientPolicyTlsProperty> {
            java.lang.Object validation;
            java.lang.Object certificate;
            java.lang.Object enforce;
            java.lang.Object ports;

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getValidation}
             * @param validation A reference to an object that represents a TLS validation context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextProperty validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getValidation}
             * @param validation A reference to an object that represents a TLS validation context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.IResolvable validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getCertificate}
             * @param certificate A reference to an object that represents a client's TLS certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ClientTlsCertificateProperty certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getCertificate}
             * @param certificate A reference to an object that represents a client's TLS certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.IResolvable certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getEnforce}
             * @param enforce Whether the policy is enforced.
             *                The default is <code>True</code> , if a value isn't specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforce(java.lang.Boolean enforce) {
                this.enforce = enforce;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getEnforce}
             * @param enforce Whether the policy is enforced.
             *                The default is <code>True</code> , if a value isn't specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforce(software.amazon.awscdk.IResolvable enforce) {
                this.enforce = enforce;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getPorts}
             * @param ports One or more ports that the policy is enforced for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(software.amazon.awscdk.IResolvable ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Sets the value of {@link ClientPolicyTlsProperty#getPorts}
             * @param ports One or more ports that the policy is enforced for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(java.util.List<? extends java.lang.Number> ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientPolicyTlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientPolicyTlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientPolicyTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientPolicyTlsProperty {
            private final java.lang.Object validation;
            private final java.lang.Object certificate;
            private final java.lang.Object enforce;
            private final java.lang.Object ports;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforce = software.amazon.jsii.Kernel.get(this, "enforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.validation = java.util.Objects.requireNonNull(builder.validation, "validation is required");
                this.certificate = builder.certificate;
                this.enforce = builder.enforce;
                this.ports = builder.ports;
            }

            @Override
            public final java.lang.Object getValidation() {
                return this.validation;
            }

            @Override
            public final java.lang.Object getCertificate() {
                return this.certificate;
            }

            @Override
            public final java.lang.Object getEnforce() {
                return this.enforce;
            }

            @Override
            public final java.lang.Object getPorts() {
                return this.ports;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("validation", om.valueToTree(this.getValidation()));
                if (this.getCertificate() != null) {
                    data.set("certificate", om.valueToTree(this.getCertificate()));
                }
                if (this.getEnforce() != null) {
                    data.set("enforce", om.valueToTree(this.getEnforce()));
                }
                if (this.getPorts() != null) {
                    data.set("ports", om.valueToTree(this.getPorts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ClientPolicyTlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientPolicyTlsProperty.Jsii$Proxy that = (ClientPolicyTlsProperty.Jsii$Proxy) o;

                if (!validation.equals(that.validation)) return false;
                if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
                if (this.enforce != null ? !this.enforce.equals(that.enforce) : that.enforce != null) return false;
                return this.ports != null ? this.ports.equals(that.ports) : that.ports == null;
            }

            @Override
            public final int hashCode() {
                int result = this.validation.hashCode();
                result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
                result = 31 * result + (this.enforce != null ? this.enforce.hashCode() : 0);
                result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the client's certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ClientTlsCertificateProperty clientTlsCertificateProperty = ClientTlsCertificateProperty.builder()
     *         .file(ListenerTlsFileCertificateProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .privateKey("privateKey")
     *                 .build())
     *         .sds(ListenerTlsSdsCertificateProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ClientTlsCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientTlsCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientTlsCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a local file certificate.
         * <p>
         * The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a client's TLS Secret Discovery Service certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientTlsCertificateProperty> {
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link ClientTlsCertificateProperty#getFile}
             * @param file An object that represents a local file certificate.
             *             The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsFileCertificateProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link ClientTlsCertificateProperty#getFile}
             * @param file An object that represents a local file certificate.
             *             The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link ClientTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a client's TLS Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsSdsCertificateProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link ClientTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a client's TLS Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientTlsCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientTlsCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientTlsCertificateProperty {
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ClientTlsCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientTlsCertificateProperty.Jsii$Proxy that = (ClientTlsCertificateProperty.Jsii$Proxy) o;

                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.file != null ? this.file.hashCode() : 0;
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the DNS service discovery information for your virtual node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * DnsServiceDiscoveryProperty dnsServiceDiscoveryProperty = DnsServiceDiscoveryProperty.builder()
     *         .hostname("hostname")
     *         // the properties below are optional
     *         .ipPreference("ipPreference")
     *         .responseType("responseType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.DnsServiceDiscoveryProperty")
    @software.amazon.jsii.Jsii.Proxy(DnsServiceDiscoveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DnsServiceDiscoveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the DNS service discovery hostname for the virtual node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostname();

        /**
         * The preferred IP version that this virtual node uses.
         * <p>
         * Setting the IP preference on the virtual node only overrides the IP preference set for the mesh on this specific node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpPreference() {
            return null;
        }

        /**
         * Specifies the DNS response type for the virtual node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponseType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DnsServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DnsServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DnsServiceDiscoveryProperty> {
            java.lang.String hostname;
            java.lang.String ipPreference;
            java.lang.String responseType;

            /**
             * Sets the value of {@link DnsServiceDiscoveryProperty#getHostname}
             * @param hostname Specifies the DNS service discovery hostname for the virtual node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(java.lang.String hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link DnsServiceDiscoveryProperty#getIpPreference}
             * @param ipPreference The preferred IP version that this virtual node uses.
             *                     Setting the IP preference on the virtual node only overrides the IP preference set for the mesh on this specific node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipPreference(java.lang.String ipPreference) {
                this.ipPreference = ipPreference;
                return this;
            }

            /**
             * Sets the value of {@link DnsServiceDiscoveryProperty#getResponseType}
             * @param responseType Specifies the DNS response type for the virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseType(java.lang.String responseType) {
                this.responseType = responseType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DnsServiceDiscoveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DnsServiceDiscoveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DnsServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsServiceDiscoveryProperty {
            private final java.lang.String hostname;
            private final java.lang.String ipPreference;
            private final java.lang.String responseType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipPreference = software.amazon.jsii.Kernel.get(this, "ipPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseType = software.amazon.jsii.Kernel.get(this, "responseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostname = java.util.Objects.requireNonNull(builder.hostname, "hostname is required");
                this.ipPreference = builder.ipPreference;
                this.responseType = builder.responseType;
            }

            @Override
            public final java.lang.String getHostname() {
                return this.hostname;
            }

            @Override
            public final java.lang.String getIpPreference() {
                return this.ipPreference;
            }

            @Override
            public final java.lang.String getResponseType() {
                return this.responseType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hostname", om.valueToTree(this.getHostname()));
                if (this.getIpPreference() != null) {
                    data.set("ipPreference", om.valueToTree(this.getIpPreference()));
                }
                if (this.getResponseType() != null) {
                    data.set("responseType", om.valueToTree(this.getResponseType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.DnsServiceDiscoveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DnsServiceDiscoveryProperty.Jsii$Proxy that = (DnsServiceDiscoveryProperty.Jsii$Proxy) o;

                if (!hostname.equals(that.hostname)) return false;
                if (this.ipPreference != null ? !this.ipPreference.equals(that.ipPreference) : that.ipPreference != null) return false;
                return this.responseType != null ? this.responseType.equals(that.responseType) : that.responseType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostname.hashCode();
                result = 31 * result + (this.ipPreference != null ? this.ipPreference.hashCode() : 0);
                result = 31 * result + (this.responseType != null ? this.responseType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a duration of time.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * DurationProperty durationProperty = DurationProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.DurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unit of time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * A number of time units.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link DurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DurationProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link DurationProperty#getUnit}
             * @param unit A unit of time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link DurationProperty#getValue}
             * @param value A number of time units. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DurationProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.DurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DurationProperty.Jsii$Proxy that = (DurationProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents an access log file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * FileAccessLogProperty fileAccessLogProperty = FileAccessLogProperty.builder()
     *         .path("path")
     *         // the properties below are optional
     *         .format(LoggingFormatProperty.builder()
     *                 .json(List.of(JsonFormatRefProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .text("text")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.FileAccessLogProperty")
    @software.amazon.jsii.Jsii.Proxy(FileAccessLogProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileAccessLogProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file path to write access logs to.
         * <p>
         * You can use <code>/dev/stdout</code> to send access logs to standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code> , to export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's file system to write the files to disk.
         * <p>
         * <blockquote>
         * <p>
         * The Envoy process must have write permissions to the path that you specify here. Otherwise, Envoy fails to bootstrap properly.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * `CfnVirtualNode.FileAccessLogProperty.Format`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileAccessLogProperty> {
            java.lang.String path;
            java.lang.Object format;

            /**
             * Sets the value of {@link FileAccessLogProperty#getPath}
             * @param path The file path to write access logs to. This parameter is required.
             *             You can use <code>/dev/stdout</code> to send access logs to standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code> , to export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's file system to write the files to disk.
             *             <p>
             *             <blockquote>
             *             <p>
             *             The Envoy process must have write permissions to the path that you specify here. Otherwise, Envoy fails to bootstrap properly.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link FileAccessLogProperty#getFormat}
             * @param format `CfnVirtualNode.FileAccessLogProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingFormatProperty format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link FileAccessLogProperty#getFormat}
             * @param format `CfnVirtualNode.FileAccessLogProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(software.amazon.awscdk.IResolvable format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileAccessLogProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileAccessLogProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAccessLogProperty {
            private final java.lang.String path;
            private final java.lang.Object format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.format = builder.format;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Object getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("path", om.valueToTree(this.getPath()));
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.FileAccessLogProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileAccessLogProperty.Jsii$Proxy that = (FileAccessLogProperty.Jsii$Proxy) o;

                if (!path.equals(that.path)) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path.hashCode();
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents types of timeouts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcTimeoutProperty grpcTimeoutProperty = GrpcTimeoutProperty.builder()
     *         .idle(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .perRequest(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.GrpcTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents an idle timeout.
         * <p>
         * An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdle() {
            return null;
        }

        /**
         * An object that represents a per request timeout.
         * <p>
         * The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPerRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcTimeoutProperty> {
            java.lang.Object idle;
            java.lang.Object perRequest;

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.IResolvable idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.IResolvable perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcTimeoutProperty {
            private final java.lang.Object idle;
            private final java.lang.Object perRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idle = software.amazon.jsii.Kernel.get(this, "idle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.perRequest = software.amazon.jsii.Kernel.get(this, "perRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idle = builder.idle;
                this.perRequest = builder.perRequest;
            }

            @Override
            public final java.lang.Object getIdle() {
                return this.idle;
            }

            @Override
            public final java.lang.Object getPerRequest() {
                return this.perRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdle() != null) {
                    data.set("idle", om.valueToTree(this.getIdle()));
                }
                if (this.getPerRequest() != null) {
                    data.set("perRequest", om.valueToTree(this.getPerRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.GrpcTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcTimeoutProperty.Jsii$Proxy that = (GrpcTimeoutProperty.Jsii$Proxy) o;

                if (this.idle != null ? !this.idle.equals(that.idle) : that.idle != null) return false;
                return this.perRequest != null ? this.perRequest.equals(that.perRequest) : that.perRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idle != null ? this.idle.hashCode() : 0;
                result = 31 * result + (this.perRequest != null ? this.perRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the health check policy for a virtual node's listener.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HealthCheckProperty healthCheckProperty = HealthCheckProperty.builder()
     *         .healthyThreshold(123)
     *         .intervalMillis(123)
     *         .protocol("protocol")
     *         .timeoutMillis(123)
     *         .unhealthyThreshold(123)
     *         // the properties below are optional
     *         .path("path")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.HealthCheckProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of consecutive successful health checks that must occur before declaring listener healthy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHealthyThreshold();

        /**
         * The time period in milliseconds between each health check execution.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getIntervalMillis();

        /**
         * The protocol for the health check request.
         * <p>
         * If you specify <code>grpc</code> , then your service must conform to the <a href="https://docs.aws.amazon.com/https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * The amount of time to wait when receiving a response from the health check, in milliseconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutMillis();

        /**
         * The number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getUnhealthyThreshold();

        /**
         * The destination path for the health check request.
         * <p>
         * This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The destination port for the health check request.
         * <p>
         * This port must match the port defined in the <code>PortMapping</code> for the listener.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckProperty> {
            java.lang.Number healthyThreshold;
            java.lang.Number intervalMillis;
            java.lang.String protocol;
            java.lang.Number timeoutMillis;
            java.lang.Number unhealthyThreshold;
            java.lang.String path;
            java.lang.Number port;

            /**
             * Sets the value of {@link HealthCheckProperty#getHealthyThreshold}
             * @param healthyThreshold The number of consecutive successful health checks that must occur before declaring listener healthy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthyThreshold(java.lang.Number healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getIntervalMillis}
             * @param intervalMillis The time period in milliseconds between each health check execution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalMillis(java.lang.Number intervalMillis) {
                this.intervalMillis = intervalMillis;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getProtocol}
             * @param protocol The protocol for the health check request. This parameter is required.
             *                 If you specify <code>grpc</code> , then your service must conform to the <a href="https://docs.aws.amazon.com/https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getTimeoutMillis}
             * @param timeoutMillis The amount of time to wait when receiving a response from the health check, in milliseconds. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMillis(java.lang.Number timeoutMillis) {
                this.timeoutMillis = timeoutMillis;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getUnhealthyThreshold}
             * @param unhealthyThreshold The number of consecutive failed health checks that must occur before declaring a virtual node unhealthy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unhealthyThreshold(java.lang.Number unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getPath}
             * @param path The destination path for the health check request.
             *             This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getPort}
             * @param port The destination port for the health check request.
             *             This port must match the port defined in the <code>PortMapping</code> for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckProperty {
            private final java.lang.Number healthyThreshold;
            private final java.lang.Number intervalMillis;
            private final java.lang.String protocol;
            private final java.lang.Number timeoutMillis;
            private final java.lang.Number unhealthyThreshold;
            private final java.lang.String path;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthyThreshold = software.amazon.jsii.Kernel.get(this, "healthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalMillis = software.amazon.jsii.Kernel.get(this, "intervalMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutMillis = software.amazon.jsii.Kernel.get(this, "timeoutMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unhealthyThreshold = software.amazon.jsii.Kernel.get(this, "unhealthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthyThreshold = java.util.Objects.requireNonNull(builder.healthyThreshold, "healthyThreshold is required");
                this.intervalMillis = java.util.Objects.requireNonNull(builder.intervalMillis, "intervalMillis is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.timeoutMillis = java.util.Objects.requireNonNull(builder.timeoutMillis, "timeoutMillis is required");
                this.unhealthyThreshold = java.util.Objects.requireNonNull(builder.unhealthyThreshold, "unhealthyThreshold is required");
                this.path = builder.path;
                this.port = builder.port;
            }

            @Override
            public final java.lang.Number getHealthyThreshold() {
                return this.healthyThreshold;
            }

            @Override
            public final java.lang.Number getIntervalMillis() {
                return this.intervalMillis;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getTimeoutMillis() {
                return this.timeoutMillis;
            }

            @Override
            public final java.lang.Number getUnhealthyThreshold() {
                return this.unhealthyThreshold;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
                data.set("intervalMillis", om.valueToTree(this.getIntervalMillis()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("timeoutMillis", om.valueToTree(this.getTimeoutMillis()));
                data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.HealthCheckProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckProperty.Jsii$Proxy that = (HealthCheckProperty.Jsii$Proxy) o;

                if (!healthyThreshold.equals(that.healthyThreshold)) return false;
                if (!intervalMillis.equals(that.intervalMillis)) return false;
                if (!protocol.equals(that.protocol)) return false;
                if (!timeoutMillis.equals(that.timeoutMillis)) return false;
                if (!unhealthyThreshold.equals(that.unhealthyThreshold)) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthyThreshold.hashCode();
                result = 31 * result + (this.intervalMillis.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.timeoutMillis.hashCode());
                result = 31 * result + (this.unhealthyThreshold.hashCode());
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents types of timeouts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpTimeoutProperty httpTimeoutProperty = HttpTimeoutProperty.builder()
     *         .idle(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .perRequest(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.HttpTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents an idle timeout.
         * <p>
         * An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdle() {
            return null;
        }

        /**
         * An object that represents a per request timeout.
         * <p>
         * The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPerRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpTimeoutProperty> {
            java.lang.Object idle;
            java.lang.Object perRequest;

            /**
             * Sets the value of {@link HttpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link HttpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.IResolvable idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link HttpTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Sets the value of {@link HttpTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.IResolvable perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpTimeoutProperty {
            private final java.lang.Object idle;
            private final java.lang.Object perRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idle = software.amazon.jsii.Kernel.get(this, "idle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.perRequest = software.amazon.jsii.Kernel.get(this, "perRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idle = builder.idle;
                this.perRequest = builder.perRequest;
            }

            @Override
            public final java.lang.Object getIdle() {
                return this.idle;
            }

            @Override
            public final java.lang.Object getPerRequest() {
                return this.perRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdle() != null) {
                    data.set("idle", om.valueToTree(this.getIdle()));
                }
                if (this.getPerRequest() != null) {
                    data.set("perRequest", om.valueToTree(this.getPerRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.HttpTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpTimeoutProperty.Jsii$Proxy that = (HttpTimeoutProperty.Jsii$Proxy) o;

                if (this.idle != null ? !this.idle.equals(that.idle) : that.idle != null) return false;
                return this.perRequest != null ? this.perRequest.equals(that.perRequest) : that.perRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idle != null ? this.idle.hashCode() : 0;
                result = 31 * result + (this.perRequest != null ? this.perRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * JsonFormatRefProperty jsonFormatRefProperty = JsonFormatRefProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.JsonFormatRefProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonFormatRefProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonFormatRefProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnVirtualNode.JsonFormatRefProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnVirtualNode.JsonFormatRefProperty.Value`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link JsonFormatRefProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonFormatRefProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonFormatRefProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link JsonFormatRefProperty#getKey}
             * @param key `CfnVirtualNode.JsonFormatRefProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link JsonFormatRefProperty#getValue}
             * @param value `CfnVirtualNode.JsonFormatRefProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonFormatRefProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonFormatRefProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonFormatRefProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonFormatRefProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.JsonFormatRefProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonFormatRefProperty.Jsii$Proxy that = (JsonFormatRefProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents a listener for a virtual node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerProperty listenerProperty = ListenerProperty.builder()
     *         .portMapping(PortMappingProperty.builder()
     *                 .port(123)
     *                 .protocol("protocol")
     *                 .build())
     *         // the properties below are optional
     *         .connectionPool(VirtualNodeConnectionPoolProperty.builder()
     *                 .grpc(VirtualNodeGrpcConnectionPoolProperty.builder()
     *                         .maxRequests(123)
     *                         .build())
     *                 .http(VirtualNodeHttpConnectionPoolProperty.builder()
     *                         .maxConnections(123)
     *                         // the properties below are optional
     *                         .maxPendingRequests(123)
     *                         .build())
     *                 .http2(VirtualNodeHttp2ConnectionPoolProperty.builder()
     *                         .maxRequests(123)
     *                         .build())
     *                 .tcp(VirtualNodeTcpConnectionPoolProperty.builder()
     *                         .maxConnections(123)
     *                         .build())
     *                 .build())
     *         .healthCheck(HealthCheckProperty.builder()
     *                 .healthyThreshold(123)
     *                 .intervalMillis(123)
     *                 .protocol("protocol")
     *                 .timeoutMillis(123)
     *                 .unhealthyThreshold(123)
     *                 // the properties below are optional
     *                 .path("path")
     *                 .port(123)
     *                 .build())
     *         .outlierDetection(OutlierDetectionProperty.builder()
     *                 .baseEjectionDuration(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .interval(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .maxEjectionPercent(123)
     *                 .maxServerErrors(123)
     *                 .build())
     *         .timeout(ListenerTimeoutProperty.builder()
     *                 .grpc(GrpcTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .perRequest(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .http(HttpTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .perRequest(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .http2(HttpTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .perRequest(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .tcp(TcpTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .tls(ListenerTlsProperty.builder()
     *                 .certificate(ListenerTlsCertificateProperty.builder()
     *                         .acm(ListenerTlsAcmCertificateProperty.builder()
     *                                 .certificateArn("certificateArn")
     *                                 .build())
     *                         .file(ListenerTlsFileCertificateProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .privateKey("privateKey")
     *                                 .build())
     *                         .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 .mode("mode")
     *                 // the properties below are optional
     *                 .validation(ListenerTlsValidationContextProperty.builder()
     *                         .trust(ListenerTlsValidationContextTrustProperty.builder()
     *                                 .file(TlsValidationContextFileTrustProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .build())
     *                                 .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                         .exact(List.of("exact"))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port mapping information for the listener.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPortMapping();

        /**
         * The connection pool information for the listener.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionPool() {
            return null;
        }

        /**
         * The health check information for the listener.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheck() {
            return null;
        }

        /**
         * The outlier detection information for the listener.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutlierDetection() {
            return null;
        }

        /**
         * An object that represents timeouts for different protocols.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
            return null;
        }

        /**
         * A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerProperty> {
            java.lang.Object portMapping;
            java.lang.Object connectionPool;
            java.lang.Object healthCheck;
            java.lang.Object outlierDetection;
            java.lang.Object timeout;
            java.lang.Object tls;

            /**
             * Sets the value of {@link ListenerProperty#getPortMapping}
             * @param portMapping The port mapping information for the listener. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portMapping(software.amazon.awscdk.services.appmesh.CfnVirtualNode.PortMappingProperty portMapping) {
                this.portMapping = portMapping;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getPortMapping}
             * @param portMapping The port mapping information for the listener. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portMapping(software.amazon.awscdk.IResolvable portMapping) {
                this.portMapping = portMapping;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getConnectionPool}
             * @param connectionPool The connection pool information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionPool(software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeConnectionPoolProperty connectionPool) {
                this.connectionPool = connectionPool;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getConnectionPool}
             * @param connectionPool The connection pool information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionPool(software.amazon.awscdk.IResolvable connectionPool) {
                this.connectionPool = connectionPool;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getHealthCheck}
             * @param healthCheck The health check information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.services.appmesh.CfnVirtualNode.HealthCheckProperty healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getHealthCheck}
             * @param healthCheck The health check information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.IResolvable healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getOutlierDetection}
             * @param outlierDetection The outlier detection information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlierDetection(software.amazon.awscdk.services.appmesh.CfnVirtualNode.OutlierDetectionProperty outlierDetection) {
                this.outlierDetection = outlierDetection;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getOutlierDetection}
             * @param outlierDetection The outlier detection information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlierDetection(software.amazon.awscdk.IResolvable outlierDetection) {
                this.outlierDetection = outlierDetection;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getTimeout}
             * @param timeout An object that represents timeouts for different protocols.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTimeoutProperty timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getTimeout}
             * @param timeout An object that represents timeouts for different protocols.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.IResolvable timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getTls}
             * @param tls A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsProperty tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Sets the value of {@link ListenerProperty#getTls}
             * @param tls A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.IResolvable tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerProperty {
            private final java.lang.Object portMapping;
            private final java.lang.Object connectionPool;
            private final java.lang.Object healthCheck;
            private final java.lang.Object outlierDetection;
            private final java.lang.Object timeout;
            private final java.lang.Object tls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.portMapping = software.amazon.jsii.Kernel.get(this, "portMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionPool = software.amazon.jsii.Kernel.get(this, "connectionPool", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outlierDetection = software.amazon.jsii.Kernel.get(this, "outlierDetection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.portMapping = java.util.Objects.requireNonNull(builder.portMapping, "portMapping is required");
                this.connectionPool = builder.connectionPool;
                this.healthCheck = builder.healthCheck;
                this.outlierDetection = builder.outlierDetection;
                this.timeout = builder.timeout;
                this.tls = builder.tls;
            }

            @Override
            public final java.lang.Object getPortMapping() {
                return this.portMapping;
            }

            @Override
            public final java.lang.Object getConnectionPool() {
                return this.connectionPool;
            }

            @Override
            public final java.lang.Object getHealthCheck() {
                return this.healthCheck;
            }

            @Override
            public final java.lang.Object getOutlierDetection() {
                return this.outlierDetection;
            }

            @Override
            public final java.lang.Object getTimeout() {
                return this.timeout;
            }

            @Override
            public final java.lang.Object getTls() {
                return this.tls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("portMapping", om.valueToTree(this.getPortMapping()));
                if (this.getConnectionPool() != null) {
                    data.set("connectionPool", om.valueToTree(this.getConnectionPool()));
                }
                if (this.getHealthCheck() != null) {
                    data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                }
                if (this.getOutlierDetection() != null) {
                    data.set("outlierDetection", om.valueToTree(this.getOutlierDetection()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }
                if (this.getTls() != null) {
                    data.set("tls", om.valueToTree(this.getTls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerProperty.Jsii$Proxy that = (ListenerProperty.Jsii$Proxy) o;

                if (!portMapping.equals(that.portMapping)) return false;
                if (this.connectionPool != null ? !this.connectionPool.equals(that.connectionPool) : that.connectionPool != null) return false;
                if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
                if (this.outlierDetection != null ? !this.outlierDetection.equals(that.outlierDetection) : that.outlierDetection != null) return false;
                if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
                return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.portMapping.hashCode();
                result = 31 * result + (this.connectionPool != null ? this.connectionPool.hashCode() : 0);
                result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
                result = 31 * result + (this.outlierDetection != null ? this.outlierDetection.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents timeouts for different protocols.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTimeoutProperty listenerTimeoutProperty = ListenerTimeoutProperty.builder()
     *         .grpc(GrpcTimeoutProperty.builder()
     *                 .idle(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .perRequest(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .http(HttpTimeoutProperty.builder()
     *                 .idle(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .perRequest(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .http2(HttpTimeoutProperty.builder()
     *                 .idle(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .perRequest(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .tcp(TcpTimeoutProperty.builder()
     *                 .idle(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents types of timeouts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrpc() {
            return null;
        }

        /**
         * An object that represents types of timeouts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp() {
            return null;
        }

        /**
         * An object that represents types of timeouts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp2() {
            return null;
        }

        /**
         * An object that represents types of timeouts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTcp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenerTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTimeoutProperty> {
            java.lang.Object grpc;
            java.lang.Object http;
            java.lang.Object http2;
            java.lang.Object tcp;

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getGrpc}
             * @param grpc An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpc(software.amazon.awscdk.services.appmesh.CfnVirtualNode.GrpcTimeoutProperty grpc) {
                this.grpc = grpc;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getGrpc}
             * @param grpc An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpc(software.amazon.awscdk.IResolvable grpc) {
                this.grpc = grpc;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getHttp}
             * @param http An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.services.appmesh.CfnVirtualNode.HttpTimeoutProperty http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getHttp}
             * @param http An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.IResolvable http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getHttp2}
             * @param http2 An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2(software.amazon.awscdk.services.appmesh.CfnVirtualNode.HttpTimeoutProperty http2) {
                this.http2 = http2;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getHttp2}
             * @param http2 An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2(software.amazon.awscdk.IResolvable http2) {
                this.http2 = http2;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getTcp}
             * @param tcp An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcp(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TcpTimeoutProperty tcp) {
                this.tcp = tcp;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTimeoutProperty#getTcp}
             * @param tcp An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcp(software.amazon.awscdk.IResolvable tcp) {
                this.tcp = tcp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTimeoutProperty {
            private final java.lang.Object grpc;
            private final java.lang.Object http;
            private final java.lang.Object http2;
            private final java.lang.Object tcp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grpc = software.amazon.jsii.Kernel.get(this, "grpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http = software.amazon.jsii.Kernel.get(this, "http", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http2 = software.amazon.jsii.Kernel.get(this, "http2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tcp = software.amazon.jsii.Kernel.get(this, "tcp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grpc = builder.grpc;
                this.http = builder.http;
                this.http2 = builder.http2;
                this.tcp = builder.tcp;
            }

            @Override
            public final java.lang.Object getGrpc() {
                return this.grpc;
            }

            @Override
            public final java.lang.Object getHttp() {
                return this.http;
            }

            @Override
            public final java.lang.Object getHttp2() {
                return this.http2;
            }

            @Override
            public final java.lang.Object getTcp() {
                return this.tcp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrpc() != null) {
                    data.set("grpc", om.valueToTree(this.getGrpc()));
                }
                if (this.getHttp() != null) {
                    data.set("http", om.valueToTree(this.getHttp()));
                }
                if (this.getHttp2() != null) {
                    data.set("http2", om.valueToTree(this.getHttp2()));
                }
                if (this.getTcp() != null) {
                    data.set("tcp", om.valueToTree(this.getTcp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTimeoutProperty.Jsii$Proxy that = (ListenerTimeoutProperty.Jsii$Proxy) o;

                if (this.grpc != null ? !this.grpc.equals(that.grpc) : that.grpc != null) return false;
                if (this.http != null ? !this.http.equals(that.http) : that.http != null) return false;
                if (this.http2 != null ? !this.http2.equals(that.http2) : that.http2 != null) return false;
                return this.tcp != null ? this.tcp.equals(that.tcp) : that.tcp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grpc != null ? this.grpc.hashCode() : 0;
                result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
                result = 31 * result + (this.http2 != null ? this.http2.hashCode() : 0);
                result = 31 * result + (this.tcp != null ? this.tcp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents an AWS Certificate Manager certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTlsAcmCertificateProperty listenerTlsAcmCertificateProperty = ListenerTlsAcmCertificateProperty.builder()
     *         .certificateArn("certificateArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsAcmCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTlsAcmCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTlsAcmCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the certificate.
         * <p>
         * The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn();

        /**
         * @return a {@link Builder} of {@link ListenerTlsAcmCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTlsAcmCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsAcmCertificateProperty> {
            java.lang.String certificateArn;

            /**
             * Sets the value of {@link ListenerTlsAcmCertificateProperty#getCertificateArn}
             * @param certificateArn The Amazon Resource Name (ARN) for the certificate. This parameter is required.
             *                       The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTlsAcmCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTlsAcmCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTlsAcmCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsAcmCertificateProperty {
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = java.util.Objects.requireNonNull(builder.certificateArn, "certificateArn is required");
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateArn", om.valueToTree(this.getCertificateArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsAcmCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTlsAcmCertificateProperty.Jsii$Proxy that = (ListenerTlsAcmCertificateProperty.Jsii$Proxy) o;

                return this.certificateArn.equals(that.certificateArn);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a listener's Transport Layer Security (TLS) certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTlsCertificateProperty listenerTlsCertificateProperty = ListenerTlsCertificateProperty.builder()
     *         .acm(ListenerTlsAcmCertificateProperty.builder()
     *                 .certificateArn("certificateArn")
     *                 .build())
     *         .file(ListenerTlsFileCertificateProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .privateKey("privateKey")
     *                 .build())
     *         .sds(ListenerTlsSdsCertificateProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTlsCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTlsCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents an AWS Certificate Manager certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcm() {
            return null;
        }

        /**
         * A reference to an object that represents a local file certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a listener's Secret Discovery Service certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenerTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsCertificateProperty> {
            java.lang.Object acm;
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link ListenerTlsCertificateProperty#getAcm}
             * @param acm A reference to an object that represents an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsAcmCertificateProperty acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsCertificateProperty#getAcm}
             * @param acm A reference to an object that represents an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.IResolvable acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsCertificateProperty#getFile}
             * @param file A reference to an object that represents a local file certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsFileCertificateProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsCertificateProperty#getFile}
             * @param file A reference to an object that represents a local file certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a listener's Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsSdsCertificateProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a listener's Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTlsCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTlsCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsCertificateProperty {
            private final java.lang.Object acm;
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acm = software.amazon.jsii.Kernel.get(this, "acm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acm = builder.acm;
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getAcm() {
                return this.acm;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcm() != null) {
                    data.set("acm", om.valueToTree(this.getAcm()));
                }
                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTlsCertificateProperty.Jsii$Proxy that = (ListenerTlsCertificateProperty.Jsii$Proxy) o;

                if (this.acm != null ? !this.acm.equals(that.acm) : that.acm != null) return false;
                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acm != null ? this.acm.hashCode() : 0;
                result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a local file certificate.
     * <p>
     * The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTlsFileCertificateProperty listenerTlsFileCertificateProperty = ListenerTlsFileCertificateProperty.builder()
     *         .certificateChain("certificateChain")
     *         .privateKey("privateKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsFileCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTlsFileCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTlsFileCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The certificate chain for the certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateChain();

        /**
         * The private key for a certificate stored on the file system of the virtual node that the proxy is running on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrivateKey();

        /**
         * @return a {@link Builder} of {@link ListenerTlsFileCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTlsFileCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsFileCertificateProperty> {
            java.lang.String certificateChain;
            java.lang.String privateKey;

            /**
             * Sets the value of {@link ListenerTlsFileCertificateProperty#getCertificateChain}
             * @param certificateChain The certificate chain for the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateChain(java.lang.String certificateChain) {
                this.certificateChain = certificateChain;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsFileCertificateProperty#getPrivateKey}
             * @param privateKey The private key for a certificate stored on the file system of the virtual node that the proxy is running on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKey(java.lang.String privateKey) {
                this.privateKey = privateKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTlsFileCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTlsFileCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTlsFileCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsFileCertificateProperty {
            private final java.lang.String certificateChain;
            private final java.lang.String privateKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateChain = software.amazon.jsii.Kernel.get(this, "certificateChain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateKey = software.amazon.jsii.Kernel.get(this, "privateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateChain = java.util.Objects.requireNonNull(builder.certificateChain, "certificateChain is required");
                this.privateKey = java.util.Objects.requireNonNull(builder.privateKey, "privateKey is required");
            }

            @Override
            public final java.lang.String getCertificateChain() {
                return this.certificateChain;
            }

            @Override
            public final java.lang.String getPrivateKey() {
                return this.privateKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateChain", om.valueToTree(this.getCertificateChain()));
                data.set("privateKey", om.valueToTree(this.getPrivateKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsFileCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTlsFileCertificateProperty.Jsii$Proxy that = (ListenerTlsFileCertificateProperty.Jsii$Proxy) o;

                if (!certificateChain.equals(that.certificateChain)) return false;
                return this.privateKey.equals(that.privateKey);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateChain.hashCode();
                result = 31 * result + (this.privateKey.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the Transport Layer Security (TLS) properties for a listener.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTlsProperty listenerTlsProperty = ListenerTlsProperty.builder()
     *         .certificate(ListenerTlsCertificateProperty.builder()
     *                 .acm(ListenerTlsAcmCertificateProperty.builder()
     *                         .certificateArn("certificateArn")
     *                         .build())
     *                 .file(ListenerTlsFileCertificateProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .privateKey("privateKey")
     *                         .build())
     *                 .sds(ListenerTlsSdsCertificateProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         .mode("mode")
     *         // the properties below are optional
     *         .validation(ListenerTlsValidationContextProperty.builder()
     *                 .trust(ListenerTlsValidationContextTrustProperty.builder()
     *                         .file(TlsValidationContextFileTrustProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .build())
     *                         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                 .exact(List.of("exact"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCertificate();

        /**
         * Specify one of the following modes.
         * <p>
         * <ul>
         * <li>** STRICT – Listener only accepts connections with TLS enabled.</li>
         * <li>** PERMISSIVE – Listener accepts connections with or without TLS enabled.</li>
         * <li>** DISABLED – Listener only accepts connections without TLS.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenerTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsProperty> {
            java.lang.Object certificate;
            java.lang.String mode;
            java.lang.Object validation;

            /**
             * Sets the value of {@link ListenerTlsProperty#getCertificate}
             * @param certificate A reference to an object that represents a listener's Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsCertificateProperty certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsProperty#getCertificate}
             * @param certificate A reference to an object that represents a listener's Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.IResolvable certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsProperty#getMode}
             * @param mode Specify one of the following modes. This parameter is required.
             *             <ul>
             *             <li>** STRICT – Listener only accepts connections with TLS enabled.</li>
             *             <li>** PERMISSIVE – Listener accepts connections with or without TLS enabled.</li>
             *             <li>** DISABLED – Listener only accepts connections without TLS.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsProperty#getValidation}
             * @param validation A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsValidationContextProperty validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsProperty#getValidation}
             * @param validation A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.IResolvable validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsProperty {
            private final java.lang.Object certificate;
            private final java.lang.String mode;
            private final java.lang.Object validation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificate = java.util.Objects.requireNonNull(builder.certificate, "certificate is required");
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.validation = builder.validation;
            }

            @Override
            public final java.lang.Object getCertificate() {
                return this.certificate;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Object getValidation() {
                return this.validation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificate", om.valueToTree(this.getCertificate()));
                data.set("mode", om.valueToTree(this.getMode()));
                if (this.getValidation() != null) {
                    data.set("validation", om.valueToTree(this.getValidation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTlsProperty.Jsii$Proxy that = (ListenerTlsProperty.Jsii$Proxy) o;

                if (!certificate.equals(that.certificate)) return false;
                if (!mode.equals(that.mode)) return false;
                return this.validation != null ? this.validation.equals(that.validation) : that.validation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificate.hashCode();
                result = 31 * result + (this.mode.hashCode());
                result = 31 * result + (this.validation != null ? this.validation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the listener's Secret Discovery Service certificate.
     * <p>
     * The proxy must be configured with a local SDS provider via a Unix Domain Socket. See App Mesh <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS documentation</a> for more info.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTlsSdsCertificateProperty listenerTlsSdsCertificateProperty = ListenerTlsSdsCertificateProperty.builder()
     *         .secretName("secretName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsSdsCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTlsSdsCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTlsSdsCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents the name of the secret requested from the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or certificate chain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretName();

        /**
         * @return a {@link Builder} of {@link ListenerTlsSdsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTlsSdsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsSdsCertificateProperty> {
            java.lang.String secretName;

            /**
             * Sets the value of {@link ListenerTlsSdsCertificateProperty#getSecretName}
             * @param secretName A reference to an object that represents the name of the secret requested from the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or certificate chain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretName(java.lang.String secretName) {
                this.secretName = secretName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTlsSdsCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTlsSdsCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTlsSdsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsSdsCertificateProperty {
            private final java.lang.String secretName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretName = java.util.Objects.requireNonNull(builder.secretName, "secretName is required");
            }

            @Override
            public final java.lang.String getSecretName() {
                return this.secretName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretName", om.valueToTree(this.getSecretName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsSdsCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTlsSdsCertificateProperty.Jsii$Proxy that = (ListenerTlsSdsCertificateProperty.Jsii$Proxy) o;

                return this.secretName.equals(that.secretName);
            }

            @Override
            public final int hashCode() {
                int result = this.secretName.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a listener's Transport Layer Security (TLS) validation context.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTlsValidationContextProperty listenerTlsValidationContextProperty = ListenerTlsValidationContextProperty.builder()
     *         .trust(ListenerTlsValidationContextTrustProperty.builder()
     *                 .file(TlsValidationContextFileTrustProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .build())
     *                 .sds(TlsValidationContextSdsTrustProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                         .exact(List.of("exact"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsValidationContextProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTlsValidationContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTlsValidationContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrust();

        /**
         * A reference to an object that represents the SANs for a listener's Transport Layer Security (TLS) validation context.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubjectAlternativeNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenerTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsValidationContextProperty> {
            java.lang.Object trust;
            java.lang.Object subjectAlternativeNames;

            /**
             * Sets the value of {@link ListenerTlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ListenerTlsValidationContextTrustProperty trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.IResolvable trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.services.appmesh.CfnVirtualNode.SubjectAlternativeNamesProperty subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.IResolvable subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTlsValidationContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTlsValidationContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsValidationContextProperty {
            private final java.lang.Object trust;
            private final java.lang.Object subjectAlternativeNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trust = software.amazon.jsii.Kernel.get(this, "trust", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trust = java.util.Objects.requireNonNull(builder.trust, "trust is required");
                this.subjectAlternativeNames = builder.subjectAlternativeNames;
            }

            @Override
            public final java.lang.Object getTrust() {
                return this.trust;
            }

            @Override
            public final java.lang.Object getSubjectAlternativeNames() {
                return this.subjectAlternativeNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("trust", om.valueToTree(this.getTrust()));
                if (this.getSubjectAlternativeNames() != null) {
                    data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsValidationContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTlsValidationContextProperty.Jsii$Proxy that = (ListenerTlsValidationContextProperty.Jsii$Proxy) o;

                if (!trust.equals(that.trust)) return false;
                return this.subjectAlternativeNames != null ? this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.trust.hashCode();
                result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a listener's Transport Layer Security (TLS) validation context trust.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ListenerTlsValidationContextTrustProperty listenerTlsValidationContextTrustProperty = ListenerTlsValidationContextTrustProperty.builder()
     *         .file(TlsValidationContextFileTrustProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .build())
     *         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsValidationContextTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerTlsValidationContextTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerTlsValidationContextTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenerTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerTlsValidationContextTrustProperty> {
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link ListenerTlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextFileTrustProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextSdsTrustProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link ListenerTlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerTlsValidationContextTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerTlsValidationContextTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerTlsValidationContextTrustProperty {
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ListenerTlsValidationContextTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerTlsValidationContextTrustProperty.Jsii$Proxy that = (ListenerTlsValidationContextTrustProperty.Jsii$Proxy) o;

                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.file != null ? this.file.hashCode() : 0;
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * LoggingFormatProperty loggingFormatProperty = LoggingFormatProperty.builder()
     *         .json(List.of(JsonFormatRefProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.LoggingFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnVirtualNode.LoggingFormatProperty.Json`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJson() {
            return null;
        }

        /**
         * `CfnVirtualNode.LoggingFormatProperty.Text`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingFormatProperty> {
            java.lang.Object json;
            java.lang.String text;

            /**
             * Sets the value of {@link LoggingFormatProperty#getJson}
             * @param json `CfnVirtualNode.LoggingFormatProperty.Json`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.IResolvable json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link LoggingFormatProperty#getJson}
             * @param json `CfnVirtualNode.LoggingFormatProperty.Json`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(java.util.List<? extends java.lang.Object> json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link LoggingFormatProperty#getText}
             * @param text `CfnVirtualNode.LoggingFormatProperty.Text`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingFormatProperty {
            private final java.lang.Object json;
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.json = software.amazon.jsii.Kernel.get(this, "json", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.json = builder.json;
                this.text = builder.text;
            }

            @Override
            public final java.lang.Object getJson() {
                return this.json;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJson() != null) {
                    data.set("json", om.valueToTree(this.getJson()));
                }
                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.LoggingFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingFormatProperty.Jsii$Proxy that = (LoggingFormatProperty.Jsii$Proxy) o;

                if (this.json != null ? !this.json.equals(that.json) : that.json != null) return false;
                return this.text != null ? this.text.equals(that.text) : that.text == null;
            }

            @Override
            public final int hashCode() {
                int result = this.json != null ? this.json.hashCode() : 0;
                result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the logging information for a virtual node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * LoggingProperty loggingProperty = LoggingProperty.builder()
     *         .accessLog(AccessLogProperty.builder()
     *                 .file(FileAccessLogProperty.builder()
     *                         .path("path")
     *                         // the properties below are optional
     *                         .format(LoggingFormatProperty.builder()
     *                                 .json(List.of(JsonFormatRefProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .text("text")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access log configuration for a virtual node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLog() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            java.lang.Object accessLog;

            /**
             * Sets the value of {@link LoggingProperty#getAccessLog}
             * @param accessLog The access log configuration for a virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLog(software.amazon.awscdk.services.appmesh.CfnVirtualNode.AccessLogProperty accessLog) {
                this.accessLog = accessLog;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getAccessLog}
             * @param accessLog The access log configuration for a virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLog(software.amazon.awscdk.IResolvable accessLog) {
                this.accessLog = accessLog;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.Object accessLog;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessLog = software.amazon.jsii.Kernel.get(this, "accessLog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessLog = builder.accessLog;
            }

            @Override
            public final java.lang.Object getAccessLog() {
                return this.accessLog;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessLog() != null) {
                    data.set("accessLog", om.valueToTree(this.getAccessLog()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                return this.accessLog != null ? this.accessLog.equals(that.accessLog) : that.accessLog == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessLog != null ? this.accessLog.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the outlier detection for a virtual node's listener.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * OutlierDetectionProperty outlierDetectionProperty = OutlierDetectionProperty.builder()
     *         .baseEjectionDuration(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .interval(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .maxEjectionPercent(123)
     *         .maxServerErrors(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.OutlierDetectionProperty")
    @software.amazon.jsii.Jsii.Proxy(OutlierDetectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutlierDetectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The base amount of time for which a host is ejected.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBaseEjectionDuration();

        /**
         * The time interval between ejection sweep analysis.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInterval();

        /**
         * Maximum percentage of hosts in load balancing pool for upstream service that can be ejected.
         * <p>
         * Will eject at least one host regardless of the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxEjectionPercent();

        /**
         * Number of consecutive `5xx` errors required for ejection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxServerErrors();

        /**
         * @return a {@link Builder} of {@link OutlierDetectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutlierDetectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutlierDetectionProperty> {
            java.lang.Object baseEjectionDuration;
            java.lang.Object interval;
            java.lang.Number maxEjectionPercent;
            java.lang.Number maxServerErrors;

            /**
             * Sets the value of {@link OutlierDetectionProperty#getBaseEjectionDuration}
             * @param baseEjectionDuration The base amount of time for which a host is ejected. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseEjectionDuration(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty baseEjectionDuration) {
                this.baseEjectionDuration = baseEjectionDuration;
                return this;
            }

            /**
             * Sets the value of {@link OutlierDetectionProperty#getBaseEjectionDuration}
             * @param baseEjectionDuration The base amount of time for which a host is ejected. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseEjectionDuration(software.amazon.awscdk.IResolvable baseEjectionDuration) {
                this.baseEjectionDuration = baseEjectionDuration;
                return this;
            }

            /**
             * Sets the value of {@link OutlierDetectionProperty#getInterval}
             * @param interval The time interval between ejection sweep analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link OutlierDetectionProperty#getInterval}
             * @param interval The time interval between ejection sweep analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(software.amazon.awscdk.IResolvable interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link OutlierDetectionProperty#getMaxEjectionPercent}
             * @param maxEjectionPercent Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. This parameter is required.
             *                           Will eject at least one host regardless of the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxEjectionPercent(java.lang.Number maxEjectionPercent) {
                this.maxEjectionPercent = maxEjectionPercent;
                return this;
            }

            /**
             * Sets the value of {@link OutlierDetectionProperty#getMaxServerErrors}
             * @param maxServerErrors Number of consecutive `5xx` errors required for ejection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxServerErrors(java.lang.Number maxServerErrors) {
                this.maxServerErrors = maxServerErrors;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutlierDetectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutlierDetectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutlierDetectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutlierDetectionProperty {
            private final java.lang.Object baseEjectionDuration;
            private final java.lang.Object interval;
            private final java.lang.Number maxEjectionPercent;
            private final java.lang.Number maxServerErrors;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseEjectionDuration = software.amazon.jsii.Kernel.get(this, "baseEjectionDuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxEjectionPercent = software.amazon.jsii.Kernel.get(this, "maxEjectionPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxServerErrors = software.amazon.jsii.Kernel.get(this, "maxServerErrors", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseEjectionDuration = java.util.Objects.requireNonNull(builder.baseEjectionDuration, "baseEjectionDuration is required");
                this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
                this.maxEjectionPercent = java.util.Objects.requireNonNull(builder.maxEjectionPercent, "maxEjectionPercent is required");
                this.maxServerErrors = java.util.Objects.requireNonNull(builder.maxServerErrors, "maxServerErrors is required");
            }

            @Override
            public final java.lang.Object getBaseEjectionDuration() {
                return this.baseEjectionDuration;
            }

            @Override
            public final java.lang.Object getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.Number getMaxEjectionPercent() {
                return this.maxEjectionPercent;
            }

            @Override
            public final java.lang.Number getMaxServerErrors() {
                return this.maxServerErrors;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("baseEjectionDuration", om.valueToTree(this.getBaseEjectionDuration()));
                data.set("interval", om.valueToTree(this.getInterval()));
                data.set("maxEjectionPercent", om.valueToTree(this.getMaxEjectionPercent()));
                data.set("maxServerErrors", om.valueToTree(this.getMaxServerErrors()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.OutlierDetectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutlierDetectionProperty.Jsii$Proxy that = (OutlierDetectionProperty.Jsii$Proxy) o;

                if (!baseEjectionDuration.equals(that.baseEjectionDuration)) return false;
                if (!interval.equals(that.interval)) return false;
                if (!maxEjectionPercent.equals(that.maxEjectionPercent)) return false;
                return this.maxServerErrors.equals(that.maxServerErrors);
            }

            @Override
            public final int hashCode() {
                int result = this.baseEjectionDuration.hashCode();
                result = 31 * result + (this.interval.hashCode());
                result = 31 * result + (this.maxEjectionPercent.hashCode());
                result = 31 * result + (this.maxServerErrors.hashCode());
                return result;
            }
        }
    }
    /**
     * An object representing a virtual node or virtual router listener port mapping.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * PortMappingProperty portMappingProperty = PortMappingProperty.builder()
     *         .port(123)
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.PortMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(PortMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port used for the port mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The protocol used for the port mapping.
         * <p>
         * Specify <code>http</code> , <code>http2</code> , <code>grpc</code> , or <code>tcp</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * @return a {@link Builder} of {@link PortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortMappingProperty> {
            java.lang.Number port;
            java.lang.String protocol;

            /**
             * Sets the value of {@link PortMappingProperty#getPort}
             * @param port The port used for the port mapping. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link PortMappingProperty#getProtocol}
             * @param protocol The protocol used for the port mapping. This parameter is required.
             *                 Specify <code>http</code> , <code>http2</code> , <code>grpc</code> , or <code>tcp</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortMappingProperty {
            private final java.lang.Number port;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.PortMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortMappingProperty.Jsii$Proxy that = (PortMappingProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                return this.protocol.equals(that.protocol);
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.protocol.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the service discovery information for a virtual node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * ServiceDiscoveryProperty serviceDiscoveryProperty = ServiceDiscoveryProperty.builder()
     *         .awsCloudMap(AwsCloudMapServiceDiscoveryProperty.builder()
     *                 .namespaceName("namespaceName")
     *                 .serviceName("serviceName")
     *                 // the properties below are optional
     *                 .attributes(List.of(AwsCloudMapInstanceAttributeProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .ipPreference("ipPreference")
     *                 .build())
     *         .dns(DnsServiceDiscoveryProperty.builder()
     *                 .hostname("hostname")
     *                 // the properties below are optional
     *                 .ipPreference("ipPreference")
     *                 .responseType("responseType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.ServiceDiscoveryProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceDiscoveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceDiscoveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies any AWS Cloud Map information for the virtual node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsCloudMap() {
            return null;
        }

        /**
         * Specifies the DNS information for the virtual node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceDiscoveryProperty> {
            java.lang.Object awsCloudMap;
            java.lang.Object dns;

            /**
             * Sets the value of {@link ServiceDiscoveryProperty#getAwsCloudMap}
             * @param awsCloudMap Specifies any AWS Cloud Map information for the virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsCloudMap(software.amazon.awscdk.services.appmesh.CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty awsCloudMap) {
                this.awsCloudMap = awsCloudMap;
                return this;
            }

            /**
             * Sets the value of {@link ServiceDiscoveryProperty#getAwsCloudMap}
             * @param awsCloudMap Specifies any AWS Cloud Map information for the virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsCloudMap(software.amazon.awscdk.IResolvable awsCloudMap) {
                this.awsCloudMap = awsCloudMap;
                return this;
            }

            /**
             * Sets the value of {@link ServiceDiscoveryProperty#getDns}
             * @param dns Specifies the DNS information for the virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dns(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DnsServiceDiscoveryProperty dns) {
                this.dns = dns;
                return this;
            }

            /**
             * Sets the value of {@link ServiceDiscoveryProperty#getDns}
             * @param dns Specifies the DNS information for the virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dns(software.amazon.awscdk.IResolvable dns) {
                this.dns = dns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceDiscoveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceDiscoveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceDiscoveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceDiscoveryProperty {
            private final java.lang.Object awsCloudMap;
            private final java.lang.Object dns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsCloudMap = software.amazon.jsii.Kernel.get(this, "awsCloudMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dns = software.amazon.jsii.Kernel.get(this, "dns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsCloudMap = builder.awsCloudMap;
                this.dns = builder.dns;
            }

            @Override
            public final java.lang.Object getAwsCloudMap() {
                return this.awsCloudMap;
            }

            @Override
            public final java.lang.Object getDns() {
                return this.dns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsCloudMap() != null) {
                    data.set("awsCloudMap", om.valueToTree(this.getAwsCloudMap()));
                }
                if (this.getDns() != null) {
                    data.set("dns", om.valueToTree(this.getDns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.ServiceDiscoveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceDiscoveryProperty.Jsii$Proxy that = (ServiceDiscoveryProperty.Jsii$Proxy) o;

                if (this.awsCloudMap != null ? !this.awsCloudMap.equals(that.awsCloudMap) : that.awsCloudMap != null) return false;
                return this.dns != null ? this.dns.equals(that.dns) : that.dns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsCloudMap != null ? this.awsCloudMap.hashCode() : 0;
                result = 31 * result + (this.dns != null ? this.dns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the methods by which a subject alternative name on a peer Transport Layer Security (TLS) certificate can be matched.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * SubjectAlternativeNameMatchersProperty subjectAlternativeNameMatchersProperty = SubjectAlternativeNameMatchersProperty.builder()
     *         .exact(List.of("exact"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.SubjectAlternativeNameMatchersProperty")
    @software.amazon.jsii.Jsii.Proxy(SubjectAlternativeNameMatchersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectAlternativeNameMatchersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The values sent must match the specified values exactly.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExact() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubjectAlternativeNameMatchersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectAlternativeNameMatchersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectAlternativeNameMatchersProperty> {
            java.util.List<java.lang.String> exact;

            /**
             * Sets the value of {@link SubjectAlternativeNameMatchersProperty#getExact}
             * @param exact The values sent must match the specified values exactly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.util.List<java.lang.String> exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectAlternativeNameMatchersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectAlternativeNameMatchersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectAlternativeNameMatchersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectAlternativeNameMatchersProperty {
            private final java.util.List<java.lang.String> exact;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
            }

            @Override
            public final java.util.List<java.lang.String> getExact() {
                return this.exact;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.SubjectAlternativeNameMatchersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectAlternativeNameMatchersProperty.Jsii$Proxy that = (SubjectAlternativeNameMatchersProperty.Jsii$Proxy) o;

                return this.exact != null ? this.exact.equals(that.exact) : that.exact == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the subject alternative names secured by the certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * SubjectAlternativeNamesProperty subjectAlternativeNamesProperty = SubjectAlternativeNamesProperty.builder()
     *         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                 .exact(List.of("exact"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.SubjectAlternativeNamesProperty")
    @software.amazon.jsii.Jsii.Proxy(SubjectAlternativeNamesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectAlternativeNamesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the criteria for determining a SANs match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatch();

        /**
         * @return a {@link Builder} of {@link SubjectAlternativeNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectAlternativeNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectAlternativeNamesProperty> {
            java.lang.Object match;

            /**
             * Sets the value of {@link SubjectAlternativeNamesProperty#getMatch}
             * @param match An object that represents the criteria for determining a SANs match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnVirtualNode.SubjectAlternativeNameMatchersProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link SubjectAlternativeNamesProperty#getMatch}
             * @param match An object that represents the criteria for determining a SANs match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectAlternativeNamesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectAlternativeNamesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectAlternativeNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectAlternativeNamesProperty {
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("match", om.valueToTree(this.getMatch()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.SubjectAlternativeNamesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectAlternativeNamesProperty.Jsii$Proxy that = (SubjectAlternativeNamesProperty.Jsii$Proxy) o;

                return this.match.equals(that.match);
            }

            @Override
            public final int hashCode() {
                int result = this.match.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents types of timeouts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TcpTimeoutProperty tcpTimeoutProperty = TcpTimeoutProperty.builder()
     *         .idle(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.TcpTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(TcpTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TcpTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents an idle timeout.
         * <p>
         * An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TcpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TcpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TcpTimeoutProperty> {
            java.lang.Object idle;

            /**
             * Sets the value of {@link TcpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link TcpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.IResolvable idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TcpTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TcpTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TcpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TcpTimeoutProperty {
            private final java.lang.Object idle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idle = software.amazon.jsii.Kernel.get(this, "idle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idle = builder.idle;
            }

            @Override
            public final java.lang.Object getIdle() {
                return this.idle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdle() != null) {
                    data.set("idle", om.valueToTree(this.getIdle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.TcpTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TcpTimeoutProperty.Jsii$Proxy that = (TcpTimeoutProperty.Jsii$Proxy) o;

                return this.idle != null ? this.idle.equals(that.idle) : that.idle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idle != null ? this.idle.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TlsValidationContextAcmTrustProperty tlsValidationContextAcmTrustProperty = TlsValidationContextAcmTrustProperty.builder()
     *         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextAcmTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsValidationContextAcmTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsValidationContextAcmTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more ACM Amazon Resource Name (ARN)s.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCertificateAuthorityArns();

        /**
         * @return a {@link Builder} of {@link TlsValidationContextAcmTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsValidationContextAcmTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsValidationContextAcmTrustProperty> {
            java.util.List<java.lang.String> certificateAuthorityArns;

            /**
             * Sets the value of {@link TlsValidationContextAcmTrustProperty#getCertificateAuthorityArns}
             * @param certificateAuthorityArns One or more ACM Amazon Resource Name (ARN)s. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateAuthorityArns(java.util.List<java.lang.String> certificateAuthorityArns) {
                this.certificateAuthorityArns = certificateAuthorityArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsValidationContextAcmTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsValidationContextAcmTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsValidationContextAcmTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsValidationContextAcmTrustProperty {
            private final java.util.List<java.lang.String> certificateAuthorityArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateAuthorityArns = software.amazon.jsii.Kernel.get(this, "certificateAuthorityArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateAuthorityArns = java.util.Objects.requireNonNull(builder.certificateAuthorityArns, "certificateAuthorityArns is required");
            }

            @Override
            public final java.util.List<java.lang.String> getCertificateAuthorityArns() {
                return this.certificateAuthorityArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateAuthorityArns", om.valueToTree(this.getCertificateAuthorityArns()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextAcmTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsValidationContextAcmTrustProperty.Jsii$Proxy that = (TlsValidationContextAcmTrustProperty.Jsii$Proxy) o;

                return this.certificateAuthorityArns.equals(that.certificateAuthorityArns);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateAuthorityArns.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TlsValidationContextFileTrustProperty tlsValidationContextFileTrustProperty = TlsValidationContextFileTrustProperty.builder()
     *         .certificateChain("certificateChain")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextFileTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsValidationContextFileTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsValidationContextFileTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is running on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateChain();

        /**
         * @return a {@link Builder} of {@link TlsValidationContextFileTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsValidationContextFileTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsValidationContextFileTrustProperty> {
            java.lang.String certificateChain;

            /**
             * Sets the value of {@link TlsValidationContextFileTrustProperty#getCertificateChain}
             * @param certificateChain The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is running on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateChain(java.lang.String certificateChain) {
                this.certificateChain = certificateChain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsValidationContextFileTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsValidationContextFileTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsValidationContextFileTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsValidationContextFileTrustProperty {
            private final java.lang.String certificateChain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateChain = software.amazon.jsii.Kernel.get(this, "certificateChain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateChain = java.util.Objects.requireNonNull(builder.certificateChain, "certificateChain is required");
            }

            @Override
            public final java.lang.String getCertificateChain() {
                return this.certificateChain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateChain", om.valueToTree(this.getCertificateChain()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextFileTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsValidationContextFileTrustProperty.Jsii$Proxy that = (TlsValidationContextFileTrustProperty.Jsii$Proxy) o;

                return this.certificateChain.equals(that.certificateChain);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateChain.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents how the proxy will validate its peer during Transport Layer Security (TLS) negotiation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TlsValidationContextProperty tlsValidationContextProperty = TlsValidationContextProperty.builder()
     *         .trust(TlsValidationContextTrustProperty.builder()
     *                 .acm(TlsValidationContextAcmTrustProperty.builder()
     *                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                         .build())
     *                 .file(TlsValidationContextFileTrustProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .build())
     *                 .sds(TlsValidationContextSdsTrustProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                         .exact(List.of("exact"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsValidationContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsValidationContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrust();

        /**
         * A reference to an object that represents the SANs for a Transport Layer Security (TLS) validation context.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubjectAlternativeNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsValidationContextProperty> {
            java.lang.Object trust;
            java.lang.Object subjectAlternativeNames;

            /**
             * Sets the value of {@link TlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextTrustProperty trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.IResolvable trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.services.appmesh.CfnVirtualNode.SubjectAlternativeNamesProperty subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.IResolvable subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsValidationContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsValidationContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsValidationContextProperty {
            private final java.lang.Object trust;
            private final java.lang.Object subjectAlternativeNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trust = software.amazon.jsii.Kernel.get(this, "trust", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trust = java.util.Objects.requireNonNull(builder.trust, "trust is required");
                this.subjectAlternativeNames = builder.subjectAlternativeNames;
            }

            @Override
            public final java.lang.Object getTrust() {
                return this.trust;
            }

            @Override
            public final java.lang.Object getSubjectAlternativeNames() {
                return this.subjectAlternativeNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("trust", om.valueToTree(this.getTrust()));
                if (this.getSubjectAlternativeNames() != null) {
                    data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsValidationContextProperty.Jsii$Proxy that = (TlsValidationContextProperty.Jsii$Proxy) o;

                if (!trust.equals(that.trust)) return false;
                return this.subjectAlternativeNames != null ? this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.trust.hashCode();
                result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) Secret Discovery Service validation context trust.
     * <p>
     * The proxy must be configured with a local SDS provider via a Unix Domain Socket. See App Mesh <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS documentation</a> for more info.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TlsValidationContextSdsTrustProperty tlsValidationContextSdsTrustProperty = TlsValidationContextSdsTrustProperty.builder()
     *         .secretName("secretName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextSdsTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsValidationContextSdsTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsValidationContextSdsTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret Discovery Service validation context trust.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretName();

        /**
         * @return a {@link Builder} of {@link TlsValidationContextSdsTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsValidationContextSdsTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsValidationContextSdsTrustProperty> {
            java.lang.String secretName;

            /**
             * Sets the value of {@link TlsValidationContextSdsTrustProperty#getSecretName}
             * @param secretName A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret Discovery Service validation context trust. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretName(java.lang.String secretName) {
                this.secretName = secretName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsValidationContextSdsTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsValidationContextSdsTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsValidationContextSdsTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsValidationContextSdsTrustProperty {
            private final java.lang.String secretName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretName = java.util.Objects.requireNonNull(builder.secretName, "secretName is required");
            }

            @Override
            public final java.lang.String getSecretName() {
                return this.secretName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretName", om.valueToTree(this.getSecretName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextSdsTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsValidationContextSdsTrustProperty.Jsii$Proxy that = (TlsValidationContextSdsTrustProperty.Jsii$Proxy) o;

                return this.secretName.equals(that.secretName);
            }

            @Override
            public final int hashCode() {
                int result = this.secretName.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) validation context trust.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TlsValidationContextTrustProperty tlsValidationContextTrustProperty = TlsValidationContextTrustProperty.builder()
     *         .acm(TlsValidationContextAcmTrustProperty.builder()
     *                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                 .build())
     *         .file(TlsValidationContextFileTrustProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .build())
     *         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsValidationContextTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsValidationContextTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcm() {
            return null;
        }

        /**
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation context trust.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsValidationContextTrustProperty> {
            java.lang.Object acm;
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link TlsValidationContextTrustProperty#getAcm}
             * @param acm A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextAcmTrustProperty acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextTrustProperty#getAcm}
             * @param acm A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.IResolvable acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextFileTrustProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextSdsTrustProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link TlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsValidationContextTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsValidationContextTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsValidationContextTrustProperty {
            private final java.lang.Object acm;
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acm = software.amazon.jsii.Kernel.get(this, "acm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acm = builder.acm;
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getAcm() {
                return this.acm;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcm() != null) {
                    data.set("acm", om.valueToTree(this.getAcm()));
                }
                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.TlsValidationContextTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsValidationContextTrustProperty.Jsii$Proxy that = (TlsValidationContextTrustProperty.Jsii$Proxy) o;

                if (this.acm != null ? !this.acm.equals(that.acm) : that.acm != null) return false;
                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acm != null ? this.acm.hashCode() : 0;
                result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the type of virtual node connection pool.
     * <p>
     * Only one protocol is used at a time and should be the same protocol as the one chosen under port mapping.
     * <p>
     * If not present the default value for <code>maxPendingRequests</code> is <code>2147483647</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualNodeConnectionPoolProperty virtualNodeConnectionPoolProperty = VirtualNodeConnectionPoolProperty.builder()
     *         .grpc(VirtualNodeGrpcConnectionPoolProperty.builder()
     *                 .maxRequests(123)
     *                 .build())
     *         .http(VirtualNodeHttpConnectionPoolProperty.builder()
     *                 .maxConnections(123)
     *                 // the properties below are optional
     *                 .maxPendingRequests(123)
     *                 .build())
     *         .http2(VirtualNodeHttp2ConnectionPoolProperty.builder()
     *                 .maxRequests(123)
     *                 .build())
     *         .tcp(VirtualNodeTcpConnectionPoolProperty.builder()
     *                 .maxConnections(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualNodeConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualNodeConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a type of connection pool.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrpc() {
            return null;
        }

        /**
         * An object that represents a type of connection pool.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp() {
            return null;
        }

        /**
         * An object that represents a type of connection pool.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp2() {
            return null;
        }

        /**
         * An object that represents a type of connection pool.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTcp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualNodeConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualNodeConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeConnectionPoolProperty> {
            java.lang.Object grpc;
            java.lang.Object http;
            java.lang.Object http2;
            java.lang.Object tcp;

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getGrpc}
             * @param grpc An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpc(software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeGrpcConnectionPoolProperty grpc) {
                this.grpc = grpc;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getGrpc}
             * @param grpc An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpc(software.amazon.awscdk.IResolvable grpc) {
                this.grpc = grpc;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getHttp}
             * @param http An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeHttpConnectionPoolProperty http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getHttp}
             * @param http An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.IResolvable http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getHttp2}
             * @param http2 An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2(software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeHttp2ConnectionPoolProperty http2) {
                this.http2 = http2;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getHttp2}
             * @param http2 An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2(software.amazon.awscdk.IResolvable http2) {
                this.http2 = http2;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getTcp}
             * @param tcp An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcp(software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeTcpConnectionPoolProperty tcp) {
                this.tcp = tcp;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeConnectionPoolProperty#getTcp}
             * @param tcp An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcp(software.amazon.awscdk.IResolvable tcp) {
                this.tcp = tcp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualNodeConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualNodeConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualNodeConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeConnectionPoolProperty {
            private final java.lang.Object grpc;
            private final java.lang.Object http;
            private final java.lang.Object http2;
            private final java.lang.Object tcp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grpc = software.amazon.jsii.Kernel.get(this, "grpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http = software.amazon.jsii.Kernel.get(this, "http", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http2 = software.amazon.jsii.Kernel.get(this, "http2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tcp = software.amazon.jsii.Kernel.get(this, "tcp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grpc = builder.grpc;
                this.http = builder.http;
                this.http2 = builder.http2;
                this.tcp = builder.tcp;
            }

            @Override
            public final java.lang.Object getGrpc() {
                return this.grpc;
            }

            @Override
            public final java.lang.Object getHttp() {
                return this.http;
            }

            @Override
            public final java.lang.Object getHttp2() {
                return this.http2;
            }

            @Override
            public final java.lang.Object getTcp() {
                return this.tcp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrpc() != null) {
                    data.set("grpc", om.valueToTree(this.getGrpc()));
                }
                if (this.getHttp() != null) {
                    data.set("http", om.valueToTree(this.getHttp()));
                }
                if (this.getHttp2() != null) {
                    data.set("http2", om.valueToTree(this.getHttp2()));
                }
                if (this.getTcp() != null) {
                    data.set("tcp", om.valueToTree(this.getTcp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualNodeConnectionPoolProperty.Jsii$Proxy that = (VirtualNodeConnectionPoolProperty.Jsii$Proxy) o;

                if (this.grpc != null ? !this.grpc.equals(that.grpc) : that.grpc != null) return false;
                if (this.http != null ? !this.http.equals(that.http) : that.http != null) return false;
                if (this.http2 != null ? !this.http2.equals(that.http2) : that.http2 != null) return false;
                return this.tcp != null ? this.tcp.equals(that.tcp) : that.tcp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grpc != null ? this.grpc.hashCode() : 0;
                result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
                result = 31 * result + (this.http2 != null ? this.http2.hashCode() : 0);
                result = 31 * result + (this.tcp != null ? this.tcp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a type of connection pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualNodeGrpcConnectionPoolProperty virtualNodeGrpcConnectionPoolProperty = VirtualNodeGrpcConnectionPoolProperty.builder()
     *         .maxRequests(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeGrpcConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualNodeGrpcConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualNodeGrpcConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRequests();

        /**
         * @return a {@link Builder} of {@link VirtualNodeGrpcConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualNodeGrpcConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeGrpcConnectionPoolProperty> {
            java.lang.Number maxRequests;

            /**
             * Sets the value of {@link VirtualNodeGrpcConnectionPoolProperty#getMaxRequests}
             * @param maxRequests Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRequests(java.lang.Number maxRequests) {
                this.maxRequests = maxRequests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualNodeGrpcConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualNodeGrpcConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualNodeGrpcConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeGrpcConnectionPoolProperty {
            private final java.lang.Number maxRequests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRequests = software.amazon.jsii.Kernel.get(this, "maxRequests", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRequests = java.util.Objects.requireNonNull(builder.maxRequests, "maxRequests is required");
            }

            @Override
            public final java.lang.Number getMaxRequests() {
                return this.maxRequests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRequests", om.valueToTree(this.getMaxRequests()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeGrpcConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualNodeGrpcConnectionPoolProperty.Jsii$Proxy that = (VirtualNodeGrpcConnectionPoolProperty.Jsii$Proxy) o;

                return this.maxRequests.equals(that.maxRequests);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRequests.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a type of connection pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualNodeHttp2ConnectionPoolProperty virtualNodeHttp2ConnectionPoolProperty = VirtualNodeHttp2ConnectionPoolProperty.builder()
     *         .maxRequests(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeHttp2ConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualNodeHttp2ConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualNodeHttp2ConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRequests();

        /**
         * @return a {@link Builder} of {@link VirtualNodeHttp2ConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualNodeHttp2ConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeHttp2ConnectionPoolProperty> {
            java.lang.Number maxRequests;

            /**
             * Sets the value of {@link VirtualNodeHttp2ConnectionPoolProperty#getMaxRequests}
             * @param maxRequests Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRequests(java.lang.Number maxRequests) {
                this.maxRequests = maxRequests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualNodeHttp2ConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualNodeHttp2ConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualNodeHttp2ConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeHttp2ConnectionPoolProperty {
            private final java.lang.Number maxRequests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRequests = software.amazon.jsii.Kernel.get(this, "maxRequests", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRequests = java.util.Objects.requireNonNull(builder.maxRequests, "maxRequests is required");
            }

            @Override
            public final java.lang.Number getMaxRequests() {
                return this.maxRequests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRequests", om.valueToTree(this.getMaxRequests()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeHttp2ConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualNodeHttp2ConnectionPoolProperty.Jsii$Proxy that = (VirtualNodeHttp2ConnectionPoolProperty.Jsii$Proxy) o;

                return this.maxRequests.equals(that.maxRequests);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRequests.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a type of connection pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualNodeHttpConnectionPoolProperty virtualNodeHttpConnectionPoolProperty = VirtualNodeHttpConnectionPoolProperty.builder()
     *         .maxConnections(123)
     *         // the properties below are optional
     *         .maxPendingRequests(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeHttpConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualNodeHttpConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualNodeHttpConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxConnections();

        /**
         * Number of overflowing requests after `max_connections` Envoy will queue to upstream cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPendingRequests() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualNodeHttpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualNodeHttpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeHttpConnectionPoolProperty> {
            java.lang.Number maxConnections;
            java.lang.Number maxPendingRequests;

            /**
             * Sets the value of {@link VirtualNodeHttpConnectionPoolProperty#getMaxConnections}
             * @param maxConnections Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConnections(java.lang.Number maxConnections) {
                this.maxConnections = maxConnections;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeHttpConnectionPoolProperty#getMaxPendingRequests}
             * @param maxPendingRequests Number of overflowing requests after `max_connections` Envoy will queue to upstream cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPendingRequests(java.lang.Number maxPendingRequests) {
                this.maxPendingRequests = maxPendingRequests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualNodeHttpConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualNodeHttpConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualNodeHttpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeHttpConnectionPoolProperty {
            private final java.lang.Number maxConnections;
            private final java.lang.Number maxPendingRequests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConnections = software.amazon.jsii.Kernel.get(this, "maxConnections", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxPendingRequests = software.amazon.jsii.Kernel.get(this, "maxPendingRequests", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConnections = java.util.Objects.requireNonNull(builder.maxConnections, "maxConnections is required");
                this.maxPendingRequests = builder.maxPendingRequests;
            }

            @Override
            public final java.lang.Number getMaxConnections() {
                return this.maxConnections;
            }

            @Override
            public final java.lang.Number getMaxPendingRequests() {
                return this.maxPendingRequests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxConnections", om.valueToTree(this.getMaxConnections()));
                if (this.getMaxPendingRequests() != null) {
                    data.set("maxPendingRequests", om.valueToTree(this.getMaxPendingRequests()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeHttpConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualNodeHttpConnectionPoolProperty.Jsii$Proxy that = (VirtualNodeHttpConnectionPoolProperty.Jsii$Proxy) o;

                if (!maxConnections.equals(that.maxConnections)) return false;
                return this.maxPendingRequests != null ? this.maxPendingRequests.equals(that.maxPendingRequests) : that.maxPendingRequests == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxConnections.hashCode();
                result = 31 * result + (this.maxPendingRequests != null ? this.maxPendingRequests.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the specification of a virtual node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualNodeSpecProperty virtualNodeSpecProperty = VirtualNodeSpecProperty.builder()
     *         .backendDefaults(BackendDefaultsProperty.builder()
     *                 .clientPolicy(ClientPolicyProperty.builder()
     *                         .tls(ClientPolicyTlsProperty.builder()
     *                                 .validation(TlsValidationContextProperty.builder()
     *                                         .trust(TlsValidationContextTrustProperty.builder()
     *                                                 .acm(TlsValidationContextAcmTrustProperty.builder()
     *                                                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                                         .build())
     *                                                 .file(TlsValidationContextFileTrustProperty.builder()
     *                                                         .certificateChain("certificateChain")
     *                                                         .build())
     *                                                 .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                                         .secretName("secretName")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                         .exact(List.of("exact"))
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .certificate(ClientTlsCertificateProperty.builder()
     *                                         .file(ListenerTlsFileCertificateProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .privateKey("privateKey")
     *                                                 .build())
     *                                         .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 .enforce(false)
     *                                 .ports(List.of(123))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .backends(List.of(BackendProperty.builder()
     *                 .virtualService(VirtualServiceBackendProperty.builder()
     *                         .virtualServiceName("virtualServiceName")
     *                         // the properties below are optional
     *                         .clientPolicy(ClientPolicyProperty.builder()
     *                                 .tls(ClientPolicyTlsProperty.builder()
     *                                         .validation(TlsValidationContextProperty.builder()
     *                                                 .trust(TlsValidationContextTrustProperty.builder()
     *                                                         .acm(TlsValidationContextAcmTrustProperty.builder()
     *                                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                                                 .build())
     *                                                         .file(TlsValidationContextFileTrustProperty.builder()
     *                                                                 .certificateChain("certificateChain")
     *                                                                 .build())
     *                                                         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                                                 .secretName("secretName")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                                 .exact(List.of("exact"))
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .certificate(ClientTlsCertificateProperty.builder()
     *                                                 .file(ListenerTlsFileCertificateProperty.builder()
     *                                                         .certificateChain("certificateChain")
     *                                                         .privateKey("privateKey")
     *                                                         .build())
     *                                                 .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                                         .secretName("secretName")
     *                                                         .build())
     *                                                 .build())
     *                                         .enforce(false)
     *                                         .ports(List.of(123))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .listeners(List.of(ListenerProperty.builder()
     *                 .portMapping(PortMappingProperty.builder()
     *                         .port(123)
     *                         .protocol("protocol")
     *                         .build())
     *                 // the properties below are optional
     *                 .connectionPool(VirtualNodeConnectionPoolProperty.builder()
     *                         .grpc(VirtualNodeGrpcConnectionPoolProperty.builder()
     *                                 .maxRequests(123)
     *                                 .build())
     *                         .http(VirtualNodeHttpConnectionPoolProperty.builder()
     *                                 .maxConnections(123)
     *                                 // the properties below are optional
     *                                 .maxPendingRequests(123)
     *                                 .build())
     *                         .http2(VirtualNodeHttp2ConnectionPoolProperty.builder()
     *                                 .maxRequests(123)
     *                                 .build())
     *                         .tcp(VirtualNodeTcpConnectionPoolProperty.builder()
     *                                 .maxConnections(123)
     *                                 .build())
     *                         .build())
     *                 .healthCheck(HealthCheckProperty.builder()
     *                         .healthyThreshold(123)
     *                         .intervalMillis(123)
     *                         .protocol("protocol")
     *                         .timeoutMillis(123)
     *                         .unhealthyThreshold(123)
     *                         // the properties below are optional
     *                         .path("path")
     *                         .port(123)
     *                         .build())
     *                 .outlierDetection(OutlierDetectionProperty.builder()
     *                         .baseEjectionDuration(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .interval(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .maxEjectionPercent(123)
     *                         .maxServerErrors(123)
     *                         .build())
     *                 .timeout(ListenerTimeoutProperty.builder()
     *                         .grpc(GrpcTimeoutProperty.builder()
     *                                 .idle(DurationProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .perRequest(DurationProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .build())
     *                         .http(HttpTimeoutProperty.builder()
     *                                 .idle(DurationProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .perRequest(DurationProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .build())
     *                         .http2(HttpTimeoutProperty.builder()
     *                                 .idle(DurationProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .perRequest(DurationProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .build())
     *                         .tcp(TcpTimeoutProperty.builder()
     *                                 .idle(DurationProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .tls(ListenerTlsProperty.builder()
     *                         .certificate(ListenerTlsCertificateProperty.builder()
     *                                 .acm(ListenerTlsAcmCertificateProperty.builder()
     *                                         .certificateArn("certificateArn")
     *                                         .build())
     *                                 .file(ListenerTlsFileCertificateProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .privateKey("privateKey")
     *                                         .build())
     *                                 .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         .mode("mode")
     *                         // the properties below are optional
     *                         .validation(ListenerTlsValidationContextProperty.builder()
     *                                 .trust(ListenerTlsValidationContextTrustProperty.builder()
     *                                         .file(TlsValidationContextFileTrustProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .build())
     *                                         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                 .exact(List.of("exact"))
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .logging(LoggingProperty.builder()
     *                 .accessLog(AccessLogProperty.builder()
     *                         .file(FileAccessLogProperty.builder()
     *                                 .path("path")
     *                                 // the properties below are optional
     *                                 .format(LoggingFormatProperty.builder()
     *                                         .json(List.of(JsonFormatRefProperty.builder()
     *                                                 .key("key")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .text("text")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .serviceDiscovery(ServiceDiscoveryProperty.builder()
     *                 .awsCloudMap(AwsCloudMapServiceDiscoveryProperty.builder()
     *                         .namespaceName("namespaceName")
     *                         .serviceName("serviceName")
     *                         // the properties below are optional
     *                         .attributes(List.of(AwsCloudMapInstanceAttributeProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .ipPreference("ipPreference")
     *                         .build())
     *                 .dns(DnsServiceDiscoveryProperty.builder()
     *                         .hostname("hostname")
     *                         // the properties below are optional
     *                         .ipPreference("ipPreference")
     *                         .responseType("responseType")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualNodeSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualNodeSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents the defaults for backends.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBackendDefaults() {
            return null;
        }

        /**
         * The backends that the virtual node is expected to send outbound traffic to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBackends() {
            return null;
        }

        /**
         * The listener that the virtual node is expected to receive inbound traffic from.
         * <p>
         * You can specify one listener.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getListeners() {
            return null;
        }

        /**
         * The inbound and outbound access logging information for the virtual node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
            return null;
        }

        /**
         * The service discovery information for the virtual node.
         * <p>
         * If your virtual node does not expect ingress traffic, you can omit this parameter. If you specify a <code>listener</code> , then you must specify service discovery information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceDiscovery() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualNodeSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualNodeSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeSpecProperty> {
            java.lang.Object backendDefaults;
            java.lang.Object backends;
            java.lang.Object listeners;
            java.lang.Object logging;
            java.lang.Object serviceDiscovery;

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getBackendDefaults}
             * @param backendDefaults A reference to an object that represents the defaults for backends.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backendDefaults(software.amazon.awscdk.services.appmesh.CfnVirtualNode.BackendDefaultsProperty backendDefaults) {
                this.backendDefaults = backendDefaults;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getBackendDefaults}
             * @param backendDefaults A reference to an object that represents the defaults for backends.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backendDefaults(software.amazon.awscdk.IResolvable backendDefaults) {
                this.backendDefaults = backendDefaults;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getBackends}
             * @param backends The backends that the virtual node is expected to send outbound traffic to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backends(software.amazon.awscdk.IResolvable backends) {
                this.backends = backends;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getBackends}
             * @param backends The backends that the virtual node is expected to send outbound traffic to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backends(java.util.List<? extends java.lang.Object> backends) {
                this.backends = backends;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getListeners}
             * @param listeners The listener that the virtual node is expected to receive inbound traffic from.
             *                  You can specify one listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listeners(software.amazon.awscdk.IResolvable listeners) {
                this.listeners = listeners;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getListeners}
             * @param listeners The listener that the virtual node is expected to receive inbound traffic from.
             *                  You can specify one listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listeners(java.util.List<? extends java.lang.Object> listeners) {
                this.listeners = listeners;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getLogging}
             * @param logging The inbound and outbound access logging information for the virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getLogging}
             * @param logging The inbound and outbound access logging information for the virtual node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.IResolvable logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getServiceDiscovery}
             * @param serviceDiscovery The service discovery information for the virtual node.
             *                         If your virtual node does not expect ingress traffic, you can omit this parameter. If you specify a <code>listener</code> , then you must specify service discovery information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceDiscovery(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ServiceDiscoveryProperty serviceDiscovery) {
                this.serviceDiscovery = serviceDiscovery;
                return this;
            }

            /**
             * Sets the value of {@link VirtualNodeSpecProperty#getServiceDiscovery}
             * @param serviceDiscovery The service discovery information for the virtual node.
             *                         If your virtual node does not expect ingress traffic, you can omit this parameter. If you specify a <code>listener</code> , then you must specify service discovery information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceDiscovery(software.amazon.awscdk.IResolvable serviceDiscovery) {
                this.serviceDiscovery = serviceDiscovery;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualNodeSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualNodeSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualNodeSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeSpecProperty {
            private final java.lang.Object backendDefaults;
            private final java.lang.Object backends;
            private final java.lang.Object listeners;
            private final java.lang.Object logging;
            private final java.lang.Object serviceDiscovery;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backendDefaults = software.amazon.jsii.Kernel.get(this, "backendDefaults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.backends = software.amazon.jsii.Kernel.get(this, "backends", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.listeners = software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceDiscovery = software.amazon.jsii.Kernel.get(this, "serviceDiscovery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backendDefaults = builder.backendDefaults;
                this.backends = builder.backends;
                this.listeners = builder.listeners;
                this.logging = builder.logging;
                this.serviceDiscovery = builder.serviceDiscovery;
            }

            @Override
            public final java.lang.Object getBackendDefaults() {
                return this.backendDefaults;
            }

            @Override
            public final java.lang.Object getBackends() {
                return this.backends;
            }

            @Override
            public final java.lang.Object getListeners() {
                return this.listeners;
            }

            @Override
            public final java.lang.Object getLogging() {
                return this.logging;
            }

            @Override
            public final java.lang.Object getServiceDiscovery() {
                return this.serviceDiscovery;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBackendDefaults() != null) {
                    data.set("backendDefaults", om.valueToTree(this.getBackendDefaults()));
                }
                if (this.getBackends() != null) {
                    data.set("backends", om.valueToTree(this.getBackends()));
                }
                if (this.getListeners() != null) {
                    data.set("listeners", om.valueToTree(this.getListeners()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }
                if (this.getServiceDiscovery() != null) {
                    data.set("serviceDiscovery", om.valueToTree(this.getServiceDiscovery()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualNodeSpecProperty.Jsii$Proxy that = (VirtualNodeSpecProperty.Jsii$Proxy) o;

                if (this.backendDefaults != null ? !this.backendDefaults.equals(that.backendDefaults) : that.backendDefaults != null) return false;
                if (this.backends != null ? !this.backends.equals(that.backends) : that.backends != null) return false;
                if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) return false;
                if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
                return this.serviceDiscovery != null ? this.serviceDiscovery.equals(that.serviceDiscovery) : that.serviceDiscovery == null;
            }

            @Override
            public final int hashCode() {
                int result = this.backendDefaults != null ? this.backendDefaults.hashCode() : 0;
                result = 31 * result + (this.backends != null ? this.backends.hashCode() : 0);
                result = 31 * result + (this.listeners != null ? this.listeners.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                result = 31 * result + (this.serviceDiscovery != null ? this.serviceDiscovery.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a type of connection pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualNodeTcpConnectionPoolProperty virtualNodeTcpConnectionPoolProperty = VirtualNodeTcpConnectionPoolProperty.builder()
     *         .maxConnections(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeTcpConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualNodeTcpConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualNodeTcpConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxConnections();

        /**
         * @return a {@link Builder} of {@link VirtualNodeTcpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualNodeTcpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeTcpConnectionPoolProperty> {
            java.lang.Number maxConnections;

            /**
             * Sets the value of {@link VirtualNodeTcpConnectionPoolProperty#getMaxConnections}
             * @param maxConnections Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConnections(java.lang.Number maxConnections) {
                this.maxConnections = maxConnections;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualNodeTcpConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualNodeTcpConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualNodeTcpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeTcpConnectionPoolProperty {
            private final java.lang.Number maxConnections;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConnections = software.amazon.jsii.Kernel.get(this, "maxConnections", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConnections = java.util.Objects.requireNonNull(builder.maxConnections, "maxConnections is required");
            }

            @Override
            public final java.lang.Number getMaxConnections() {
                return this.maxConnections;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxConnections", om.valueToTree(this.getMaxConnections()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualNodeTcpConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualNodeTcpConnectionPoolProperty.Jsii$Proxy that = (VirtualNodeTcpConnectionPoolProperty.Jsii$Proxy) o;

                return this.maxConnections.equals(that.maxConnections);
            }

            @Override
            public final int hashCode() {
                int result = this.maxConnections.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a virtual service backend for a virtual node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualServiceBackendProperty virtualServiceBackendProperty = VirtualServiceBackendProperty.builder()
     *         .virtualServiceName("virtualServiceName")
     *         // the properties below are optional
     *         .clientPolicy(ClientPolicyProperty.builder()
     *                 .tls(ClientPolicyTlsProperty.builder()
     *                         .validation(TlsValidationContextProperty.builder()
     *                                 .trust(TlsValidationContextTrustProperty.builder()
     *                                         .acm(TlsValidationContextAcmTrustProperty.builder()
     *                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                                 .build())
     *                                         .file(TlsValidationContextFileTrustProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .build())
     *                                         .sds(TlsValidationContextSdsTrustProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                 .exact(List.of("exact"))
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .certificate(ClientTlsCertificateProperty.builder()
     *                                 .file(ListenerTlsFileCertificateProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .privateKey("privateKey")
     *                                         .build())
     *                                 .sds(ListenerTlsSdsCertificateProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         .enforce(false)
     *                         .ports(List.of(123))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualServiceBackendProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualServiceBackendProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualServiceBackendProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the virtual service that is acting as a virtual node backend.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVirtualServiceName();

        /**
         * A reference to an object that represents the client policy for a backend.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualServiceBackendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualServiceBackendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualServiceBackendProperty> {
            java.lang.String virtualServiceName;
            java.lang.Object clientPolicy;

            /**
             * Sets the value of {@link VirtualServiceBackendProperty#getVirtualServiceName}
             * @param virtualServiceName The name of the virtual service that is acting as a virtual node backend. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualServiceName(java.lang.String virtualServiceName) {
                this.virtualServiceName = virtualServiceName;
                return this;
            }

            /**
             * Sets the value of {@link VirtualServiceBackendProperty#getClientPolicy}
             * @param clientPolicy A reference to an object that represents the client policy for a backend.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientPolicy(software.amazon.awscdk.services.appmesh.CfnVirtualNode.ClientPolicyProperty clientPolicy) {
                this.clientPolicy = clientPolicy;
                return this;
            }

            /**
             * Sets the value of {@link VirtualServiceBackendProperty#getClientPolicy}
             * @param clientPolicy A reference to an object that represents the client policy for a backend.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientPolicy(software.amazon.awscdk.IResolvable clientPolicy) {
                this.clientPolicy = clientPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualServiceBackendProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualServiceBackendProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualServiceBackendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualServiceBackendProperty {
            private final java.lang.String virtualServiceName;
            private final java.lang.Object clientPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.virtualServiceName = software.amazon.jsii.Kernel.get(this, "virtualServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientPolicy = software.amazon.jsii.Kernel.get(this, "clientPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.virtualServiceName = java.util.Objects.requireNonNull(builder.virtualServiceName, "virtualServiceName is required");
                this.clientPolicy = builder.clientPolicy;
            }

            @Override
            public final java.lang.String getVirtualServiceName() {
                return this.virtualServiceName;
            }

            @Override
            public final java.lang.Object getClientPolicy() {
                return this.clientPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("virtualServiceName", om.valueToTree(this.getVirtualServiceName()));
                if (this.getClientPolicy() != null) {
                    data.set("clientPolicy", om.valueToTree(this.getClientPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualNode.VirtualServiceBackendProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualServiceBackendProperty.Jsii$Proxy that = (VirtualServiceBackendProperty.Jsii$Proxy) o;

                if (!virtualServiceName.equals(that.virtualServiceName)) return false;
                return this.clientPolicy != null ? this.clientPolicy.equals(that.clientPolicy) : that.clientPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.virtualServiceName.hashCode();
                result = 31 * result + (this.clientPolicy != null ? this.clientPolicy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.CfnVirtualNode}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.CfnVirtualNode> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.CfnVirtualNodeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.CfnVirtualNodeProps.Builder();
        }

        /**
         * The name of the service mesh to create the virtual node in.
         * <p>
         * @return {@code this}
         * @param meshName The name of the service mesh to create the virtual node in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(final java.lang.String meshName) {
            this.props.meshName(meshName);
            return this;
        }

        /**
         * The virtual node specification to apply.
         * <p>
         * @return {@code this}
         * @param spec The virtual node specification to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeSpecProperty spec) {
            this.props.spec(spec);
            return this;
        }
        /**
         * The virtual node specification to apply.
         * <p>
         * @return {@code this}
         * @param spec The virtual node specification to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.IResolvable spec) {
            this.props.spec(spec);
            return this;
        }

        /**
         * The AWS IAM account ID of the service mesh owner.
         * <p>
         * If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * <p>
         * @return {@code this}
         * @param meshOwner The AWS IAM account ID of the service mesh owner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(final java.lang.String meshOwner) {
            this.props.meshOwner(meshOwner);
            return this;
        }

        /**
         * Optional metadata that you can apply to the virtual node to assist with categorization and organization.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * <p>
         * @return {@code this}
         * @param tags Optional metadata that you can apply to the virtual node to assist with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The name to use for the virtual node.
         * <p>
         * @return {@code this}
         * @param virtualNodeName The name to use for the virtual node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeName(final java.lang.String virtualNodeName) {
            this.props.virtualNodeName(virtualNodeName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appmesh.CfnVirtualNode}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.CfnVirtualNode build() {
            return new software.amazon.awscdk.services.appmesh.CfnVirtualNode(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
