package software.amazon.awscdk.services.appmesh;

/**
 * The properties applied to the VirtualService being defined.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node"))
 *         .build();
 * VirtualService virtualService = VirtualService.Builder.create(this, "service-1")
 *         .virtualServiceProvider(VirtualServiceProvider.virtualNode(node))
 *         .virtualServiceName("service1.domain.local")
 *         .build();
 * node.addBackend(Backend.virtualService(virtualService));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:00.496Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualServiceProps")
@software.amazon.jsii.Jsii.Proxy(VirtualServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VirtualNode or VirtualRouter which the VirtualService uses as its provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceProvider getVirtualServiceProvider();

    /**
     * The name of the VirtualService.
     * <p>
     * It is recommended this follows the fully-qualified domain name format,
     * such as "my-service.default.svc.cluster.local".
     * <p>
     * Example value: <code>service.domain.local</code>
     * <p>
     * Default: - A name is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualServiceName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VirtualServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualServiceProps> {
        software.amazon.awscdk.services.appmesh.VirtualServiceProvider virtualServiceProvider;
        java.lang.String virtualServiceName;

        /**
         * Sets the value of {@link VirtualServiceProps#getVirtualServiceProvider}
         * @param virtualServiceProvider The VirtualNode or VirtualRouter which the VirtualService uses as its provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualServiceProvider(software.amazon.awscdk.services.appmesh.VirtualServiceProvider virtualServiceProvider) {
            this.virtualServiceProvider = virtualServiceProvider;
            return this;
        }

        /**
         * Sets the value of {@link VirtualServiceProps#getVirtualServiceName}
         * @param virtualServiceName The name of the VirtualService.
         *                           It is recommended this follows the fully-qualified domain name format,
         *                           such as "my-service.default.svc.cluster.local".
         *                           <p>
         *                           Example value: <code>service.domain.local</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualServiceName(java.lang.String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualServiceProps {
        private final software.amazon.awscdk.services.appmesh.VirtualServiceProvider virtualServiceProvider;
        private final java.lang.String virtualServiceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.virtualServiceProvider = software.amazon.jsii.Kernel.get(this, "virtualServiceProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualServiceProvider.class));
            this.virtualServiceName = software.amazon.jsii.Kernel.get(this, "virtualServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.virtualServiceProvider = java.util.Objects.requireNonNull(builder.virtualServiceProvider, "virtualServiceProvider is required");
            this.virtualServiceName = builder.virtualServiceName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.VirtualServiceProvider getVirtualServiceProvider() {
            return this.virtualServiceProvider;
        }

        @Override
        public final java.lang.String getVirtualServiceName() {
            return this.virtualServiceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("virtualServiceProvider", om.valueToTree(this.getVirtualServiceProvider()));
            if (this.getVirtualServiceName() != null) {
                data.set("virtualServiceName", om.valueToTree(this.getVirtualServiceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualServiceProps.Jsii$Proxy that = (VirtualServiceProps.Jsii$Proxy) o;

            if (!virtualServiceProvider.equals(that.virtualServiceProvider)) return false;
            return this.virtualServiceName != null ? this.virtualServiceName.equals(that.virtualServiceName) : that.virtualServiceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.virtualServiceProvider.hashCode();
            result = 31 * result + (this.virtualServiceName != null ? this.virtualServiceName.hashCode() : 0);
            return result;
        }
    }
}
