package software.amazon.awscdk.services.athena;

/**
 * A CloudFormation `AWS::Athena::WorkGroup`.
 * <p>
 * The AWS::Athena::WorkGroup resource specifies an Amazon Athena workgroup, which contains a name, description, creation time, state, and other configuration, listed under <code>WorkGroupConfiguration</code> . Each workgroup enables you to isolate queries for you or your group from other queries in the same account. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/APIReference/API_CreateWorkGroup.html">CreateWorkGroup</a> in the <em>Amazon Athena API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.athena.*;
 * CfnWorkGroup cfnWorkGroup = CfnWorkGroup.Builder.create(this, "MyCfnWorkGroup")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .recursiveDeleteOption(false)
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workGroupConfiguration(WorkGroupConfigurationProperty.builder()
 *                 .bytesScannedCutoffPerQuery(123)
 *                 .enforceWorkGroupConfiguration(false)
 *                 .engineVersion(EngineVersionProperty.builder()
 *                         .effectiveEngineVersion("effectiveEngineVersion")
 *                         .selectedEngineVersion("selectedEngineVersion")
 *                         .build())
 *                 .publishCloudWatchMetricsEnabled(false)
 *                 .requesterPaysEnabled(false)
 *                 .resultConfiguration(ResultConfigurationProperty.builder()
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .outputLocation("outputLocation")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:00.604Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup")
public class CfnWorkGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnWorkGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.athena.CfnWorkGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Athena::WorkGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.athena.CfnWorkGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date and time the workgroup was created, as a UNIX timestamp in seconds.
     * <p>
     * For example: <code>1582761016</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkGroupConfigurationEngineVersionEffectiveEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkGroupConfigurationEngineVersionEffectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The workgroup name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workgroup name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The workgroup description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workgroup description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecursiveDeleteOption() {
        return software.amazon.jsii.Kernel.get(this, "recursiveDeleteOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecursiveDeleteOption(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "recursiveDeleteOption", value);
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecursiveDeleteOption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recursiveDeleteOption", value);
    }

    /**
     * The state of the workgroup: ENABLED or DISABLED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the workgroup: ENABLED or DISABLED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkGroupConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "workGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkGroupConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfiguration", value);
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkGroupConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfiguration", value);
    }
    /**
     * If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .encryptionOption("encryptionOption")
     *         // the properties below are optional
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( `SSE_S3` ), server-side encryption with KMS-managed keys ( `SSE_KMS` ), or client-side encryption with KMS-managed keys ( `CSE_KMS` ) is used.
         * <p>
         * If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionOption();

        /**
         * For `SSE_KMS` and `CSE_KMS` , this is the KMS key ARN or ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.String encryptionOption;
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getEncryptionOption}
             * @param encryptionOption Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( `SSE_S3` ), server-side encryption with KMS-managed keys ( `SSE_KMS` ), or client-side encryption with KMS-managed keys ( `CSE_KMS` ) is used. This parameter is required.
             *                         If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionOption(java.lang.String encryptionOption) {
                this.encryptionOption = encryptionOption;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey For `SSE_KMS` and `CSE_KMS` , this is the KMS key ARN or ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String encryptionOption;
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionOption = software.amazon.jsii.Kernel.get(this, "encryptionOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionOption = java.util.Objects.requireNonNull(builder.encryptionOption, "encryptionOption is required");
                this.kmsKey = builder.kmsKey;
            }

            @Override
            public final java.lang.String getEncryptionOption() {
                return this.encryptionOption;
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionOption", om.valueToTree(this.getEncryptionOption()));
                if (this.getKmsKey() != null) {
                    data.set("kmsKey", om.valueToTree(this.getKmsKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                if (!encryptionOption.equals(that.encryptionOption)) return false;
                return this.kmsKey != null ? this.kmsKey.equals(that.kmsKey) : that.kmsKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionOption.hashCode();
                result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Athena engine version for running queries.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * EngineVersionProperty engineVersionProperty = EngineVersionProperty.builder()
     *         .effectiveEngineVersion("effectiveEngineVersion")
     *         .selectedEngineVersion("selectedEngineVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.EngineVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(EngineVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EngineVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Read only.
         * <p>
         * The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEffectiveEngineVersion() {
            return null;
        }

        /**
         * The engine version requested by the user.
         * <p>
         * Possible values are determined by the output of <code>ListEngineVersions</code> , including Auto. The default is Auto.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectedEngineVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EngineVersionProperty> {
            java.lang.String effectiveEngineVersion;
            java.lang.String selectedEngineVersion;

            /**
             * Sets the value of {@link EngineVersionProperty#getEffectiveEngineVersion}
             * @param effectiveEngineVersion Read only.
             *                               The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder effectiveEngineVersion(java.lang.String effectiveEngineVersion) {
                this.effectiveEngineVersion = effectiveEngineVersion;
                return this;
            }

            /**
             * Sets the value of {@link EngineVersionProperty#getSelectedEngineVersion}
             * @param selectedEngineVersion The engine version requested by the user.
             *                              Possible values are determined by the output of <code>ListEngineVersions</code> , including Auto. The default is Auto.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectedEngineVersion(java.lang.String selectedEngineVersion) {
                this.selectedEngineVersion = selectedEngineVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EngineVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EngineVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EngineVersionProperty {
            private final java.lang.String effectiveEngineVersion;
            private final java.lang.String selectedEngineVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.effectiveEngineVersion = software.amazon.jsii.Kernel.get(this, "effectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectedEngineVersion = software.amazon.jsii.Kernel.get(this, "selectedEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.effectiveEngineVersion = builder.effectiveEngineVersion;
                this.selectedEngineVersion = builder.selectedEngineVersion;
            }

            @Override
            public final java.lang.String getEffectiveEngineVersion() {
                return this.effectiveEngineVersion;
            }

            @Override
            public final java.lang.String getSelectedEngineVersion() {
                return this.selectedEngineVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEffectiveEngineVersion() != null) {
                    data.set("effectiveEngineVersion", om.valueToTree(this.getEffectiveEngineVersion()));
                }
                if (this.getSelectedEngineVersion() != null) {
                    data.set("selectedEngineVersion", om.valueToTree(this.getSelectedEngineVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.EngineVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EngineVersionProperty.Jsii$Proxy that = (EngineVersionProperty.Jsii$Proxy) o;

                if (this.effectiveEngineVersion != null ? !this.effectiveEngineVersion.equals(that.effectiveEngineVersion) : that.effectiveEngineVersion != null) return false;
                return this.selectedEngineVersion != null ? this.selectedEngineVersion.equals(that.selectedEngineVersion) : that.selectedEngineVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.effectiveEngineVersion != null ? this.effectiveEngineVersion.hashCode() : 0;
                result = 31 * result + (this.selectedEngineVersion != null ? this.selectedEngineVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
     * <p>
     * These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ResultConfigurationProperty resultConfigurationProperty = ResultConfigurationProperty.builder()
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .encryptionOption("encryptionOption")
     *                 // the properties below are optional
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .outputLocation("outputLocation")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ResultConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResultConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information.
         * <p>
         * This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` .
         * <p>
         * To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and Query History</a> and <code>EnforceWorkGroupConfiguration</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResultConfigurationProperty> {
            java.lang.Object encryptionConfiguration;
            java.lang.String outputLocation;

            /**
             * Sets the value of {@link ResultConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information.
             *                                This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information.
             *                                This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getOutputLocation}
             * @param outputLocation The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` .
             *                       To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and Query History</a> and <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputLocation(java.lang.String outputLocation) {
                this.outputLocation = outputLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResultConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResultConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResultConfigurationProperty {
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String outputLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.outputLocation = builder.outputLocation;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getOutputLocation() {
                return this.outputLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getOutputLocation() != null) {
                    data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResultConfigurationProperty.Jsii$Proxy that = (ResultConfigurationProperty.Jsii$Proxy) o;

                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                return this.outputLocation != null ? this.outputLocation.equals(that.outputLocation) : that.outputLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0;
                result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * WorkGroupConfigurationProperty workGroupConfigurationProperty = WorkGroupConfigurationProperty.builder()
     *         .bytesScannedCutoffPerQuery(123)
     *         .enforceWorkGroupConfiguration(false)
     *         .engineVersion(EngineVersionProperty.builder()
     *                 .effectiveEngineVersion("effectiveEngineVersion")
     *                 .selectedEngineVersion("selectedEngineVersion")
     *                 .build())
     *         .publishCloudWatchMetricsEnabled(false)
     *         .requesterPaysEnabled(false)
     *         .resultConfiguration(ResultConfigurationProperty.builder()
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .encryptionOption("encryptionOption")
     *                         // the properties below are optional
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .outputLocation("outputLocation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkGroupConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkGroupConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * <p>
         * No default is defined.
         * <p>
         * <blockquote>
         * <p>
         * This property currently supports integer types. Support for long values is planned.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesScannedCutoffPerQuery() {
            return null;
        }

        /**
         * If set to "true", the settings for the workgroup override client-side settings.
         * <p>
         * If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceWorkGroupConfiguration() {
            return null;
        }

        /**
         * The engine version that all queries running on the workgroup use.
         * <p>
         * Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEngineVersion() {
            return null;
        }

        /**
         * Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishCloudWatchMetricsEnabled() {
            return null;
        }

        /**
         * If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
         * <p>
         * If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequesterPaysEnabled() {
            return null;
        }

        /**
         * Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and Query History</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResultConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkGroupConfigurationProperty> {
            java.lang.Number bytesScannedCutoffPerQuery;
            java.lang.Object enforceWorkGroupConfiguration;
            java.lang.Object engineVersion;
            java.lang.Object publishCloudWatchMetricsEnabled;
            java.lang.Object requesterPaysEnabled;
            java.lang.Object resultConfiguration;

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getBytesScannedCutoffPerQuery}
             * @param bytesScannedCutoffPerQuery The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
             *                                   No default is defined.
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   This property currently supports integer types. Support for long values is planned.
             *                                   <p>
             *                                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesScannedCutoffPerQuery(java.lang.Number bytesScannedCutoffPerQuery) {
                this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(java.lang.Boolean enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(software.amazon.awscdk.IResolvable enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineVersion}
             * @param engineVersion The engine version that all queries running on the workgroup use.
             *                      Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineVersion}
             * @param engineVersion The engine version that all queries running on the workgroup use.
             *                      Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.IResolvable engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(java.lang.Boolean publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(java.lang.Boolean requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(software.amazon.awscdk.IResolvable requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getResultConfiguration}
             * @param resultConfiguration Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
             *                            For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and Query History</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationProperty resultConfiguration) {
                this.resultConfiguration = resultConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getResultConfiguration}
             * @param resultConfiguration Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
             *                            For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and Query History</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfiguration(software.amazon.awscdk.IResolvable resultConfiguration) {
                this.resultConfiguration = resultConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkGroupConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkGroupConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkGroupConfigurationProperty {
            private final java.lang.Number bytesScannedCutoffPerQuery;
            private final java.lang.Object enforceWorkGroupConfiguration;
            private final java.lang.Object engineVersion;
            private final java.lang.Object publishCloudWatchMetricsEnabled;
            private final java.lang.Object requesterPaysEnabled;
            private final java.lang.Object resultConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bytesScannedCutoffPerQuery = software.amazon.jsii.Kernel.get(this, "bytesScannedCutoffPerQuery", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enforceWorkGroupConfiguration = software.amazon.jsii.Kernel.get(this, "enforceWorkGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publishCloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "publishCloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requesterPaysEnabled = software.amazon.jsii.Kernel.get(this, "requesterPaysEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resultConfiguration = software.amazon.jsii.Kernel.get(this, "resultConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
                this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
                this.engineVersion = builder.engineVersion;
                this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
                this.requesterPaysEnabled = builder.requesterPaysEnabled;
                this.resultConfiguration = builder.resultConfiguration;
            }

            @Override
            public final java.lang.Number getBytesScannedCutoffPerQuery() {
                return this.bytesScannedCutoffPerQuery;
            }

            @Override
            public final java.lang.Object getEnforceWorkGroupConfiguration() {
                return this.enforceWorkGroupConfiguration;
            }

            @Override
            public final java.lang.Object getEngineVersion() {
                return this.engineVersion;
            }

            @Override
            public final java.lang.Object getPublishCloudWatchMetricsEnabled() {
                return this.publishCloudWatchMetricsEnabled;
            }

            @Override
            public final java.lang.Object getRequesterPaysEnabled() {
                return this.requesterPaysEnabled;
            }

            @Override
            public final java.lang.Object getResultConfiguration() {
                return this.resultConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBytesScannedCutoffPerQuery() != null) {
                    data.set("bytesScannedCutoffPerQuery", om.valueToTree(this.getBytesScannedCutoffPerQuery()));
                }
                if (this.getEnforceWorkGroupConfiguration() != null) {
                    data.set("enforceWorkGroupConfiguration", om.valueToTree(this.getEnforceWorkGroupConfiguration()));
                }
                if (this.getEngineVersion() != null) {
                    data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
                }
                if (this.getPublishCloudWatchMetricsEnabled() != null) {
                    data.set("publishCloudWatchMetricsEnabled", om.valueToTree(this.getPublishCloudWatchMetricsEnabled()));
                }
                if (this.getRequesterPaysEnabled() != null) {
                    data.set("requesterPaysEnabled", om.valueToTree(this.getRequesterPaysEnabled()));
                }
                if (this.getResultConfiguration() != null) {
                    data.set("resultConfiguration", om.valueToTree(this.getResultConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkGroupConfigurationProperty.Jsii$Proxy that = (WorkGroupConfigurationProperty.Jsii$Proxy) o;

                if (this.bytesScannedCutoffPerQuery != null ? !this.bytesScannedCutoffPerQuery.equals(that.bytesScannedCutoffPerQuery) : that.bytesScannedCutoffPerQuery != null) return false;
                if (this.enforceWorkGroupConfiguration != null ? !this.enforceWorkGroupConfiguration.equals(that.enforceWorkGroupConfiguration) : that.enforceWorkGroupConfiguration != null) return false;
                if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
                if (this.publishCloudWatchMetricsEnabled != null ? !this.publishCloudWatchMetricsEnabled.equals(that.publishCloudWatchMetricsEnabled) : that.publishCloudWatchMetricsEnabled != null) return false;
                if (this.requesterPaysEnabled != null ? !this.requesterPaysEnabled.equals(that.requesterPaysEnabled) : that.requesterPaysEnabled != null) return false;
                return this.resultConfiguration != null ? this.resultConfiguration.equals(that.resultConfiguration) : that.resultConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bytesScannedCutoffPerQuery != null ? this.bytesScannedCutoffPerQuery.hashCode() : 0;
                result = 31 * result + (this.enforceWorkGroupConfiguration != null ? this.enforceWorkGroupConfiguration.hashCode() : 0);
                result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
                result = 31 * result + (this.publishCloudWatchMetricsEnabled != null ? this.publishCloudWatchMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.requesterPaysEnabled != null ? this.requesterPaysEnabled.hashCode() : 0);
                result = 31 * result + (this.resultConfiguration != null ? this.resultConfiguration.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.athena.CfnWorkGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.athena.CfnWorkGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.athena.CfnWorkGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.athena.CfnWorkGroupProps.Builder();
        }

        /**
         * The workgroup name.
         * <p>
         * @return {@code this}
         * @param name The workgroup name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The workgroup description.
         * <p>
         * @return {@code this}
         * @param description The workgroup description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(final java.lang.Boolean recursiveDeleteOption) {
            this.props.recursiveDeleteOption(recursiveDeleteOption);
            return this;
        }
        /**
         * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(final software.amazon.awscdk.IResolvable recursiveDeleteOption) {
            this.props.recursiveDeleteOption(recursiveDeleteOption);
            return this;
        }

        /**
         * The state of the workgroup: ENABLED or DISABLED.
         * <p>
         * @return {@code this}
         * @param state The state of the workgroup: ENABLED or DISABLED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props.state(state);
            return this;
        }

        /**
         * The tags (key-value pairs) to associate with this resource.
         * <p>
         * @return {@code this}
         * @param tags The tags (key-value pairs) to associate with this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         * <p>
         * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * <p>
         * @return {@code this}
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(final software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty workGroupConfiguration) {
            this.props.workGroupConfiguration(workGroupConfiguration);
            return this;
        }
        /**
         * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         * <p>
         * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * <p>
         * @return {@code this}
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(final software.amazon.awscdk.IResolvable workGroupConfiguration) {
            this.props.workGroupConfiguration(workGroupConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.athena.CfnWorkGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.athena.CfnWorkGroup build() {
            return new software.amazon.awscdk.services.athena.CfnWorkGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
