package software.amazon.awscdk.services.batch;

/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 * <p>
 * The <code>AWS::Batch::ComputeEnvironment</code> resource defines your AWS Batch compute environment. You can define <code>MANAGED</code> or <code>UNMANAGED</code> compute environments. <code>MANAGED</code> compute environments can use Amazon EC2 or AWS Fargate resources. <code>UNMANAGED</code> compute environments can only use EC2 resources. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
 * <p>
 * In a managed compute environment, AWS Batch manages the capacity and instance types of the compute resources within the environment. This is based on the compute resource specification that you define or the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">launch template</a> that you specify when you create the compute environment. You can choose either to use EC2 On-Demand Instances and EC2 Spot Instances, or to use Fargate and Fargate Spot capacity in your managed compute environment. You can optionally set a maximum price so that Spot Instances only launch when the Spot Instance price is below a specified percentage of the On-Demand price.
 * <p>
 * <blockquote>
 * <p>
 * Multi-node parallel jobs are not supported on Spot Instances.
 * <p>
 * </blockquote>
 * <p>
 * In an unmanaged compute environment, you can manage your own EC2 compute resources and have a lot of flexibility with how you configure your compute resources. For example, you can use custom AMI. However, you need to verify that your AMI meets the Amazon ECS container instance AMI specification. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html">container instance AMIs</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . After you have created your unmanaged compute environment, you can use the <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeComputeEnvironments.html">DescribeComputeEnvironments</a> operation to find the Amazon ECS cluster that is associated with it. Then, manually launch your container instances into that Amazon ECS cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html">Launching an Amazon ECS container instance</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * AWS Batch doesn't upgrade the AMIs in a compute environment after it's created except under specific conditions. For example, it doesn't automatically update the AMIs when a newer version of the Amazon ECS optimized AMI is available. Therefore, you're responsible for the management of the guest operating system (including updates and security patches) and any additional application software or utilities that you install on the compute resources. There are two ways to use a new AMI for your AWS Batch jobs. The original method is to complete these steps:
 * <p>
 * <ul>
 * <li>Create a new compute environment with the new AMI.</li>
 * <li>Add the compute environment to an existing job queue.</li>
 * <li>Remove the earlier compute environment from your job queue.</li>
 * <li>Delete the earlier compute environment.</li>
 * </ul>
 * <p>
 * In April 2022, AWS Batch added enhanced support for updating compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> . To use the enhanced updating of compute environments to update AMIs, follow these rules:
 * <p>
 * <ul>
 * <li>Either do not set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole">ServiceRole</a> property or set it to the <em>AWSServiceRoleForBatch</em> service-linked role.</li>
 * <li>Set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy">AllocationStrategy</a> property to <code>BEST_FIT_PROGRESSIVE</code> or <code>SPOT_CAPACITY_OPTIMIZED</code> .</li>
 * <li>Set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-replacecomputeenvironment">ReplaceComputeEnvironment</a> property to <code>false</code> .</li>
 * <li>Set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion">UpdateToLatestImageVersion</a> property to <code>true</code> .</li>
 * <li>Either do not specify an image ID in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid">ImageId</a> or <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-ec2configurationobject.html#cfn-batch-computeenvironment-ec2configurationobject-imageidoverride">ImageIdOverride</a> properties, or in the launch template identified by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate">Launch Template</a> property. In that case AWS Batch will select the latest Amazon ECS optimized AMI supported by AWS Batch at the time the infrastructure update is initiated. Alternatively you can specify the AMI ID in the <code>ImageId</code> or <code>ImageIdOverride</code> properties, or the launch template identified by the <code>LaunchTemplate</code> properties. Changing any of these properties will trigger an infrastructure update.</li>
 * </ul>
 * <p>
 * If these rules are followed, any update that triggers an infrastructure update will cause the AMI ID to be re-selected. If the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-version">Version</a> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html">LaunchTemplateSpecification</a> is set to <code>$Latest</code> or <code>$Default</code> , the latest or default version of the launch template will be evaluated up at the time of the infrastructure update, even if the <code>LaunchTemplateSpecification</code> was not updated.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * CfnComputeEnvironment cfnComputeEnvironment = CfnComputeEnvironment.Builder.create(this, "MyCfnComputeEnvironment")
 *         .type("type")
 *         // the properties below are optional
 *         .computeEnvironmentName("computeEnvironmentName")
 *         .computeResources(ComputeResourcesProperty.builder()
 *                 .maxvCpus(123)
 *                 .subnets(List.of("subnets"))
 *                 .type("type")
 *                 // the properties below are optional
 *                 .allocationStrategy("allocationStrategy")
 *                 .bidPercentage(123)
 *                 .desiredvCpus(123)
 *                 .ec2Configuration(List.of(Ec2ConfigurationObjectProperty.builder()
 *                         .imageType("imageType")
 *                         // the properties below are optional
 *                         .imageIdOverride("imageIdOverride")
 *                         .build()))
 *                 .ec2KeyPair("ec2KeyPair")
 *                 .imageId("imageId")
 *                 .instanceRole("instanceRole")
 *                 .instanceTypes(List.of("instanceTypes"))
 *                 .launchTemplate(LaunchTemplateSpecificationProperty.builder()
 *                         .launchTemplateId("launchTemplateId")
 *                         .launchTemplateName("launchTemplateName")
 *                         .version("version")
 *                         .build())
 *                 .minvCpus(123)
 *                 .placementGroup("placementGroup")
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .spotIamFleetRole("spotIamFleetRole")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .updateToLatestImageVersion(false)
 *                 .build())
 *         .replaceComputeEnvironment(false)
 *         .serviceRole("serviceRole")
 *         .state("state")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .unmanagedvCpus(123)
 *         .updatePolicy(UpdatePolicyProperty.builder()
 *                 .jobExecutionTimeoutMinutes(123)
 *                 .terminateJobsOnUpdate(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:00.778Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnComputeEnvironment")
public class CfnComputeEnvironment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnComputeEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComputeEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.CfnComputeEnvironment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Batch::ComputeEnvironment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComputeEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the compute environment ARN, such as `batch: *us-east-1* : *111122223333* :compute-environment/ *ComputeEnvironmentName*` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComputeEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "attrComputeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags applied to the compute environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The type of the compute environment: `MANAGED` or `UNMANAGED` .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <em>AWS Batch User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the compute environment: `MANAGED` or `UNMANAGED` .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <em>AWS Batch User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The name for your compute environment.
     * <p>
     * It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComputeEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for your compute environment.
     * <p>
     * It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeEnvironmentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "computeEnvironmentName", value);
    }

    /**
     * The ComputeResources property type specifies details of the compute resources managed by the compute environment.
     * <p>
     * This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getComputeResources() {
        return software.amazon.jsii.Kernel.get(this, "computeResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The ComputeResources property type specifies details of the compute resources managed by the compute environment.
     * <p>
     * This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeResources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty value) {
        software.amazon.jsii.Kernel.set(this, "computeResources", value);
    }

    /**
     * The ComputeResources property type specifies details of the compute resources managed by the compute environment.
     * <p>
     * This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeResources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "computeResources", value);
    }

    /**
     * Specifies whether the compute environment should be replaced if an update is made that requires replacing the instances in the compute environment.
     * <p>
     * The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , no other properties should be changed at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplaceComputeEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the compute environment should be replaced if an update is made that requires replacing the instances in the compute environment.
     * <p>
     * The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , no other properties should be changed at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceComputeEnvironment(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "replaceComputeEnvironment", value);
    }

    /**
     * Specifies whether the compute environment should be replaced if an update is made that requires replacing the instances in the compute environment.
     * <p>
     * The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , no other properties should be changed at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceComputeEnvironment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replaceComputeEnvironment", value);
    }

    /**
     * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">AWS Batch service IAM role</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If your account already created the AWS Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the AWS Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the AWS Batch service-linked role in your account.
     * <p>
     * </blockquote>
     * <p>
     * If your specified role has a path other than <code>/</code> , then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Depending on how you created your AWS Batch service role, its ARN might contain the <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN doesn't use the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">AWS Batch service IAM role</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If your account already created the AWS Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the AWS Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the AWS Batch service-linked role in your account.
     * <p>
     * </blockquote>
     * <p>
     * If your specified role has a path other than <code>/</code> , then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Depending on how you created your AWS Batch service role, its ARN might contain the <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN doesn't use the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRole", value);
    }

    /**
     * The state of the compute environment.
     * <p>
     * If the state is <code>ENABLED</code> , then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
     * <p>
     * If the state is <code>ENABLED</code> , then the AWS Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
     * <p>
     * If the state is <code>DISABLED</code> , then the AWS Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don't scale out. However, they scale in to <code>minvCpus</code> value after instances become idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the compute environment.
     * <p>
     * If the state is <code>ENABLED</code> , then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
     * <p>
     * If the state is <code>ENABLED</code> , then the AWS Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
     * <p>
     * If the state is <code>DISABLED</code> , then the AWS Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don't scale out. However, they scale in to <code>minvCpus</code> value after instances become idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }

    /**
     * The maximum number of vCPUs for an unmanaged compute environment.
     * <p>
     * This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only supported when the <code>type</code> parameter is set to <code>UNMANAGED</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getUnmanagedvCpus() {
        return software.amazon.jsii.Kernel.get(this, "unmanagedvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of vCPUs for an unmanaged compute environment.
     * <p>
     * This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only supported when the <code>type</code> parameter is set to <code>UNMANAGED</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUnmanagedvCpus(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "unmanagedvCpus", value);
    }

    /**
     * Specifies the infrastructure update policy for the compute environment.
     * <p>
     * For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUpdatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "updatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the infrastructure update policy for the compute environment.
     * <p>
     * For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUpdatePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnComputeEnvironment.UpdatePolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "updatePolicy", value);
    }

    /**
     * Specifies the infrastructure update policy for the compute environment.
     * <p>
     * For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUpdatePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "updatePolicy", value);
    }
    /**
     * Details about the compute resources managed by the compute environment.
     * <p>
     * This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ComputeResourcesProperty computeResourcesProperty = ComputeResourcesProperty.builder()
     *         .maxvCpus(123)
     *         .subnets(List.of("subnets"))
     *         .type("type")
     *         // the properties below are optional
     *         .allocationStrategy("allocationStrategy")
     *         .bidPercentage(123)
     *         .desiredvCpus(123)
     *         .ec2Configuration(List.of(Ec2ConfigurationObjectProperty.builder()
     *                 .imageType("imageType")
     *                 // the properties below are optional
     *                 .imageIdOverride("imageIdOverride")
     *                 .build()))
     *         .ec2KeyPair("ec2KeyPair")
     *         .imageId("imageId")
     *         .instanceRole("instanceRole")
     *         .instanceTypes(List.of("instanceTypes"))
     *         .launchTemplate(LaunchTemplateSpecificationProperty.builder()
     *                 .launchTemplateId("launchTemplateId")
     *                 .launchTemplateName("launchTemplateName")
     *                 .version("version")
     *                 .build())
     *         .minvCpus(123)
     *         .placementGroup("placementGroup")
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .spotIamFleetRole("spotIamFleetRole")
     *         .tags(Map.of(
     *                 "tagsKey", "tags"))
     *         .updateToLatestImageVersion(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnComputeEnvironment.ComputeResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(ComputeResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComputeResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of Amazon EC2 vCPUs that an environment can reach.
         * <p>
         * <blockquote>
         * <p>
         * With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation strategies, AWS Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements. In this event, AWS Batch never exceeds <code>maxvCpus</code> by more than a single instance. That is, no more than a single instance from among those specified in your compute environment.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxvCpus();

        /**
         * The VPC subnets where the compute resources are launched.
         * <p>
         * Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <em>Amazon VPC User Guide</em> .
         * <p>
         * When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * The type of compute environment: `EC2` , `SPOT` , `FARGATE` , or `FARGATE_SPOT` .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * If you choose <code>SPOT</code> , you must also specify an Amazon EC2 Spot Fleet role with the <code>spotIamFleetRole</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * When updating compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * When updating the type of a compute environment, changing between <code>EC2</code> and <code>SPOT</code> or between <code>FARGATE</code> and <code>FARGATE_SPOT</code> will initiate an infrastructure update, but if you switch between <code>EC2</code> and <code>FARGATE</code> , AWS CloudFormation will create a new compute environment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated.
         * <p>
         * This might be because of availability of the instance type in the Region or <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service limits</a> . For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation strategies</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> . <code>BEST_FIT</code> is not supported when updating a compute environment.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>BEST_FIT (default)</strong> - AWS Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, AWS Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service limits</a> then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with <code>BEST_FIT</code> then the Spot Fleet IAM role must be specified.</li>
         * <li><strong>BEST_FIT_PROGRESSIVE</strong> - AWS Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, AWS Batch will select new instance types.</li>
         * <li><strong>SPOT_CAPACITY_OPTIMIZED</strong> - AWS Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.</li>
         * </ul>
         * <p>
         * With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> strategies, AWS Batch might need to go above <code>maxvCpus</code> to meet your capacity requirements. In this event, AWS Batch never exceeds <code>maxvCpus</code> by more than a single instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched.
         * <p>
         * For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage.
         * <p>
         * When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBidPercentage() {
            return null;
        }

        /**
         * The desired number of Amazon EC2 vCPUS in the compute environment.
         * <p>
         * AWS Batch modifies this value between the minimum and maximum values based on job queue demand.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredvCpus() {
            return null;
        }

        /**
         * Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment.
         * <p>
         * If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code> .
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> . To remove the EC2 configuration and any custom AMI ID specified in <code>imageIdOverride</code> , set this value to an empty string.
         * <p>
         * One or two values can be provided.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2Configuration() {
            return null;
        }

        /**
         * The Amazon EC2 key pair that's used for instances launched in the compute environment.
         * <p>
         * You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.
         * <p>
         * When updating a compute environment, changing the EC2 key pair requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2KeyPair() {
            return null;
        }

        /**
         * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment.
         * <p>
         * This parameter is overridden by the <code>imageIdOverride</code> member of the <code>Ec2Configuration</code> structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.
         * <p>
         * When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. &gt; The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html">Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
            return null;
        }

        /**
         * The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment.
         * <p>
         * You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, <code>*ecsInstanceRole*</code> or <code>arn:aws:iam:: *&lt;aws_account_id&gt;* :instance-profile/ *ecsInstanceRole*</code> . For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon ECS instance role</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceRole() {
            return null;
        }

        /**
         * The instances types that can be launched.
         * <p>
         * You can specify instance families to launch any instance type within those families (for example, <code>c5</code> or <code>p3</code> ), or you can specify specific sizes within a family (such as <code>c5.8xlarge</code> ). You can also choose <code>optimal</code> to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. &gt; When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment. &gt; Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceTypes() {
            return null;
        }

        /**
         * The launch template to use for your compute resources.
         * <p>
         * Any other compute resource parameters that you specify in a <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html">CreateComputeEnvironment</a> API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch Template Support</a> in the ** .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplate() {
            return null;
        }

        /**
         * The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is `DISABLED` ).
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinvCpus() {
            return null;
        }

        /**
         * The Amazon EC2 placement group to associate with your compute resources.
         * <p>
         * If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
         * <p>
         * When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroup() {
            return null;
        }

        /**
         * The Amazon EC2 security groups associated with instances launched in the compute environment.
         * <p>
         * This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the security groups from the compute resource.
         * <p>
         * When updating a compute environment, changing the EC2 security groups requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment.
         * <p>
         * This role is required if the allocation strategy set to <code>BEST_FIT</code> or if the allocation strategy isn't specified. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. &gt; To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer <em>AmazonEC2SpotFleetTaggingRole</em> managed policy. The previously recommended <em>AmazonEC2SpotFleetRole</em> managed policy doesn't have the required permissions to tag Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag">Spot instances not tagged on creation</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotIamFleetRole() {
            return null;
        }

        /**
         * Key-value pair tags to be applied to EC2 resources that are launched in the compute environment.
         * <p>
         * For AWS Batch , these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, <code>{ "Name": "Batch Instance - C4OnDemand" }</code> . This is helpful for recognizing your AWS Batch instances in the Amazon EC2 console. These tags aren't seen when using the AWS Batch <code>ListTagsForResource</code> API operation.
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
            return null;
        }

        /**
         * Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * <blockquote>
         * <p>
         * If an AMI ID is specified in the <code>imageId</code> or <code>imageIdOverride</code> parameters or by the launch template specified in the <code>launchTemplate</code> parameter, this parameter is ignored. For more information on updating AMI IDs during an infrastructure update, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami">Updating the AMI ID</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateToLatestImageVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComputeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComputeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComputeResourcesProperty> {
            java.lang.Number maxvCpus;
            java.util.List<java.lang.String> subnets;
            java.lang.String type;
            java.lang.String allocationStrategy;
            java.lang.Number bidPercentage;
            java.lang.Number desiredvCpus;
            java.lang.Object ec2Configuration;
            java.lang.String ec2KeyPair;
            java.lang.String imageId;
            java.lang.String instanceRole;
            java.util.List<java.lang.String> instanceTypes;
            java.lang.Object launchTemplate;
            java.lang.Number minvCpus;
            java.lang.String placementGroup;
            java.util.List<java.lang.String> securityGroupIds;
            java.lang.String spotIamFleetRole;
            java.util.Map<java.lang.String, java.lang.String> tags;
            java.lang.Object updateToLatestImageVersion;

            /**
             * Sets the value of {@link ComputeResourcesProperty#getMaxvCpus}
             * @param maxvCpus The maximum number of Amazon EC2 vCPUs that an environment can reach. This parameter is required.
             *                 <blockquote>
             *                 <p>
             *                 With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation strategies, AWS Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements. In this event, AWS Batch never exceeds <code>maxvCpus</code> by more than a single instance. That is, no more than a single instance from among those specified in your compute environment.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxvCpus(java.lang.Number maxvCpus) {
                this.maxvCpus = maxvCpus;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getSubnets}
             * @param subnets The VPC subnets where the compute resources are launched. This parameter is required.
             *                Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <em>Amazon VPC User Guide</em> .
             *                <p>
             *                When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getType}
             * @param type The type of compute environment: `EC2` , `SPOT` , `FARGATE` , or `FARGATE_SPOT` . This parameter is required.
             *             For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in the <em>AWS Batch User Guide</em> .
             *             <p>
             *             If you choose <code>SPOT</code> , you must also specify an Amazon EC2 Spot Fleet role with the <code>spotIamFleetRole</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a> in the <em>AWS Batch User Guide</em> .
             *             <p>
             *             When updating compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *             <p>
             *             When updating the type of a compute environment, changing between <code>EC2</code> and <code>SPOT</code> or between <code>FARGATE</code> and <code>FARGATE_SPOT</code> will initiate an infrastructure update, but if you switch between <code>EC2</code> and <code>FARGATE</code> , AWS CloudFormation will create a new compute environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getAllocationStrategy}
             * @param allocationStrategy The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated.
             *                           This might be because of availability of the instance type in the Region or <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service limits</a> . For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation strategies</a> in the <em>AWS Batch User Guide</em> .
             *                           <p>
             *                           When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> . <code>BEST_FIT</code> is not supported when updating a compute environment.
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                           <p>
             *                           </blockquote>
             *                           <p>
             *                           <ul>
             *                           <li><strong>BEST_FIT (default)</strong> - AWS Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren't available, AWS Batch waits for the additional instances to be available. If there aren't enough instances available, or if the user is reaching <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service limits</a> then additional jobs aren't run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with <code>BEST_FIT</code> then the Spot Fleet IAM role must be specified.</li>
             *                           <li><strong>BEST_FIT_PROGRESSIVE</strong> - AWS Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren't available, AWS Batch will select new instance types.</li>
             *                           <li><strong>SPOT_CAPACITY_OPTIMIZED</strong> - AWS Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.</li>
             *                           </ul>
             *                           <p>
             *                           With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> strategies, AWS Batch might need to go above <code>maxvCpus</code> to meet your capacity requirements. In this event, AWS Batch never exceeds <code>maxvCpus</code> by more than a single instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getBidPercentage}
             * @param bidPercentage The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched.
             *                      For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage.
             *                      <p>
             *                      When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bidPercentage(java.lang.Number bidPercentage) {
                this.bidPercentage = bidPercentage;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getDesiredvCpus}
             * @param desiredvCpus The desired number of Amazon EC2 vCPUS in the compute environment.
             *                     AWS Batch modifies this value between the minimum and maximum values based on job queue demand.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredvCpus(java.lang.Number desiredvCpus) {
                this.desiredvCpus = desiredvCpus;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getEc2Configuration}
             * @param ec2Configuration Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment.
             *                         If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code> .
             *                         <p>
             *                         When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> . To remove the EC2 configuration and any custom AMI ID specified in <code>imageIdOverride</code> , set this value to an empty string.
             *                         <p>
             *                         One or two values can be provided.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2Configuration(software.amazon.awscdk.IResolvable ec2Configuration) {
                this.ec2Configuration = ec2Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getEc2Configuration}
             * @param ec2Configuration Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment.
             *                         If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code> .
             *                         <p>
             *                         When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> . To remove the EC2 configuration and any custom AMI ID specified in <code>imageIdOverride</code> , set this value to an empty string.
             *                         <p>
             *                         One or two values can be provided.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2Configuration(java.util.List<? extends java.lang.Object> ec2Configuration) {
                this.ec2Configuration = ec2Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getEc2KeyPair}
             * @param ec2KeyPair The Amazon EC2 key pair that's used for instances launched in the compute environment.
             *                   You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.
             *                   <p>
             *                   When updating a compute environment, changing the EC2 key pair requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2KeyPair(java.lang.String ec2KeyPair) {
                this.ec2KeyPair = ec2KeyPair;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getImageId}
             * @param imageId The Amazon Machine Image (AMI) ID used for instances launched in the compute environment.
             *                This parameter is overridden by the <code>imageIdOverride</code> member of the <code>Ec2Configuration</code> structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.
             *                <p>
             *                When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. &gt; The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html">Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getInstanceRole}
             * @param instanceRole The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment.
             *                     You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, <code>*ecsInstanceRole*</code> or <code>arn:aws:iam:: *&lt;aws_account_id&gt;* :instance-profile/ *ecsInstanceRole*</code> . For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon ECS instance role</a> in the <em>AWS Batch User Guide</em> .
             *                     <p>
             *                     When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRole(java.lang.String instanceRole) {
                this.instanceRole = instanceRole;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getInstanceTypes}
             * @param instanceTypes The instances types that can be launched.
             *                      You can specify instance families to launch any instance type within those families (for example, <code>c5</code> or <code>p3</code> ), or you can specify specific sizes within a family (such as <code>c5.8xlarge</code> ). You can also choose <code>optimal</code> to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
             *                      <p>
             *                      When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. &gt; When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment. &gt; Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions that don't have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceTypes(java.util.List<java.lang.String> instanceTypes) {
                this.instanceTypes = instanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getLaunchTemplate}
             * @param launchTemplate The launch template to use for your compute resources.
             *                       Any other compute resource parameters that you specify in a <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html">CreateComputeEnvironment</a> API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch Template Support</a> in the ** .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplate(software.amazon.awscdk.services.batch.CfnComputeEnvironment.LaunchTemplateSpecificationProperty launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getLaunchTemplate}
             * @param launchTemplate The launch template to use for your compute resources.
             *                       Any other compute resource parameters that you specify in a <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html">CreateComputeEnvironment</a> API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch Template Support</a> in the ** .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplate(software.amazon.awscdk.IResolvable launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getMinvCpus}
             * @param minvCpus The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is `DISABLED` ).
             *                 <blockquote>
             *                 <p>
             *                 This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minvCpus(java.lang.Number minvCpus) {
                this.minvCpus = minvCpus;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getPlacementGroup}
             * @param placementGroup The Amazon EC2 placement group to associate with your compute resources.
             *                       If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
             *                       <p>
             *                       When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementGroup(java.lang.String placementGroup) {
                this.placementGroup = placementGroup;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getSecurityGroupIds}
             * @param securityGroupIds The Amazon EC2 security groups associated with instances launched in the compute environment.
             *                         This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is made. For EC2 compute resources, providing an empty list removes the security groups from the compute resource.
             *                         <p>
             *                         When updating a compute environment, changing the EC2 security groups requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getSpotIamFleetRole}
             * @param spotIamFleetRole The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a `SPOT` compute environment.
             *                         This role is required if the allocation strategy set to <code>BEST_FIT</code> or if the allocation strategy isn't specified. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a> in the <em>AWS Batch User Guide</em> .
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified. &gt; To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer <em>AmazonEC2SpotFleetTaggingRole</em> managed policy. The previously recommended <em>AmazonEC2SpotFleetRole</em> managed policy doesn't have the required permissions to tag Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag">Spot instances not tagged on creation</a> in the <em>AWS Batch User Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotIamFleetRole(java.lang.String spotIamFleetRole) {
                this.spotIamFleetRole = spotIamFleetRole;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getTags}
             * @param tags Key-value pair tags to be applied to EC2 resources that are launched in the compute environment.
             *             For AWS Batch , these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, <code>{ "Name": "Batch Instance - C4OnDemand" }</code> . This is helpful for recognizing your AWS Batch instances in the Amazon EC2 console. These tags aren't seen when using the AWS Batch <code>ListTagsForResource</code> API operation.
             *             <p>
             *             When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *             <p>
             *             <blockquote>
             *             <p>
             *             This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getUpdateToLatestImageVersion}
             * @param updateToLatestImageVersion Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update.
             *                                   The default value is <code>false</code> .
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   If an AMI ID is specified in the <code>imageId</code> or <code>imageIdOverride</code> parameters or by the launch template specified in the <code>launchTemplate</code> parameter, this parameter is ignored. For more information on updating AMI IDs during an infrastructure update, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami">Updating the AMI ID</a> in the <em>AWS Batch User Guide</em> .
             *                                   <p>
             *                                   </blockquote>
             *                                   <p>
             *                                   When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateToLatestImageVersion(java.lang.Boolean updateToLatestImageVersion) {
                this.updateToLatestImageVersion = updateToLatestImageVersion;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getUpdateToLatestImageVersion}
             * @param updateToLatestImageVersion Specifies whether the AMI ID is updated to the latest one that's supported by AWS Batch when the compute environment has an infrastructure update.
             *                                   The default value is <code>false</code> .
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   If an AMI ID is specified in the <code>imageId</code> or <code>imageIdOverride</code> parameters or by the launch template specified in the <code>launchTemplate</code> parameter, this parameter is ignored. For more information on updating AMI IDs during an infrastructure update, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami">Updating the AMI ID</a> in the <em>AWS Batch User Guide</em> .
             *                                   <p>
             *                                   </blockquote>
             *                                   <p>
             *                                   When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateToLatestImageVersion(software.amazon.awscdk.IResolvable updateToLatestImageVersion) {
                this.updateToLatestImageVersion = updateToLatestImageVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComputeResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComputeResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComputeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeResourcesProperty {
            private final java.lang.Number maxvCpus;
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String type;
            private final java.lang.String allocationStrategy;
            private final java.lang.Number bidPercentage;
            private final java.lang.Number desiredvCpus;
            private final java.lang.Object ec2Configuration;
            private final java.lang.String ec2KeyPair;
            private final java.lang.String imageId;
            private final java.lang.String instanceRole;
            private final java.util.List<java.lang.String> instanceTypes;
            private final java.lang.Object launchTemplate;
            private final java.lang.Number minvCpus;
            private final java.lang.String placementGroup;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.lang.String spotIamFleetRole;
            private final java.util.Map<java.lang.String, java.lang.String> tags;
            private final java.lang.Object updateToLatestImageVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxvCpus = software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bidPercentage = software.amazon.jsii.Kernel.get(this, "bidPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.desiredvCpus = software.amazon.jsii.Kernel.get(this, "desiredvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ec2Configuration = software.amazon.jsii.Kernel.get(this, "ec2Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2KeyPair = software.amazon.jsii.Kernel.get(this, "ec2KeyPair", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceTypes = software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minvCpus = software.amazon.jsii.Kernel.get(this, "minvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.placementGroup = software.amazon.jsii.Kernel.get(this, "placementGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.spotIamFleetRole = software.amazon.jsii.Kernel.get(this, "spotIamFleetRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.updateToLatestImageVersion = software.amazon.jsii.Kernel.get(this, "updateToLatestImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxvCpus = java.util.Objects.requireNonNull(builder.maxvCpus, "maxvCpus is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.allocationStrategy = builder.allocationStrategy;
                this.bidPercentage = builder.bidPercentage;
                this.desiredvCpus = builder.desiredvCpus;
                this.ec2Configuration = builder.ec2Configuration;
                this.ec2KeyPair = builder.ec2KeyPair;
                this.imageId = builder.imageId;
                this.instanceRole = builder.instanceRole;
                this.instanceTypes = builder.instanceTypes;
                this.launchTemplate = builder.launchTemplate;
                this.minvCpus = builder.minvCpus;
                this.placementGroup = builder.placementGroup;
                this.securityGroupIds = builder.securityGroupIds;
                this.spotIamFleetRole = builder.spotIamFleetRole;
                this.tags = builder.tags;
                this.updateToLatestImageVersion = builder.updateToLatestImageVersion;
            }

            @Override
            public final java.lang.Number getMaxvCpus() {
                return this.maxvCpus;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Number getBidPercentage() {
                return this.bidPercentage;
            }

            @Override
            public final java.lang.Number getDesiredvCpus() {
                return this.desiredvCpus;
            }

            @Override
            public final java.lang.Object getEc2Configuration() {
                return this.ec2Configuration;
            }

            @Override
            public final java.lang.String getEc2KeyPair() {
                return this.ec2KeyPair;
            }

            @Override
            public final java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public final java.lang.String getInstanceRole() {
                return this.instanceRole;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceTypes() {
                return this.instanceTypes;
            }

            @Override
            public final java.lang.Object getLaunchTemplate() {
                return this.launchTemplate;
            }

            @Override
            public final java.lang.Number getMinvCpus() {
                return this.minvCpus;
            }

            @Override
            public final java.lang.String getPlacementGroup() {
                return this.placementGroup;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.lang.String getSpotIamFleetRole() {
                return this.spotIamFleetRole;
            }

            @Override
            public final java.util.Map<java.lang.String, java.lang.String> getTags() {
                return this.tags;
            }

            @Override
            public final java.lang.Object getUpdateToLatestImageVersion() {
                return this.updateToLatestImageVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxvCpus", om.valueToTree(this.getMaxvCpus()));
                data.set("subnets", om.valueToTree(this.getSubnets()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getBidPercentage() != null) {
                    data.set("bidPercentage", om.valueToTree(this.getBidPercentage()));
                }
                if (this.getDesiredvCpus() != null) {
                    data.set("desiredvCpus", om.valueToTree(this.getDesiredvCpus()));
                }
                if (this.getEc2Configuration() != null) {
                    data.set("ec2Configuration", om.valueToTree(this.getEc2Configuration()));
                }
                if (this.getEc2KeyPair() != null) {
                    data.set("ec2KeyPair", om.valueToTree(this.getEc2KeyPair()));
                }
                if (this.getImageId() != null) {
                    data.set("imageId", om.valueToTree(this.getImageId()));
                }
                if (this.getInstanceRole() != null) {
                    data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
                }
                if (this.getInstanceTypes() != null) {
                    data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
                }
                if (this.getLaunchTemplate() != null) {
                    data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
                }
                if (this.getMinvCpus() != null) {
                    data.set("minvCpus", om.valueToTree(this.getMinvCpus()));
                }
                if (this.getPlacementGroup() != null) {
                    data.set("placementGroup", om.valueToTree(this.getPlacementGroup()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSpotIamFleetRole() != null) {
                    data.set("spotIamFleetRole", om.valueToTree(this.getSpotIamFleetRole()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }
                if (this.getUpdateToLatestImageVersion() != null) {
                    data.set("updateToLatestImageVersion", om.valueToTree(this.getUpdateToLatestImageVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnComputeEnvironment.ComputeResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComputeResourcesProperty.Jsii$Proxy that = (ComputeResourcesProperty.Jsii$Proxy) o;

                if (!maxvCpus.equals(that.maxvCpus)) return false;
                if (!subnets.equals(that.subnets)) return false;
                if (!type.equals(that.type)) return false;
                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.bidPercentage != null ? !this.bidPercentage.equals(that.bidPercentage) : that.bidPercentage != null) return false;
                if (this.desiredvCpus != null ? !this.desiredvCpus.equals(that.desiredvCpus) : that.desiredvCpus != null) return false;
                if (this.ec2Configuration != null ? !this.ec2Configuration.equals(that.ec2Configuration) : that.ec2Configuration != null) return false;
                if (this.ec2KeyPair != null ? !this.ec2KeyPair.equals(that.ec2KeyPair) : that.ec2KeyPair != null) return false;
                if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
                if (this.instanceRole != null ? !this.instanceRole.equals(that.instanceRole) : that.instanceRole != null) return false;
                if (this.instanceTypes != null ? !this.instanceTypes.equals(that.instanceTypes) : that.instanceTypes != null) return false;
                if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
                if (this.minvCpus != null ? !this.minvCpus.equals(that.minvCpus) : that.minvCpus != null) return false;
                if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.spotIamFleetRole != null ? !this.spotIamFleetRole.equals(that.spotIamFleetRole) : that.spotIamFleetRole != null) return false;
                if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
                return this.updateToLatestImageVersion != null ? this.updateToLatestImageVersion.equals(that.updateToLatestImageVersion) : that.updateToLatestImageVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxvCpus.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
                result = 31 * result + (this.bidPercentage != null ? this.bidPercentage.hashCode() : 0);
                result = 31 * result + (this.desiredvCpus != null ? this.desiredvCpus.hashCode() : 0);
                result = 31 * result + (this.ec2Configuration != null ? this.ec2Configuration.hashCode() : 0);
                result = 31 * result + (this.ec2KeyPair != null ? this.ec2KeyPair.hashCode() : 0);
                result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
                result = 31 * result + (this.instanceRole != null ? this.instanceRole.hashCode() : 0);
                result = 31 * result + (this.instanceTypes != null ? this.instanceTypes.hashCode() : 0);
                result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
                result = 31 * result + (this.minvCpus != null ? this.minvCpus.hashCode() : 0);
                result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.spotIamFleetRole != null ? this.spotIamFleetRole.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                result = 31 * result + (this.updateToLatestImageVersion != null ? this.updateToLatestImageVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information used to select Amazon Machine Images (AMIs) for instances in the compute environment.
     * <p>
     * If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code> ( <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon Linux 2</a> ).
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Ec2ConfigurationObjectProperty ec2ConfigurationObjectProperty = Ec2ConfigurationObjectProperty.builder()
     *         .imageType("imageType")
     *         // the properties below are optional
     *         .imageIdOverride("imageIdOverride")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnComputeEnvironment.Ec2ConfigurationObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(Ec2ConfigurationObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ec2ConfigurationObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The image type to match with the instance type to select an AMI.
         * <p>
         * If the <code>imageIdOverride</code> parameter isn't specified, then a recent <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon ECS-optimized Amazon Linux 2 AMI</a> ( <code>ECS_AL2</code> ) is used. If a new image type is specified in an update, but neither an <code>imageId</code> nor a <code>imageIdOverride</code> parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by AWS Batch is used.
         * <p>
         * <ul>
         * <li><strong>ECS_AL2</strong> - <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon Linux 2</a> − Default for all non-GPU instance families.</li>
         * <li><strong>ECS_AL2_NVIDIA</strong> - <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami">Amazon Linux 2 (GPU)</a> −Default for all GPU instance families (for example <code>P4</code> and <code>G4</code> ) and can be used for all non AWS Graviton-based instance types.</li>
         * <li><strong>ECS_AL1</strong> - <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami">Amazon Linux</a> . Amazon Linux is reaching the end-of-life of standard support. For more information, see <a href="https://docs.aws.amazon.com/amazon-linux-ami/">Amazon Linux AMI</a> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageType();

        /**
         * The AMI ID used for instances launched in the compute environment that match the image type.
         * <p>
         * This setting overrides the <code>imageId</code> set in the <code>computeResource</code> object.
         * <p>
         * <blockquote>
         * <p>
         * The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html">Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageIdOverride() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ec2ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ec2ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ec2ConfigurationObjectProperty> {
            java.lang.String imageType;
            java.lang.String imageIdOverride;

            /**
             * Sets the value of {@link Ec2ConfigurationObjectProperty#getImageType}
             * @param imageType The image type to match with the instance type to select an AMI. This parameter is required.
             *                  If the <code>imageIdOverride</code> parameter isn't specified, then a recent <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon ECS-optimized Amazon Linux 2 AMI</a> ( <code>ECS_AL2</code> ) is used. If a new image type is specified in an update, but neither an <code>imageId</code> nor a <code>imageIdOverride</code> parameter is specified, then the latest Amazon ECS optimized AMI for that image type that's supported by AWS Batch is used.
             *                  <p>
             *                  <ul>
             *                  <li><strong>ECS_AL2</strong> - <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon Linux 2</a> − Default for all non-GPU instance families.</li>
             *                  <li><strong>ECS_AL2_NVIDIA</strong> - <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami">Amazon Linux 2 (GPU)</a> −Default for all GPU instance families (for example <code>P4</code> and <code>G4</code> ) and can be used for all non AWS Graviton-based instance types.</li>
             *                  <li><strong>ECS_AL1</strong> - <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami">Amazon Linux</a> . Amazon Linux is reaching the end-of-life of standard support. For more information, see <a href="https://docs.aws.amazon.com/amazon-linux-ami/">Amazon Linux AMI</a> .</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageType(java.lang.String imageType) {
                this.imageType = imageType;
                return this;
            }

            /**
             * Sets the value of {@link Ec2ConfigurationObjectProperty#getImageIdOverride}
             * @param imageIdOverride The AMI ID used for instances launched in the compute environment that match the image type.
             *                        This setting overrides the <code>imageId</code> set in the <code>computeResource</code> object.
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html">Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageIdOverride(java.lang.String imageIdOverride) {
                this.imageIdOverride = imageIdOverride;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ec2ConfigurationObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ec2ConfigurationObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ec2ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2ConfigurationObjectProperty {
            private final java.lang.String imageType;
            private final java.lang.String imageIdOverride;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageType = software.amazon.jsii.Kernel.get(this, "imageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageIdOverride = software.amazon.jsii.Kernel.get(this, "imageIdOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageType = java.util.Objects.requireNonNull(builder.imageType, "imageType is required");
                this.imageIdOverride = builder.imageIdOverride;
            }

            @Override
            public final java.lang.String getImageType() {
                return this.imageType;
            }

            @Override
            public final java.lang.String getImageIdOverride() {
                return this.imageIdOverride;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageType", om.valueToTree(this.getImageType()));
                if (this.getImageIdOverride() != null) {
                    data.set("imageIdOverride", om.valueToTree(this.getImageIdOverride()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnComputeEnvironment.Ec2ConfigurationObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ec2ConfigurationObjectProperty.Jsii$Proxy that = (Ec2ConfigurationObjectProperty.Jsii$Proxy) o;

                if (!imageType.equals(that.imageType)) return false;
                return this.imageIdOverride != null ? this.imageIdOverride.equals(that.imageIdOverride) : that.imageIdOverride == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageType.hashCode();
                result = 31 * result + (this.imageIdOverride != null ? this.imageIdOverride.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing a launch template associated with a compute resource.
     * <p>
     * You must specify either the launch template ID or launch template name in the request, but not both.
     * <p>
     * If security groups are specified using both the <code>securityGroupIds</code> parameter of <code>CreateComputeEnvironment</code> and the launch template, the values in the <code>securityGroupIds</code> parameter of <code>CreateComputeEnvironment</code> will be used.
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * LaunchTemplateSpecificationProperty launchTemplateSpecificationProperty = LaunchTemplateSpecificationProperty.builder()
     *         .launchTemplateId("launchTemplateId")
     *         .launchTemplateName("launchTemplateName")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnComputeEnvironment.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the launch template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * The name of the launch template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * The version number of the launch template, `$Latest` , or `$Default` .
         * <p>
         * If the value is <code>$Latest</code> , the latest version of the launch template is used. If the value is <code>$Default</code> , the default version of the launch template is used.
         * <p>
         * <blockquote>
         * <p>
         * If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the <code>updateToLatestImageVersion</code> parameter for the compute environment is set to <code>true</code> . During an infrastructure update, if either <code>$Latest</code> or <code>$Default</code> is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>$Default</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateSpecificationProperty> {
            java.lang.String launchTemplateId;
            java.lang.String launchTemplateName;
            java.lang.String version;

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getLaunchTemplateId}
             * @param launchTemplateId The ID of the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getLaunchTemplateName}
             * @param launchTemplateName The name of the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getVersion}
             * @param version The version number of the launch template, `$Latest` , or `$Default` .
             *                If the value is <code>$Latest</code> , the latest version of the launch template is used. If the value is <code>$Default</code> , the default version of the launch template is used.
             *                <p>
             *                <blockquote>
             *                <p>
             *                If the AMI ID that's used in a compute environment is from the launch template, the AMI isn't changed when the compute environment is updated. It's only changed if the <code>updateToLatestImageVersion</code> parameter for the compute environment is set to <code>true</code> . During an infrastructure update, if either <code>$Latest</code> or <code>$Default</code> is specified, AWS Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn't specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
             *                <p>
             *                </blockquote>
             *                <p>
             *                Default: <code>$Default</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateSpecificationProperty {
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateId = builder.launchTemplateId;
                this.launchTemplateName = builder.launchTemplateName;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnComputeEnvironment.LaunchTemplateSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateSpecificationProperty.Jsii$Proxy that = (LaunchTemplateSpecificationProperty.Jsii$Proxy) o;

                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0;
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the infrastructure update policy for the compute environment.
     * <p>
     * For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/infrastructure-updates.html">Infrastructure updates</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * UpdatePolicyProperty updatePolicyProperty = UpdatePolicyProperty.builder()
     *         .jobExecutionTimeoutMinutes(123)
     *         .terminateJobsOnUpdate(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnComputeEnvironment.UpdatePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(UpdatePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpdatePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the job timeout, in minutes, when the compute environment infrastructure is updated.
         * <p>
         * The default value is 30.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getJobExecutionTimeoutMinutes() {
            return null;
        }

        /**
         * Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
         * <p>
         * The default value is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTerminateJobsOnUpdate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpdatePolicyProperty> {
            java.lang.Number jobExecutionTimeoutMinutes;
            java.lang.Object terminateJobsOnUpdate;

            /**
             * Sets the value of {@link UpdatePolicyProperty#getJobExecutionTimeoutMinutes}
             * @param jobExecutionTimeoutMinutes Specifies the job timeout, in minutes, when the compute environment infrastructure is updated.
             *                                   The default value is 30.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobExecutionTimeoutMinutes(java.lang.Number jobExecutionTimeoutMinutes) {
                this.jobExecutionTimeoutMinutes = jobExecutionTimeoutMinutes;
                return this;
            }

            /**
             * Sets the value of {@link UpdatePolicyProperty#getTerminateJobsOnUpdate}
             * @param terminateJobsOnUpdate Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
             *                              The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateJobsOnUpdate(java.lang.Boolean terminateJobsOnUpdate) {
                this.terminateJobsOnUpdate = terminateJobsOnUpdate;
                return this;
            }

            /**
             * Sets the value of {@link UpdatePolicyProperty#getTerminateJobsOnUpdate}
             * @param terminateJobsOnUpdate Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
             *                              The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateJobsOnUpdate(software.amazon.awscdk.IResolvable terminateJobsOnUpdate) {
                this.terminateJobsOnUpdate = terminateJobsOnUpdate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpdatePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpdatePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpdatePolicyProperty {
            private final java.lang.Number jobExecutionTimeoutMinutes;
            private final java.lang.Object terminateJobsOnUpdate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jobExecutionTimeoutMinutes = software.amazon.jsii.Kernel.get(this, "jobExecutionTimeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.terminateJobsOnUpdate = software.amazon.jsii.Kernel.get(this, "terminateJobsOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jobExecutionTimeoutMinutes = builder.jobExecutionTimeoutMinutes;
                this.terminateJobsOnUpdate = builder.terminateJobsOnUpdate;
            }

            @Override
            public final java.lang.Number getJobExecutionTimeoutMinutes() {
                return this.jobExecutionTimeoutMinutes;
            }

            @Override
            public final java.lang.Object getTerminateJobsOnUpdate() {
                return this.terminateJobsOnUpdate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJobExecutionTimeoutMinutes() != null) {
                    data.set("jobExecutionTimeoutMinutes", om.valueToTree(this.getJobExecutionTimeoutMinutes()));
                }
                if (this.getTerminateJobsOnUpdate() != null) {
                    data.set("terminateJobsOnUpdate", om.valueToTree(this.getTerminateJobsOnUpdate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnComputeEnvironment.UpdatePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpdatePolicyProperty.Jsii$Proxy that = (UpdatePolicyProperty.Jsii$Proxy) o;

                if (this.jobExecutionTimeoutMinutes != null ? !this.jobExecutionTimeoutMinutes.equals(that.jobExecutionTimeoutMinutes) : that.jobExecutionTimeoutMinutes != null) return false;
                return this.terminateJobsOnUpdate != null ? this.terminateJobsOnUpdate.equals(that.terminateJobsOnUpdate) : that.terminateJobsOnUpdate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jobExecutionTimeoutMinutes != null ? this.jobExecutionTimeoutMinutes.hashCode() : 0;
                result = 31 * result + (this.terminateJobsOnUpdate != null ? this.terminateJobsOnUpdate.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.CfnComputeEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.CfnComputeEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps.Builder();
        }

        /**
         * The type of the compute environment: `MANAGED` or `UNMANAGED` .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @return {@code this}
         * @param type The type of the compute environment: `MANAGED` or `UNMANAGED` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The name for your compute environment.
         * <p>
         * It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         * <p>
         * @return {@code this}
         * @param computeEnvironmentName The name for your compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(final java.lang.String computeEnvironmentName) {
            this.props.computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        /**
         * The ComputeResources property type specifies details of the compute resources managed by the compute environment.
         * <p>
         * This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
         * <p>
         * @return {@code this}
         * @param computeResources The ComputeResources property type specifies details of the compute resources managed by the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(final software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty computeResources) {
            this.props.computeResources(computeResources);
            return this;
        }
        /**
         * The ComputeResources property type specifies details of the compute resources managed by the compute environment.
         * <p>
         * This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
         * <p>
         * @return {@code this}
         * @param computeResources The ComputeResources property type specifies details of the compute resources managed by the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(final software.amazon.awscdk.IResolvable computeResources) {
            this.props.computeResources(computeResources);
            return this;
        }

        /**
         * Specifies whether the compute environment should be replaced if an update is made that requires replacing the instances in the compute environment.
         * <p>
         * The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , no other properties should be changed at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
         * <p>
         * @return {@code this}
         * @param replaceComputeEnvironment Specifies whether the compute environment should be replaced if an update is made that requires replacing the instances in the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(final java.lang.Boolean replaceComputeEnvironment) {
            this.props.replaceComputeEnvironment(replaceComputeEnvironment);
            return this;
        }
        /**
         * Specifies whether the compute environment should be replaced if an update is made that requires replacing the instances in the compute environment.
         * <p>
         * The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , no other properties should be changed at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
         * <p>
         * @return {@code this}
         * @param replaceComputeEnvironment Specifies whether the compute environment should be replaced if an update is made that requires replacing the instances in the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(final software.amazon.awscdk.IResolvable replaceComputeEnvironment) {
            this.props.replaceComputeEnvironment(replaceComputeEnvironment);
            return this;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">AWS Batch service IAM role</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If your account already created the AWS Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the AWS Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the AWS Batch service-linked role in your account.
         * <p>
         * </blockquote>
         * <p>
         * If your specified role has a path other than <code>/</code> , then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * Depending on how you created your AWS Batch service role, its ARN might contain the <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN doesn't use the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param serviceRole The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final java.lang.String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The state of the compute environment.
         * <p>
         * If the state is <code>ENABLED</code> , then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
         * <p>
         * If the state is <code>ENABLED</code> , then the AWS Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
         * <p>
         * If the state is <code>DISABLED</code> , then the AWS Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don't scale out. However, they scale in to <code>minvCpus</code> value after instances become idle.
         * <p>
         * @return {@code this}
         * @param state The state of the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props.state(state);
            return this;
        }

        /**
         * The tags applied to the compute environment.
         * <p>
         * @return {@code this}
         * @param tags The tags applied to the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The maximum number of vCPUs for an unmanaged compute environment.
         * <p>
         * This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only supported when the <code>type</code> parameter is set to <code>UNMANAGED</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param unmanagedvCpus The maximum number of vCPUs for an unmanaged compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unmanagedvCpus(final java.lang.Number unmanagedvCpus) {
            this.props.unmanagedvCpus(unmanagedvCpus);
            return this;
        }

        /**
         * Specifies the infrastructure update policy for the compute environment.
         * <p>
         * For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @return {@code this}
         * @param updatePolicy Specifies the infrastructure update policy for the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatePolicy(final software.amazon.awscdk.services.batch.CfnComputeEnvironment.UpdatePolicyProperty updatePolicy) {
            this.props.updatePolicy(updatePolicy);
            return this;
        }
        /**
         * Specifies the infrastructure update policy for the compute environment.
         * <p>
         * For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @return {@code this}
         * @param updatePolicy Specifies the infrastructure update policy for the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatePolicy(final software.amazon.awscdk.IResolvable updatePolicy) {
            this.props.updatePolicy(updatePolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.CfnComputeEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.CfnComputeEnvironment build() {
            return new software.amazon.awscdk.services.batch.CfnComputeEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
