package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for creating a Response Headers Policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Using an existing managed response headers policy
 * S3Origin bucketOrigin;
 * Distribution.Builder.create(this, "myDistManagedPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS)
 *                 .build())
 *         .build();
 * // Creating a custom response headers policy -- all parameters optional
 * ResponseHeadersPolicy myResponseHeadersPolicy = ResponseHeadersPolicy.Builder.create(this, "ResponseHeadersPolicy")
 *         .responseHeadersPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .corsBehavior(ResponseHeadersCorsBehavior.builder()
 *                 .accessControlAllowCredentials(false)
 *                 .accessControlAllowHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlAllowMethods(List.of("GET", "POST"))
 *                 .accessControlAllowOrigins(List.of("*"))
 *                 .accessControlExposeHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlMaxAge(Duration.seconds(600))
 *                 .originOverride(true)
 *                 .build())
 *         .customHeadersBehavior(ResponseCustomHeadersBehavior.builder()
 *                 .customHeaders(List.of(ResponseCustomHeader.builder().header("X-Amz-Date").value("some-value").override(true).build(), ResponseCustomHeader.builder().header("X-Amz-Security-Token").value("some-value").override(false).build()))
 *                 .build())
 *         .securityHeadersBehavior(ResponseSecurityHeadersBehavior.builder()
 *                 .contentSecurityPolicy(ResponseHeadersContentSecurityPolicy.builder().contentSecurityPolicy("default-src https:;").override(true).build())
 *                 .contentTypeOptions(ResponseHeadersContentTypeOptions.builder().override(true).build())
 *                 .frameOptions(ResponseHeadersFrameOptions.builder().frameOption(HeadersFrameOption.DENY).override(true).build())
 *                 .referrerPolicy(ResponseHeadersReferrerPolicy.builder().referrerPolicy(HeadersReferrerPolicy.NO_REFERRER).override(true).build())
 *                 .strictTransportSecurity(ResponseHeadersStrictTransportSecurity.builder().accessControlMaxAge(Duration.seconds(600)).includeSubdomains(true).override(true).build())
 *                 .xssProtection(ResponseHeadersXSSProtection.builder().protection(true).modeBlock(true).reportUri("https://example.com/csp-report").override(true).build())
 *                 .build())
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(myResponseHeadersPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.066Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ResponseHeadersPolicyProps")
@software.amazon.jsii.Jsii.Proxy(ResponseHeadersPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResponseHeadersPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A comment to describe the response headers policy.
     * <p>
     * Default: - no comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
     * <p>
     * Default: - no cors behavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior getCorsBehavior() {
        return null;
    }

    /**
     * A configuration for a set of custom HTTP response headers.
     * <p>
     * Default: - no custom headers behavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseCustomHeadersBehavior getCustomHeadersBehavior() {
        return null;
    }

    /**
     * A unique name to identify the response headers policy.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResponseHeadersPolicyName() {
        return null;
    }

    /**
     * A configuration for a set of security-related HTTP response headers.
     * <p>
     * Default: - no security headers behavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseSecurityHeadersBehavior getSecurityHeadersBehavior() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResponseHeadersPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResponseHeadersPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResponseHeadersPolicyProps> {
        java.lang.String comment;
        software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior corsBehavior;
        software.amazon.awscdk.services.cloudfront.ResponseCustomHeadersBehavior customHeadersBehavior;
        java.lang.String responseHeadersPolicyName;
        software.amazon.awscdk.services.cloudfront.ResponseSecurityHeadersBehavior securityHeadersBehavior;

        /**
         * Sets the value of {@link ResponseHeadersPolicyProps#getComment}
         * @param comment A comment to describe the response headers policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersPolicyProps#getCorsBehavior}
         * @param corsBehavior A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsBehavior(software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior corsBehavior) {
            this.corsBehavior = corsBehavior;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersPolicyProps#getCustomHeadersBehavior}
         * @param customHeadersBehavior A configuration for a set of custom HTTP response headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeadersBehavior(software.amazon.awscdk.services.cloudfront.ResponseCustomHeadersBehavior customHeadersBehavior) {
            this.customHeadersBehavior = customHeadersBehavior;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersPolicyProps#getResponseHeadersPolicyName}
         * @param responseHeadersPolicyName A unique name to identify the response headers policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicyName(java.lang.String responseHeadersPolicyName) {
            this.responseHeadersPolicyName = responseHeadersPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersPolicyProps#getSecurityHeadersBehavior}
         * @param securityHeadersBehavior A configuration for a set of security-related HTTP response headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityHeadersBehavior(software.amazon.awscdk.services.cloudfront.ResponseSecurityHeadersBehavior securityHeadersBehavior) {
            this.securityHeadersBehavior = securityHeadersBehavior;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResponseHeadersPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResponseHeadersPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResponseHeadersPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseHeadersPolicyProps {
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior corsBehavior;
        private final software.amazon.awscdk.services.cloudfront.ResponseCustomHeadersBehavior customHeadersBehavior;
        private final java.lang.String responseHeadersPolicyName;
        private final software.amazon.awscdk.services.cloudfront.ResponseSecurityHeadersBehavior securityHeadersBehavior;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.corsBehavior = software.amazon.jsii.Kernel.get(this, "corsBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior.class));
            this.customHeadersBehavior = software.amazon.jsii.Kernel.get(this, "customHeadersBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseCustomHeadersBehavior.class));
            this.responseHeadersPolicyName = software.amazon.jsii.Kernel.get(this, "responseHeadersPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityHeadersBehavior = software.amazon.jsii.Kernel.get(this, "securityHeadersBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseSecurityHeadersBehavior.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.corsBehavior = builder.corsBehavior;
            this.customHeadersBehavior = builder.customHeadersBehavior;
            this.responseHeadersPolicyName = builder.responseHeadersPolicyName;
            this.securityHeadersBehavior = builder.securityHeadersBehavior;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior getCorsBehavior() {
            return this.corsBehavior;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseCustomHeadersBehavior getCustomHeadersBehavior() {
            return this.customHeadersBehavior;
        }

        @Override
        public final java.lang.String getResponseHeadersPolicyName() {
            return this.responseHeadersPolicyName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseSecurityHeadersBehavior getSecurityHeadersBehavior() {
            return this.securityHeadersBehavior;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getCorsBehavior() != null) {
                data.set("corsBehavior", om.valueToTree(this.getCorsBehavior()));
            }
            if (this.getCustomHeadersBehavior() != null) {
                data.set("customHeadersBehavior", om.valueToTree(this.getCustomHeadersBehavior()));
            }
            if (this.getResponseHeadersPolicyName() != null) {
                data.set("responseHeadersPolicyName", om.valueToTree(this.getResponseHeadersPolicyName()));
            }
            if (this.getSecurityHeadersBehavior() != null) {
                data.set("securityHeadersBehavior", om.valueToTree(this.getSecurityHeadersBehavior()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.ResponseHeadersPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResponseHeadersPolicyProps.Jsii$Proxy that = (ResponseHeadersPolicyProps.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.corsBehavior != null ? !this.corsBehavior.equals(that.corsBehavior) : that.corsBehavior != null) return false;
            if (this.customHeadersBehavior != null ? !this.customHeadersBehavior.equals(that.customHeadersBehavior) : that.customHeadersBehavior != null) return false;
            if (this.responseHeadersPolicyName != null ? !this.responseHeadersPolicyName.equals(that.responseHeadersPolicyName) : that.responseHeadersPolicyName != null) return false;
            return this.securityHeadersBehavior != null ? this.securityHeadersBehavior.equals(that.securityHeadersBehavior) : that.securityHeadersBehavior == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.corsBehavior != null ? this.corsBehavior.hashCode() : 0);
            result = 31 * result + (this.customHeadersBehavior != null ? this.customHeadersBehavior.hashCode() : 0);
            result = 31 * result + (this.responseHeadersPolicyName != null ? this.responseHeadersPolicyName.hashCode() : 0);
            result = 31 * result + (this.securityHeadersBehavior != null ? this.securityHeadersBehavior.hashCode() : 0);
            return result;
        }
    }
}
