package software.amazon.awscdk.services.cloudfront.origins;

/**
 * An Origin for a v2 load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * Vpc vpc;
 * // Create an application load balancer in a VPC. 'internetFacing' must be 'true'
 * // for CloudFront to access the load balancer and use it as an origin.
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(new LoadBalancerV2Origin(lb)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.079Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.LoadBalancerV2Origin")
public class LoadBalancerV2Origin extends software.amazon.awscdk.services.cloudfront.origins.HttpOrigin {

    protected LoadBalancerV2Origin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancerV2Origin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param loadBalancer This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LoadBalancerV2Origin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2 loadBalancer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2OriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required"), props });
    }

    /**
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LoadBalancerV2Origin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2 loadBalancer) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2Origin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2Origin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param loadBalancer This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2 loadBalancer) {
            return new Builder(loadBalancer);
        }

        private final software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2 loadBalancer;
        private software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2OriginProps.Builder props;

        private Builder(final software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2 loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        /**
         * The number of times that CloudFront attempts to connect to the origin;
         * <p>
         * valid values are 1, 2, or 3 attempts.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionAttempts(final java.lang.Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * <p>
         * Valid values are 1-10 seconds, inclusive.
         * <p>
         * Default: Duration.seconds(10)
         * <p>
         * @return {@code this}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionTimeout(final software.amazon.awscdk.Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        /**
         * A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(final java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        /**
         * A unique identifier for the origin.
         * <p>
         * This value must be unique within the distribution.
         * <p>
         * Default: - an originid will be generated for you
         * <p>
         * @return {@code this}
         * @param originId A unique identifier for the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originId(final java.lang.String originId) {
            this.props().originId(originId);
            return this;
        }

        /**
         * When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance.
         * <p>
         * Default: - origin shield not enabled
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html</a>
         * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldRegion(final java.lang.String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        /**
         * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         * <p>
         * Must begin, but not end, with '/' (e.g., '/production/images').
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originPath(final java.lang.String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        /**
         * The HTTP port that CloudFront uses to connect to the origin.
         * <p>
         * Default: 80
         * <p>
         * @return {@code this}
         * @param httpPort The HTTP port that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPort(final java.lang.Number httpPort) {
            this.props().httpPort(httpPort);
            return this;
        }

        /**
         * The HTTPS port that CloudFront uses to connect to the origin.
         * <p>
         * Default: 443
         * <p>
         * @return {@code this}
         * @param httpsPort The HTTPS port that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsPort(final java.lang.Number httpsPort) {
            this.props().httpsPort(httpsPort);
            return this;
        }

        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(5)
         * <p>
         * @return {@code this}
         * @param keepaliveTimeout Specifies how long, in seconds, CloudFront persists its connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepaliveTimeout(final software.amazon.awscdk.Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        /**
         * The SSL versions to use when interacting with the origin.
         * <p>
         * Default: OriginSslPolicy.TLS_V1_2
         * <p>
         * @return {@code this}
         * @param originSslProtocols The SSL versions to use when interacting with the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originSslProtocols(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols) {
            this.props().originSslProtocols(originSslProtocols);
            return this;
        }

        /**
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         * <p>
         * Default: OriginProtocolPolicy.HTTPS_ONLY
         * <p>
         * @return {@code this}
         * @param protocolPolicy Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolPolicy(final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy) {
            this.props().protocolPolicy(protocolPolicy);
            return this;
        }

        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param readTimeout Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readTimeout(final software.amazon.awscdk.Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2Origin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2Origin build() {
            return new software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2Origin(
                this.loadBalancer,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2OriginProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2OriginProps.Builder();
            }
            return this.props;
        }
    }
}
