package software.amazon.awscdk.services.cloudwatch;

/**
 * A CloudFormation `AWS::CloudWatch::MetricStream`.
 * <p>
 * Creates or updates a metric stream. Metrics streams can automatically stream CloudWatch metrics to AWS destinations including Amazon S3 and to many third-party solutions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Metric-Streams.html">Metric streams</a> .
 * <p>
 * To create a metric stream, you must be logged on to an account that has the <code>iam:PassRole</code> permission and either the <em>CloudWatchFullAccess</em> policy or the <code>cloudwatch:PutMetricStream</code> permission.
 * <p>
 * When you create or update a metric stream, you choose one of the following:
 * <p>
 * <ul>
 * <li>Stream metrics from all metric namespaces in the account.</li>
 * <li>Stream metrics from all metric namespaces in the account, except for the namespaces that you list in <code>ExcludeFilters</code> .</li>
 * <li>Stream metrics from only the metric namespaces that you list in <code>IncludeFilters</code> .</li>
 * </ul>
 * <p>
 * When you create a metric stream, the stream is created in the <code>running</code> state. If you update an existing metric stream, the state does not change.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CfnMetricStream cfnMetricStream = CfnMetricStream.Builder.create(this, "MyCfnMetricStream")
 *         .firehoseArn("firehoseArn")
 *         .outputFormat("outputFormat")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .excludeFilters(List.of(MetricStreamFilterProperty.builder()
 *                 .namespace("namespace")
 *                 .build()))
 *         .includeFilters(List.of(MetricStreamFilterProperty.builder()
 *                 .namespace("namespace")
 *                 .build()))
 *         .name("name")
 *         .statisticsConfigurations(List.of(MetricStreamStatisticsConfigurationProperty.builder()
 *                 .additionalStatistics(List.of("additionalStatistics"))
 *                 .includeMetrics(List.of(MetricStreamStatisticsMetricProperty.builder()
 *                         .metricName("metricName")
 *                         .namespace("namespace")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.155Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnMetricStream")
public class CfnMetricStream extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMetricStream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMetricStream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.CfnMetricStream.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudWatch::MetricStream`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMetricStream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CfnMetricStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the metric stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date that the metric stream was originally created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date that the metric stream was most recently updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdateDate() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdateDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the metric stream, either `running` or `stopped` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to the metric stream.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
     * <p>
     * This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFirehoseArn() {
        return software.amazon.jsii.Kernel.get(this, "firehoseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
     * <p>
     * This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirehoseArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "firehoseArn", java.util.Objects.requireNonNull(value, "firehoseArn is required"));
    }

    /**
     * The output format for the stream.
     * <p>
     * Valid values are <code>json</code> and <code>opentelemetry0.7</code> For more information about metric stream output formats, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">Metric streams output formats</a> .
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOutputFormat() {
        return software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The output format for the stream.
     * <p>
     * Valid values are <code>json</code> and <code>opentelemetry0.7</code> For more information about metric stream output formats, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">Metric streams output formats</a> .
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputFormat(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "outputFormat", java.util.Objects.requireNonNull(value, "outputFormat is required"));
    }

    /**
     * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources.
     * <p>
     * This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the <code>firehose:PutRecord</code> and <code>firehose:PutRecordBatch</code> permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources.
     * <p>
     * This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the <code>firehose:PutRecord</code> and <code>firehose:PutRecordBatch</code> permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExcludeFilters() {
        return software.amazon.jsii.Kernel.get(this, "excludeFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "excludeFilters", value);
    }

    /**
     * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeFilters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudwatch.CfnMetricStream.MetricStreamFilterProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudwatch.CfnMetricStream.MetricStreamFilterProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "excludeFilters", value);
    }

    /**
     * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIncludeFilters() {
        return software.amazon.jsii.Kernel.get(this, "includeFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "includeFilters", value);
    }

    /**
     * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeFilters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudwatch.CfnMetricStream.MetricStreamFilterProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudwatch.CfnMetricStream.MetricStreamFilterProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "includeFilters", value);
    }

    /**
     * If you are creating a new metric stream, this is the name for the new stream.
     * <p>
     * The name must be different than the names of other metric streams in this account and Region.
     * <p>
     * If you are updating a metric stream, specify the name of that stream here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you are creating a new metric stream, this is the name for the new stream.
     * <p>
     * The name must be different than the names of other metric streams in this account and Region.
     * <p>
     * If you are updating a metric stream, specify the name of that stream here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
     * <p>
     * You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
     * <p>
     * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is <code>opentelemetry0</code> .7, you can stream percentile statistics <em>(p??)</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStatisticsConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "statisticsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
     * <p>
     * You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
     * <p>
     * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is <code>opentelemetry0</code> .7, you can stream percentile statistics <em>(p??)</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatisticsConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "statisticsConfigurations", value);
    }

    /**
     * By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
     * <p>
     * You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
     * <p>
     * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is <code>opentelemetry0</code> .7, you can stream percentile statistics <em>(p??)</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatisticsConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudwatch.CfnMetricStream.MetricStreamStatisticsConfigurationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudwatch.CfnMetricStream.MetricStreamStatisticsConfigurationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "statisticsConfigurations", value);
    }
    /**
     * This structure contains the name of one of the metric namespaces that is listed in a filter of a metric stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * MetricStreamFilterProperty metricStreamFilterProperty = MetricStreamFilterProperty.builder()
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnMetricStream.MetricStreamFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricStreamFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricStreamFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric namespace in the filter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * @return a {@link Builder} of {@link MetricStreamFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricStreamFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricStreamFilterProperty> {
            java.lang.String namespace;

            /**
             * Sets the value of {@link MetricStreamFilterProperty#getNamespace}
             * @param namespace The name of the metric namespace in the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricStreamFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricStreamFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricStreamFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStreamFilterProperty {
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("namespace", om.valueToTree(this.getNamespace()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnMetricStream.MetricStreamFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricStreamFilterProperty.Jsii$Proxy that = (MetricStreamFilterProperty.Jsii$Proxy) o;

                return this.namespace.equals(that.namespace);
            }

            @Override
            public final int hashCode() {
                int result = this.namespace.hashCode();
                return result;
            }
        }
    }
    /**
     * This structure specifies a list of additional statistics to stream, and the metrics to stream those additional statistics for.
     * <p>
     * All metrics that match the combination of metric name and namespace will be streamed with the additional statistics, no matter their dimensions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * MetricStreamStatisticsConfigurationProperty metricStreamStatisticsConfigurationProperty = MetricStreamStatisticsConfigurationProperty.builder()
     *         .additionalStatistics(List.of("additionalStatistics"))
     *         .includeMetrics(List.of(MetricStreamStatisticsMetricProperty.builder()
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnMetricStream.MetricStreamStatisticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricStreamStatisticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricStreamStatisticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The additional statistics to stream for the metrics listed in `IncludeMetrics` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAdditionalStatistics();

        /**
         * An array that defines the metrics that are to have additional statistics streamed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIncludeMetrics();

        /**
         * @return a {@link Builder} of {@link MetricStreamStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricStreamStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricStreamStatisticsConfigurationProperty> {
            java.util.List<java.lang.String> additionalStatistics;
            java.lang.Object includeMetrics;

            /**
             * Sets the value of {@link MetricStreamStatisticsConfigurationProperty#getAdditionalStatistics}
             * @param additionalStatistics The additional statistics to stream for the metrics listed in `IncludeMetrics` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalStatistics(java.util.List<java.lang.String> additionalStatistics) {
                this.additionalStatistics = additionalStatistics;
                return this;
            }

            /**
             * Sets the value of {@link MetricStreamStatisticsConfigurationProperty#getIncludeMetrics}
             * @param includeMetrics An array that defines the metrics that are to have additional statistics streamed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMetrics(software.amazon.awscdk.IResolvable includeMetrics) {
                this.includeMetrics = includeMetrics;
                return this;
            }

            /**
             * Sets the value of {@link MetricStreamStatisticsConfigurationProperty#getIncludeMetrics}
             * @param includeMetrics An array that defines the metrics that are to have additional statistics streamed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMetrics(java.util.List<? extends java.lang.Object> includeMetrics) {
                this.includeMetrics = includeMetrics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricStreamStatisticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricStreamStatisticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricStreamStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStreamStatisticsConfigurationProperty {
            private final java.util.List<java.lang.String> additionalStatistics;
            private final java.lang.Object includeMetrics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalStatistics = software.amazon.jsii.Kernel.get(this, "additionalStatistics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includeMetrics = software.amazon.jsii.Kernel.get(this, "includeMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalStatistics = java.util.Objects.requireNonNull(builder.additionalStatistics, "additionalStatistics is required");
                this.includeMetrics = java.util.Objects.requireNonNull(builder.includeMetrics, "includeMetrics is required");
            }

            @Override
            public final java.util.List<java.lang.String> getAdditionalStatistics() {
                return this.additionalStatistics;
            }

            @Override
            public final java.lang.Object getIncludeMetrics() {
                return this.includeMetrics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("additionalStatistics", om.valueToTree(this.getAdditionalStatistics()));
                data.set("includeMetrics", om.valueToTree(this.getIncludeMetrics()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnMetricStream.MetricStreamStatisticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricStreamStatisticsConfigurationProperty.Jsii$Proxy that = (MetricStreamStatisticsConfigurationProperty.Jsii$Proxy) o;

                if (!additionalStatistics.equals(that.additionalStatistics)) return false;
                return this.includeMetrics.equals(that.includeMetrics);
            }

            @Override
            public final int hashCode() {
                int result = this.additionalStatistics.hashCode();
                result = 31 * result + (this.includeMetrics.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure that specifies the metric name and namespace for one metric that is going to have additional statistics included in the stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudwatch.*;
     * MetricStreamStatisticsMetricProperty metricStreamStatisticsMetricProperty = MetricStreamStatisticsMetricProperty.builder()
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnMetricStream.MetricStreamStatisticsMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricStreamStatisticsMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricStreamStatisticsMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The namespace of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * @return a {@link Builder} of {@link MetricStreamStatisticsMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricStreamStatisticsMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricStreamStatisticsMetricProperty> {
            java.lang.String metricName;
            java.lang.String namespace;

            /**
             * Sets the value of {@link MetricStreamStatisticsMetricProperty#getMetricName}
             * @param metricName The name of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricStreamStatisticsMetricProperty#getNamespace}
             * @param namespace The namespace of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricStreamStatisticsMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricStreamStatisticsMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricStreamStatisticsMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStreamStatisticsMetricProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnMetricStream.MetricStreamStatisticsMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricStreamStatisticsMetricProperty.Jsii$Proxy that = (MetricStreamStatisticsMetricProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                return this.namespace.equals(that.namespace);
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.CfnMetricStream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.CfnMetricStream> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudwatch.CfnMetricStreamProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudwatch.CfnMetricStreamProps.Builder();
        }

        /**
         * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
         * <p>
         * This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
         * <p>
         * @return {@code this}
         * @param firehoseArn The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firehoseArn(final java.lang.String firehoseArn) {
            this.props.firehoseArn(firehoseArn);
            return this;
        }

        /**
         * The output format for the stream.
         * <p>
         * Valid values are <code>json</code> and <code>opentelemetry0.7</code> For more information about metric stream output formats, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">Metric streams output formats</a> .
         * <p>
         * This parameter is required.
         * <p>
         * @return {@code this}
         * @param outputFormat The output format for the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputFormat(final java.lang.String outputFormat) {
            this.props.outputFormat(outputFormat);
            return this;
        }

        /**
         * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources.
         * <p>
         * This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the <code>firehose:PutRecord</code> and <code>firehose:PutRecordBatch</code> permissions.
         * <p>
         * @return {@code this}
         * @param roleArn The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
         * <p>
         * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         * <p>
         * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * <p>
         * @return {@code this}
         * @param excludeFilters If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeFilters(final software.amazon.awscdk.IResolvable excludeFilters) {
            this.props.excludeFilters(excludeFilters);
            return this;
        }
        /**
         * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
         * <p>
         * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         * <p>
         * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * <p>
         * @return {@code this}
         * @param excludeFilters If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeFilters(final java.util.List<? extends java.lang.Object> excludeFilters) {
            this.props.excludeFilters(excludeFilters);
            return this;
        }

        /**
         * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
         * <p>
         * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         * <p>
         * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * <p>
         * @return {@code this}
         * @param includeFilters If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeFilters(final software.amazon.awscdk.IResolvable includeFilters) {
            this.props.includeFilters(includeFilters);
            return this;
        }
        /**
         * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
         * <p>
         * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         * <p>
         * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * <p>
         * @return {@code this}
         * @param includeFilters If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeFilters(final java.util.List<? extends java.lang.Object> includeFilters) {
            this.props.includeFilters(includeFilters);
            return this;
        }

        /**
         * If you are creating a new metric stream, this is the name for the new stream.
         * <p>
         * The name must be different than the names of other metric streams in this account and Region.
         * <p>
         * If you are updating a metric stream, specify the name of that stream here.
         * <p>
         * @return {@code this}
         * @param name If you are creating a new metric stream, this is the name for the new stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
         * <p>
         * You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
         * <p>
         * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is <code>opentelemetry0</code> .7, you can stream percentile statistics <em>(p??)</em> .
         * <p>
         * @return {@code this}
         * @param statisticsConfigurations By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statisticsConfigurations(final software.amazon.awscdk.IResolvable statisticsConfigurations) {
            this.props.statisticsConfigurations(statisticsConfigurations);
            return this;
        }
        /**
         * By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
         * <p>
         * You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
         * <p>
         * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is <code>opentelemetry0</code> .7, you can stream percentile statistics <em>(p??)</em> .
         * <p>
         * @return {@code this}
         * @param statisticsConfigurations By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statisticsConfigurations(final java.util.List<? extends java.lang.Object> statisticsConfigurations) {
            this.props.statisticsConfigurations(statisticsConfigurations);
            return this;
        }

        /**
         * An array of key-value pairs to apply to the metric stream.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to the metric stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.CfnMetricStream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.CfnMetricStream build() {
            return new software.amazon.awscdk.services.cloudwatch.CfnMetricStream(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
