package software.amazon.awscdk.services.codebuild;

/**
 * A representation of a CodeBuild Project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Project project = Project.Builder.create(this, "MyProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         .artifacts(Artifacts.s3(S3ArtifactsProps.builder()
 *                 .bucket(bucket)
 *                 .includeBuildId(false)
 *                 .packageZip(true)
 *                 .path("another/path")
 *                 .identifier("AddArtifact1")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.269Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.Project")
public class Project extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codebuild.IProject {

    protected Project(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Project(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Project(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param projectArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject fromProjectArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String projectArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Project.class, "fromProjectArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IProject.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(projectArn, "projectArn is required") });
    }

    /**
     * Import a Project defined either outside the CDK, or in a different CDK Stack (and exported using the {@link export} method).
     * <p>
     * @return a reference to the existing Project
     * @param scope the parent Construct for this Construct. This parameter is required.
     * @param id the logical name of this Construct. This parameter is required.
     * @param projectName the name of the project to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject fromProjectName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String projectName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Project.class, "fromProjectName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IProject.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(projectName, "projectName is required") });
    }

    /**
     * Convert the environment variables map of string to {@link BuildEnvironmentVariable}, which is the customer-facing type, to a list of {@link CfnProject.EnvironmentVariableProperty}, which is the representation of environment variables in CloudFormation.
     * <p>
     * @return an array of {@link CfnProject.EnvironmentVariableProperty} instances
     * @param environmentVariables the map of string to environment variables. This parameter is required.
     * @param validateNoPlainTextSecrets whether to throw an exception if any of the plain text environment variables contain secrets, defaults to 'false'.
     * @param principal
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentVariableProperty> serializeEnvVariables(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables, final @org.jetbrains.annotations.Nullable java.lang.Boolean validateNoPlainTextSecrets, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IGrantable principal) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Project.class, "serializeEnvVariables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentVariableProperty.class)), new Object[] { java.util.Objects.requireNonNull(environmentVariables, "environmentVariables is required"), validateNoPlainTextSecrets, principal }));
    }

    /**
     * Convert the environment variables map of string to {@link BuildEnvironmentVariable}, which is the customer-facing type, to a list of {@link CfnProject.EnvironmentVariableProperty}, which is the representation of environment variables in CloudFormation.
     * <p>
     * @return an array of {@link CfnProject.EnvironmentVariableProperty} instances
     * @param environmentVariables the map of string to environment variables. This parameter is required.
     * @param validateNoPlainTextSecrets whether to throw an exception if any of the plain text environment variables contain secrets, defaults to 'false'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentVariableProperty> serializeEnvVariables(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables, final @org.jetbrains.annotations.Nullable java.lang.Boolean validateNoPlainTextSecrets) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Project.class, "serializeEnvVariables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentVariableProperty.class)), new Object[] { java.util.Objects.requireNonNull(environmentVariables, "environmentVariables is required"), validateNoPlainTextSecrets }));
    }

    /**
     * Convert the environment variables map of string to {@link BuildEnvironmentVariable}, which is the customer-facing type, to a list of {@link CfnProject.EnvironmentVariableProperty}, which is the representation of environment variables in CloudFormation.
     * <p>
     * @return an array of {@link CfnProject.EnvironmentVariableProperty} instances
     * @param environmentVariables the map of string to environment variables. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentVariableProperty> serializeEnvVariables(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Project.class, "serializeEnvVariables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentVariableProperty.class)), new Object[] { java.util.Objects.requireNonNull(environmentVariables, "environmentVariables is required") }));
    }

    /**
     * Adds a fileSystemLocation to the Project.
     * <p>
     * @param fileSystemLocation the fileSystemLocation to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFileSystemLocation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IFileSystemLocation fileSystemLocation) {
        software.amazon.jsii.Kernel.call(this, "addFileSystemLocation", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(fileSystemLocation, "fileSystemLocation is required") });
    }

    /**
     * Adds a secondary artifact to the Project.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html</a>
     * @param secondaryArtifact the artifact to add as a secondary artifact. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecondaryArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IArtifacts secondaryArtifact) {
        software.amazon.jsii.Kernel.call(this, "addSecondaryArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(secondaryArtifact, "secondaryArtifact is required") });
    }

    /**
     * Adds a secondary source to the Project.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html</a>
     * @param secondarySource the source to add as a secondary source. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecondarySource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ISource secondarySource) {
        software.amazon.jsii.Kernel.call(this, "addSecondarySource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(secondarySource, "secondarySource is required") });
    }

    /**
     * Add a permission only if there's a policy attached.
     * <p>
     * @param statement The permissions statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Returns a source configuration for notification rule.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig bindAsNotificationRuleSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bindAsNotificationRuleSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * A callback invoked when the given project is added to a CodePipeline.
     * <p>
     * @param _scope the construct the binding is taking place in. This parameter is required.
     * @param options additional options for the binding. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bindToCodePipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BindToCodePipelineOptions options) {
        software.amazon.jsii.Kernel.call(this, "bindToCodePipeline", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Enable batch builds.
     * <p>
     * Returns an object contining the batch service role if batch builds
     * could be enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BatchBuildConfig enableBatchBuilds() {
        return software.amazon.jsii.Kernel.call(this, "enableBatchBuilds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BatchBuildConfig.class));
    }

    /**
     * @return a CloudWatch metric associated with this build project.
     * @param metricName The name of the metric. This parameter is required.
     * @param props Customization properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * @return a CloudWatch metric associated with this build project.
     * @param metricName The name of the metric. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Measures the number of builds triggered.
     * <p>
     * Units: Count
     * <p>
     * Valid CloudWatch statistics: Sum
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBuilds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricBuilds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Measures the number of builds triggered.
     * <p>
     * Units: Count
     * <p>
     * Valid CloudWatch statistics: Sum
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBuilds() {
        return software.amazon.jsii.Kernel.call(this, "metricBuilds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Measures the duration of all builds over time.
     * <p>
     * Units: Seconds
     * <p>
     * Valid CloudWatch statistics: Average (recommended), Maximum, Minimum
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Measures the duration of all builds over time.
     * <p>
     * Units: Seconds
     * <p>
     * Valid CloudWatch statistics: Average (recommended), Maximum, Minimum
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration() {
        return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Measures the number of builds that failed because of client error or because of a timeout.
     * <p>
     * Units: Count
     * <p>
     * Valid CloudWatch statistics: Sum
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailedBuilds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricFailedBuilds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Measures the number of builds that failed because of client error or because of a timeout.
     * <p>
     * Units: Count
     * <p>
     * Valid CloudWatch statistics: Sum
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailedBuilds() {
        return software.amazon.jsii.Kernel.call(this, "metricFailedBuilds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Measures the number of successful builds.
     * <p>
     * Units: Count
     * <p>
     * Valid CloudWatch statistics: Sum
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSucceededBuilds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSucceededBuilds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Measures the number of successful builds.
     * <p>
     * Units: Count
     * <p>
     * Valid CloudWatch statistics: Sum
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSucceededBuilds() {
        return software.amazon.jsii.Kernel.call(this, "metricSucceededBuilds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Defines a CodeStar Notification rule triggered when the project events emitted by you specified, it very similar to `onEvent` API.
     * <p>
     * You can also use the methods <code>notifyOnBuildSucceeded</code> and
     * <code>notifyOnBuildFailed</code> to define rules for these specific event emitted.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOn(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ProjectNotifyOnOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Defines a CodeStar notification rule which triggers when a build fails.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBuildFailed(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBuildFailed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar notification rule which triggers when a build fails.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBuildFailed(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBuildFailed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CodeStar notification rule which triggers when a build completes successfully.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBuildSucceeded(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBuildSucceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar notification rule which triggers when a build completes successfully.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBuildSucceeded(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBuildSucceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines an event rule which triggers when a build fails.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onBuildFailed(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onBuildFailed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an event rule which triggers when a build fails.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onBuildFailed(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onBuildFailed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an event rule which triggers when a build starts.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onBuildStarted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onBuildStarted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an event rule which triggers when a build starts.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onBuildStarted(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onBuildStarted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an event rule which triggers when a build completes successfully.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onBuildSucceeded(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onBuildSucceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an event rule which triggers when a build completes successfully.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onBuildSucceeded(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onBuildSucceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule triggered when something happens with this project.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html</a>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule triggered when something happens with this project.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html</a>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule that triggers upon phase change of this build project.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html</a>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPhaseChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onPhaseChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule that triggers upon phase change of this build project.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html</a>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPhaseChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onPhaseChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule triggered when the build project state changes.
     * <p>
     * You can filter specific build status events using an event
     * pattern filter on the <code>build-status</code> detail field:
     * <p>
     * <blockquote><pre>
     * const rule = project.onStateChange('OnBuildStarted', { target });
     * rule.addEventPattern({
     *   detail: {
     *     'build-status': [
     *       "IN_PROGRESS",
     *       "SUCCEEDED",
     *       "FAILED",
     *       "STOPPED"
     *     ]
     *   }
     * });
     * </pre></blockquote>
     * <p>
     * You can also use the methods <code>onBuildFailed</code> and <code>onBuildSucceeded</code> to define rules for
     * these specific state changes.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html</a>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule triggered when the build project state changes.
     * <p>
     * You can filter specific build status events using an event
     * pattern filter on the <code>build-status</code> detail field:
     * <p>
     * <blockquote><pre>
     * const rule = project.onStateChange('OnBuildStarted', { target });
     * rule.addEventPattern({
     *   detail: {
     *     'build-status': [
     *       "IN_PROGRESS",
     *       "SUCCEEDED",
     *       "FAILED",
     *       "STOPPED"
     *     ]
     *   }
     * });
     * </pre></blockquote>
     * <p>
     * You can also use the methods <code>onBuildFailed</code> and <code>onBuildSucceeded</code> to define rules for
     * these specific state changes.
     * <p>
     * To access fields from the event in the event target input,
     * use the static fields on the <code>StateChangeEvent</code> class.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html</a>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Access the Connections object.
     * <p>
     * Will fail if this Project does not have a VPC set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The ARN of the project.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProjectArn() {
        return software.amazon.jsii.Kernel.get(this, "projectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the project.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProjectName() {
        return software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role for this project.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.Project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.Project> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.ProjectProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.ProjectProps.Builder();
        }

        /**
         * Whether to allow the CodeBuild to send all network traffic.
         * <p>
         * If set to false, you must individually add traffic rules to allow the
         * CodeBuild project to connect to network targets.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow the CodeBuild to send all network traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
         * <p>
         * For more information, see Build Badges Sample
         * in the AWS CodeBuild User Guide.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param badge Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badge(final java.lang.Boolean badge) {
            this.props.badge(badge);
            return this;
        }

        /**
         * Filename or contents of buildspec in JSON format.
         * <p>
         * Default: - Empty buildspec.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example">https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example</a>
         * @param buildSpec Filename or contents of buildspec in JSON format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSpec(final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        /**
         * Caching strategy to use.
         * <p>
         * Default: Cache.none
         * <p>
         * @return {@code this}
         * @param cache Caching strategy to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(final software.amazon.awscdk.services.codebuild.Cache cache) {
            this.props.cache(cache);
            return this;
        }

        /**
         * Whether to check for the presence of any secrets in the environment variables of the default type, BuildEnvironmentVariableType.PLAINTEXT. Since using a secret for the value of that kind of variable would result in it being displayed in plain text in the AWS Console, the construct will throw an exception if it detects a secret was passed there. Pass this property as false if you want to skip this validation, and keep using a secret in a plain text environment variable.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param checkSecretsInPlainTextEnvVariables Whether to check for the presence of any secrets in the environment variables of the default type, BuildEnvironmentVariableType.PLAINTEXT. Since using a secret for the value of that kind of variable would result in it being displayed in plain text in the AWS Console, the construct will throw an exception if it detects a secret was passed there. Pass this property as false if you want to skip this validation, and keep using a secret in a plain text environment variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder checkSecretsInPlainTextEnvVariables(final java.lang.Boolean checkSecretsInPlainTextEnvVariables) {
            this.props.checkSecretsInPlainTextEnvVariables(checkSecretsInPlainTextEnvVariables);
            return this;
        }

        /**
         * Maximum number of concurrent builds.
         * <p>
         * Minimum value is 1 and maximum is account build limit.
         * <p>
         * Default: - no explicit limit is set
         * <p>
         * @return {@code this}
         * @param concurrentBuildLimit Maximum number of concurrent builds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder concurrentBuildLimit(final java.lang.Number concurrentBuildLimit) {
            this.props.concurrentBuildLimit(concurrentBuildLimit);
            return this;
        }

        /**
         * A description of the project.
         * <p>
         * Use the description to identify the purpose
         * of the project.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Encryption key to use to read and write artifacts.
         * <p>
         * Default: - The AWS-managed CMK for Amazon Simple Storage Service (Amazon S3) is used.
         * <p>
         * @return {@code this}
         * @param encryptionKey Encryption key to use to read and write artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Build environment to use for the build.
         * <p>
         * Default: BuildEnvironment.LinuxBuildImage.STANDARD_1_0
         * <p>
         * @return {@code this}
         * @param environment Build environment to use for the build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.services.codebuild.BuildEnvironment environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * Additional environment variables to add to the build environment.
         * <p>
         * Default: - No additional environment variables are specified.
         * <p>
         * @return {@code this}
         * @param environmentVariables Additional environment variables to add to the build environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        /**
         * An  ProjectFileSystemLocation objects for a CodeBuild build project.
         * <p>
         * A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
         * and type of a file system created using Amazon Elastic File System.
         * <p>
         * Default: - no file system locations
         * <p>
         * @return {@code this}
         * @param fileSystemLocations An  ProjectFileSystemLocation objects for a CodeBuild build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(final java.util.List<? extends software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        /**
         * Add permissions to this project's role to create and use test report groups with name starting with the name of this project.
         * <p>
         * That is the standard report group that gets created when a simple name
         * (in contrast to an ARN)
         * is used in the 'reports' section of the buildspec of this project.
         * This is usually harmless, but you can turn these off if you don't plan on using test
         * reports in this project.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/test-report-group-naming.html">https://docs.aws.amazon.com/codebuild/latest/userguide/test-report-group-naming.html</a>
         * @param grantReportGroupPermissions Add permissions to this project's role to create and use test report groups with name starting with the name of this project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantReportGroupPermissions(final java.lang.Boolean grantReportGroupPermissions) {
            this.props.grantReportGroupPermissions(grantReportGroupPermissions);
            return this;
        }

        /**
         * Information about logs for the build project.
         * <p>
         * A project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
         * <p>
         * Default: - no log configuration is set
         * <p>
         * @return {@code this}
         * @param logging Information about logs for the build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.codebuild.LoggingOptions logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * The physical, human-readable name of the CodeBuild Project.
         * <p>
         * Default: - Name is automatically generated.
         * <p>
         * @return {@code this}
         * @param projectName The physical, human-readable name of the CodeBuild Project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(final java.lang.String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        /**
         * The number of minutes after which AWS CodeBuild stops the build if it's still in queue.
         * <p>
         * For valid values, see the timeoutInMinutes field in the AWS
         * CodeBuild User Guide.
         * <p>
         * Default: - no queue timeout is set
         * <p>
         * @return {@code this}
         * @param queuedTimeout The number of minutes after which AWS CodeBuild stops the build if it's still in queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queuedTimeout(final software.amazon.awscdk.Duration queuedTimeout) {
            this.props.queuedTimeout(queuedTimeout);
            return this;
        }

        /**
         * Service Role to assume while running the build.
         * <p>
         * Default: - A role will be created.
         * <p>
         * @return {@code this}
         * @param role Service Role to assume while running the build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * What security group to associate with the codebuild project's network interfaces.
         * <p>
         * If no security group is identified, one will be created automatically.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - Security group will be automatically created.
         * <p>
         * @return {@code this}
         * @param securityGroups What security group to associate with the codebuild project's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Where to place the network interfaces within the VPC.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - All private subnets.
         * <p>
         * @return {@code this}
         * @param subnetSelection Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         * <p>
         * For valid values, see the timeoutInMinutes field in the AWS
         * CodeBuild User Guide.
         * <p>
         * Default: Duration.hours(1)
         * <p>
         * @return {@code this}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * VPC network to place codebuild network interfaces.
         * <p>
         * Specify this if the codebuild project needs to access resources in a VPC.
         * <p>
         * Default: - No VPC is specified.
         * <p>
         * @return {@code this}
         * @param vpc VPC network to place codebuild network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Defines where build artifacts will be stored.
         * <p>
         * Could be: PipelineBuildArtifacts, NoArtifacts and S3Artifacts.
         * <p>
         * Default: NoArtifacts
         * <p>
         * @return {@code this}
         * @param artifacts Defines where build artifacts will be stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifacts(final software.amazon.awscdk.services.codebuild.IArtifacts artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }

        /**
         * The secondary artifacts for the Project.
         * <p>
         * Can also be added after the Project has been created by using the {&#64;link Project#addSecondaryArtifact} method.
         * <p>
         * Default: - No secondary artifacts.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html</a>
         * @param secondaryArtifacts The secondary artifacts for the Project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryArtifacts(final java.util.List<? extends software.amazon.awscdk.services.codebuild.IArtifacts> secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }

        /**
         * The secondary sources for the Project.
         * <p>
         * Can be also added after the Project has been created by using the {&#64;link Project#addSecondarySource} method.
         * <p>
         * Default: - No secondary sources.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html</a>
         * @param secondarySources The secondary sources for the Project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySources(final java.util.List<? extends software.amazon.awscdk.services.codebuild.ISource> secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }

        /**
         * The source of the build.
         * <p>
         * <em>Note</em>: if {&#64;link NoSource} is given as the source,
         * then you need to provide an explicit <code>buildSpec</code>.
         * <p>
         * Default: - NoSource
         * <p>
         * @return {@code this}
         * @param source The source of the build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.codebuild.ISource source) {
            this.props.source(source);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codebuild.Project}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.Project build() {
            return new software.amazon.awscdk.services.codebuild.Project(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
