package software.amazon.awscdk.services.codecommit;

/**
 * List of event types for AWS CodeCommit.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-repositories">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-repositories</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.301Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codecommit.RepositoryNotificationEvents")
public enum RepositoryNotificationEvents {
    /**
     * Trigger notication when comment made on commit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMMIT_COMMENT,
    /**
     * Trigger notification when comment made on pull request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_COMMENT,
    /**
     * Trigger notification when approval status changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPROVAL_STATUS_CHANGED,
    /**
     * Trigger notifications when approval rule is overridden.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPROVAL_RULE_OVERRIDDEN,
    /**
     * Trigger notification when pull request created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_CREATED,
    /**
     * Trigger notification when pull request source updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_SOURCE_UPDATED,
    /**
     * Trigger notification when pull request status is changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_STATUS_CHANGED,
    /**
     * Trigger notification when pull requset is merged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_MERGED,
    /**
     * Trigger notification when a branch or tag is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BRANCH_OR_TAG_CREATED,
    /**
     * Trigger notification when a branch or tag is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BRANCH_OR_TAG_DELETED,
    /**
     * Trigger notification when a branch or tag is updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BRANCH_OR_TAG_UPDATED,
}
