package software.amazon.awscdk.services.codepipeline;

/**
 * Additional options to pass to the notification rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * PipelineNotifyOnOptions pipelineNotifyOnOptions = PipelineNotifyOnOptions.builder()
 *         .events(List.of(PipelineNotificationEvents.PIPELINE_EXECUTION_FAILED))
 *         // the properties below are optional
 *         .detailType(DetailType.BASIC)
 *         .enabled(false)
 *         .notificationRuleName("notificationRuleName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.416Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.PipelineNotifyOnOptions")
@software.amazon.jsii.Jsii.Proxy(PipelineNotifyOnOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipelineNotifyOnOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions {

    /**
     * A list of event types associated with this notification rule for CodePipeline Pipeline.
     * <p>
     * For a complete list of event types and IDs, see Notification concepts in the Developer Tools Console User Guide.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents> getEvents();

    /**
     * @return a {@link Builder} of {@link PipelineNotifyOnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineNotifyOnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineNotifyOnOptions> {
        java.util.List<software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents> events;
        software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        java.lang.Boolean enabled;
        java.lang.String notificationRuleName;

        /**
         * Sets the value of {@link PipelineNotifyOnOptions#getEvents}
         * @param events A list of event types associated with this notification rule for CodePipeline Pipeline. This parameter is required.
         *               For a complete list of event types and IDs, see Notification concepts in the Developer Tools Console User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder events(java.util.List<? extends software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents> events) {
            this.events = (java.util.List<software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents>)events;
            return this;
        }

        /**
         * Sets the value of {@link PipelineNotifyOnOptions#getDetailType}
         * @param detailType The level of detail to include in the notifications for this resource.
         *                   BASIC will include only the contents of the event as it would appear in AWS CloudWatch.
         *                   FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(software.amazon.awscdk.services.codestarnotifications.DetailType detailType) {
            this.detailType = detailType;
            return this;
        }

        /**
         * Sets the value of {@link PipelineNotifyOnOptions#getEnabled}
         * @param enabled The status of the notification rule.
         *                If the enabled is set to DISABLED, notifications aren't sent for the notification rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link PipelineNotifyOnOptions#getNotificationRuleName}
         * @param notificationRuleName The name for the notification rule.
         *                             Notification rule names must be unique in your AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationRuleName(java.lang.String notificationRuleName) {
            this.notificationRuleName = notificationRuleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineNotifyOnOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipelineNotifyOnOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PipelineNotifyOnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineNotifyOnOptions {
        private final java.util.List<software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents> events;
        private final software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        private final java.lang.Boolean enabled;
        private final java.lang.String notificationRuleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents.class)));
            this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.DetailType.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notificationRuleName = software.amazon.jsii.Kernel.get(this, "notificationRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.events = (java.util.List<software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents>)java.util.Objects.requireNonNull(builder.events, "events is required");
            this.detailType = builder.detailType;
            this.enabled = builder.enabled;
            this.notificationRuleName = builder.notificationRuleName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.PipelineNotificationEvents> getEvents() {
            return this.events;
        }

        @Override
        public final software.amazon.awscdk.services.codestarnotifications.DetailType getDetailType() {
            return this.detailType;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getNotificationRuleName() {
            return this.notificationRuleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("events", om.valueToTree(this.getEvents()));
            if (this.getDetailType() != null) {
                data.set("detailType", om.valueToTree(this.getDetailType()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getNotificationRuleName() != null) {
                data.set("notificationRuleName", om.valueToTree(this.getNotificationRuleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.PipelineNotifyOnOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineNotifyOnOptions.Jsii$Proxy that = (PipelineNotifyOnOptions.Jsii$Proxy) o;

            if (!events.equals(that.events)) return false;
            if (this.detailType != null ? !this.detailType.equals(that.detailType) : that.detailType != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.notificationRuleName != null ? this.notificationRuleName.equals(that.notificationRuleName) : that.notificationRuleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.events.hashCode();
            result = 31 * result + (this.detailType != null ? this.detailType.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.notificationRuleName != null ? this.notificationRuleName.hashCode() : 0);
            return result;
        }
    }
}
