package software.amazon.awscdk.services.config;

/**
 * Properties for defining a `CfnConfigurationRecorder`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnConfigurationRecorderProps cfnConfigurationRecorderProps = CfnConfigurationRecorderProps.builder()
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .name("name")
 *         .recordingGroup(RecordingGroupProperty.builder()
 *                 .allSupported(false)
 *                 .includeGlobalResourceTypes(false)
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.644Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorderProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationRecorderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationRecorderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the IAM (IAM) role that is used to make read or write requests to the delivery channel that you specify and to get configuration details for supported AWS resources.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * A name for the configuration recorder.
     * <p>
     * If you don't specify a name, AWS CloudFormation CloudFormation generates a unique physical ID and uses that ID for the configuration recorder name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * After you create a configuration recorder, you cannot rename it. If you don't want a name that AWS CloudFormation generates, specify a value for this property.
     * <p>
     * </blockquote>
     * <p>
     * Updates are not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Indicates whether to record configurations for all supported resources or for a list of resource types.
     * <p>
     * The resource types that you list must be supported by AWS Config .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecordingGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationRecorderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationRecorderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationRecorderProps> {
        java.lang.String roleArn;
        java.lang.String name;
        java.lang.Object recordingGroup;

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM (IAM) role that is used to make read or write requests to the delivery channel that you specify and to get configuration details for supported AWS resources. This parameter is required.
         *                For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getName}
         * @param name A name for the configuration recorder.
         *             If you don't specify a name, AWS CloudFormation CloudFormation generates a unique physical ID and uses that ID for the configuration recorder name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             After you create a configuration recorder, you cannot rename it. If you don't want a name that AWS CloudFormation generates, specify a value for this property.
         *             <p>
         *             </blockquote>
         *             <p>
         *             Updates are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRecordingGroup}
         * @param recordingGroup Indicates whether to record configurations for all supported resources or for a list of resource types.
         *                       The resource types that you list must be supported by AWS Config .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRecordingGroup}
         * @param recordingGroup Indicates whether to record configurations for all supported resources or for a list of resource types.
         *                       The resource types that you list must be supported by AWS Config .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(software.amazon.awscdk.IResolvable recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationRecorderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationRecorderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationRecorderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationRecorderProps {
        private final java.lang.String roleArn;
        private final java.lang.String name;
        private final java.lang.Object recordingGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordingGroup = software.amazon.jsii.Kernel.get(this, "recordingGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.name = builder.name;
            this.recordingGroup = builder.recordingGroup;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRecordingGroup() {
            return this.recordingGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRecordingGroup() != null) {
                data.set("recordingGroup", om.valueToTree(this.getRecordingGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationRecorderProps.Jsii$Proxy that = (CfnConfigurationRecorderProps.Jsii$Proxy) o;

            if (!roleArn.equals(that.roleArn)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.recordingGroup != null ? this.recordingGroup.equals(that.recordingGroup) : that.recordingGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleArn.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.recordingGroup != null ? this.recordingGroup.hashCode() : 0);
            return result;
        }
    }
}
