package software.amazon.awscdk.services.config;

/**
 * Resources types that are supported by AWS Config.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Lambda function containing logic that evaluates compliance with the rule.
 * Function evalComplianceFn = Function.Builder.create(this, "CustomFunction")
 *         .code(AssetCode.fromInline("exports.handler = (event) =&gt; console.log(event);"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .build();
 * // A custom rule that runs on configuration changes of EC2 instances
 * CustomRule customRule = CustomRule.Builder.create(this, "Custom")
 *         .configurationChanges(true)
 *         .lambdaFunction(evalComplianceFn)
 *         .ruleScope(RuleScope.fromResource(ResourceType.EC2_INSTANCE))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html">https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.ResourceType")
public class ResourceType extends software.amazon.jsii.JsiiObject {

    protected ResourceType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResourceType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACM_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ACM_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAY_REST_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAY_REST_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAY_STAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAY_STAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAYV2_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAYV2_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAYV2_STAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAYV2_STAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPCONFIG_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPCONFIG_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPSYNC_GRAPHQL_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPSYNC_GRAPHQL_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_LAUNCH_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_LAUNCH_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_SCHEDULED_ACTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_SCHEDULED_ACTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_SELECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_SELECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_VAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_VAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_RECOVERY_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_RECOVERY_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BATCH_COMPUTE_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BATCH_COMPUTE_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BATCH_JOB_QUEUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BATCH_JOB_QUEUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFORMATION_STACK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFORMATION_STACK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFRONT_DISTRIBUTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFRONT_DISTRIBUTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFRONT_STREAMING_DISTRIBUTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFRONT_STREAMING_DISTRIBUTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDTRAIL_TRAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDTRAIL_TRAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDWATCH_ALARM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDWATCH_ALARM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEBUILD_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEBUILD_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_DEPLOYMENT_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_DEPLOYMENT_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_DEPLOYMENT_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_DEPLOYMENT_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEPIPELINE_PIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEPIPELINE_PIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONFIG_CONFORMANCE_PACK_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONFIG_CONFORMANCE_PACK_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONFIG_RESOURCE_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONFIG_RESOURCE_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_EFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_EFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_FSX_LUSTRE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_FSX_LUSTRE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_NFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_NFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_S3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_S3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_SMB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_SMB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_TASK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_TASK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DMS_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DMS_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DMS_REPLICATION_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DMS_REPLICATION_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DYNAMODB_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DYNAMODB_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EBS_VOLUME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EBS_VOLUME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_CUSTOMER_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_CUSTOMER_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_EGRESS_ONLY_INTERNET_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_EGRESS_ONLY_INTERNET_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_EIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_EIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_FLOW_LOG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_FLOW_LOG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_HOST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_HOST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_INTERNET_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_INTERNET_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_LAUNCH_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_LAUNCH_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NAT_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NAT_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_INTERFACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_INTERFACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_REGISTERED_HA_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_REGISTERED_HA_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_ROUTE_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_ROUTE_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SUBNET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SUBNET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_ATTACHMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_ATTACHMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_ROUTE_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_ROUTE_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_ENDPOINT_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_ENDPOINT_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_PEERING_CONNECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_PEERING_CONNECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPN_CONNECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPN_CONNECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPN_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPN_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_PUBLIC_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_PUBLIC_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_TASK_DEFINITION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_TASK_DEFINITION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EFS_ACCESS_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EFS_ACCESS_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EFS_FILE_SYSTEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EFS_FILE_SYSTEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EKS_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EKS_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_APPLICATION_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_APPLICATION_VERSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTICSEARCH_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTICSEARCH_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELB_LOAD_BALANCER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELB_LOAD_BALANCER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELBV2_LISTENER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELBV2_LISTENER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELBV2_LOAD_BALANCER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELBV2_LOAD_BALANCER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EMR_SECURITY_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EMR_SECURITY_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_ACCELERATOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_ACCELERATOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_ENDPOINT_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_ENDPOINT_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_LISTENER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_LISTENER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_DETECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_DETECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_IP_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_IP_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_THREAT_INTEL_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_THREAT_INTEL_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_ACCESSANALYZER_ANALYZER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_ACCESSANALYZER_ANALYZER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_ROLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_ROLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_STREAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_STREAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_STREAM_CONSUMER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_STREAM_CONSUMER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KMS_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KMS_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LAMBDA_FUNCTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LAMBDA_FUNCTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MSK_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MSK_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        OPENSEARCH_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "OPENSEARCH_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        QLDB_LEDGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "QLDB_LEDGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_CLUSTER_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_CLUSTER_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_PARAMETER_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_PARAMETER_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_ACCOUNT_PUBLIC_ACCESS_BLOCK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_ACCOUNT_PUBLIC_ACCESS_BLOCK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_BUCKET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_BUCKET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_CODE_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_CODE_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_MODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_MODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_NOTEBOOK_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_NOTEBOOK_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_WORKTEAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_WORKTEAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SECRETS_MANAGER_SECRET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SECRETS_MANAGER_SECRET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_CLOUDFORMATION_PRODUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_CLOUDFORMATION_PRODUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_PORTFOLIO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_PORTFOLIO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_CONFIGURATION_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_CONFIGURATION_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_CONTACT_LIST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_CONTACT_LIST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SHIELD_PROTECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SHIELD_PROTECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SHIELD_REGIONAL_PROTECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SHIELD_REGIONAL_PROTECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SNS_TOPIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SNS_TOPIC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SQS_QUEUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SQS_QUEUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        STEPFUNCTIONS_ACTIVITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "STEPFUNCTIONS_ACTIVITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        STEPFUNCTIONS_STATE_MACHINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "STEPFUNCTIONS_STATE_MACHINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_FILE_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_FILE_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_PATCH_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_PATCH_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RATE_BASED_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RATE_BASED_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RATE_BASED_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RATE_BASED_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_IP_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_IP_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_MANAGED_RULE_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_MANAGED_RULE_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_REGEX_PATTERN_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_REGEX_PATTERN_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WORKSPACES_CONNECTION_ALIAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WORKSPACES_CONNECTION_ALIAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WORKSPACES_WORKSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WORKSPACES_WORKSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        XRAY_ENCRYPTION_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "XRAY_ENCRYPTION_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
    }

    /**
     * A custom resource type to support future cases.
     * <p>
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.ResourceType of(final @org.jetbrains.annotations.NotNull java.lang.String type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.ResourceType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * AWS Certificate manager certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ACM_CERTIFICATE;

    /**
     * API Gateway REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAY_REST_API;

    /**
     * API Gateway Stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAY_STAGE;

    /**
     * API Gatewayv2 API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAYV2_API;

    /**
     * API Gatewayv2 Stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAYV2_STAGE;

    /**
     * AWS AppConfig application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPCONFIG_APPLICATION;

    /**
     * AWS AppSync GraphQL Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPSYNC_GRAPHQL_API;

    /**
     * AWS Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_GROUP;

    /**
     * AWS Auto Scaling launch configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_LAUNCH_CONFIGURATION;

    /**
     * AWS Auto Scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_POLICY;

    /**
     * AWS Auto Scaling scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_SCHEDULED_ACTION;

    /**
     * AWS Backup backup plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_PLAN;

    /**
     * AWS Backup backup selection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_SELECTION;

    /**
     * AWS Backup backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_VAULT;

    /**
     * AWS Backup backup recovery point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_RECOVERY_POINT;

    /**
     * AWS Batch compute environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BATCH_COMPUTE_ENVIRONMENT;

    /**
     * AWS Batch job queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BATCH_JOB_QUEUE;

    /**
     * AWS CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFORMATION_STACK;

    /**
     * Amazon CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFRONT_DISTRIBUTION;

    /**
     * Amazon CloudFront streaming distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFRONT_STREAMING_DISTRIBUTION;

    /**
     * AWS CloudTrail trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDTRAIL_TRAIL;

    /**
     * Amazon CloudWatch Alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDWATCH_ALARM;

    /**
     * AWS CodeBuild project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEBUILD_PROJECT;

    /**
     * AWS CodeDeploy application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_APPLICATION;

    /**
     * AWS CodeDeploy deployment config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_DEPLOYMENT_CONFIG;

    /**
     * AWS CodeDeploy deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_DEPLOYMENT_GROUP;

    /**
     * AWS CodePipeline pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEPIPELINE_PIPELINE;

    /**
     * AWS Config conformance pack compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONFIG_CONFORMANCE_PACK_COMPLIANCE;

    /**
     * AWS Config resource compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONFIG_RESOURCE_COMPLIANCE;

    /**
     * AWS DataSync location EFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_EFS;

    /**
     * AWS DataSync location FSx Lustre.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_FSX_LUSTRE;

    /**
     * AWS DataSync location NFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_NFS;

    /**
     * AWS DataSync location S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_S3;

    /**
     * AWS DataSync location SMB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_SMB;

    /**
     * AWS DataSync task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_TASK;

    /**
     * AWS DMS event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DMS_EVENT_SUBSCRIPTION;

    /**
     * AWS DMS replication subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DMS_REPLICATION_SUBNET_GROUP;

    /**
     * Amazon DynamoDB Table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DYNAMODB_TABLE;

    /**
     * Elastic Block Store (EBS) volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EBS_VOLUME;

    /**
     * Amazon EC2 customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_CUSTOMER_GATEWAY;

    /**
     * EC2 Egress only internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_EGRESS_ONLY_INTERNET_GATEWAY;

    /**
     * EC2 Elastic IP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_EIP;

    /**
     * EC2 flow log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_FLOW_LOG;

    /**
     * EC2 host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_HOST;

    /**
     * EC2 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_INSTANCE;

    /**
     * Amazon EC2 internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_INTERNET_GATEWAY;

    /**
     * EC2 launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_LAUNCH_TEMPLATE;

    /**
     * EC2 NAT gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NAT_GATEWAY;

    /**
     * Amazon EC2 network ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_ACL;

    /**
     * EC2 Network Insights Access Scope Analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS;

    /**
     * EC2 Network Interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_INTERFACE;

    /**
     * EC2 registered HA instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_REGISTERED_HA_INSTANCE;

    /**
     * Amazon EC2 route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_ROUTE_TABLE;

    /**
     * EC2 security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SECURITY_GROUP;

    /**
     * Amazon EC2 subnet table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SUBNET;

    /**
     * EC2 transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY;

    /**
     * EC2 transit gateway attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_ATTACHMENT;

    /**
     * EC2 transit gateway route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_ROUTE_TABLE;

    /**
     * Amazon EC2 VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC;

    /**
     * EC2 VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_ENDPOINT;

    /**
     * EC2 VPC endpoint service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_ENDPOINT_SERVICE;

    /**
     * EC2 VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_PEERING_CONNECTION;

    /**
     * Amazon EC2 VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPN_CONNECTION;

    /**
     * Amazon EC2 VPN gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPN_GATEWAY;

    /**
     * Amazon ECR public repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_PUBLIC_REPOSITORY;

    /**
     * Amazon ECR repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_REPOSITORY;

    /**
     * Amazon ECS cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_CLUSTER;

    /**
     * Amazon ECS service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_SERVICE;

    /**
     * Amazon ECS task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_TASK_DEFINITION;

    /**
     * Amazon EFS access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EFS_ACCESS_POINT;

    /**
     * Amazon EFS file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EFS_FILE_SYSTEM;

    /**
     * Amazon Elastic Kubernetes Service cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EKS_CLUSTER;

    /**
     * AWS Elastic Beanstalk (EB) application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_APPLICATION;

    /**
     * AWS Elastic Beanstalk (EB) application version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_APPLICATION_VERSION;

    /**
     * AWS Elastic Beanstalk (EB) environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_ENVIRONMENT;

    /**
     * Amazon ElasticSearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTICSEARCH_DOMAIN;

    /**
     * AWS ELB classic load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELB_LOAD_BALANCER;

    /**
     * AWS ELBv2 application load balancer listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELBV2_LISTENER;

    /**
     * AWS ELBv2 network load balancer or AWS ELBv2 application load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELBV2_LOAD_BALANCER;

    /**
     * Amazon EMR security configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EMR_SECURITY_CONFIGURATION;

    /**
     * AWS GlobalAccelerator accelerator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_ACCELERATOR;

    /**
     * AWS GlobalAccelerator endpoint group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_ENDPOINT_GROUP;

    /**
     * AWS GlobalAccelerator listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_LISTENER;

    /**
     * Amazon GuardDuty detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_DETECTOR;

    /**
     * Amazon GuardDuty IP Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_IP_SET;

    /**
     * Amazon GuardDuty Threat Intel Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_THREAT_INTEL_SET;

    /**
     * AWS IAM AccessAnalyzer analyzer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_ACCESSANALYZER_ANALYZER;

    /**
     * AWS IAM group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_GROUP;

    /**
     * AWS IAM policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_POLICY;

    /**
     * AWS IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_ROLE;

    /**
     * AWS IAM user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_USER;

    /**
     * Amazon Kinesis stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_STREAM;

    /**
     * Amazon Kinesis stream consumer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_STREAM_CONSUMER;

    /**
     * AWS KMS Key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KMS_KEY;

    /**
     * AWS Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LAMBDA_FUNCTION;

    /**
     * Amazon MSK cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MSK_CLUSTER;

    /**
     * Amazon OpenSearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType OPENSEARCH_DOMAIN;

    /**
     * Amazon QLDB ledger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType QLDB_LEDGER;

    /**
     * Amazon RDS database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_CLUSTER;

    /**
     * Amazon RDS database cluster snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_CLUSTER_SNAPSHOT;

    /**
     * Amazon RDS database instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_INSTANCE;

    /**
     * Amazon RDS database security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SECURITY_GROUP;

    /**
     * Amazon RDS database snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SNAPSHOT;

    /**
     * Amazon RDS database subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SUBNET_GROUP;

    /**
     * Amazon RDS event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_EVENT_SUBSCRIPTION;

    /**
     * Amazon Redshift cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER;

    /**
     * Amazon Redshift cluster parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_PARAMETER_GROUP;

    /**
     * Amazon Redshift cluster security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SECURITY_GROUP;

    /**
     * Amazon Redshift cluster snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SNAPSHOT;

    /**
     * Amazon Redshift cluster subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SUBNET_GROUP;

    /**
     * Amazon Redshift event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_EVENT_SUBSCRIPTION;

    /**
     * Amazon Route53 resolver resolver endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_ENDPOINT;

    /**
     * Amazon Route53 resolver resolver rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_RULE;

    /**
     * Amazon Route53 resolver resolver rule association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION;

    /**
     * Amazon S3 account public access block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_ACCOUNT_PUBLIC_ACCESS_BLOCK;

    /**
     * Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_BUCKET;

    /**
     * Amazon SageMaker code repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_CODE_REPOSITORY;

    /**
     * Amazon SageMaker model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_MODEL;

    /**
     * Amazon SageMaker notebook instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_NOTEBOOK_INSTANCE;

    /**
     * Amazon SageMaker workteam.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_WORKTEAM;

    /**
     * AWS Secrets Manager secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SECRETS_MANAGER_SECRET;

    /**
     * AWS Service Catalog CloudFormation product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_CLOUDFORMATION_PRODUCT;

    /**
     * AWS Service Catalog CloudFormation provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT;

    /**
     * AWS Service Catalog portfolio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_PORTFOLIO;

    /**
     * AWS Cloud Map(ServiceDiscovery) Public Dns Namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE;

    /**
     * AWS Cloud Map(ServiceDiscovery) service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_SERVICE;

    /**
     * Amazon SES Configuration Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_CONFIGURATION_SET;

    /**
     * Amazon SES Contact List.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_CONTACT_LIST;

    /**
     * AWS Shield protection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SHIELD_PROTECTION;

    /**
     * AWS Shield regional protection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SHIELD_REGIONAL_PROTECTION;

    /**
     * Amazon SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SNS_TOPIC;

    /**
     * Amazon SQS queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SQS_QUEUE;

    /**
     * AWS StepFunctions activity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType STEPFUNCTIONS_ACTIVITY;

    /**
     * AWS StepFunctions state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType STEPFUNCTIONS_STATE_MACHINE;

    /**
     * AWS Systems Manager association compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE;

    /**
     * AWS Systems Manager file data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_FILE_DATA;

    /**
     * AWS Systems Manager managed instance inventory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY;

    /**
     * AWS Systems Manager patch compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_PATCH_COMPLIANCE;

    /**
     * AWS WAF rate based rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RATE_BASED_RULE;

    /**
     * AWS WAF regional rate based rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RATE_BASED_RULE;

    /**
     * AWS WAF regional rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RULE;

    /**
     * AWS WAF regional rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RULE_GROUP;

    /**
     * AWS WAF web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_WEB_ACL;

    /**
     * AWS WAF rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RULE;

    /**
     * AWS WAF rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RULE_GROUP;

    /**
     * AWS WAF web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_WEB_ACL;

    /**
     * AWS WAFv2 ip set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_IP_SET;

    /**
     * AWS WAFv2 managed rule set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_MANAGED_RULE_SET;

    /**
     * AWS WAFv2 regex pattern set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_REGEX_PATTERN_SET;

    /**
     * AWS WAFv2 rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_RULE_GROUP;

    /**
     * AWS WAFv2 web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_WEB_ACL;

    /**
     * Amazon WorkSpaces connection alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WORKSPACES_CONNECTION_ALIAS;

    /**
     * Amazon WorkSpaces workSpace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WORKSPACES_WORKSPACE;

    /**
     * AWS X-Ray encryption configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType XRAY_ENCRYPTION_CONFIGURATION;

    /**
     * Valid value of resource type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComplianceResourceType() {
        return software.amazon.jsii.Kernel.get(this, "complianceResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
