package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a `CfnInstanceStorageConfig`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnInstanceStorageConfigProps cfnInstanceStorageConfigProps = CfnInstanceStorageConfigProps.builder()
 *         .instanceArn("instanceArn")
 *         .resourceType("resourceType")
 *         .storageType("storageType")
 *         // the properties below are optional
 *         .kinesisFirehoseConfig(KinesisFirehoseConfigProperty.builder()
 *                 .firehoseArn("firehoseArn")
 *                 .build())
 *         .kinesisStreamConfig(KinesisStreamConfigProperty.builder()
 *                 .streamArn("streamArn")
 *                 .build())
 *         .kinesisVideoStreamConfig(KinesisVideoStreamConfigProperty.builder()
 *                 .prefix("prefix")
 *                 .retentionPeriodHours(123)
 *                 // the properties below are optional
 *                 .encryptionConfig(EncryptionConfigProperty.builder()
 *                         .encryptionType("encryptionType")
 *                         .keyId("keyId")
 *                         .build())
 *                 .build())
 *         .s3Config(S3ConfigProperty.builder()
 *                 .bucketName("bucketName")
 *                 .bucketPrefix("bucketPrefix")
 *                 // the properties below are optional
 *                 .encryptionConfig(EncryptionConfigProperty.builder()
 *                         .encryptionType("encryptionType")
 *                         .keyId("keyId")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.690Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnInstanceStorageConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceStorageConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceStorageConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Connect::InstanceStorageConfig.InstanceArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * `AWS::Connect::InstanceStorageConfig.ResourceType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * `AWS::Connect::InstanceStorageConfig.StorageType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStorageType();

    /**
     * `AWS::Connect::InstanceStorageConfig.KinesisFirehoseConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseConfig() {
        return null;
    }

    /**
     * `AWS::Connect::InstanceStorageConfig.KinesisStreamConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamConfig() {
        return null;
    }

    /**
     * `AWS::Connect::InstanceStorageConfig.KinesisVideoStreamConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisVideoStreamConfig() {
        return null;
    }

    /**
     * `AWS::Connect::InstanceStorageConfig.S3Config`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3Config() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceStorageConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceStorageConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceStorageConfigProps> {
        java.lang.String instanceArn;
        java.lang.String resourceType;
        java.lang.String storageType;
        java.lang.Object kinesisFirehoseConfig;
        java.lang.Object kinesisStreamConfig;
        java.lang.Object kinesisVideoStreamConfig;
        java.lang.Object s3Config;

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getInstanceArn}
         * @param instanceArn `AWS::Connect::InstanceStorageConfig.InstanceArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getResourceType}
         * @param resourceType `AWS::Connect::InstanceStorageConfig.ResourceType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getStorageType}
         * @param storageType `AWS::Connect::InstanceStorageConfig.StorageType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(java.lang.String storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getKinesisFirehoseConfig}
         * @param kinesisFirehoseConfig `AWS::Connect::InstanceStorageConfig.KinesisFirehoseConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisFirehoseConfig(software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisFirehoseConfigProperty kinesisFirehoseConfig) {
            this.kinesisFirehoseConfig = kinesisFirehoseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getKinesisFirehoseConfig}
         * @param kinesisFirehoseConfig `AWS::Connect::InstanceStorageConfig.KinesisFirehoseConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisFirehoseConfig(software.amazon.awscdk.IResolvable kinesisFirehoseConfig) {
            this.kinesisFirehoseConfig = kinesisFirehoseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getKinesisStreamConfig}
         * @param kinesisStreamConfig `AWS::Connect::InstanceStorageConfig.KinesisStreamConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamConfig(software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisStreamConfigProperty kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getKinesisStreamConfig}
         * @param kinesisStreamConfig `AWS::Connect::InstanceStorageConfig.KinesisStreamConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamConfig(software.amazon.awscdk.IResolvable kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getKinesisVideoStreamConfig}
         * @param kinesisVideoStreamConfig `AWS::Connect::InstanceStorageConfig.KinesisVideoStreamConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStreamConfig(software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisVideoStreamConfigProperty kinesisVideoStreamConfig) {
            this.kinesisVideoStreamConfig = kinesisVideoStreamConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getKinesisVideoStreamConfig}
         * @param kinesisVideoStreamConfig `AWS::Connect::InstanceStorageConfig.KinesisVideoStreamConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStreamConfig(software.amazon.awscdk.IResolvable kinesisVideoStreamConfig) {
            this.kinesisVideoStreamConfig = kinesisVideoStreamConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getS3Config}
         * @param s3Config `AWS::Connect::InstanceStorageConfig.S3Config`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Config(software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.S3ConfigProperty s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceStorageConfigProps#getS3Config}
         * @param s3Config `AWS::Connect::InstanceStorageConfig.S3Config`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Config(software.amazon.awscdk.IResolvable s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceStorageConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceStorageConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceStorageConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceStorageConfigProps {
        private final java.lang.String instanceArn;
        private final java.lang.String resourceType;
        private final java.lang.String storageType;
        private final java.lang.Object kinesisFirehoseConfig;
        private final java.lang.Object kinesisStreamConfig;
        private final java.lang.Object kinesisVideoStreamConfig;
        private final java.lang.Object s3Config;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kinesisFirehoseConfig = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisStreamConfig = software.amazon.jsii.Kernel.get(this, "kinesisStreamConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisVideoStreamConfig = software.amazon.jsii.Kernel.get(this, "kinesisVideoStreamConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.s3Config = software.amazon.jsii.Kernel.get(this, "s3Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
            this.storageType = java.util.Objects.requireNonNull(builder.storageType, "storageType is required");
            this.kinesisFirehoseConfig = builder.kinesisFirehoseConfig;
            this.kinesisStreamConfig = builder.kinesisStreamConfig;
            this.kinesisVideoStreamConfig = builder.kinesisVideoStreamConfig;
            this.s3Config = builder.s3Config;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final java.lang.String getStorageType() {
            return this.storageType;
        }

        @Override
        public final java.lang.Object getKinesisFirehoseConfig() {
            return this.kinesisFirehoseConfig;
        }

        @Override
        public final java.lang.Object getKinesisStreamConfig() {
            return this.kinesisStreamConfig;
        }

        @Override
        public final java.lang.Object getKinesisVideoStreamConfig() {
            return this.kinesisVideoStreamConfig;
        }

        @Override
        public final java.lang.Object getS3Config() {
            return this.s3Config;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("resourceType", om.valueToTree(this.getResourceType()));
            data.set("storageType", om.valueToTree(this.getStorageType()));
            if (this.getKinesisFirehoseConfig() != null) {
                data.set("kinesisFirehoseConfig", om.valueToTree(this.getKinesisFirehoseConfig()));
            }
            if (this.getKinesisStreamConfig() != null) {
                data.set("kinesisStreamConfig", om.valueToTree(this.getKinesisStreamConfig()));
            }
            if (this.getKinesisVideoStreamConfig() != null) {
                data.set("kinesisVideoStreamConfig", om.valueToTree(this.getKinesisVideoStreamConfig()));
            }
            if (this.getS3Config() != null) {
                data.set("s3Config", om.valueToTree(this.getS3Config()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnInstanceStorageConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceStorageConfigProps.Jsii$Proxy that = (CfnInstanceStorageConfigProps.Jsii$Proxy) o;

            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!resourceType.equals(that.resourceType)) return false;
            if (!storageType.equals(that.storageType)) return false;
            if (this.kinesisFirehoseConfig != null ? !this.kinesisFirehoseConfig.equals(that.kinesisFirehoseConfig) : that.kinesisFirehoseConfig != null) return false;
            if (this.kinesisStreamConfig != null ? !this.kinesisStreamConfig.equals(that.kinesisStreamConfig) : that.kinesisStreamConfig != null) return false;
            if (this.kinesisVideoStreamConfig != null ? !this.kinesisVideoStreamConfig.equals(that.kinesisVideoStreamConfig) : that.kinesisVideoStreamConfig != null) return false;
            return this.s3Config != null ? this.s3Config.equals(that.s3Config) : that.s3Config == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceArn.hashCode();
            result = 31 * result + (this.resourceType.hashCode());
            result = 31 * result + (this.storageType.hashCode());
            result = 31 * result + (this.kinesisFirehoseConfig != null ? this.kinesisFirehoseConfig.hashCode() : 0);
            result = 31 * result + (this.kinesisStreamConfig != null ? this.kinesisStreamConfig.hashCode() : 0);
            result = 31 * result + (this.kinesisVideoStreamConfig != null ? this.kinesisVideoStreamConfig.hashCode() : 0);
            result = 31 * result + (this.s3Config != null ? this.s3Config.hashCode() : 0);
            return result;
        }
    }
}
