package software.amazon.awscdk.services.connect;

/**
 * A CloudFormation `AWS::Connect::User`.
 * <p>
 * Creates a user account for the specified Amazon Connect instance.
 * <p>
 * For information about how to create user accounts using the Amazon Connect console, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <em>Amazon Connect Administrator Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnUser cfnUser = CfnUser.Builder.create(this, "MyCfnUser")
 *         .instanceArn("instanceArn")
 *         .phoneConfig(UserPhoneConfigProperty.builder()
 *                 .phoneType("phoneType")
 *                 // the properties below are optional
 *                 .afterContactWorkTimeLimit(123)
 *                 .autoAccept(false)
 *                 .deskPhoneNumber("deskPhoneNumber")
 *                 .build())
 *         .routingProfileArn("routingProfileArn")
 *         .securityProfileArns(List.of("securityProfileArns"))
 *         .username("username")
 *         // the properties below are optional
 *         .directoryUserId("directoryUserId")
 *         .hierarchyGroupArn("hierarchyGroupArn")
 *         .identityInfo(UserIdentityInfoProperty.builder()
 *                 .email("email")
 *                 .firstName("firstName")
 *                 .lastName("lastName")
 *                 .mobile("mobile")
 *                 .secondaryEmail("secondaryEmail")
 *                 .build())
 *         .password("password")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.696Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUser")
public class CfnUser extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnUser(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUser(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnUser.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Connect::User`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUser(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnUserProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUserArn() {
        return software.amazon.jsii.Kernel.get(this, "attrUserArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * Information about the phone configuration for the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPhoneConfig() {
        return software.amazon.jsii.Kernel.get(this, "phoneConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the phone configuration for the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhoneConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnUser.UserPhoneConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "phoneConfig", java.util.Objects.requireNonNull(value, "phoneConfig is required"));
    }

    /**
     * Information about the phone configuration for the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhoneConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "phoneConfig", java.util.Objects.requireNonNull(value, "phoneConfig is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the user's routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoutingProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "routingProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the user's routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingProfileArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routingProfileArn", java.util.Objects.requireNonNull(value, "routingProfileArn is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the user's security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityProfileArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityProfileArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the user's security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityProfileArns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityProfileArns", java.util.Objects.requireNonNull(value, "securityProfileArns is required"));
    }

    /**
     * The user name assigned to the user account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUsername() {
        return software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user name assigned to the user account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsername(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "username", java.util.Objects.requireNonNull(value, "username is required"));
    }

    /**
     * The identifier of the user account in the directory used for identity management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDirectoryUserId() {
        return software.amazon.jsii.Kernel.get(this, "directoryUserId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the user account in the directory used for identity management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDirectoryUserId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "directoryUserId", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the user's hierarchy group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHierarchyGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "hierarchyGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the user's hierarchy group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHierarchyGroupArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hierarchyGroupArn", value);
    }

    /**
     * Information about the user identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdentityInfo() {
        return software.amazon.jsii.Kernel.get(this, "identityInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the user identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnUser.UserIdentityInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "identityInfo", value);
    }

    /**
     * Information about the user identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identityInfo", value);
    }

    /**
     * The user's password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user's password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "password", value);
    }
    /**
     * Contains information about the identity of a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * UserIdentityInfoProperty userIdentityInfoProperty = UserIdentityInfoProperty.builder()
     *         .email("email")
     *         .firstName("firstName")
     *         .lastName("lastName")
     *         .mobile("mobile")
     *         .secondaryEmail("secondaryEmail")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUser.UserIdentityInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(UserIdentityInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserIdentityInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email address.
         * <p>
         * If you are using SAML for identity management and include this parameter, an error is returned.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmail() {
            return null;
        }

        /**
         * The first name.
         * <p>
         * This is required if you are using Amazon Connect or SAML for identity management.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFirstName() {
            return null;
        }

        /**
         * The last name.
         * <p>
         * This is required if you are using Amazon Connect or SAML for identity management.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLastName() {
            return null;
        }

        /**
         * `CfnUser.UserIdentityInfoProperty.Mobile`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMobile() {
            return null;
        }

        /**
         * `CfnUser.UserIdentityInfoProperty.SecondaryEmail`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecondaryEmail() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserIdentityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserIdentityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserIdentityInfoProperty> {
            java.lang.String email;
            java.lang.String firstName;
            java.lang.String lastName;
            java.lang.String mobile;
            java.lang.String secondaryEmail;

            /**
             * Sets the value of {@link UserIdentityInfoProperty#getEmail}
             * @param email The email address.
             *              If you are using SAML for identity management and include this parameter, an error is returned.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(java.lang.String email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link UserIdentityInfoProperty#getFirstName}
             * @param firstName The first name.
             *                  This is required if you are using Amazon Connect or SAML for identity management.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstName(java.lang.String firstName) {
                this.firstName = firstName;
                return this;
            }

            /**
             * Sets the value of {@link UserIdentityInfoProperty#getLastName}
             * @param lastName The last name.
             *                 This is required if you are using Amazon Connect or SAML for identity management.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastName(java.lang.String lastName) {
                this.lastName = lastName;
                return this;
            }

            /**
             * Sets the value of {@link UserIdentityInfoProperty#getMobile}
             * @param mobile `CfnUser.UserIdentityInfoProperty.Mobile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mobile(java.lang.String mobile) {
                this.mobile = mobile;
                return this;
            }

            /**
             * Sets the value of {@link UserIdentityInfoProperty#getSecondaryEmail}
             * @param secondaryEmail `CfnUser.UserIdentityInfoProperty.SecondaryEmail`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryEmail(java.lang.String secondaryEmail) {
                this.secondaryEmail = secondaryEmail;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserIdentityInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserIdentityInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserIdentityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserIdentityInfoProperty {
            private final java.lang.String email;
            private final java.lang.String firstName;
            private final java.lang.String lastName;
            private final java.lang.String mobile;
            private final java.lang.String secondaryEmail;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firstName = software.amazon.jsii.Kernel.get(this, "firstName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lastName = software.amazon.jsii.Kernel.get(this, "lastName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mobile = software.amazon.jsii.Kernel.get(this, "mobile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secondaryEmail = software.amazon.jsii.Kernel.get(this, "secondaryEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.email = builder.email;
                this.firstName = builder.firstName;
                this.lastName = builder.lastName;
                this.mobile = builder.mobile;
                this.secondaryEmail = builder.secondaryEmail;
            }

            @Override
            public final java.lang.String getEmail() {
                return this.email;
            }

            @Override
            public final java.lang.String getFirstName() {
                return this.firstName;
            }

            @Override
            public final java.lang.String getLastName() {
                return this.lastName;
            }

            @Override
            public final java.lang.String getMobile() {
                return this.mobile;
            }

            @Override
            public final java.lang.String getSecondaryEmail() {
                return this.secondaryEmail;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmail() != null) {
                    data.set("email", om.valueToTree(this.getEmail()));
                }
                if (this.getFirstName() != null) {
                    data.set("firstName", om.valueToTree(this.getFirstName()));
                }
                if (this.getLastName() != null) {
                    data.set("lastName", om.valueToTree(this.getLastName()));
                }
                if (this.getMobile() != null) {
                    data.set("mobile", om.valueToTree(this.getMobile()));
                }
                if (this.getSecondaryEmail() != null) {
                    data.set("secondaryEmail", om.valueToTree(this.getSecondaryEmail()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUser.UserIdentityInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserIdentityInfoProperty.Jsii$Proxy that = (UserIdentityInfoProperty.Jsii$Proxy) o;

                if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
                if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) return false;
                if (this.lastName != null ? !this.lastName.equals(that.lastName) : that.lastName != null) return false;
                if (this.mobile != null ? !this.mobile.equals(that.mobile) : that.mobile != null) return false;
                return this.secondaryEmail != null ? this.secondaryEmail.equals(that.secondaryEmail) : that.secondaryEmail == null;
            }

            @Override
            public final int hashCode() {
                int result = this.email != null ? this.email.hashCode() : 0;
                result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
                result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
                result = 31 * result + (this.mobile != null ? this.mobile.hashCode() : 0);
                result = 31 * result + (this.secondaryEmail != null ? this.secondaryEmail.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the phone configuration settings for a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * UserPhoneConfigProperty userPhoneConfigProperty = UserPhoneConfigProperty.builder()
     *         .phoneType("phoneType")
     *         // the properties below are optional
     *         .afterContactWorkTimeLimit(123)
     *         .autoAccept(false)
     *         .deskPhoneNumber("deskPhoneNumber")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUser.UserPhoneConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPhoneConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPhoneConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The phone type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPhoneType();

        /**
         * The After Call Work (ACW) timeout setting, in seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAfterContactWorkTimeLimit() {
            return null;
        }

        /**
         * The Auto accept setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoAccept() {
            return null;
        }

        /**
         * The phone number for the user's desk phone.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeskPhoneNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPhoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPhoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPhoneConfigProperty> {
            java.lang.String phoneType;
            java.lang.Number afterContactWorkTimeLimit;
            java.lang.Object autoAccept;
            java.lang.String deskPhoneNumber;

            /**
             * Sets the value of {@link UserPhoneConfigProperty#getPhoneType}
             * @param phoneType The phone type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneType(java.lang.String phoneType) {
                this.phoneType = phoneType;
                return this;
            }

            /**
             * Sets the value of {@link UserPhoneConfigProperty#getAfterContactWorkTimeLimit}
             * @param afterContactWorkTimeLimit The After Call Work (ACW) timeout setting, in seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afterContactWorkTimeLimit(java.lang.Number afterContactWorkTimeLimit) {
                this.afterContactWorkTimeLimit = afterContactWorkTimeLimit;
                return this;
            }

            /**
             * Sets the value of {@link UserPhoneConfigProperty#getAutoAccept}
             * @param autoAccept The Auto accept setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAccept(java.lang.Boolean autoAccept) {
                this.autoAccept = autoAccept;
                return this;
            }

            /**
             * Sets the value of {@link UserPhoneConfigProperty#getAutoAccept}
             * @param autoAccept The Auto accept setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAccept(software.amazon.awscdk.IResolvable autoAccept) {
                this.autoAccept = autoAccept;
                return this;
            }

            /**
             * Sets the value of {@link UserPhoneConfigProperty#getDeskPhoneNumber}
             * @param deskPhoneNumber The phone number for the user's desk phone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deskPhoneNumber(java.lang.String deskPhoneNumber) {
                this.deskPhoneNumber = deskPhoneNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPhoneConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPhoneConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPhoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPhoneConfigProperty {
            private final java.lang.String phoneType;
            private final java.lang.Number afterContactWorkTimeLimit;
            private final java.lang.Object autoAccept;
            private final java.lang.String deskPhoneNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.phoneType = software.amazon.jsii.Kernel.get(this, "phoneType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.afterContactWorkTimeLimit = software.amazon.jsii.Kernel.get(this, "afterContactWorkTimeLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.autoAccept = software.amazon.jsii.Kernel.get(this, "autoAccept", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deskPhoneNumber = software.amazon.jsii.Kernel.get(this, "deskPhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.phoneType = java.util.Objects.requireNonNull(builder.phoneType, "phoneType is required");
                this.afterContactWorkTimeLimit = builder.afterContactWorkTimeLimit;
                this.autoAccept = builder.autoAccept;
                this.deskPhoneNumber = builder.deskPhoneNumber;
            }

            @Override
            public final java.lang.String getPhoneType() {
                return this.phoneType;
            }

            @Override
            public final java.lang.Number getAfterContactWorkTimeLimit() {
                return this.afterContactWorkTimeLimit;
            }

            @Override
            public final java.lang.Object getAutoAccept() {
                return this.autoAccept;
            }

            @Override
            public final java.lang.String getDeskPhoneNumber() {
                return this.deskPhoneNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("phoneType", om.valueToTree(this.getPhoneType()));
                if (this.getAfterContactWorkTimeLimit() != null) {
                    data.set("afterContactWorkTimeLimit", om.valueToTree(this.getAfterContactWorkTimeLimit()));
                }
                if (this.getAutoAccept() != null) {
                    data.set("autoAccept", om.valueToTree(this.getAutoAccept()));
                }
                if (this.getDeskPhoneNumber() != null) {
                    data.set("deskPhoneNumber", om.valueToTree(this.getDeskPhoneNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUser.UserPhoneConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPhoneConfigProperty.Jsii$Proxy that = (UserPhoneConfigProperty.Jsii$Proxy) o;

                if (!phoneType.equals(that.phoneType)) return false;
                if (this.afterContactWorkTimeLimit != null ? !this.afterContactWorkTimeLimit.equals(that.afterContactWorkTimeLimit) : that.afterContactWorkTimeLimit != null) return false;
                if (this.autoAccept != null ? !this.autoAccept.equals(that.autoAccept) : that.autoAccept != null) return false;
                return this.deskPhoneNumber != null ? this.deskPhoneNumber.equals(that.deskPhoneNumber) : that.deskPhoneNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.phoneType.hashCode();
                result = 31 * result + (this.afterContactWorkTimeLimit != null ? this.afterContactWorkTimeLimit.hashCode() : 0);
                result = 31 * result + (this.autoAccept != null ? this.autoAccept.hashCode() : 0);
                result = 31 * result + (this.deskPhoneNumber != null ? this.deskPhoneNumber.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnUser}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnUser> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnUserProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnUserProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the instance.
         * <p>
         * @return {@code this}
         * @param instanceArn The Amazon Resource Name (ARN) of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * Information about the phone configuration for the user.
         * <p>
         * @return {@code this}
         * @param phoneConfig Information about the phone configuration for the user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneConfig(final software.amazon.awscdk.services.connect.CfnUser.UserPhoneConfigProperty phoneConfig) {
            this.props.phoneConfig(phoneConfig);
            return this;
        }
        /**
         * Information about the phone configuration for the user.
         * <p>
         * @return {@code this}
         * @param phoneConfig Information about the phone configuration for the user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneConfig(final software.amazon.awscdk.IResolvable phoneConfig) {
            this.props.phoneConfig(phoneConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the user's routing profile.
         * <p>
         * @return {@code this}
         * @param routingProfileArn The Amazon Resource Name (ARN) of the user's routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingProfileArn(final java.lang.String routingProfileArn) {
            this.props.routingProfileArn(routingProfileArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the user's security profile.
         * <p>
         * @return {@code this}
         * @param securityProfileArns The Amazon Resource Name (ARN) of the user's security profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileArns(final java.util.List<java.lang.String> securityProfileArns) {
            this.props.securityProfileArns(securityProfileArns);
            return this;
        }

        /**
         * The user name assigned to the user account.
         * <p>
         * @return {@code this}
         * @param username The user name assigned to the user account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * The identifier of the user account in the directory used for identity management.
         * <p>
         * @return {@code this}
         * @param directoryUserId The identifier of the user account in the directory used for identity management. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryUserId(final java.lang.String directoryUserId) {
            this.props.directoryUserId(directoryUserId);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the user's hierarchy group.
         * <p>
         * @return {@code this}
         * @param hierarchyGroupArn The Amazon Resource Name (ARN) of the user's hierarchy group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hierarchyGroupArn(final java.lang.String hierarchyGroupArn) {
            this.props.hierarchyGroupArn(hierarchyGroupArn);
            return this;
        }

        /**
         * Information about the user identity.
         * <p>
         * @return {@code this}
         * @param identityInfo Information about the user identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityInfo(final software.amazon.awscdk.services.connect.CfnUser.UserIdentityInfoProperty identityInfo) {
            this.props.identityInfo(identityInfo);
            return this;
        }
        /**
         * Information about the user identity.
         * <p>
         * @return {@code this}
         * @param identityInfo Information about the user identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityInfo(final software.amazon.awscdk.IResolvable identityInfo) {
            this.props.identityInfo(identityInfo);
            return this;
        }

        /**
         * The user's password.
         * <p>
         * @return {@code this}
         * @param password The user's password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final java.lang.String password) {
            this.props.password(password);
            return this;
        }

        /**
         * The tags.
         * <p>
         * @return {@code this}
         * @param tags The tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.connect.CfnUser}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnUser build() {
            return new software.amazon.awscdk.services.connect.CfnUser(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
