package software.amazon.awscdk.services.connectcampaigns;

/**
 * A CloudFormation `AWS::ConnectCampaigns::Campaign`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connectcampaigns.*;
 * CfnCampaign cfnCampaign = CfnCampaign.Builder.create(this, "MyCfnCampaign")
 *         .connectInstanceArn("connectInstanceArn")
 *         .dialerConfig(DialerConfigProperty.builder()
 *                 .predictiveDialerConfig(PredictiveDialerConfigProperty.builder()
 *                         .bandwidthAllocation(123)
 *                         .build())
 *                 .progressiveDialerConfig(ProgressiveDialerConfigProperty.builder()
 *                         .bandwidthAllocation(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .outboundCallConfig(OutboundCallConfigProperty.builder()
 *                 .connectContactFlowArn("connectContactFlowArn")
 *                 .connectQueueArn("connectQueueArn")
 *                 // the properties below are optional
 *                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:01.699Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign")
public class CfnCampaign extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCampaign(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ConnectCampaigns::Campaign`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCampaign(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaigns.CfnCampaignProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.ConnectInstanceArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "connectInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.ConnectInstanceArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectInstanceArn", java.util.Objects.requireNonNull(value, "connectInstanceArn is required"));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.DialerConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDialerConfig() {
        return software.amazon.jsii.Kernel.get(this, "dialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.DialerConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDialerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaigns.CfnCampaign.DialerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dialerConfig", java.util.Objects.requireNonNull(value, "dialerConfig is required"));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.DialerConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDialerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dialerConfig", java.util.Objects.requireNonNull(value, "dialerConfig is required"));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.OutboundCallConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutboundCallConfig() {
        return software.amazon.jsii.Kernel.get(this, "outboundCallConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.OutboundCallConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutboundCallConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaigns.CfnCampaign.OutboundCallConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "outboundCallConfig", java.util.Objects.requireNonNull(value, "outboundCallConfig is required"));
    }

    /**
     * `AWS::ConnectCampaigns::Campaign.OutboundCallConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutboundCallConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outboundCallConfig", java.util.Objects.requireNonNull(value, "outboundCallConfig is required"));
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * DialerConfigProperty dialerConfigProperty = DialerConfigProperty.builder()
     *         .predictiveDialerConfig(PredictiveDialerConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 .build())
     *         .progressiveDialerConfig(ProgressiveDialerConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.DialerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DialerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DialerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCampaign.DialerConfigProperty.PredictiveDialerConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveDialerConfig() {
            return null;
        }

        /**
         * `CfnCampaign.DialerConfigProperty.ProgressiveDialerConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProgressiveDialerConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DialerConfigProperty> {
            java.lang.Object predictiveDialerConfig;
            java.lang.Object progressiveDialerConfig;

            /**
             * Sets the value of {@link DialerConfigProperty#getPredictiveDialerConfig}
             * @param predictiveDialerConfig `CfnCampaign.DialerConfigProperty.PredictiveDialerConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveDialerConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.PredictiveDialerConfigProperty predictiveDialerConfig) {
                this.predictiveDialerConfig = predictiveDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getPredictiveDialerConfig}
             * @param predictiveDialerConfig `CfnCampaign.DialerConfigProperty.PredictiveDialerConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveDialerConfig(software.amazon.awscdk.IResolvable predictiveDialerConfig) {
                this.predictiveDialerConfig = predictiveDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getProgressiveDialerConfig}
             * @param progressiveDialerConfig `CfnCampaign.DialerConfigProperty.ProgressiveDialerConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveDialerConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.ProgressiveDialerConfigProperty progressiveDialerConfig) {
                this.progressiveDialerConfig = progressiveDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getProgressiveDialerConfig}
             * @param progressiveDialerConfig `CfnCampaign.DialerConfigProperty.ProgressiveDialerConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveDialerConfig(software.amazon.awscdk.IResolvable progressiveDialerConfig) {
                this.progressiveDialerConfig = progressiveDialerConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DialerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DialerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DialerConfigProperty {
            private final java.lang.Object predictiveDialerConfig;
            private final java.lang.Object progressiveDialerConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predictiveDialerConfig = software.amazon.jsii.Kernel.get(this, "predictiveDialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.progressiveDialerConfig = software.amazon.jsii.Kernel.get(this, "progressiveDialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predictiveDialerConfig = builder.predictiveDialerConfig;
                this.progressiveDialerConfig = builder.progressiveDialerConfig;
            }

            @Override
            public final java.lang.Object getPredictiveDialerConfig() {
                return this.predictiveDialerConfig;
            }

            @Override
            public final java.lang.Object getProgressiveDialerConfig() {
                return this.progressiveDialerConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPredictiveDialerConfig() != null) {
                    data.set("predictiveDialerConfig", om.valueToTree(this.getPredictiveDialerConfig()));
                }
                if (this.getProgressiveDialerConfig() != null) {
                    data.set("progressiveDialerConfig", om.valueToTree(this.getProgressiveDialerConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.DialerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DialerConfigProperty.Jsii$Proxy that = (DialerConfigProperty.Jsii$Proxy) o;

                if (this.predictiveDialerConfig != null ? !this.predictiveDialerConfig.equals(that.predictiveDialerConfig) : that.predictiveDialerConfig != null) return false;
                return this.progressiveDialerConfig != null ? this.progressiveDialerConfig.equals(that.progressiveDialerConfig) : that.progressiveDialerConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predictiveDialerConfig != null ? this.predictiveDialerConfig.hashCode() : 0;
                result = 31 * result + (this.progressiveDialerConfig != null ? this.progressiveDialerConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * OutboundCallConfigProperty outboundCallConfigProperty = OutboundCallConfigProperty.builder()
     *         .connectContactFlowArn("connectContactFlowArn")
     *         .connectQueueArn("connectQueueArn")
     *         // the properties below are optional
     *         .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.OutboundCallConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OutboundCallConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutboundCallConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCampaign.OutboundCallConfigProperty.ConnectContactFlowArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectContactFlowArn();

        /**
         * `CfnCampaign.OutboundCallConfigProperty.ConnectQueueArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectQueueArn();

        /**
         * `CfnCampaign.OutboundCallConfigProperty.ConnectSourcePhoneNumber`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectSourcePhoneNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutboundCallConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutboundCallConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutboundCallConfigProperty> {
            java.lang.String connectContactFlowArn;
            java.lang.String connectQueueArn;
            java.lang.String connectSourcePhoneNumber;

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getConnectContactFlowArn}
             * @param connectContactFlowArn `CfnCampaign.OutboundCallConfigProperty.ConnectContactFlowArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectContactFlowArn(java.lang.String connectContactFlowArn) {
                this.connectContactFlowArn = connectContactFlowArn;
                return this;
            }

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getConnectQueueArn}
             * @param connectQueueArn `CfnCampaign.OutboundCallConfigProperty.ConnectQueueArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectQueueArn(java.lang.String connectQueueArn) {
                this.connectQueueArn = connectQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getConnectSourcePhoneNumber}
             * @param connectSourcePhoneNumber `CfnCampaign.OutboundCallConfigProperty.ConnectSourcePhoneNumber`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourcePhoneNumber(java.lang.String connectSourcePhoneNumber) {
                this.connectSourcePhoneNumber = connectSourcePhoneNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutboundCallConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutboundCallConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutboundCallConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutboundCallConfigProperty {
            private final java.lang.String connectContactFlowArn;
            private final java.lang.String connectQueueArn;
            private final java.lang.String connectSourcePhoneNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectContactFlowArn = software.amazon.jsii.Kernel.get(this, "connectContactFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectQueueArn = software.amazon.jsii.Kernel.get(this, "connectQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectSourcePhoneNumber = software.amazon.jsii.Kernel.get(this, "connectSourcePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectContactFlowArn = java.util.Objects.requireNonNull(builder.connectContactFlowArn, "connectContactFlowArn is required");
                this.connectQueueArn = java.util.Objects.requireNonNull(builder.connectQueueArn, "connectQueueArn is required");
                this.connectSourcePhoneNumber = builder.connectSourcePhoneNumber;
            }

            @Override
            public final java.lang.String getConnectContactFlowArn() {
                return this.connectContactFlowArn;
            }

            @Override
            public final java.lang.String getConnectQueueArn() {
                return this.connectQueueArn;
            }

            @Override
            public final java.lang.String getConnectSourcePhoneNumber() {
                return this.connectSourcePhoneNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectContactFlowArn", om.valueToTree(this.getConnectContactFlowArn()));
                data.set("connectQueueArn", om.valueToTree(this.getConnectQueueArn()));
                if (this.getConnectSourcePhoneNumber() != null) {
                    data.set("connectSourcePhoneNumber", om.valueToTree(this.getConnectSourcePhoneNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.OutboundCallConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutboundCallConfigProperty.Jsii$Proxy that = (OutboundCallConfigProperty.Jsii$Proxy) o;

                if (!connectContactFlowArn.equals(that.connectContactFlowArn)) return false;
                if (!connectQueueArn.equals(that.connectQueueArn)) return false;
                return this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.equals(that.connectSourcePhoneNumber) : that.connectSourcePhoneNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectContactFlowArn.hashCode();
                result = 31 * result + (this.connectQueueArn.hashCode());
                result = 31 * result + (this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * PredictiveDialerConfigProperty predictiveDialerConfigProperty = PredictiveDialerConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.PredictiveDialerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveDialerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveDialerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCampaign.PredictiveDialerConfigProperty.BandwidthAllocation`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * @return a {@link Builder} of {@link PredictiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveDialerConfigProperty> {
            java.lang.Number bandwidthAllocation;

            /**
             * Sets the value of {@link PredictiveDialerConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation `CfnCampaign.PredictiveDialerConfigProperty.BandwidthAllocation`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveDialerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveDialerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveDialerConfigProperty {
            private final java.lang.Number bandwidthAllocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.PredictiveDialerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveDialerConfigProperty.Jsii$Proxy that = (PredictiveDialerConfigProperty.Jsii$Proxy) o;

                return this.bandwidthAllocation.equals(that.bandwidthAllocation);
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * ProgressiveDialerConfigProperty progressiveDialerConfigProperty = ProgressiveDialerConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.ProgressiveDialerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProgressiveDialerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProgressiveDialerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCampaign.ProgressiveDialerConfigProperty.BandwidthAllocation`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * @return a {@link Builder} of {@link ProgressiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProgressiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProgressiveDialerConfigProperty> {
            java.lang.Number bandwidthAllocation;

            /**
             * Sets the value of {@link ProgressiveDialerConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation `CfnCampaign.ProgressiveDialerConfigProperty.BandwidthAllocation`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProgressiveDialerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProgressiveDialerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProgressiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProgressiveDialerConfigProperty {
            private final java.lang.Number bandwidthAllocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.ProgressiveDialerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProgressiveDialerConfigProperty.Jsii$Proxy that = (ProgressiveDialerConfigProperty.Jsii$Proxy) o;

                return this.bandwidthAllocation.equals(that.bandwidthAllocation);
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connectcampaigns.CfnCampaign}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connectcampaigns.CfnCampaign> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connectcampaigns.CfnCampaignProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connectcampaigns.CfnCampaignProps.Builder();
        }

        /**
         * `AWS::ConnectCampaigns::Campaign.ConnectInstanceArn`.
         * <p>
         * @return {@code this}
         * @param connectInstanceArn `AWS::ConnectCampaigns::Campaign.ConnectInstanceArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectInstanceArn(final java.lang.String connectInstanceArn) {
            this.props.connectInstanceArn(connectInstanceArn);
            return this;
        }

        /**
         * `AWS::ConnectCampaigns::Campaign.DialerConfig`.
         * <p>
         * @return {@code this}
         * @param dialerConfig `AWS::ConnectCampaigns::Campaign.DialerConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dialerConfig(final software.amazon.awscdk.services.connectcampaigns.CfnCampaign.DialerConfigProperty dialerConfig) {
            this.props.dialerConfig(dialerConfig);
            return this;
        }
        /**
         * `AWS::ConnectCampaigns::Campaign.DialerConfig`.
         * <p>
         * @return {@code this}
         * @param dialerConfig `AWS::ConnectCampaigns::Campaign.DialerConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dialerConfig(final software.amazon.awscdk.IResolvable dialerConfig) {
            this.props.dialerConfig(dialerConfig);
            return this;
        }

        /**
         * `AWS::ConnectCampaigns::Campaign.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::ConnectCampaigns::Campaign.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::ConnectCampaigns::Campaign.OutboundCallConfig`.
         * <p>
         * @return {@code this}
         * @param outboundCallConfig `AWS::ConnectCampaigns::Campaign.OutboundCallConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallConfig(final software.amazon.awscdk.services.connectcampaigns.CfnCampaign.OutboundCallConfigProperty outboundCallConfig) {
            this.props.outboundCallConfig(outboundCallConfig);
            return this;
        }
        /**
         * `AWS::ConnectCampaigns::Campaign.OutboundCallConfig`.
         * <p>
         * @return {@code this}
         * @param outboundCallConfig `AWS::ConnectCampaigns::Campaign.OutboundCallConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallConfig(final software.amazon.awscdk.IResolvable outboundCallConfig) {
            this.props.outboundCallConfig(outboundCallConfig);
            return this;
        }

        /**
         * `AWS::ConnectCampaigns::Campaign.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::ConnectCampaigns::Campaign.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.connectcampaigns.CfnCampaign}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connectcampaigns.CfnCampaign build() {
            return new software.amazon.awscdk.services.connectcampaigns.CfnCampaign(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
