package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::CapacityReservationFleet`.
 * <p>
 * Creates a new Capacity Reservation Fleet with the specified attributes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-fleets.html">Capacity Reservation Fleets</a> in the <em>Amazon EC2 User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnCapacityReservationFleet cfnCapacityReservationFleet = CfnCapacityReservationFleet.Builder.create(this, "MyCfnCapacityReservationFleet")
 *         .allocationStrategy("allocationStrategy")
 *         .endDate("endDate")
 *         .instanceMatchCriteria("instanceMatchCriteria")
 *         .instanceTypeSpecifications(List.of(InstanceTypeSpecificationProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .availabilityZoneId("availabilityZoneId")
 *                 .ebsOptimized(false)
 *                 .instancePlatform("instancePlatform")
 *                 .instanceType("instanceType")
 *                 .priority(123)
 *                 .weight(123)
 *                 .build()))
 *         .noRemoveEndDate(false)
 *         .removeEndDate(false)
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .tenancy("tenancy")
 *         .totalTargetCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:02.046Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnCapacityReservationFleet")
public class CfnCapacityReservationFleet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCapacityReservationFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityReservationFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::CapacityReservationFleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityReservationFleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::EC2::CapacityReservationFleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityReservationFleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the Capacity Reservation Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCapacityReservationFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrCapacityReservationFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use.
     * <p>
     * Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy">Allocation strategy</a> in the Amazon EC2 User Guide.
     * <p>
     * Valid values: <code>prioritized</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
        return software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use.
     * <p>
     * Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy">Allocation strategy</a> in the Amazon EC2 User Guide.
     * <p>
     * Valid values: <code>prioritized</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocationStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "allocationStrategy", value);
    }

    /**
     * The date and time at which the Capacity Reservation Fleet expires.
     * <p>
     * When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.
     * <p>
     * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code> , <code>13:30:55</code> , the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time at which the Capacity Reservation Fleet expires.
     * <p>
     * When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.
     * <p>
     * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code> , <code>13:30:55</code> , the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndDate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endDate", value);
    }

    /**
     * Indicates the type of instance launches that the Capacity Reservation Fleet accepts.
     * <p>
     * All Capacity Reservations in the Fleet inherit this instance matching criteria.
     * <p>
     * Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceMatchCriteria() {
        return software.amazon.jsii.Kernel.get(this, "instanceMatchCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the type of instance launches that the Capacity Reservation Fleet accepts.
     * <p>
     * All Capacity Reservations in the Fleet inherit this instance matching criteria.
     * <p>
     * Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceMatchCriteria(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceMatchCriteria", value);
    }

    /**
     * Information about the instance types for which to reserve the capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceTypeSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "instanceTypeSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the instance types for which to reserve the capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceTypeSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceTypeSpecifications", value);
    }

    /**
     * Information about the instance types for which to reserve the capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceTypeSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet.InstanceTypeSpecificationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet.InstanceTypeSpecificationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "instanceTypeSpecifications", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNoRemoveEndDate() {
        return software.amazon.jsii.Kernel.get(this, "noRemoveEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNoRemoveEndDate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "noRemoveEndDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNoRemoveEndDate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "noRemoveEndDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRemoveEndDate() {
        return software.amazon.jsii.Kernel.get(this, "removeEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveEndDate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "removeEndDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveEndDate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "removeEndDate", value);
    }

    /**
     * The tags to assign to the Capacity Reservation Fleet.
     * <p>
     * The tags are automatically assigned to the Capacity Reservations in the Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tags to assign to the Capacity Reservation Fleet.
     * <p>
     * The tags are automatically assigned to the Capacity Reservations in the Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * The tags to assign to the Capacity Reservation Fleet.
     * <p>
     * The tags are automatically assigned to the Capacity Reservations in the Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet.TagSpecificationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet.TagSpecificationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * Indicates the tenancy of the Capacity Reservation Fleet.
     * <p>
     * All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:
     * <p>
     * <ul>
     * <li><code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other AWS accounts .</li>
     * <li><code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single AWS account .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the tenancy of the Capacity Reservation Fleet.
     * <p>
     * All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:
     * <p>
     * <ul>
     * <li><code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other AWS accounts .</li>
     * <li><code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single AWS account .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTenancy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tenancy", value);
    }

    /**
     * The total number of capacity units to be reserved by the Capacity Reservation Fleet.
     * <p>
     * This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the Amazon EC2 User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTotalTargetCapacity() {
        return software.amazon.jsii.Kernel.get(this, "totalTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The total number of capacity units to be reserved by the Capacity Reservation Fleet.
     * <p>
     * This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the Amazon EC2 User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTotalTargetCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "totalTargetCapacity", value);
    }
    /**
     * Specifies information about an instance type to use in a Capacity Reservation Fleet.
     * <p>
     * <code>InstanceTypeSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html">AWS::EC2::CapacityReservationFleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceTypeSpecificationProperty instanceTypeSpecificationProperty = InstanceTypeSpecificationProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .availabilityZoneId("availabilityZoneId")
     *         .ebsOptimized(false)
     *         .instancePlatform("instancePlatform")
     *         .instanceType("instanceType")
     *         .priority(123)
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnCapacityReservationFleet.InstanceTypeSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceTypeSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceTypeSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity.
         * <p>
         * A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity.
         * <p>
         * A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
            return null;
        }

        /**
         * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types.
         * <p>
         * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using EBS-optimized instance types.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstancePlatform() {
            return null;
        }

        /**
         * The instance type for which the Capacity Reservation Fleet reserves capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The priority to assign to the instance type.
         * <p>
         * This value is used to determine which of the instance types specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance type priority</a> in the Amazon EC2 User Guide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * The number of capacity units provided by the specified instance type.
         * <p>
         * This value, together with the total target capacity that you specify for the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the Amazon EC2 User Guide.
         * <p>
         * Valid Range: Minimum value of <code>0.001</code> . Maximum value of <code>99.999</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceTypeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceTypeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceTypeSpecificationProperty> {
            java.lang.String availabilityZone;
            java.lang.String availabilityZoneId;
            java.lang.Object ebsOptimized;
            java.lang.String instancePlatform;
            java.lang.String instanceType;
            java.lang.Number priority;
            java.lang.Number weight;

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone in which the Capacity Reservation Fleet reserves the capacity.
             *                         A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getAvailabilityZoneId}
             * @param availabilityZoneId The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity.
             *                           A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZoneId(java.lang.String availabilityZoneId) {
                this.availabilityZoneId = availabilityZoneId;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types.
             *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using EBS-optimized instance types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types.
             *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using EBS-optimized instance types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getInstancePlatform}
             * @param instancePlatform The type of operating system for which the Capacity Reservation Fleet reserves capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePlatform(java.lang.String instancePlatform) {
                this.instancePlatform = instancePlatform;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getInstanceType}
             * @param instanceType The instance type for which the Capacity Reservation Fleet reserves capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getPriority}
             * @param priority The priority to assign to the instance type.
             *                 This value is used to determine which of the instance types specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance type priority</a> in the Amazon EC2 User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getWeight}
             * @param weight The number of capacity units provided by the specified instance type.
             *               This value, together with the total target capacity that you specify for the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the Amazon EC2 User Guide.
             *               <p>
             *               Valid Range: Minimum value of <code>0.001</code> . Maximum value of <code>99.999</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceTypeSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceTypeSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceTypeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceTypeSpecificationProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String availabilityZoneId;
            private final java.lang.Object ebsOptimized;
            private final java.lang.String instancePlatform;
            private final java.lang.String instanceType;
            private final java.lang.Number priority;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZoneId = software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instancePlatform = software.amazon.jsii.Kernel.get(this, "instancePlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.availabilityZoneId = builder.availabilityZoneId;
                this.ebsOptimized = builder.ebsOptimized;
                this.instancePlatform = builder.instancePlatform;
                this.instanceType = builder.instanceType;
                this.priority = builder.priority;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getAvailabilityZoneId() {
                return this.availabilityZoneId;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public final java.lang.String getInstancePlatform() {
                return this.instancePlatform;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getAvailabilityZoneId() != null) {
                    data.set("availabilityZoneId", om.valueToTree(this.getAvailabilityZoneId()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }
                if (this.getInstancePlatform() != null) {
                    data.set("instancePlatform", om.valueToTree(this.getInstancePlatform()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnCapacityReservationFleet.InstanceTypeSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceTypeSpecificationProperty.Jsii$Proxy that = (InstanceTypeSpecificationProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.availabilityZoneId != null ? !this.availabilityZoneId.equals(that.availabilityZoneId) : that.availabilityZoneId != null) return false;
                if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
                if (this.instancePlatform != null ? !this.instancePlatform.equals(that.instancePlatform) : that.instancePlatform != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.availabilityZoneId != null ? this.availabilityZoneId.hashCode() : 0);
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                result = 31 * result + (this.instancePlatform != null ? this.instancePlatform.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The tags to apply to a resource when the resource is being created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnCapacityReservationFleet.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to tag on creation. Specify `capacity-reservation-fleet` .
         * <p>
         * To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The tags to apply to the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource to tag on creation. Specify `capacity-reservation-fleet` .
             *                     To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags The tags to apply to the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnCapacityReservationFleet.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use.
         * <p>
         * Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy">Allocation strategy</a> in the Amazon EC2 User Guide.
         * <p>
         * Valid values: <code>prioritized</code>
         * <p>
         * @return {@code this}
         * @param allocationStrategy The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationStrategy(final java.lang.String allocationStrategy) {
            this.props().allocationStrategy(allocationStrategy);
            return this;
        }

        /**
         * The date and time at which the Capacity Reservation Fleet expires.
         * <p>
         * When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.
         * <p>
         * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code> , <code>13:30:55</code> , the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code> .
         * <p>
         * @return {@code this}
         * @param endDate The date and time at which the Capacity Reservation Fleet expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(final java.lang.String endDate) {
            this.props().endDate(endDate);
            return this;
        }

        /**
         * Indicates the type of instance launches that the Capacity Reservation Fleet accepts.
         * <p>
         * All Capacity Reservations in the Fleet inherit this instance matching criteria.
         * <p>
         * Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
         * <p>
         * @return {@code this}
         * @param instanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation Fleet accepts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMatchCriteria(final java.lang.String instanceMatchCriteria) {
            this.props().instanceMatchCriteria(instanceMatchCriteria);
            return this;
        }

        /**
         * Information about the instance types for which to reserve the capacity.
         * <p>
         * @return {@code this}
         * @param instanceTypeSpecifications Information about the instance types for which to reserve the capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(final software.amazon.awscdk.IResolvable instanceTypeSpecifications) {
            this.props().instanceTypeSpecifications(instanceTypeSpecifications);
            return this;
        }
        /**
         * Information about the instance types for which to reserve the capacity.
         * <p>
         * @return {@code this}
         * @param instanceTypeSpecifications Information about the instance types for which to reserve the capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(final java.util.List<? extends java.lang.Object> instanceTypeSpecifications) {
            this.props().instanceTypeSpecifications(instanceTypeSpecifications);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param noRemoveEndDate `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(final java.lang.Boolean noRemoveEndDate) {
            this.props().noRemoveEndDate(noRemoveEndDate);
            return this;
        }
        /**
         * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param noRemoveEndDate `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(final software.amazon.awscdk.IResolvable noRemoveEndDate) {
            this.props().noRemoveEndDate(noRemoveEndDate);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param removeEndDate `AWS::EC2::CapacityReservationFleet.RemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(final java.lang.Boolean removeEndDate) {
            this.props().removeEndDate(removeEndDate);
            return this;
        }
        /**
         * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param removeEndDate `AWS::EC2::CapacityReservationFleet.RemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(final software.amazon.awscdk.IResolvable removeEndDate) {
            this.props().removeEndDate(removeEndDate);
            return this;
        }

        /**
         * The tags to assign to the Capacity Reservation Fleet.
         * <p>
         * The tags are automatically assigned to the Capacity Reservations in the Fleet.
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to assign to the Capacity Reservation Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.IResolvable tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * The tags to assign to the Capacity Reservation Fleet.
         * <p>
         * The tags are automatically assigned to the Capacity Reservations in the Fleet.
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to assign to the Capacity Reservation Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * Indicates the tenancy of the Capacity Reservation Fleet.
         * <p>
         * All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:
         * <p>
         * <ul>
         * <li><code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other AWS accounts .</li>
         * <li><code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single AWS account .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param tenancy Indicates the tenancy of the Capacity Reservation Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(final java.lang.String tenancy) {
            this.props().tenancy(tenancy);
            return this;
        }

        /**
         * The total number of capacity units to be reserved by the Capacity Reservation Fleet.
         * <p>
         * This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the Amazon EC2 User Guide.
         * <p>
         * @return {@code this}
         * @param totalTargetCapacity The total number of capacity units to be reserved by the Capacity Reservation Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTargetCapacity(final java.lang.Number totalTargetCapacity) {
            this.props().totalTargetCapacity(totalTargetCapacity);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet build() {
            return new software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps.Builder();
            }
            return this.props;
        }
    }
}
