package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnHost`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnHostProps cfnHostProps = CfnHostProps.builder()
 *         .availabilityZone("availabilityZone")
 *         // the properties below are optional
 *         .autoPlacement("autoPlacement")
 *         .hostRecovery("hostRecovery")
 *         .instanceFamily("instanceFamily")
 *         .instanceType("instanceType")
 *         .outpostArn("outpostArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:02.111Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnHostProps")
@software.amazon.jsii.Jsii.Proxy(CfnHostProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHostProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Availability Zone in which to allocate the Dedicated Host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

    /**
     * Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding">Understanding auto-placement and affinity</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Default: <code>on</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoPlacement() {
        return null;
    }

    /**
     * Indicates whether to enable or disable host recovery for the Dedicated Host.
     * <p>
     * Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">Host recovery</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Default: <code>off</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostRecovery() {
        return null;
    }

    /**
     * `AWS::EC2::Host.InstanceFamily`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceFamily() {
        return null;
    }

    /**
     * Specifies the instance type to be supported by the Dedicated Hosts.
     * <p>
     * If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
        return null;
    }

    /**
     * `AWS::EC2::Host.OutpostArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutpostArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHostProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHostProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHostProps> {
        java.lang.String availabilityZone;
        java.lang.String autoPlacement;
        java.lang.String hostRecovery;
        java.lang.String instanceFamily;
        java.lang.String instanceType;
        java.lang.String outpostArn;

        /**
         * Sets the value of {@link CfnHostProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone in which to allocate the Dedicated Host. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostProps#getAutoPlacement}
         * @param autoPlacement Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID.
         *                      For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding">Understanding auto-placement and affinity</a> in the <em>Amazon EC2 User Guide</em> .
         *                      <p>
         *                      Default: <code>on</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPlacement(java.lang.String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostProps#getHostRecovery}
         * @param hostRecovery Indicates whether to enable or disable host recovery for the Dedicated Host.
         *                     Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">Host recovery</a> in the <em>Amazon EC2 User Guide</em> .
         *                     <p>
         *                     Default: <code>off</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostRecovery(java.lang.String hostRecovery) {
            this.hostRecovery = hostRecovery;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostProps#getInstanceFamily}
         * @param instanceFamily `AWS::EC2::Host.InstanceFamily`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceFamily(java.lang.String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostProps#getInstanceType}
         * @param instanceType Specifies the instance type to be supported by the Dedicated Hosts.
         *                     If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostProps#getOutpostArn}
         * @param outpostArn `AWS::EC2::Host.OutpostArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostArn(java.lang.String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHostProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHostProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnHostProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHostProps {
        private final java.lang.String availabilityZone;
        private final java.lang.String autoPlacement;
        private final java.lang.String hostRecovery;
        private final java.lang.String instanceFamily;
        private final java.lang.String instanceType;
        private final java.lang.String outpostArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoPlacement = software.amazon.jsii.Kernel.get(this, "autoPlacement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostRecovery = software.amazon.jsii.Kernel.get(this, "hostRecovery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceFamily = software.amazon.jsii.Kernel.get(this, "instanceFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outpostArn = software.amazon.jsii.Kernel.get(this, "outpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(builder.availabilityZone, "availabilityZone is required");
            this.autoPlacement = builder.autoPlacement;
            this.hostRecovery = builder.hostRecovery;
            this.instanceFamily = builder.instanceFamily;
            this.instanceType = builder.instanceType;
            this.outpostArn = builder.outpostArn;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getAutoPlacement() {
            return this.autoPlacement;
        }

        @Override
        public final java.lang.String getHostRecovery() {
            return this.hostRecovery;
        }

        @Override
        public final java.lang.String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            if (this.getAutoPlacement() != null) {
                data.set("autoPlacement", om.valueToTree(this.getAutoPlacement()));
            }
            if (this.getHostRecovery() != null) {
                data.set("hostRecovery", om.valueToTree(this.getHostRecovery()));
            }
            if (this.getInstanceFamily() != null) {
                data.set("instanceFamily", om.valueToTree(this.getInstanceFamily()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getOutpostArn() != null) {
                data.set("outpostArn", om.valueToTree(this.getOutpostArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnHostProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHostProps.Jsii$Proxy that = (CfnHostProps.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (this.autoPlacement != null ? !this.autoPlacement.equals(that.autoPlacement) : that.autoPlacement != null) return false;
            if (this.hostRecovery != null ? !this.hostRecovery.equals(that.hostRecovery) : that.hostRecovery != null) return false;
            if (this.instanceFamily != null ? !this.instanceFamily.equals(that.instanceFamily) : that.instanceFamily != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            return this.outpostArn != null ? this.outpostArn.equals(that.outpostArn) : that.outpostArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.autoPlacement != null ? this.autoPlacement.hashCode() : 0);
            result = 31 * result + (this.hostRecovery != null ? this.hostRecovery.hashCode() : 0);
            result = 31 * result + (this.instanceFamily != null ? this.instanceFamily.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.outpostArn != null ? this.outpostArn.hashCode() : 0);
            return result;
        }
    }
}
