package software.amazon.awscdk.services.events;

/**
 * Properties for defining a `CfnApiDestination`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * CfnApiDestinationProps cfnApiDestinationProps = CfnApiDestinationProps.builder()
 *         .connectionArn("connectionArn")
 *         .httpMethod("httpMethod")
 *         .invocationEndpoint("invocationEndpoint")
 *         // the properties below are optional
 *         .description("description")
 *         .invocationRateLimitPerSecond(123)
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:03.183Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnApiDestinationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApiDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApiDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the connection to use for the API destination.
     * <p>
     * The destination endpoint must support the authorization type specified for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionArn();

    /**
     * The method to use for the request to the HTTP invocation endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod();

    /**
     * The URL to the HTTP invocation endpoint for the API destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInvocationEndpoint();

    /**
     * A description for the API destination to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The maximum number of requests per second to send to the HTTP invocation endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInvocationRateLimitPerSecond() {
        return null;
    }

    /**
     * The name for the API destination to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApiDestinationProps> {
        java.lang.String connectionArn;
        java.lang.String httpMethod;
        java.lang.String invocationEndpoint;
        java.lang.String description;
        java.lang.Number invocationRateLimitPerSecond;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnApiDestinationProps#getConnectionArn}
         * @param connectionArn The ARN of the connection to use for the API destination. This parameter is required.
         *                      The destination endpoint must support the authorization type specified for the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(java.lang.String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiDestinationProps#getHttpMethod}
         * @param httpMethod The method to use for the request to the HTTP invocation endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(java.lang.String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiDestinationProps#getInvocationEndpoint}
         * @param invocationEndpoint The URL to the HTTP invocation endpoint for the API destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationEndpoint(java.lang.String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiDestinationProps#getDescription}
         * @param description A description for the API destination to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiDestinationProps#getInvocationRateLimitPerSecond}
         * @param invocationRateLimitPerSecond The maximum number of requests per second to send to the HTTP invocation endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationRateLimitPerSecond(java.lang.Number invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiDestinationProps#getName}
         * @param name The name for the API destination to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApiDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApiDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApiDestinationProps {
        private final java.lang.String connectionArn;
        private final java.lang.String httpMethod;
        private final java.lang.String invocationEndpoint;
        private final java.lang.String description;
        private final java.lang.Number invocationRateLimitPerSecond;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invocationEndpoint = software.amazon.jsii.Kernel.get(this, "invocationEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invocationRateLimitPerSecond = software.amazon.jsii.Kernel.get(this, "invocationRateLimitPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionArn = java.util.Objects.requireNonNull(builder.connectionArn, "connectionArn is required");
            this.httpMethod = java.util.Objects.requireNonNull(builder.httpMethod, "httpMethod is required");
            this.invocationEndpoint = java.util.Objects.requireNonNull(builder.invocationEndpoint, "invocationEndpoint is required");
            this.description = builder.description;
            this.invocationRateLimitPerSecond = builder.invocationRateLimitPerSecond;
            this.name = builder.name;
        }

        @Override
        public final java.lang.String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        public final java.lang.String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.String getInvocationEndpoint() {
            return this.invocationEndpoint;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getInvocationRateLimitPerSecond() {
            return this.invocationRateLimitPerSecond;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
            data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            data.set("invocationEndpoint", om.valueToTree(this.getInvocationEndpoint()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getInvocationRateLimitPerSecond() != null) {
                data.set("invocationRateLimitPerSecond", om.valueToTree(this.getInvocationRateLimitPerSecond()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnApiDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApiDestinationProps.Jsii$Proxy that = (CfnApiDestinationProps.Jsii$Proxy) o;

            if (!connectionArn.equals(that.connectionArn)) return false;
            if (!httpMethod.equals(that.httpMethod)) return false;
            if (!invocationEndpoint.equals(that.invocationEndpoint)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.invocationRateLimitPerSecond != null ? !this.invocationRateLimitPerSecond.equals(that.invocationRateLimitPerSecond) : that.invocationRateLimitPerSecond != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionArn.hashCode();
            result = 31 * result + (this.httpMethod.hashCode());
            result = 31 * result + (this.invocationEndpoint.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.invocationRateLimitPerSecond != null ? this.invocationRateLimitPerSecond.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
