package software.amazon.awscdk.services.events;

/**
 * Properties for defining a `CfnEndpoint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * CfnEndpointProps cfnEndpointProps = CfnEndpointProps.builder()
 *         .eventBuses(List.of(EndpointEventBusProperty.builder()
 *                 .eventBusArn("eventBusArn")
 *                 .build()))
 *         .name("name")
 *         .routingConfig(RoutingConfigProperty.builder()
 *                 .failoverConfig(FailoverConfigProperty.builder()
 *                         .primary(PrimaryProperty.builder()
 *                                 .healthCheck("healthCheck")
 *                                 .build())
 *                         .secondary(SecondaryProperty.builder()
 *                                 .route("route")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .replicationConfig(ReplicationConfigProperty.builder()
 *                 .state("state")
 *                 .build())
 *         .roleArn("roleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:03.191Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The event buses being used by the endpoint.
     * <p>
     * <em>Exactly</em> : <code>2</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEventBuses();

    /**
     * The name of the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The routing configuration of the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRoutingConfig();

    /**
     * A description for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Whether event replication was enabled or disabled for this endpoint.
     * <p>
     * The default state is <code>ENABLED</code> which means you must supply a <code>RoleArn</code> . If you don't have a <code>RoleArn</code> or you don't want event replication enabled, set the state to <code>DISABLED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationConfig() {
        return null;
    }

    /**
     * The ARN of the role used by event replication for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointProps> {
        java.lang.Object eventBuses;
        java.lang.String name;
        java.lang.Object routingConfig;
        java.lang.String description;
        java.lang.Object replicationConfig;
        java.lang.String roleArn;

        /**
         * Sets the value of {@link CfnEndpointProps#getEventBuses}
         * @param eventBuses The event buses being used by the endpoint. This parameter is required.
         *                   <em>Exactly</em> : <code>2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBuses(software.amazon.awscdk.IResolvable eventBuses) {
            this.eventBuses = eventBuses;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getEventBuses}
         * @param eventBuses The event buses being used by the endpoint. This parameter is required.
         *                   <em>Exactly</em> : <code>2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBuses(java.util.List<? extends java.lang.Object> eventBuses) {
            this.eventBuses = eventBuses;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getName}
         * @param name The name of the endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRoutingConfig}
         * @param routingConfig The routing configuration of the endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfig(software.amazon.awscdk.services.events.CfnEndpoint.RoutingConfigProperty routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRoutingConfig}
         * @param routingConfig The routing configuration of the endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfig(software.amazon.awscdk.IResolvable routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getDescription}
         * @param description A description for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getReplicationConfig}
         * @param replicationConfig Whether event replication was enabled or disabled for this endpoint.
         *                          The default state is <code>ENABLED</code> which means you must supply a <code>RoleArn</code> . If you don't have a <code>RoleArn</code> or you don't want event replication enabled, set the state to <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfig(software.amazon.awscdk.services.events.CfnEndpoint.ReplicationConfigProperty replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getReplicationConfig}
         * @param replicationConfig Whether event replication was enabled or disabled for this endpoint.
         *                          The default state is <code>ENABLED</code> which means you must supply a <code>RoleArn</code> . If you don't have a <code>RoleArn</code> or you don't want event replication enabled, set the state to <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfig(software.amazon.awscdk.IResolvable replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRoleArn}
         * @param roleArn The ARN of the role used by event replication for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointProps {
        private final java.lang.Object eventBuses;
        private final java.lang.String name;
        private final java.lang.Object routingConfig;
        private final java.lang.String description;
        private final java.lang.Object replicationConfig;
        private final java.lang.String roleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventBuses = software.amazon.jsii.Kernel.get(this, "eventBuses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routingConfig = software.amazon.jsii.Kernel.get(this, "routingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationConfig = software.amazon.jsii.Kernel.get(this, "replicationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventBuses = java.util.Objects.requireNonNull(builder.eventBuses, "eventBuses is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.routingConfig = java.util.Objects.requireNonNull(builder.routingConfig, "routingConfig is required");
            this.description = builder.description;
            this.replicationConfig = builder.replicationConfig;
            this.roleArn = builder.roleArn;
        }

        @Override
        public final java.lang.Object getEventBuses() {
            return this.eventBuses;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRoutingConfig() {
            return this.routingConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getReplicationConfig() {
            return this.replicationConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventBuses", om.valueToTree(this.getEventBuses()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("routingConfig", om.valueToTree(this.getRoutingConfig()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getReplicationConfig() != null) {
                data.set("replicationConfig", om.valueToTree(this.getReplicationConfig()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointProps.Jsii$Proxy that = (CfnEndpointProps.Jsii$Proxy) o;

            if (!eventBuses.equals(that.eventBuses)) return false;
            if (!name.equals(that.name)) return false;
            if (!routingConfig.equals(that.routingConfig)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.replicationConfig != null ? !this.replicationConfig.equals(that.replicationConfig) : that.replicationConfig != null) return false;
            return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventBuses.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.routingConfig.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.replicationConfig != null ? this.replicationConfig.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            return result;
        }
    }
}
