package software.amazon.awscdk.services.events;

/**
 * Interface with properties necessary to import a reusable Connection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * ConnectionAttributes connectionAttributes = ConnectionAttributes.builder()
 *         .connectionArn("connectionArn")
 *         .connectionName("connectionName")
 *         .connectionSecretArn("connectionSecretArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:03.224Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.ConnectionAttributes")
@software.amazon.jsii.Jsii.Proxy(ConnectionAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectionAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the connection created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionArn();

    /**
     * The Name for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionName();

    /**
     * The ARN for the secret created for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionSecretArn();

    /**
     * @return a {@link Builder} of {@link ConnectionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectionAttributes> {
        java.lang.String connectionArn;
        java.lang.String connectionName;
        java.lang.String connectionSecretArn;

        /**
         * Sets the value of {@link ConnectionAttributes#getConnectionArn}
         * @param connectionArn The ARN of the connection created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(java.lang.String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionAttributes#getConnectionName}
         * @param connectionName The Name for the connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionName(java.lang.String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionAttributes#getConnectionSecretArn}
         * @param connectionSecretArn The ARN for the secret created for the connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionSecretArn(java.lang.String connectionSecretArn) {
            this.connectionSecretArn = connectionSecretArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectionAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionAttributes {
        private final java.lang.String connectionArn;
        private final java.lang.String connectionName;
        private final java.lang.String connectionSecretArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionSecretArn = software.amazon.jsii.Kernel.get(this, "connectionSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionArn = java.util.Objects.requireNonNull(builder.connectionArn, "connectionArn is required");
            this.connectionName = java.util.Objects.requireNonNull(builder.connectionName, "connectionName is required");
            this.connectionSecretArn = java.util.Objects.requireNonNull(builder.connectionSecretArn, "connectionSecretArn is required");
        }

        @Override
        public final java.lang.String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        public final java.lang.String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final java.lang.String getConnectionSecretArn() {
            return this.connectionSecretArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
            data.set("connectionName", om.valueToTree(this.getConnectionName()));
            data.set("connectionSecretArn", om.valueToTree(this.getConnectionSecretArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.ConnectionAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionAttributes.Jsii$Proxy that = (ConnectionAttributes.Jsii$Proxy) o;

            if (!connectionArn.equals(that.connectionArn)) return false;
            if (!connectionName.equals(that.connectionName)) return false;
            return this.connectionSecretArn.equals(that.connectionSecretArn);
        }

        @Override
        public final int hashCode() {
            int result = this.connectionArn.hashCode();
            result = 31 * result + (this.connectionName.hashCode());
            result = 31 * result + (this.connectionSecretArn.hashCode());
            return result;
        }
    }
}
