package software.amazon.awscdk.services.finspace;

/**
 * A CloudFormation `AWS::FinSpace::Environment`.
 * <p>
 * The <code>AWS::FinSpace::Environment</code> resource represents an Amazon FinSpace environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.finspace.*;
 * Object attributeMap;
 * CfnEnvironment cfnEnvironment = CfnEnvironment.Builder.create(this, "MyCfnEnvironment")
 *         .name("name")
 *         // the properties below are optional
 *         .dataBundles(List.of("dataBundles"))
 *         .description("description")
 *         .federationMode("federationMode")
 *         .federationParameters(FederationParametersProperty.builder()
 *                 .applicationCallBackUrl("applicationCallBackUrl")
 *                 .attributeMap(attributeMap)
 *                 .federationProviderName("federationProviderName")
 *                 .federationUrn("federationUrn")
 *                 .samlMetadataDocument("samlMetadataDocument")
 *                 .samlMetadataUrl("samlMetadataUrl")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .superuserParameters(SuperuserParametersProperty.builder()
 *                 .emailAddress("emailAddress")
 *                 .firstName("firstName")
 *                 .lastName("lastName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:03.301Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_finspace.CfnEnvironment")
public class CfnEnvironment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.finspace.CfnEnvironment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FinSpace::Environment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.finspace.CfnEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the AWS account in which the FinSpace environment is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "attrAwsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID of the dedicated service account associated with your FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDedicatedServiceAccountId() {
        return software.amazon.jsii.Kernel.get(this, "attrDedicatedServiceAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of your FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentId() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The sign-in url for the web application of your FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEnvironmentUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrEnvironmentUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The url of the integrated FinSpace notebook environment in your web application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSageMakerStudioDomainUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrSageMakerStudioDomainUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of creation of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:.
     * <p>
     * <ul>
     * <li><code>arn:aws:finspace:${Region}::data-bundle/capital-markets-sample</code> - Contains sample Capital Markets datasets, categories and controlled vocabularies.</li>
     * <li><code>arn:aws:finspace:${Region}::data-bundle/taq</code> (default) - Contains trades and quotes data in addition to sample Capital Markets data.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataBundles() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dataBundles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:.
     * <p>
     * <ul>
     * <li><code>arn:aws:finspace:${Region}::data-bundle/capital-markets-sample</code> - Contains sample Capital Markets datasets, categories and controlled vocabularies.</li>
     * <li><code>arn:aws:finspace:${Region}::data-bundle/taq</code> (default) - Contains trades and quotes data in addition to sample Capital Markets data.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataBundles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dataBundles", value);
    }

    /**
     * The description of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The authentication mode for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFederationMode() {
        return software.amazon.jsii.Kernel.get(this, "federationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authentication mode for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFederationMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "federationMode", value);
    }

    /**
     * Configuration information when authentication mode is FEDERATED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFederationParameters() {
        return software.amazon.jsii.Kernel.get(this, "federationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information when authentication mode is FEDERATED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFederationParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.finspace.CfnEnvironment.FederationParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "federationParameters", value);
    }

    /**
     * Configuration information when authentication mode is FEDERATED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFederationParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "federationParameters", value);
    }

    /**
     * The KMS key id used to encrypt in the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The KMS key id used to encrypt in the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Configuration information for the superuser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSuperuserParameters() {
        return software.amazon.jsii.Kernel.get(this, "superuserParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information for the superuser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuperuserParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.finspace.CfnEnvironment.SuperuserParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "superuserParameters", value);
    }

    /**
     * Configuration information for the superuser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuperuserParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "superuserParameters", value);
    }
    /**
     * Configuration information when authentication mode is FEDERATED.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.finspace.*;
     * Object attributeMap;
     * FederationParametersProperty federationParametersProperty = FederationParametersProperty.builder()
     *         .applicationCallBackUrl("applicationCallBackUrl")
     *         .attributeMap(attributeMap)
     *         .federationProviderName("federationProviderName")
     *         .federationUrn("federationUrn")
     *         .samlMetadataDocument("samlMetadataDocument")
     *         .samlMetadataUrl("samlMetadataUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_finspace.CfnEnvironment.FederationParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(FederationParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FederationParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider configuration (IdP).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationCallBackUrl() {
            return null;
        }

        /**
         * SAML attribute name and value.
         * <p>
         * The name must always be <code>Email</code> and the value should be set to the attribute definition in which user email is set. For example, name would be <code>Email</code> and value <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code> . Please check your SAML 2.0 compliant identity provider (IdP) documentation for details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributeMap() {
            return null;
        }

        /**
         * Name of the identity provider (IdP).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFederationProviderName() {
            return null;
        }

        /**
         * The Uniform Resource Name (URN).
         * <p>
         * Also referred as Service Provider URN or Audience URI or Service Provider Entity ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFederationUrn() {
            return null;
        }

        /**
         * SAML 2.0 Metadata document from identity provider (IdP).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSamlMetadataDocument() {
            return null;
        }

        /**
         * Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSamlMetadataUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FederationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FederationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FederationParametersProperty> {
            java.lang.String applicationCallBackUrl;
            java.lang.Object attributeMap;
            java.lang.String federationProviderName;
            java.lang.String federationUrn;
            java.lang.String samlMetadataDocument;
            java.lang.String samlMetadataUrl;

            /**
             * Sets the value of {@link FederationParametersProperty#getApplicationCallBackUrl}
             * @param applicationCallBackUrl The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider configuration (IdP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationCallBackUrl(java.lang.String applicationCallBackUrl) {
                this.applicationCallBackUrl = applicationCallBackUrl;
                return this;
            }

            /**
             * Sets the value of {@link FederationParametersProperty#getAttributeMap}
             * @param attributeMap SAML attribute name and value.
             *                     The name must always be <code>Email</code> and the value should be set to the attribute definition in which user email is set. For example, name would be <code>Email</code> and value <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code> . Please check your SAML 2.0 compliant identity provider (IdP) documentation for details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeMap(java.lang.Object attributeMap) {
                this.attributeMap = attributeMap;
                return this;
            }

            /**
             * Sets the value of {@link FederationParametersProperty#getFederationProviderName}
             * @param federationProviderName Name of the identity provider (IdP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder federationProviderName(java.lang.String federationProviderName) {
                this.federationProviderName = federationProviderName;
                return this;
            }

            /**
             * Sets the value of {@link FederationParametersProperty#getFederationUrn}
             * @param federationUrn The Uniform Resource Name (URN).
             *                      Also referred as Service Provider URN or Audience URI or Service Provider Entity ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder federationUrn(java.lang.String federationUrn) {
                this.federationUrn = federationUrn;
                return this;
            }

            /**
             * Sets the value of {@link FederationParametersProperty#getSamlMetadataDocument}
             * @param samlMetadataDocument SAML 2.0 Metadata document from identity provider (IdP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samlMetadataDocument(java.lang.String samlMetadataDocument) {
                this.samlMetadataDocument = samlMetadataDocument;
                return this;
            }

            /**
             * Sets the value of {@link FederationParametersProperty#getSamlMetadataUrl}
             * @param samlMetadataUrl Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samlMetadataUrl(java.lang.String samlMetadataUrl) {
                this.samlMetadataUrl = samlMetadataUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FederationParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FederationParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FederationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FederationParametersProperty {
            private final java.lang.String applicationCallBackUrl;
            private final java.lang.Object attributeMap;
            private final java.lang.String federationProviderName;
            private final java.lang.String federationUrn;
            private final java.lang.String samlMetadataDocument;
            private final java.lang.String samlMetadataUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationCallBackUrl = software.amazon.jsii.Kernel.get(this, "applicationCallBackUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributeMap = software.amazon.jsii.Kernel.get(this, "attributeMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.federationProviderName = software.amazon.jsii.Kernel.get(this, "federationProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.federationUrn = software.amazon.jsii.Kernel.get(this, "federationUrn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.samlMetadataDocument = software.amazon.jsii.Kernel.get(this, "samlMetadataDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.samlMetadataUrl = software.amazon.jsii.Kernel.get(this, "samlMetadataUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationCallBackUrl = builder.applicationCallBackUrl;
                this.attributeMap = builder.attributeMap;
                this.federationProviderName = builder.federationProviderName;
                this.federationUrn = builder.federationUrn;
                this.samlMetadataDocument = builder.samlMetadataDocument;
                this.samlMetadataUrl = builder.samlMetadataUrl;
            }

            @Override
            public final java.lang.String getApplicationCallBackUrl() {
                return this.applicationCallBackUrl;
            }

            @Override
            public final java.lang.Object getAttributeMap() {
                return this.attributeMap;
            }

            @Override
            public final java.lang.String getFederationProviderName() {
                return this.federationProviderName;
            }

            @Override
            public final java.lang.String getFederationUrn() {
                return this.federationUrn;
            }

            @Override
            public final java.lang.String getSamlMetadataDocument() {
                return this.samlMetadataDocument;
            }

            @Override
            public final java.lang.String getSamlMetadataUrl() {
                return this.samlMetadataUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationCallBackUrl() != null) {
                    data.set("applicationCallBackUrl", om.valueToTree(this.getApplicationCallBackUrl()));
                }
                if (this.getAttributeMap() != null) {
                    data.set("attributeMap", om.valueToTree(this.getAttributeMap()));
                }
                if (this.getFederationProviderName() != null) {
                    data.set("federationProviderName", om.valueToTree(this.getFederationProviderName()));
                }
                if (this.getFederationUrn() != null) {
                    data.set("federationUrn", om.valueToTree(this.getFederationUrn()));
                }
                if (this.getSamlMetadataDocument() != null) {
                    data.set("samlMetadataDocument", om.valueToTree(this.getSamlMetadataDocument()));
                }
                if (this.getSamlMetadataUrl() != null) {
                    data.set("samlMetadataUrl", om.valueToTree(this.getSamlMetadataUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_finspace.CfnEnvironment.FederationParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FederationParametersProperty.Jsii$Proxy that = (FederationParametersProperty.Jsii$Proxy) o;

                if (this.applicationCallBackUrl != null ? !this.applicationCallBackUrl.equals(that.applicationCallBackUrl) : that.applicationCallBackUrl != null) return false;
                if (this.attributeMap != null ? !this.attributeMap.equals(that.attributeMap) : that.attributeMap != null) return false;
                if (this.federationProviderName != null ? !this.federationProviderName.equals(that.federationProviderName) : that.federationProviderName != null) return false;
                if (this.federationUrn != null ? !this.federationUrn.equals(that.federationUrn) : that.federationUrn != null) return false;
                if (this.samlMetadataDocument != null ? !this.samlMetadataDocument.equals(that.samlMetadataDocument) : that.samlMetadataDocument != null) return false;
                return this.samlMetadataUrl != null ? this.samlMetadataUrl.equals(that.samlMetadataUrl) : that.samlMetadataUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationCallBackUrl != null ? this.applicationCallBackUrl.hashCode() : 0;
                result = 31 * result + (this.attributeMap != null ? this.attributeMap.hashCode() : 0);
                result = 31 * result + (this.federationProviderName != null ? this.federationProviderName.hashCode() : 0);
                result = 31 * result + (this.federationUrn != null ? this.federationUrn.hashCode() : 0);
                result = 31 * result + (this.samlMetadataDocument != null ? this.samlMetadataDocument.hashCode() : 0);
                result = 31 * result + (this.samlMetadataUrl != null ? this.samlMetadataUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration information for the superuser.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.finspace.*;
     * SuperuserParametersProperty superuserParametersProperty = SuperuserParametersProperty.builder()
     *         .emailAddress("emailAddress")
     *         .firstName("firstName")
     *         .lastName("lastName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_finspace.CfnEnvironment.SuperuserParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SuperuserParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuperuserParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email address of the superuser.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailAddress() {
            return null;
        }

        /**
         * The first name of the superuser.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFirstName() {
            return null;
        }

        /**
         * The last name of the superuser.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLastName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuperuserParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuperuserParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuperuserParametersProperty> {
            java.lang.String emailAddress;
            java.lang.String firstName;
            java.lang.String lastName;

            /**
             * Sets the value of {@link SuperuserParametersProperty#getEmailAddress}
             * @param emailAddress The email address of the superuser.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAddress(java.lang.String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            /**
             * Sets the value of {@link SuperuserParametersProperty#getFirstName}
             * @param firstName The first name of the superuser.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstName(java.lang.String firstName) {
                this.firstName = firstName;
                return this;
            }

            /**
             * Sets the value of {@link SuperuserParametersProperty#getLastName}
             * @param lastName The last name of the superuser.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastName(java.lang.String lastName) {
                this.lastName = lastName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuperuserParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuperuserParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuperuserParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuperuserParametersProperty {
            private final java.lang.String emailAddress;
            private final java.lang.String firstName;
            private final java.lang.String lastName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailAddress = software.amazon.jsii.Kernel.get(this, "emailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firstName = software.amazon.jsii.Kernel.get(this, "firstName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lastName = software.amazon.jsii.Kernel.get(this, "lastName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailAddress = builder.emailAddress;
                this.firstName = builder.firstName;
                this.lastName = builder.lastName;
            }

            @Override
            public final java.lang.String getEmailAddress() {
                return this.emailAddress;
            }

            @Override
            public final java.lang.String getFirstName() {
                return this.firstName;
            }

            @Override
            public final java.lang.String getLastName() {
                return this.lastName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailAddress() != null) {
                    data.set("emailAddress", om.valueToTree(this.getEmailAddress()));
                }
                if (this.getFirstName() != null) {
                    data.set("firstName", om.valueToTree(this.getFirstName()));
                }
                if (this.getLastName() != null) {
                    data.set("lastName", om.valueToTree(this.getLastName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_finspace.CfnEnvironment.SuperuserParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuperuserParametersProperty.Jsii$Proxy that = (SuperuserParametersProperty.Jsii$Proxy) o;

                if (this.emailAddress != null ? !this.emailAddress.equals(that.emailAddress) : that.emailAddress != null) return false;
                if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) return false;
                return this.lastName != null ? this.lastName.equals(that.lastName) : that.lastName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailAddress != null ? this.emailAddress.hashCode() : 0;
                result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
                result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.finspace.CfnEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.finspace.CfnEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.finspace.CfnEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.finspace.CfnEnvironmentProps.Builder();
        }

        /**
         * The name of the FinSpace environment.
         * <p>
         * @return {@code this}
         * @param name The name of the FinSpace environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:.
         * <p>
         * <ul>
         * <li><code>arn:aws:finspace:${Region}::data-bundle/capital-markets-sample</code> - Contains sample Capital Markets datasets, categories and controlled vocabularies.</li>
         * <li><code>arn:aws:finspace:${Region}::data-bundle/taq</code> (default) - Contains trades and quotes data in addition to sample Capital Markets data.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param dataBundles The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataBundles(final java.util.List<java.lang.String> dataBundles) {
            this.props.dataBundles(dataBundles);
            return this;
        }

        /**
         * The description of the FinSpace environment.
         * <p>
         * @return {@code this}
         * @param description The description of the FinSpace environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The authentication mode for the environment.
         * <p>
         * @return {@code this}
         * @param federationMode The authentication mode for the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationMode(final java.lang.String federationMode) {
            this.props.federationMode(federationMode);
            return this;
        }

        /**
         * Configuration information when authentication mode is FEDERATED.
         * <p>
         * @return {@code this}
         * @param federationParameters Configuration information when authentication mode is FEDERATED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationParameters(final software.amazon.awscdk.services.finspace.CfnEnvironment.FederationParametersProperty federationParameters) {
            this.props.federationParameters(federationParameters);
            return this;
        }
        /**
         * Configuration information when authentication mode is FEDERATED.
         * <p>
         * @return {@code this}
         * @param federationParameters Configuration information when authentication mode is FEDERATED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationParameters(final software.amazon.awscdk.IResolvable federationParameters) {
            this.props.federationParameters(federationParameters);
            return this;
        }

        /**
         * The KMS key id used to encrypt in the FinSpace environment.
         * <p>
         * @return {@code this}
         * @param kmsKeyId The KMS key id used to encrypt in the FinSpace environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Configuration information for the superuser.
         * <p>
         * @return {@code this}
         * @param superuserParameters Configuration information for the superuser. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder superuserParameters(final software.amazon.awscdk.services.finspace.CfnEnvironment.SuperuserParametersProperty superuserParameters) {
            this.props.superuserParameters(superuserParameters);
            return this;
        }
        /**
         * Configuration information for the superuser.
         * <p>
         * @return {@code this}
         * @param superuserParameters Configuration information for the superuser. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder superuserParameters(final software.amazon.awscdk.IResolvable superuserParameters) {
            this.props.superuserParameters(superuserParameters);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.finspace.CfnEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.finspace.CfnEnvironment build() {
            return new software.amazon.awscdk.services.finspace.CfnEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
