package software.amazon.awscdk.services.frauddetector;

/**
 * A CloudFormation `AWS::FraudDetector::EventType`.
 * <p>
 * Manages an event type. An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.frauddetector.*;
 * CfnEventType cfnEventType = CfnEventType.Builder.create(this, "MyCfnEventType")
 *         .entityTypes(List.of(EntityTypeProperty.builder()
 *                 .arn("arn")
 *                 .createdTime("createdTime")
 *                 .description("description")
 *                 .inline(false)
 *                 .lastUpdatedTime("lastUpdatedTime")
 *                 .name("name")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .eventVariables(List.of(EventVariableProperty.builder()
 *                 .arn("arn")
 *                 .createdTime("createdTime")
 *                 .dataSource("dataSource")
 *                 .dataType("dataType")
 *                 .defaultValue("defaultValue")
 *                 .description("description")
 *                 .inline(false)
 *                 .lastUpdatedTime("lastUpdatedTime")
 *                 .name("name")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .variableType("variableType")
 *                 .build()))
 *         .labels(List.of(LabelProperty.builder()
 *                 .arn("arn")
 *                 .createdTime("createdTime")
 *                 .description("description")
 *                 .inline(false)
 *                 .lastUpdatedTime("lastUpdatedTime")
 *                 .name("name")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:03.344Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_frauddetector.CfnEventType")
public class CfnEventType extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEventType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.frauddetector.CfnEventType.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FraudDetector::EventType`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventType(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.frauddetector.CfnEventTypeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The event type ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Timestamp of when event type was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Timestamp of when event type was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The event type entity types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEntityTypes() {
        return software.amazon.jsii.Kernel.get(this, "entityTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The event type entity types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityTypes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "entityTypes", java.util.Objects.requireNonNull(value, "entityTypes is required"));
    }

    /**
     * The event type entity types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityTypes(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.frauddetector.CfnEventType.EntityTypeProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.frauddetector.CfnEventType.EntityTypeProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "entityTypes", java.util.Objects.requireNonNull(value, "entityTypes is required"));
    }

    /**
     * The event type event variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEventVariables() {
        return software.amazon.jsii.Kernel.get(this, "eventVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The event type event variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventVariables(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventVariables", java.util.Objects.requireNonNull(value, "eventVariables is required"));
    }

    /**
     * The event type event variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventVariables(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.frauddetector.CfnEventType.EventVariableProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.frauddetector.CfnEventType.EventVariableProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "eventVariables", java.util.Objects.requireNonNull(value, "eventVariables is required"));
    }

    /**
     * The event type labels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLabels() {
        return software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The event type labels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLabels(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "labels", java.util.Objects.requireNonNull(value, "labels is required"));
    }

    /**
     * The event type labels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLabels(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.frauddetector.CfnEventType.LabelProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.frauddetector.CfnEventType.LabelProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "labels", java.util.Objects.requireNonNull(value, "labels is required"));
    }

    /**
     * The event type name.
     * <p>
     * Pattern : <code>^[0-9a-z_-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The event type name.
     * <p>
     * Pattern : <code>^[0-9a-z_-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The event type description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The event type description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * The entity type details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.frauddetector.*;
     * EntityTypeProperty entityTypeProperty = EntityTypeProperty.builder()
     *         .arn("arn")
     *         .createdTime("createdTime")
     *         .description("description")
     *         .inline(false)
     *         .lastUpdatedTime("lastUpdatedTime")
     *         .name("name")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_frauddetector.CfnEventType.EntityTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(EntityTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EntityTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The entity type ARN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * Timestamp of when the entity type was created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedTime() {
            return null;
        }

        /**
         * The entity type description.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
         * <p>
         * If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
         * <p>
         * For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInline() {
            return null;
        }

        /**
         * Timestamp of when the entity type was last updated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLastUpdatedTime() {
            return null;
        }

        /**
         * The entity type name.
         * <p>
         * <code>^[0-9a-z_-]+$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EntityTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EntityTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EntityTypeProperty> {
            java.lang.String arn;
            java.lang.String createdTime;
            java.lang.String description;
            java.lang.Object inline;
            java.lang.String lastUpdatedTime;
            java.lang.String name;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link EntityTypeProperty#getArn}
             * @param arn The entity type ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link EntityTypeProperty#getCreatedTime}
             * @param createdTime Timestamp of when the entity type was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdTime(java.lang.String createdTime) {
                this.createdTime = createdTime;
                return this;
            }

            /**
             * Sets the value of {@link EntityTypeProperty#getDescription}
             * @param description The entity type description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link EntityTypeProperty#getInline}
             * @param inline Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
             *               If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
             *               <p>
             *               For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(java.lang.Boolean inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link EntityTypeProperty#getInline}
             * @param inline Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
             *               If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
             *               <p>
             *               For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(software.amazon.awscdk.IResolvable inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link EntityTypeProperty#getLastUpdatedTime}
             * @param lastUpdatedTime Timestamp of when the entity type was last updated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastUpdatedTime(java.lang.String lastUpdatedTime) {
                this.lastUpdatedTime = lastUpdatedTime;
                return this;
            }

            /**
             * Sets the value of {@link EntityTypeProperty#getName}
             * @param name The entity type name.
             *             <code>^[0-9a-z_-]+$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EntityTypeProperty#getTags}
             * @param tags An array of key-value pairs to apply to this resource.
             *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EntityTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EntityTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EntityTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EntityTypeProperty {
            private final java.lang.String arn;
            private final java.lang.String createdTime;
            private final java.lang.String description;
            private final java.lang.Object inline;
            private final java.lang.String lastUpdatedTime;
            private final java.lang.String name;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createdTime = software.amazon.jsii.Kernel.get(this, "createdTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inline = software.amazon.jsii.Kernel.get(this, "inline", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastUpdatedTime = software.amazon.jsii.Kernel.get(this, "lastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.createdTime = builder.createdTime;
                this.description = builder.description;
                this.inline = builder.inline;
                this.lastUpdatedTime = builder.lastUpdatedTime;
                this.name = builder.name;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getCreatedTime() {
                return this.createdTime;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getInline() {
                return this.inline;
            }

            @Override
            public final java.lang.String getLastUpdatedTime() {
                return this.lastUpdatedTime;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getCreatedTime() != null) {
                    data.set("createdTime", om.valueToTree(this.getCreatedTime()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInline() != null) {
                    data.set("inline", om.valueToTree(this.getInline()));
                }
                if (this.getLastUpdatedTime() != null) {
                    data.set("lastUpdatedTime", om.valueToTree(this.getLastUpdatedTime()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_frauddetector.CfnEventType.EntityTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EntityTypeProperty.Jsii$Proxy that = (EntityTypeProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                if (this.createdTime != null ? !this.createdTime.equals(that.createdTime) : that.createdTime != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inline != null ? !this.inline.equals(that.inline) : that.inline != null) return false;
                if (this.lastUpdatedTime != null ? !this.lastUpdatedTime.equals(that.lastUpdatedTime) : that.lastUpdatedTime != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.createdTime != null ? this.createdTime.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inline != null ? this.inline.hashCode() : 0);
                result = 31 * result + (this.lastUpdatedTime != null ? this.lastUpdatedTime.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The variables associated with this event type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.frauddetector.*;
     * EventVariableProperty eventVariableProperty = EventVariableProperty.builder()
     *         .arn("arn")
     *         .createdTime("createdTime")
     *         .dataSource("dataSource")
     *         .dataType("dataType")
     *         .defaultValue("defaultValue")
     *         .description("description")
     *         .inline(false)
     *         .lastUpdatedTime("lastUpdatedTime")
     *         .name("name")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .variableType("variableType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_frauddetector.CfnEventType.EventVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EventVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The event variable ARN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * Timestamp for when event variable was created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedTime() {
            return null;
        }

        /**
         * The source of the event variable.
         * <p>
         * Valid values: <code>EVENT | EXTERNAL_MODEL_SCORE</code>
         * <p>
         * When defining a variable within a event type, you can only use the <code>EVENT</code> value for DataSource when the <em>Inline</em> property is set to true. If the <em>Inline</em> property is set false, you can use either <code>EVENT</code> or <code>MODEL_SCORE</code> for DataSource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataSource() {
            return null;
        }

        /**
         * The data type of the event variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataType() {
            return null;
        }

        /**
         * The default value of the event variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * The event variable description.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
         * <p>
         * If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
         * <p>
         * For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInline() {
            return null;
        }

        /**
         * Timestamp for when the event variable was last updated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLastUpdatedTime() {
            return null;
        }

        /**
         * The name of the event variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * The type of event variable.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVariableType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventVariableProperty> {
            java.lang.String arn;
            java.lang.String createdTime;
            java.lang.String dataSource;
            java.lang.String dataType;
            java.lang.String defaultValue;
            java.lang.String description;
            java.lang.Object inline;
            java.lang.String lastUpdatedTime;
            java.lang.String name;
            java.util.List<software.amazon.awscdk.CfnTag> tags;
            java.lang.String variableType;

            /**
             * Sets the value of {@link EventVariableProperty#getArn}
             * @param arn The event variable ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getCreatedTime}
             * @param createdTime Timestamp for when event variable was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdTime(java.lang.String createdTime) {
                this.createdTime = createdTime;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getDataSource}
             * @param dataSource The source of the event variable.
             *                   Valid values: <code>EVENT | EXTERNAL_MODEL_SCORE</code>
             *                   <p>
             *                   When defining a variable within a event type, you can only use the <code>EVENT</code> value for DataSource when the <em>Inline</em> property is set to true. If the <em>Inline</em> property is set false, you can use either <code>EVENT</code> or <code>MODEL_SCORE</code> for DataSource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSource(java.lang.String dataSource) {
                this.dataSource = dataSource;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getDataType}
             * @param dataType The data type of the event variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(java.lang.String dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getDefaultValue}
             * @param defaultValue The default value of the event variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getDescription}
             * @param description The event variable description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getInline}
             * @param inline Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
             *               If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
             *               <p>
             *               For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(java.lang.Boolean inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getInline}
             * @param inline Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
             *               If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
             *               <p>
             *               For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(software.amazon.awscdk.IResolvable inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getLastUpdatedTime}
             * @param lastUpdatedTime Timestamp for when the event variable was last updated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastUpdatedTime(java.lang.String lastUpdatedTime) {
                this.lastUpdatedTime = lastUpdatedTime;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getName}
             * @param name The name of the event variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getTags}
             * @param tags An array of key-value pairs to apply to this resource.
             *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Sets the value of {@link EventVariableProperty#getVariableType}
             * @param variableType The type of event variable.
             *                     For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variableType(java.lang.String variableType) {
                this.variableType = variableType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventVariableProperty {
            private final java.lang.String arn;
            private final java.lang.String createdTime;
            private final java.lang.String dataSource;
            private final java.lang.String dataType;
            private final java.lang.String defaultValue;
            private final java.lang.String description;
            private final java.lang.Object inline;
            private final java.lang.String lastUpdatedTime;
            private final java.lang.String name;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;
            private final java.lang.String variableType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createdTime = software.amazon.jsii.Kernel.get(this, "createdTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inline = software.amazon.jsii.Kernel.get(this, "inline", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastUpdatedTime = software.amazon.jsii.Kernel.get(this, "lastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
                this.variableType = software.amazon.jsii.Kernel.get(this, "variableType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.createdTime = builder.createdTime;
                this.dataSource = builder.dataSource;
                this.dataType = builder.dataType;
                this.defaultValue = builder.defaultValue;
                this.description = builder.description;
                this.inline = builder.inline;
                this.lastUpdatedTime = builder.lastUpdatedTime;
                this.name = builder.name;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
                this.variableType = builder.variableType;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getCreatedTime() {
                return this.createdTime;
            }

            @Override
            public final java.lang.String getDataSource() {
                return this.dataSource;
            }

            @Override
            public final java.lang.String getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getInline() {
                return this.inline;
            }

            @Override
            public final java.lang.String getLastUpdatedTime() {
                return this.lastUpdatedTime;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public final java.lang.String getVariableType() {
                return this.variableType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getCreatedTime() != null) {
                    data.set("createdTime", om.valueToTree(this.getCreatedTime()));
                }
                if (this.getDataSource() != null) {
                    data.set("dataSource", om.valueToTree(this.getDataSource()));
                }
                if (this.getDataType() != null) {
                    data.set("dataType", om.valueToTree(this.getDataType()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInline() != null) {
                    data.set("inline", om.valueToTree(this.getInline()));
                }
                if (this.getLastUpdatedTime() != null) {
                    data.set("lastUpdatedTime", om.valueToTree(this.getLastUpdatedTime()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }
                if (this.getVariableType() != null) {
                    data.set("variableType", om.valueToTree(this.getVariableType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_frauddetector.CfnEventType.EventVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventVariableProperty.Jsii$Proxy that = (EventVariableProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                if (this.createdTime != null ? !this.createdTime.equals(that.createdTime) : that.createdTime != null) return false;
                if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) return false;
                if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inline != null ? !this.inline.equals(that.inline) : that.inline != null) return false;
                if (this.lastUpdatedTime != null ? !this.lastUpdatedTime.equals(that.lastUpdatedTime) : that.lastUpdatedTime != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
                return this.variableType != null ? this.variableType.equals(that.variableType) : that.variableType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.createdTime != null ? this.createdTime.hashCode() : 0);
                result = 31 * result + (this.dataSource != null ? this.dataSource.hashCode() : 0);
                result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inline != null ? this.inline.hashCode() : 0);
                result = 31 * result + (this.lastUpdatedTime != null ? this.lastUpdatedTime.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                result = 31 * result + (this.variableType != null ? this.variableType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The label associated with the event type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.frauddetector.*;
     * LabelProperty labelProperty = LabelProperty.builder()
     *         .arn("arn")
     *         .createdTime("createdTime")
     *         .description("description")
     *         .inline(false)
     *         .lastUpdatedTime("lastUpdatedTime")
     *         .name("name")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_frauddetector.CfnEventType.LabelProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The label ARN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * Timestamp of when the event type was created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedTime() {
            return null;
        }

        /**
         * The label description.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
         * <p>
         * If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
         * <p>
         * For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your EventType but not execute any changes to the variables.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInline() {
            return null;
        }

        /**
         * Timestamp of when the label was last updated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLastUpdatedTime() {
            return null;
        }

        /**
         * The label name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelProperty> {
            java.lang.String arn;
            java.lang.String createdTime;
            java.lang.String description;
            java.lang.Object inline;
            java.lang.String lastUpdatedTime;
            java.lang.String name;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link LabelProperty#getArn}
             * @param arn The label ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getCreatedTime}
             * @param createdTime Timestamp of when the event type was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdTime(java.lang.String createdTime) {
                this.createdTime = createdTime;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getDescription}
             * @param description The label description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getInline}
             * @param inline Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
             *               If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
             *               <p>
             *               For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your EventType but not execute any changes to the variables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(java.lang.Boolean inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getInline}
             * @param inline Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack.
             *               If the value is <code>true</code> , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is <code>false</code> , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
             *               <p>
             *               For example, when creating <code>AWS::FraudDetector::EventType</code> you must define at least two variables. You can set <code>Inline=true</code> for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set <code>Inline=false</code> , CloudFormation will associate the variables to your EventType but not execute any changes to the variables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(software.amazon.awscdk.IResolvable inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getLastUpdatedTime}
             * @param lastUpdatedTime Timestamp of when the label was last updated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastUpdatedTime(java.lang.String lastUpdatedTime) {
                this.lastUpdatedTime = lastUpdatedTime;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getName}
             * @param name The label name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getTags}
             * @param tags An array of key-value pairs to apply to this resource.
             *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelProperty {
            private final java.lang.String arn;
            private final java.lang.String createdTime;
            private final java.lang.String description;
            private final java.lang.Object inline;
            private final java.lang.String lastUpdatedTime;
            private final java.lang.String name;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createdTime = software.amazon.jsii.Kernel.get(this, "createdTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inline = software.amazon.jsii.Kernel.get(this, "inline", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastUpdatedTime = software.amazon.jsii.Kernel.get(this, "lastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.createdTime = builder.createdTime;
                this.description = builder.description;
                this.inline = builder.inline;
                this.lastUpdatedTime = builder.lastUpdatedTime;
                this.name = builder.name;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getCreatedTime() {
                return this.createdTime;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getInline() {
                return this.inline;
            }

            @Override
            public final java.lang.String getLastUpdatedTime() {
                return this.lastUpdatedTime;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getCreatedTime() != null) {
                    data.set("createdTime", om.valueToTree(this.getCreatedTime()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInline() != null) {
                    data.set("inline", om.valueToTree(this.getInline()));
                }
                if (this.getLastUpdatedTime() != null) {
                    data.set("lastUpdatedTime", om.valueToTree(this.getLastUpdatedTime()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_frauddetector.CfnEventType.LabelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelProperty.Jsii$Proxy that = (LabelProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                if (this.createdTime != null ? !this.createdTime.equals(that.createdTime) : that.createdTime != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inline != null ? !this.inline.equals(that.inline) : that.inline != null) return false;
                if (this.lastUpdatedTime != null ? !this.lastUpdatedTime.equals(that.lastUpdatedTime) : that.lastUpdatedTime != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.createdTime != null ? this.createdTime.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inline != null ? this.inline.hashCode() : 0);
                result = 31 * result + (this.lastUpdatedTime != null ? this.lastUpdatedTime.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.frauddetector.CfnEventType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.frauddetector.CfnEventType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.frauddetector.CfnEventTypeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.frauddetector.CfnEventTypeProps.Builder();
        }

        /**
         * The event type entity types.
         * <p>
         * @return {@code this}
         * @param entityTypes The event type entity types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityTypes(final software.amazon.awscdk.IResolvable entityTypes) {
            this.props.entityTypes(entityTypes);
            return this;
        }
        /**
         * The event type entity types.
         * <p>
         * @return {@code this}
         * @param entityTypes The event type entity types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityTypes(final java.util.List<? extends java.lang.Object> entityTypes) {
            this.props.entityTypes(entityTypes);
            return this;
        }

        /**
         * The event type event variables.
         * <p>
         * @return {@code this}
         * @param eventVariables The event type event variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventVariables(final software.amazon.awscdk.IResolvable eventVariables) {
            this.props.eventVariables(eventVariables);
            return this;
        }
        /**
         * The event type event variables.
         * <p>
         * @return {@code this}
         * @param eventVariables The event type event variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventVariables(final java.util.List<? extends java.lang.Object> eventVariables) {
            this.props.eventVariables(eventVariables);
            return this;
        }

        /**
         * The event type labels.
         * <p>
         * @return {@code this}
         * @param labels The event type labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final software.amazon.awscdk.IResolvable labels) {
            this.props.labels(labels);
            return this;
        }
        /**
         * The event type labels.
         * <p>
         * @return {@code this}
         * @param labels The event type labels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final java.util.List<? extends java.lang.Object> labels) {
            this.props.labels(labels);
            return this;
        }

        /**
         * The event type name.
         * <p>
         * Pattern : <code>^[0-9a-z_-]+$</code>
         * <p>
         * @return {@code this}
         * @param name The event type name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The event type description.
         * <p>
         * @return {@code this}
         * @param description The event type description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.frauddetector.CfnEventType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.frauddetector.CfnEventType build() {
            return new software.amazon.awscdk.services.frauddetector.CfnEventType(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
