package software.amazon.awscdk.services.fsx;

/**
 * A CloudFormation `AWS::FSx::DataRepositoryAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnDataRepositoryAssociation cfnDataRepositoryAssociation = CfnDataRepositoryAssociation.Builder.create(this, "MyCfnDataRepositoryAssociation")
 *         .dataRepositoryPath("dataRepositoryPath")
 *         .fileSystemId("fileSystemId")
 *         .fileSystemPath("fileSystemPath")
 *         // the properties below are optional
 *         .batchImportMetaDataOnCreate(false)
 *         .importedFileChunkSize(123)
 *         .s3(S3Property.builder()
 *                 .autoExportPolicy(AutoExportPolicyProperty.builder()
 *                         .events(List.of("events"))
 *                         .build())
 *                 .autoImportPolicy(AutoImportPolicyProperty.builder()
 *                         .events(List.of("events"))
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:03.353Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation")
public class CfnDataRepositoryAssociation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataRepositoryAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataRepositoryAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FSx::DataRepositoryAssociation`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataRepositoryAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "attrAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.DataRepositoryPath`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataRepositoryPath() {
        return software.amazon.jsii.Kernel.get(this, "dataRepositoryPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.DataRepositoryPath`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataRepositoryPath(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataRepositoryPath", java.util.Objects.requireNonNull(value, "dataRepositoryPath is required"));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.FileSystemId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.FileSystemId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemId", java.util.Objects.requireNonNull(value, "fileSystemId is required"));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.FileSystemPath`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemPath() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.FileSystemPath`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemPath(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemPath", java.util.Objects.requireNonNull(value, "fileSystemPath is required"));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBatchImportMetaDataOnCreate() {
        return software.amazon.jsii.Kernel.get(this, "batchImportMetaDataOnCreate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBatchImportMetaDataOnCreate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "batchImportMetaDataOnCreate", value);
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBatchImportMetaDataOnCreate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "batchImportMetaDataOnCreate", value);
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.ImportedFileChunkSize`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getImportedFileChunkSize() {
        return software.amazon.jsii.Kernel.get(this, "importedFileChunkSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.ImportedFileChunkSize`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImportedFileChunkSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "importedFileChunkSize", value);
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.S3`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
        return software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.S3`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.S3Property value) {
        software.amazon.jsii.Kernel.set(this, "s3", value);
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.S3`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * AutoExportPolicyProperty autoExportPolicyProperty = AutoExportPolicyProperty.builder()
     *         .events(List.of("events"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoExportPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoExportPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoExportPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDataRepositoryAssociation.AutoExportPolicyProperty.Events`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEvents();

        /**
         * @return a {@link Builder} of {@link AutoExportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoExportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoExportPolicyProperty> {
            java.util.List<java.lang.String> events;

            /**
             * Sets the value of {@link AutoExportPolicyProperty#getEvents}
             * @param events `CfnDataRepositoryAssociation.AutoExportPolicyProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoExportPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoExportPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoExportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoExportPolicyProperty {
            private final java.util.List<java.lang.String> events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.events = java.util.Objects.requireNonNull(builder.events, "events is required");
            }

            @Override
            public final java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("events", om.valueToTree(this.getEvents()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoExportPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoExportPolicyProperty.Jsii$Proxy that = (AutoExportPolicyProperty.Jsii$Proxy) o;

                return this.events.equals(that.events);
            }

            @Override
            public final int hashCode() {
                int result = this.events.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * AutoImportPolicyProperty autoImportPolicyProperty = AutoImportPolicyProperty.builder()
     *         .events(List.of("events"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoImportPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoImportPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoImportPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDataRepositoryAssociation.AutoImportPolicyProperty.Events`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEvents();

        /**
         * @return a {@link Builder} of {@link AutoImportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoImportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoImportPolicyProperty> {
            java.util.List<java.lang.String> events;

            /**
             * Sets the value of {@link AutoImportPolicyProperty#getEvents}
             * @param events `CfnDataRepositoryAssociation.AutoImportPolicyProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoImportPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoImportPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoImportPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoImportPolicyProperty {
            private final java.util.List<java.lang.String> events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.events = java.util.Objects.requireNonNull(builder.events, "events is required");
            }

            @Override
            public final java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("events", om.valueToTree(this.getEvents()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.AutoImportPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoImportPolicyProperty.Jsii$Proxy that = (AutoImportPolicyProperty.Jsii$Proxy) o;

                return this.events.equals(that.events);
            }

            @Override
            public final int hashCode() {
                int result = this.events.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * S3Property s3Property = S3Property.builder()
     *         .autoExportPolicy(AutoExportPolicyProperty.builder()
     *                 .events(List.of("events"))
     *                 .build())
     *         .autoImportPolicy(AutoImportPolicyProperty.builder()
     *                 .events(List.of("events"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.S3Property")
    @software.amazon.jsii.Jsii.Proxy(S3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDataRepositoryAssociation.S3Property.AutoExportPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoExportPolicy() {
            return null;
        }

        /**
         * `CfnDataRepositoryAssociation.S3Property.AutoImportPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoImportPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3Property> {
            java.lang.Object autoExportPolicy;
            java.lang.Object autoImportPolicy;

            /**
             * Sets the value of {@link S3Property#getAutoExportPolicy}
             * @param autoExportPolicy `CfnDataRepositoryAssociation.S3Property.AutoExportPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoExportPolicy(software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.AutoExportPolicyProperty autoExportPolicy) {
                this.autoExportPolicy = autoExportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getAutoExportPolicy}
             * @param autoExportPolicy `CfnDataRepositoryAssociation.S3Property.AutoExportPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoExportPolicy(software.amazon.awscdk.IResolvable autoExportPolicy) {
                this.autoExportPolicy = autoExportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getAutoImportPolicy}
             * @param autoImportPolicy `CfnDataRepositoryAssociation.S3Property.AutoImportPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportPolicy(software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.AutoImportPolicyProperty autoImportPolicy) {
                this.autoImportPolicy = autoImportPolicy;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getAutoImportPolicy}
             * @param autoImportPolicy `CfnDataRepositoryAssociation.S3Property.AutoImportPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoImportPolicy(software.amazon.awscdk.IResolvable autoImportPolicy) {
                this.autoImportPolicy = autoImportPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3Property {
            private final java.lang.Object autoExportPolicy;
            private final java.lang.Object autoImportPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoExportPolicy = software.amazon.jsii.Kernel.get(this, "autoExportPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoImportPolicy = software.amazon.jsii.Kernel.get(this, "autoImportPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoExportPolicy = builder.autoExportPolicy;
                this.autoImportPolicy = builder.autoImportPolicy;
            }

            @Override
            public final java.lang.Object getAutoExportPolicy() {
                return this.autoExportPolicy;
            }

            @Override
            public final java.lang.Object getAutoImportPolicy() {
                return this.autoImportPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoExportPolicy() != null) {
                    data.set("autoExportPolicy", om.valueToTree(this.getAutoExportPolicy()));
                }
                if (this.getAutoImportPolicy() != null) {
                    data.set("autoImportPolicy", om.valueToTree(this.getAutoImportPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociation.S3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3Property.Jsii$Proxy that = (S3Property.Jsii$Proxy) o;

                if (this.autoExportPolicy != null ? !this.autoExportPolicy.equals(that.autoExportPolicy) : that.autoExportPolicy != null) return false;
                return this.autoImportPolicy != null ? this.autoImportPolicy.equals(that.autoImportPolicy) : that.autoImportPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoExportPolicy != null ? this.autoExportPolicy.hashCode() : 0;
                result = 31 * result + (this.autoImportPolicy != null ? this.autoImportPolicy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociationProps.Builder();
        }

        /**
         * `AWS::FSx::DataRepositoryAssociation.DataRepositoryPath`.
         * <p>
         * @return {@code this}
         * @param dataRepositoryPath `AWS::FSx::DataRepositoryAssociation.DataRepositoryPath`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataRepositoryPath(final java.lang.String dataRepositoryPath) {
            this.props.dataRepositoryPath(dataRepositoryPath);
            return this;
        }

        /**
         * `AWS::FSx::DataRepositoryAssociation.FileSystemId`.
         * <p>
         * @return {@code this}
         * @param fileSystemId `AWS::FSx::DataRepositoryAssociation.FileSystemId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(final java.lang.String fileSystemId) {
            this.props.fileSystemId(fileSystemId);
            return this;
        }

        /**
         * `AWS::FSx::DataRepositoryAssociation.FileSystemPath`.
         * <p>
         * @return {@code this}
         * @param fileSystemPath `AWS::FSx::DataRepositoryAssociation.FileSystemPath`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPath(final java.lang.String fileSystemPath) {
            this.props.fileSystemPath(fileSystemPath);
            return this;
        }

        /**
         * `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
         * <p>
         * @return {@code this}
         * @param batchImportMetaDataOnCreate `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchImportMetaDataOnCreate(final java.lang.Boolean batchImportMetaDataOnCreate) {
            this.props.batchImportMetaDataOnCreate(batchImportMetaDataOnCreate);
            return this;
        }
        /**
         * `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
         * <p>
         * @return {@code this}
         * @param batchImportMetaDataOnCreate `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchImportMetaDataOnCreate(final software.amazon.awscdk.IResolvable batchImportMetaDataOnCreate) {
            this.props.batchImportMetaDataOnCreate(batchImportMetaDataOnCreate);
            return this;
        }

        /**
         * `AWS::FSx::DataRepositoryAssociation.ImportedFileChunkSize`.
         * <p>
         * @return {@code this}
         * @param importedFileChunkSize `AWS::FSx::DataRepositoryAssociation.ImportedFileChunkSize`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importedFileChunkSize(final java.lang.Number importedFileChunkSize) {
            this.props.importedFileChunkSize(importedFileChunkSize);
            return this;
        }

        /**
         * `AWS::FSx::DataRepositoryAssociation.S3`.
         * <p>
         * @return {@code this}
         * @param s3 `AWS::FSx::DataRepositoryAssociation.S3`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3(final software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.S3Property s3) {
            this.props.s3(s3);
            return this;
        }
        /**
         * `AWS::FSx::DataRepositoryAssociation.S3`.
         * <p>
         * @return {@code this}
         * @param s3 `AWS::FSx::DataRepositoryAssociation.S3`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3(final software.amazon.awscdk.IResolvable s3) {
            this.props.s3(s3);
            return this;
        }

        /**
         * `AWS::FSx::DataRepositoryAssociation.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::FSx::DataRepositoryAssociation.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation build() {
            return new software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
