package software.amazon.awscdk.services.lakeformation;

/**
 * A CloudFormation `AWS::LakeFormation::DataCellsFilter`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * Object allRowsWildcard;
 * CfnDataCellsFilter cfnDataCellsFilter = CfnDataCellsFilter.Builder.create(this, "MyCfnDataCellsFilter")
 *         .databaseName("databaseName")
 *         .name("name")
 *         .tableCatalogId("tableCatalogId")
 *         .tableName("tableName")
 *         // the properties below are optional
 *         .columnNames(List.of("columnNames"))
 *         .columnWildcard(ColumnWildcardProperty.builder()
 *                 .excludedColumnNames(List.of("excludedColumnNames"))
 *                 .build())
 *         .rowFilter(RowFilterProperty.builder()
 *                 .allRowsWildcard(allRowsWildcard)
 *                 .filterExpression("filterExpression")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:04.313Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataCellsFilter")
public class CfnDataCellsFilter extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataCellsFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataCellsFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::LakeFormation::DataCellsFilter`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataCellsFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lakeformation.CfnDataCellsFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.DatabaseName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.DatabaseName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", java.util.Objects.requireNonNull(value, "databaseName is required"));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.TableCatalogId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableCatalogId() {
        return software.amazon.jsii.Kernel.get(this, "tableCatalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.TableCatalogId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableCatalogId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableCatalogId", java.util.Objects.requireNonNull(value, "tableCatalogId is required"));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.TableName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.TableName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", java.util.Objects.requireNonNull(value, "tableName is required"));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.ColumnNames`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumnNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.ColumnNames`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "columnNames", value);
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.ColumnWildcard`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getColumnWildcard() {
        return software.amazon.jsii.Kernel.get(this, "columnWildcard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.ColumnWildcard`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnWildcard(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.ColumnWildcardProperty value) {
        software.amazon.jsii.Kernel.set(this, "columnWildcard", value);
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.ColumnWildcard`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnWildcard(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "columnWildcard", value);
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.RowFilter`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRowFilter() {
        return software.amazon.jsii.Kernel.get(this, "rowFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.RowFilter`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowFilter(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.RowFilterProperty value) {
        software.amazon.jsii.Kernel.set(this, "rowFilter", value);
    }

    /**
     * `AWS::LakeFormation::DataCellsFilter.RowFilter`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowFilter(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rowFilter", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * ColumnWildcardProperty columnWildcardProperty = ColumnWildcardProperty.builder()
     *         .excludedColumnNames(List.of("excludedColumnNames"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataCellsFilter.ColumnWildcardProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnWildcardProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnWildcardProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDataCellsFilter.ColumnWildcardProperty.ExcludedColumnNames`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedColumnNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnWildcardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnWildcardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnWildcardProperty> {
            java.util.List<java.lang.String> excludedColumnNames;

            /**
             * Sets the value of {@link ColumnWildcardProperty#getExcludedColumnNames}
             * @param excludedColumnNames `CfnDataCellsFilter.ColumnWildcardProperty.ExcludedColumnNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedColumnNames(java.util.List<java.lang.String> excludedColumnNames) {
                this.excludedColumnNames = excludedColumnNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnWildcardProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnWildcardProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnWildcardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnWildcardProperty {
            private final java.util.List<java.lang.String> excludedColumnNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludedColumnNames = software.amazon.jsii.Kernel.get(this, "excludedColumnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludedColumnNames = builder.excludedColumnNames;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedColumnNames() {
                return this.excludedColumnNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludedColumnNames() != null) {
                    data.set("excludedColumnNames", om.valueToTree(this.getExcludedColumnNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnDataCellsFilter.ColumnWildcardProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnWildcardProperty.Jsii$Proxy that = (ColumnWildcardProperty.Jsii$Proxy) o;

                return this.excludedColumnNames != null ? this.excludedColumnNames.equals(that.excludedColumnNames) : that.excludedColumnNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludedColumnNames != null ? this.excludedColumnNames.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * Object allRowsWildcard;
     * RowFilterProperty rowFilterProperty = RowFilterProperty.builder()
     *         .allRowsWildcard(allRowsWildcard)
     *         .filterExpression("filterExpression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataCellsFilter.RowFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(RowFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RowFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDataCellsFilter.RowFilterProperty.AllRowsWildcard`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllRowsWildcard() {
            return null;
        }

        /**
         * `CfnDataCellsFilter.RowFilterProperty.FilterExpression`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RowFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RowFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RowFilterProperty> {
            java.lang.Object allRowsWildcard;
            java.lang.String filterExpression;

            /**
             * Sets the value of {@link RowFilterProperty#getAllRowsWildcard}
             * @param allRowsWildcard `CfnDataCellsFilter.RowFilterProperty.AllRowsWildcard`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allRowsWildcard(java.lang.Object allRowsWildcard) {
                this.allRowsWildcard = allRowsWildcard;
                return this;
            }

            /**
             * Sets the value of {@link RowFilterProperty#getFilterExpression}
             * @param filterExpression `CfnDataCellsFilter.RowFilterProperty.FilterExpression`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterExpression(java.lang.String filterExpression) {
                this.filterExpression = filterExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RowFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RowFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RowFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RowFilterProperty {
            private final java.lang.Object allRowsWildcard;
            private final java.lang.String filterExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allRowsWildcard = software.amazon.jsii.Kernel.get(this, "allRowsWildcard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterExpression = software.amazon.jsii.Kernel.get(this, "filterExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allRowsWildcard = builder.allRowsWildcard;
                this.filterExpression = builder.filterExpression;
            }

            @Override
            public final java.lang.Object getAllRowsWildcard() {
                return this.allRowsWildcard;
            }

            @Override
            public final java.lang.String getFilterExpression() {
                return this.filterExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllRowsWildcard() != null) {
                    data.set("allRowsWildcard", om.valueToTree(this.getAllRowsWildcard()));
                }
                if (this.getFilterExpression() != null) {
                    data.set("filterExpression", om.valueToTree(this.getFilterExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnDataCellsFilter.RowFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RowFilterProperty.Jsii$Proxy that = (RowFilterProperty.Jsii$Proxy) o;

                if (this.allRowsWildcard != null ? !this.allRowsWildcard.equals(that.allRowsWildcard) : that.allRowsWildcard != null) return false;
                return this.filterExpression != null ? this.filterExpression.equals(that.filterExpression) : that.filterExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allRowsWildcard != null ? this.allRowsWildcard.hashCode() : 0;
                result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lakeformation.CfnDataCellsFilterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lakeformation.CfnDataCellsFilterProps.Builder();
        }

        /**
         * `AWS::LakeFormation::DataCellsFilter.DatabaseName`.
         * <p>
         * @return {@code this}
         * @param databaseName `AWS::LakeFormation::DataCellsFilter.DatabaseName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * `AWS::LakeFormation::DataCellsFilter.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::LakeFormation::DataCellsFilter.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::LakeFormation::DataCellsFilter.TableCatalogId`.
         * <p>
         * @return {@code this}
         * @param tableCatalogId `AWS::LakeFormation::DataCellsFilter.TableCatalogId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableCatalogId(final java.lang.String tableCatalogId) {
            this.props.tableCatalogId(tableCatalogId);
            return this;
        }

        /**
         * `AWS::LakeFormation::DataCellsFilter.TableName`.
         * <p>
         * @return {@code this}
         * @param tableName `AWS::LakeFormation::DataCellsFilter.TableName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * `AWS::LakeFormation::DataCellsFilter.ColumnNames`.
         * <p>
         * @return {@code this}
         * @param columnNames `AWS::LakeFormation::DataCellsFilter.ColumnNames`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnNames(final java.util.List<java.lang.String> columnNames) {
            this.props.columnNames(columnNames);
            return this;
        }

        /**
         * `AWS::LakeFormation::DataCellsFilter.ColumnWildcard`.
         * <p>
         * @return {@code this}
         * @param columnWildcard `AWS::LakeFormation::DataCellsFilter.ColumnWildcard`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnWildcard(final software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.ColumnWildcardProperty columnWildcard) {
            this.props.columnWildcard(columnWildcard);
            return this;
        }
        /**
         * `AWS::LakeFormation::DataCellsFilter.ColumnWildcard`.
         * <p>
         * @return {@code this}
         * @param columnWildcard `AWS::LakeFormation::DataCellsFilter.ColumnWildcard`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnWildcard(final software.amazon.awscdk.IResolvable columnWildcard) {
            this.props.columnWildcard(columnWildcard);
            return this;
        }

        /**
         * `AWS::LakeFormation::DataCellsFilter.RowFilter`.
         * <p>
         * @return {@code this}
         * @param rowFilter `AWS::LakeFormation::DataCellsFilter.RowFilter`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowFilter(final software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.RowFilterProperty rowFilter) {
            this.props.rowFilter(rowFilter);
            return this;
        }
        /**
         * `AWS::LakeFormation::DataCellsFilter.RowFilter`.
         * <p>
         * @return {@code this}
         * @param rowFilter `AWS::LakeFormation::DataCellsFilter.RowFilter`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowFilter(final software.amazon.awscdk.IResolvable rowFilter) {
            this.props.rowFilter(rowFilter);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter build() {
            return new software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
