package software.amazon.awscdk.services.lambda;

/**
 * Represents a Docker image in ECR that can be bound as Lambda Code.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Repository repository;
 * EcrImageCode ecrImageCode = EcrImageCode.Builder.create(repository)
 *         .cmd(List.of("cmd"))
 *         .entrypoint(List.of("entrypoint"))
 *         .tag("tag")
 *         .tagOrDigest("tagOrDigest")
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:04.396Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.EcrImageCode")
public class EcrImageCode extends software.amazon.awscdk.services.lambda.Code {

    protected EcrImageCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcrImageCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param repository This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcrImageCode(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.EcrImageCodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), props });
    }

    /**
     * @param repository This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcrImageCode(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param _ This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(_, "_ is required") });
    }

    /**
     * Determines whether this Code is inline code or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsInline() {
        return software.amazon.jsii.Kernel.get(this, "isInline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.EcrImageCode}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.EcrImageCode> {
        /**
         * @return a new instance of {@link Builder}.
         * @param repository This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.ecr.IRepository repository) {
            return new Builder(repository);
        }

        private final software.amazon.awscdk.services.ecr.IRepository repository;
        private software.amazon.awscdk.services.lambda.EcrImageCodeProps.Builder props;

        private Builder(final software.amazon.awscdk.services.ecr.IRepository repository) {
            this.repository = repository;
        }

        /**
         * Specify or override the CMD on the specified Docker image or Dockerfile.
         * <p>
         * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * <p>
         * Default: - use the CMD specified in the docker image or Dockerfile.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
         * @param cmd Specify or override the CMD on the specified Docker image or Dockerfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmd(final java.util.List<java.lang.String> cmd) {
            this.props().cmd(cmd);
            return this;
        }

        /**
         * Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
         * <p>
         * An ENTRYPOINT allows you to configure a container that will run as an executable.
         * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * <p>
         * Default: - use the ENTRYPOINT in the docker image or Dockerfile.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>
         * @param entrypoint Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(final java.util.List<java.lang.String> entrypoint) {
            this.props().entrypoint(entrypoint);
            return this;
        }

        /**
         * (deprecated) The image tag to use when pulling the image from ECR.
         * <p>
         * Default: 'latest'
         * <p>
         * @return {@code this}
         * @deprecated use `tagOrDigest`
         * @param tag The image tag to use when pulling the image from ECR. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tag(final java.lang.String tag) {
            this.props().tag(tag);
            return this;
        }

        /**
         * The image tag or digest to use when pulling the image from ECR (digests must start with `sha256:`).
         * <p>
         * Default: 'latest'
         * <p>
         * @return {@code this}
         * @param tagOrDigest The image tag or digest to use when pulling the image from ECR (digests must start with `sha256:`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagOrDigest(final java.lang.String tagOrDigest) {
            this.props().tagOrDigest(tagOrDigest);
            return this;
        }

        /**
         * Specify or override the WORKDIR on the specified Docker image or Dockerfile.
         * <p>
         * A WORKDIR allows you to configure the working directory the container will use.
         * <p>
         * Default: - use the WORKDIR in the docker image or Dockerfile.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/builder/#workdir">https://docs.docker.com/engine/reference/builder/#workdir</a>
         * @param workingDirectory Specify or override the WORKDIR on the specified Docker image or Dockerfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(final java.lang.String workingDirectory) {
            this.props().workingDirectory(workingDirectory);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.EcrImageCode}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.EcrImageCode build() {
            return new software.amazon.awscdk.services.lambda.EcrImageCode(
                this.repository,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.EcrImageCodeProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.lambda.EcrImageCodeProps.Builder();
            }
            return this.props;
        }
    }
}
