package software.amazon.awscdk.services.lambda;

/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.lambda.eventsources.DynamoEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.SqsDlq;
 * Table table;
 * Function fn;
 * Queue deadLetterQueue = new Queue(this, "deadLetterQueue");
 * fn.addEventSource(DynamoEventSource.Builder.create(table)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .batchSize(5)
 *         .bisectBatchOnError(true)
 *         .onFailure(new SqsDlq(deadLetterQueue))
 *         .retryAttempts(10)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:04.448Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.StartingPosition")
public enum StartingPosition {
    /**
     * Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRIM_HORIZON,
    /**
     * Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LATEST,
    /**
     * Start reading from a position defined by a time stamp.
     * <p>
     * Only supported for Amazon Kinesis streams, otherwise an error will occur.
     * If supplied, <code>startingPositionTimestamp</code> must also be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AT_TIMESTAMP,
}
