package software.amazon.awscdk.services.logs;

/**
 * Properties to define Cloudwatch log group resource policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.logs.*;
 * PolicyStatement policyStatement;
 * ResourcePolicyProps resourcePolicyProps = ResourcePolicyProps.builder()
 *         .policyStatements(List.of(policyStatement))
 *         .resourcePolicyName("resourcePolicyName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:04.696Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ResourcePolicyProps")
@software.amazon.jsii.Jsii.Proxy(ResourcePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourcePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Initial statements to add to the resource policy.
     * <p>
     * Default: - No statements
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
        return null;
    }

    /**
     * Name of the log group resource policy.
     * <p>
     * Default: - Uses a unique id based on the construct path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourcePolicyName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourcePolicyProps> {
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policyStatements;
        java.lang.String resourcePolicyName;

        /**
         * Sets the value of {@link ResourcePolicyProps#getPolicyStatements}
         * @param policyStatements Initial statements to add to the resource policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder policyStatements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> policyStatements) {
            this.policyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)policyStatements;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyProps#getResourcePolicyName}
         * @param resourcePolicyName Name of the log group resource policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicyName(java.lang.String resourcePolicyName) {
            this.resourcePolicyName = resourcePolicyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourcePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourcePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePolicyProps {
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policyStatements;
        private final java.lang.String resourcePolicyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyStatements = software.amazon.jsii.Kernel.get(this, "policyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.resourcePolicyName = software.amazon.jsii.Kernel.get(this, "resourcePolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.policyStatements;
            this.resourcePolicyName = builder.resourcePolicyName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
            return this.policyStatements;
        }

        @Override
        public final java.lang.String getResourcePolicyName() {
            return this.resourcePolicyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPolicyStatements() != null) {
                data.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
            }
            if (this.getResourcePolicyName() != null) {
                data.set("resourcePolicyName", om.valueToTree(this.getResourcePolicyName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.ResourcePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourcePolicyProps.Jsii$Proxy that = (ResourcePolicyProps.Jsii$Proxy) o;

            if (this.policyStatements != null ? !this.policyStatements.equals(that.policyStatements) : that.policyStatements != null) return false;
            return this.resourcePolicyName != null ? this.resourcePolicyName.equals(that.resourcePolicyName) : that.resourcePolicyName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policyStatements != null ? this.policyStatements.hashCode() : 0;
            result = 31 * result + (this.resourcePolicyName != null ? this.resourcePolicyName.hashCode() : 0);
            return result;
        }
    }
}
