package software.amazon.awscdk.services.macie;

/**
 * Properties for defining a `CfnCustomDataIdentifier`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.macie.*;
 * CfnCustomDataIdentifierProps cfnCustomDataIdentifierProps = CfnCustomDataIdentifierProps.builder()
 *         .name("name")
 *         .regex("regex")
 *         // the properties below are optional
 *         .description("description")
 *         .ignoreWords(List.of("ignoreWords"))
 *         .keywords(List.of("keywords"))
 *         .maximumMatchDistance(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:04.717Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_macie.CfnCustomDataIdentifierProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomDataIdentifierProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomDataIdentifierProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A custom name for the custom data identifier. The name can contain as many as 128 characters.
     * <p>
     * We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The regular expression ( *regex* ) that defines the pattern to match.
     * <p>
     * The expression can contain as many as 512 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegex();

    /**
     * The description of the custom data identifier.
     * <p>
     * The description can contain as many as 512 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An array that lists specific character sequences (ignore words) to exclude from the results.
     * <p>
     * If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIgnoreWords() {
        return null;
    }

    /**
     * An array that lists specific character sequences (keywords), one of which must be within proximity ( `MaximumMatchDistance` ) of the regular expression to match.
     * <p>
     * The array can contain as many as 50 keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getKeywords() {
        return null;
    }

    /**
     * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the `Keywords` array.
     * <p>
     * Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMatchDistance() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomDataIdentifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomDataIdentifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomDataIdentifierProps> {
        java.lang.String name;
        java.lang.String regex;
        java.lang.String description;
        java.util.List<java.lang.String> ignoreWords;
        java.util.List<java.lang.String> keywords;
        java.lang.Number maximumMatchDistance;

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getName}
         * @param name A custom name for the custom data identifier. The name can contain as many as 128 characters. This parameter is required.
         *             We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getRegex}
         * @param regex The regular expression ( *regex* ) that defines the pattern to match. This parameter is required.
         *              The expression can contain as many as 512 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regex(java.lang.String regex) {
            this.regex = regex;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getDescription}
         * @param description The description of the custom data identifier.
         *                    The description can contain as many as 512 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getIgnoreWords}
         * @param ignoreWords An array that lists specific character sequences (ignore words) to exclude from the results.
         *                    If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreWords(java.util.List<java.lang.String> ignoreWords) {
            this.ignoreWords = ignoreWords;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getKeywords}
         * @param keywords An array that lists specific character sequences (keywords), one of which must be within proximity ( `MaximumMatchDistance` ) of the regular expression to match.
         *                 The array can contain as many as 50 keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keywords(java.util.List<java.lang.String> keywords) {
            this.keywords = keywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getMaximumMatchDistance}
         * @param maximumMatchDistance The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the `Keywords` array.
         *                             Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMatchDistance(java.lang.Number maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomDataIdentifierProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomDataIdentifierProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomDataIdentifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomDataIdentifierProps {
        private final java.lang.String name;
        private final java.lang.String regex;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> ignoreWords;
        private final java.util.List<java.lang.String> keywords;
        private final java.lang.Number maximumMatchDistance;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ignoreWords = software.amazon.jsii.Kernel.get(this, "ignoreWords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.keywords = software.amazon.jsii.Kernel.get(this, "keywords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maximumMatchDistance = software.amazon.jsii.Kernel.get(this, "maximumMatchDistance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.regex = java.util.Objects.requireNonNull(builder.regex, "regex is required");
            this.description = builder.description;
            this.ignoreWords = builder.ignoreWords;
            this.keywords = builder.keywords;
            this.maximumMatchDistance = builder.maximumMatchDistance;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRegex() {
            return this.regex;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getIgnoreWords() {
            return this.ignoreWords;
        }

        @Override
        public final java.util.List<java.lang.String> getKeywords() {
            return this.keywords;
        }

        @Override
        public final java.lang.Number getMaximumMatchDistance() {
            return this.maximumMatchDistance;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("regex", om.valueToTree(this.getRegex()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getIgnoreWords() != null) {
                data.set("ignoreWords", om.valueToTree(this.getIgnoreWords()));
            }
            if (this.getKeywords() != null) {
                data.set("keywords", om.valueToTree(this.getKeywords()));
            }
            if (this.getMaximumMatchDistance() != null) {
                data.set("maximumMatchDistance", om.valueToTree(this.getMaximumMatchDistance()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_macie.CfnCustomDataIdentifierProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomDataIdentifierProps.Jsii$Proxy that = (CfnCustomDataIdentifierProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!regex.equals(that.regex)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.ignoreWords != null ? !this.ignoreWords.equals(that.ignoreWords) : that.ignoreWords != null) return false;
            if (this.keywords != null ? !this.keywords.equals(that.keywords) : that.keywords != null) return false;
            return this.maximumMatchDistance != null ? this.maximumMatchDistance.equals(that.maximumMatchDistance) : that.maximumMatchDistance == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.regex.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.ignoreWords != null ? this.ignoreWords.hashCode() : 0);
            result = 31 * result + (this.keywords != null ? this.keywords.hashCode() : 0);
            result = 31 * result + (this.maximumMatchDistance != null ? this.maximumMatchDistance.hashCode() : 0);
            return result;
        }
    }
}
