package software.amazon.awscdk.services.qldb;

/**
 * A CloudFormation `AWS::QLDB::Ledger`.
 * <p>
 * The <code>AWS::QLDB::Ledger</code> resource specifies a new Amazon Quantum Ledger Database (Amazon QLDB) ledger in your AWS account . Amazon QLDB is a fully managed ledger database that provides a transparent, immutable, and cryptographically verifiable transaction log owned by a central trusted authority. You can use QLDB to track all application data changes, and maintain a complete and verifiable history of changes over time.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/API_CreateLedger.html">CreateLedger</a> in the <em>Amazon QLDB API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qldb.*;
 * CfnLedger cfnLedger = CfnLedger.Builder.create(this, "MyCfnLedger")
 *         .permissionsMode("permissionsMode")
 *         // the properties below are optional
 *         .deletionProtection(false)
 *         .kmsKey("kmsKey")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.246Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qldb.CfnLedger")
public class CfnLedger extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLedger(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLedger(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.qldb.CfnLedger.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::QLDB::Ledger`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLedger(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.qldb.CfnLedgerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The permissions mode to assign to the ledger that you want to create.
     * <p>
     * This parameter can have one of the following values:
     * <p>
     * <ul>
     * <li><code>ALLOW_ALL</code> : A legacy permissions mode that enables access control with API-level granularity for ledgers.</li>
     * </ul>
     * <p>
     * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code> ) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.
     * <p>
     * <ul>
     * <li><code>STANDARD</code> : ( <em>Recommended</em> ) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</li>
     * </ul>
     * <p>
     * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <em>Amazon QLDB Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPermissionsMode() {
        return software.amazon.jsii.Kernel.get(this, "permissionsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The permissions mode to assign to the ledger that you want to create.
     * <p>
     * This parameter can have one of the following values:
     * <p>
     * <ul>
     * <li><code>ALLOW_ALL</code> : A legacy permissions mode that enables access control with API-level granularity for ledgers.</li>
     * </ul>
     * <p>
     * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code> ) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.
     * <p>
     * <ul>
     * <li><code>STANDARD</code> : ( <em>Recommended</em> ) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</li>
     * </ul>
     * <p>
     * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <em>Amazon QLDB Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionsMode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "permissionsMode", java.util.Objects.requireNonNull(value, "permissionsMode is required"));
    }

    /**
     * Specifies whether the ledger is protected from being deleted by any user.
     * <p>
     * If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the ledger is protected from being deleted by any user.
     * <p>
     * If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * Specifies whether the ledger is protected from being deleted by any user.
     * <p>
     * If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The key in AWS Key Management Service ( AWS KMS ) to use for encryption of data at rest in the ledger.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <em>Amazon QLDB Developer Guide</em> .
     * <p>
     * Use one of the following options to specify this parameter:
     * <p>
     * <ul>
     * <li><code>AWS_OWNED_KMS_KEY</code> : Use an AWS KMS key that is owned and managed by AWS on your behalf.</li>
     * <li><em>Undefined</em> : By default, use an AWS owned KMS key.</li>
     * <li><em>A valid symmetric customer managed KMS key</em> : Use the specified symmetric encryption KMS key in your account that you create, own, and manage.</li>
     * </ul>
     * <p>
     * Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code> . To specify a key in a different AWS account , you must use the key ARN or alias ARN.
     * <p>
     * For example:
     * <p>
     * <ul>
     * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Alias name: <code>alias/ExampleAlias</code></li>
     * <li>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
        return software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The key in AWS Key Management Service ( AWS KMS ) to use for encryption of data at rest in the ledger.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <em>Amazon QLDB Developer Guide</em> .
     * <p>
     * Use one of the following options to specify this parameter:
     * <p>
     * <ul>
     * <li><code>AWS_OWNED_KMS_KEY</code> : Use an AWS KMS key that is owned and managed by AWS on your behalf.</li>
     * <li><em>Undefined</em> : By default, use an AWS owned KMS key.</li>
     * <li><em>A valid symmetric customer managed KMS key</em> : Use the specified symmetric encryption KMS key in your account that you create, own, and manage.</li>
     * </ul>
     * <p>
     * Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code> . To specify a key in a different AWS account , you must use the key ARN or alias ARN.
     * <p>
     * For example:
     * <p>
     * <ul>
     * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Alias name: <code>alias/ExampleAlias</code></li>
     * <li>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKey", value);
    }

    /**
     * The name of the ledger that you want to create.
     * <p>
     * The name must be unique among all of the ledgers in your AWS account in the current Region.
     * <p>
     * Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <em>Amazon QLDB Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ledger that you want to create.
     * <p>
     * The name must be unique among all of the ledgers in your AWS account in the current Region.
     * <p>
     * Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <em>Amazon QLDB Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.qldb.CfnLedger}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.qldb.CfnLedger> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.qldb.CfnLedgerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.qldb.CfnLedgerProps.Builder();
        }

        /**
         * The permissions mode to assign to the ledger that you want to create.
         * <p>
         * This parameter can have one of the following values:
         * <p>
         * <ul>
         * <li><code>ALLOW_ALL</code> : A legacy permissions mode that enables access control with API-level granularity for ledgers.</li>
         * </ul>
         * <p>
         * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code> ) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.
         * <p>
         * <ul>
         * <li><code>STANDARD</code> : ( <em>Recommended</em> ) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</li>
         * </ul>
         * <p>
         * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <em>Amazon QLDB Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param permissionsMode The permissions mode to assign to the ledger that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsMode(final java.lang.String permissionsMode) {
            this.props.permissionsMode(permissionsMode);
            return this;
        }

        /**
         * Specifies whether the ledger is protected from being deleted by any user.
         * <p>
         * If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
         * <p>
         * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
         * <p>
         * @return {@code this}
         * @param deletionProtection Specifies whether the ledger is protected from being deleted by any user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }
        /**
         * Specifies whether the ledger is protected from being deleted by any user.
         * <p>
         * If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
         * <p>
         * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
         * <p>
         * @return {@code this}
         * @param deletionProtection Specifies whether the ledger is protected from being deleted by any user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The key in AWS Key Management Service ( AWS KMS ) to use for encryption of data at rest in the ledger.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <em>Amazon QLDB Developer Guide</em> .
         * <p>
         * Use one of the following options to specify this parameter:
         * <p>
         * <ul>
         * <li><code>AWS_OWNED_KMS_KEY</code> : Use an AWS KMS key that is owned and managed by AWS on your behalf.</li>
         * <li><em>Undefined</em> : By default, use an AWS owned KMS key.</li>
         * <li><em>A valid symmetric customer managed KMS key</em> : Use the specified symmetric encryption KMS key in your account that you create, own, and manage.</li>
         * </ul>
         * <p>
         * Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code> . To specify a key in a different AWS account , you must use the key ARN or alias ARN.
         * <p>
         * For example:
         * <p>
         * <ul>
         * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Alias name: <code>alias/ExampleAlias</code></li>
         * <li>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param kmsKey The key in AWS Key Management Service ( AWS KMS ) to use for encryption of data at rest in the ledger. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final java.lang.String kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * The name of the ledger that you want to create.
         * <p>
         * The name must be unique among all of the ledgers in your AWS account in the current Region.
         * <p>
         * Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <em>Amazon QLDB Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param name The name of the ledger that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.qldb.CfnLedger}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.qldb.CfnLedger build() {
            return new software.amazon.awscdk.services.qldb.CfnLedger(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
