package software.amazon.awscdk.services.qldb;

/**
 * Properties for defining a `CfnLedger`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qldb.*;
 * CfnLedgerProps cfnLedgerProps = CfnLedgerProps.builder()
 *         .permissionsMode("permissionsMode")
 *         // the properties below are optional
 *         .deletionProtection(false)
 *         .kmsKey("kmsKey")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.248Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qldb.CfnLedgerProps")
@software.amazon.jsii.Jsii.Proxy(CfnLedgerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLedgerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The permissions mode to assign to the ledger that you want to create.
     * <p>
     * This parameter can have one of the following values:
     * <p>
     * <ul>
     * <li><code>ALLOW_ALL</code> : A legacy permissions mode that enables access control with API-level granularity for ledgers.</li>
     * </ul>
     * <p>
     * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code> ) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.
     * <p>
     * <ul>
     * <li><code>STANDARD</code> : ( <em>Recommended</em> ) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</li>
     * </ul>
     * <p>
     * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <em>Amazon QLDB Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPermissionsMode();

    /**
     * Specifies whether the ledger is protected from being deleted by any user.
     * <p>
     * If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * The key in AWS Key Management Service ( AWS KMS ) to use for encryption of data at rest in the ledger.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <em>Amazon QLDB Developer Guide</em> .
     * <p>
     * Use one of the following options to specify this parameter:
     * <p>
     * <ul>
     * <li><code>AWS_OWNED_KMS_KEY</code> : Use an AWS KMS key that is owned and managed by AWS on your behalf.</li>
     * <li><em>Undefined</em> : By default, use an AWS owned KMS key.</li>
     * <li><em>A valid symmetric customer managed KMS key</em> : Use the specified symmetric encryption KMS key in your account that you create, own, and manage.</li>
     * </ul>
     * <p>
     * Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code> . To specify a key in a different AWS account , you must use the key ARN or alias ARN.
     * <p>
     * For example:
     * <p>
     * <ul>
     * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Alias name: <code>alias/ExampleAlias</code></li>
     * <li>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
        return null;
    }

    /**
     * The name of the ledger that you want to create.
     * <p>
     * The name must be unique among all of the ledgers in your AWS account in the current Region.
     * <p>
     * Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <em>Amazon QLDB Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLedgerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLedgerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLedgerProps> {
        java.lang.String permissionsMode;
        java.lang.Object deletionProtection;
        java.lang.String kmsKey;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLedgerProps#getPermissionsMode}
         * @param permissionsMode The permissions mode to assign to the ledger that you want to create. This parameter is required.
         *                        This parameter can have one of the following values:
         *                        <p>
         *                        <ul>
         *                        <li><code>ALLOW_ALL</code> : A legacy permissions mode that enables access control with API-level granularity for ledgers.</li>
         *                        </ul>
         *                        <p>
         *                        This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code> ) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.
         *                        <p>
         *                        <ul>
         *                        <li><code>STANDARD</code> : ( <em>Recommended</em> ) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</li>
         *                        </ul>
         *                        <p>
         *                        By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <em>Amazon QLDB Developer Guide</em> .
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsMode(java.lang.String permissionsMode) {
            this.permissionsMode = permissionsMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnLedgerProps#getDeletionProtection}
         * @param deletionProtection Specifies whether the ledger is protected from being deleted by any user.
         *                           If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
         *                           <p>
         *                           If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnLedgerProps#getDeletionProtection}
         * @param deletionProtection Specifies whether the ledger is protected from being deleted by any user.
         *                           If not defined during ledger creation, this feature is enabled ( <code>true</code> ) by default.
         *                           <p>
         *                           If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the parameter to <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnLedgerProps#getKmsKey}
         * @param kmsKey The key in AWS Key Management Service ( AWS KMS ) to use for encryption of data at rest in the ledger.
         *               For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <em>Amazon QLDB Developer Guide</em> .
         *               <p>
         *               Use one of the following options to specify this parameter:
         *               <p>
         *               <ul>
         *               <li><code>AWS_OWNED_KMS_KEY</code> : Use an AWS KMS key that is owned and managed by AWS on your behalf.</li>
         *               <li><em>Undefined</em> : By default, use an AWS owned KMS key.</li>
         *               <li><em>A valid symmetric customer managed KMS key</em> : Use the specified symmetric encryption KMS key in your account that you create, own, and manage.</li>
         *               </ul>
         *               <p>
         *               Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *               <p>
         *               To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code> . To specify a key in a different AWS account , you must use the key ARN or alias ARN.
         *               <p>
         *               For example:
         *               <p>
         *               <ul>
         *               <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         *               <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         *               <li>Alias name: <code>alias/ExampleAlias</code></li>
         *               <li>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></li>
         *               </ul>
         *               <p>
         *               For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(java.lang.String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnLedgerProps#getName}
         * @param name The name of the ledger that you want to create.
         *             The name must be unique among all of the ledgers in your AWS account in the current Region.
         *             <p>
         *             Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <em>Amazon QLDB Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnLedgerProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLedgerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLedgerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLedgerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLedgerProps {
        private final java.lang.String permissionsMode;
        private final java.lang.Object deletionProtection;
        private final java.lang.String kmsKey;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.permissionsMode = software.amazon.jsii.Kernel.get(this, "permissionsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.permissionsMode = java.util.Objects.requireNonNull(builder.permissionsMode, "permissionsMode is required");
            this.deletionProtection = builder.deletionProtection;
            this.kmsKey = builder.kmsKey;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getPermissionsMode() {
            return this.permissionsMode;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("permissionsMode", om.valueToTree(this.getPermissionsMode()));
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qldb.CfnLedgerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLedgerProps.Jsii$Proxy that = (CfnLedgerProps.Jsii$Proxy) o;

            if (!permissionsMode.equals(that.permissionsMode)) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.permissionsMode.hashCode();
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
