package software.amazon.awscdk.services.quicksight;

/**
 * Properties for defining a `CfnDataSource`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnDataSourceProps cfnDataSourceProps = CfnDataSourceProps.builder()
 *         .alternateDataSourceParameters(List.of(DataSourceParametersProperty.builder()
 *                 .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .athenaParameters(AthenaParametersProperty.builder()
 *                         .workGroup("workGroup")
 *                         .build())
 *                 .auroraParameters(AuroraParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .mariaDbParameters(MariaDbParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .mySqlParameters(MySqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .oracleParameters(OracleParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .postgreSqlParameters(PostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .prestoParameters(PrestoParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .rdsParameters(RdsParametersProperty.builder()
 *                         .database("database")
 *                         .instanceId("instanceId")
 *                         .build())
 *                 .redshiftParameters(RedshiftParametersProperty.builder()
 *                         .database("database")
 *                         // the properties below are optional
 *                         .clusterId("clusterId")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .s3Parameters(S3ParametersProperty.builder()
 *                         .manifestFileLocation(ManifestFileLocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .snowflakeParameters(SnowflakeParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .warehouse("warehouse")
 *                         .build())
 *                 .sparkParameters(SparkParametersProperty.builder()
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .sqlServerParameters(SqlServerParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .teradataParameters(TeradataParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .build()))
 *         .awsAccountId("awsAccountId")
 *         .credentials(DataSourceCredentialsProperty.builder()
 *                 .copySourceArn("copySourceArn")
 *                 .credentialPair(CredentialPairProperty.builder()
 *                         .password("password")
 *                         .username("username")
 *                         // the properties below are optional
 *                         .alternateDataSourceParameters(List.of(DataSourceParametersProperty.builder()
 *                                 .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
 *                                         .domain("domain")
 *                                         .build())
 *                                 .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
 *                                         .domain("domain")
 *                                         .build())
 *                                 .athenaParameters(AthenaParametersProperty.builder()
 *                                         .workGroup("workGroup")
 *                                         .build())
 *                                 .auroraParameters(AuroraParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .mariaDbParameters(MariaDbParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .mySqlParameters(MySqlParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .oracleParameters(OracleParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .postgreSqlParameters(PostgreSqlParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .prestoParameters(PrestoParametersProperty.builder()
 *                                         .catalog("catalog")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .rdsParameters(RdsParametersProperty.builder()
 *                                         .database("database")
 *                                         .instanceId("instanceId")
 *                                         .build())
 *                                 .redshiftParameters(RedshiftParametersProperty.builder()
 *                                         .database("database")
 *                                         // the properties below are optional
 *                                         .clusterId("clusterId")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .s3Parameters(S3ParametersProperty.builder()
 *                                         .manifestFileLocation(ManifestFileLocationProperty.builder()
 *                                                 .bucket("bucket")
 *                                                 .key("key")
 *                                                 .build())
 *                                         .build())
 *                                 .snowflakeParameters(SnowflakeParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .warehouse("warehouse")
 *                                         .build())
 *                                 .sparkParameters(SparkParametersProperty.builder()
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .sqlServerParameters(SqlServerParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .teradataParameters(TeradataParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .dataSourceId("dataSourceId")
 *         .dataSourceParameters(DataSourceParametersProperty.builder()
 *                 .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .athenaParameters(AthenaParametersProperty.builder()
 *                         .workGroup("workGroup")
 *                         .build())
 *                 .auroraParameters(AuroraParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .mariaDbParameters(MariaDbParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .mySqlParameters(MySqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .oracleParameters(OracleParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .postgreSqlParameters(PostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .prestoParameters(PrestoParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .rdsParameters(RdsParametersProperty.builder()
 *                         .database("database")
 *                         .instanceId("instanceId")
 *                         .build())
 *                 .redshiftParameters(RedshiftParametersProperty.builder()
 *                         .database("database")
 *                         // the properties below are optional
 *                         .clusterId("clusterId")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .s3Parameters(S3ParametersProperty.builder()
 *                         .manifestFileLocation(ManifestFileLocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .snowflakeParameters(SnowflakeParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .warehouse("warehouse")
 *                         .build())
 *                 .sparkParameters(SparkParametersProperty.builder()
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .sqlServerParameters(SqlServerParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .teradataParameters(TeradataParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .build())
 *         .errorInfo(DataSourceErrorInfoProperty.builder()
 *                 .message("message")
 *                 .type("type")
 *                 .build())
 *         .name("name")
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .sslProperties(SslPropertiesProperty.builder()
 *                 .disableSsl(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .vpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                 .vpcConnectionArn("vpcConnectionArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.297Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A set of alternate data source parameters that you want to share for the credentials stored with this data source.
     * <p>
     * The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAlternateDataSourceParameters() {
        return null;
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return null;
    }

    /**
     * The credentials Amazon QuickSight that uses to connect to your underlying source.
     * <p>
     * Currently, only credentials based on user name and password are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCredentials() {
        return null;
    }

    /**
     * An ID for the data source.
     * <p>
     * This ID is unique per AWS Region for each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataSourceId() {
        return null;
    }

    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSourceParameters() {
        return null;
    }

    /**
     * Error information from the last update or the creation of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getErrorInfo() {
        return null;
    }

    /**
     * A display name for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A list of resource permissions on the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return null;
    }

    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSslProperties() {
        return null;
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The type of the data source. To return a list of all data sources, use `ListDataSources` .
     * <p>
     * Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConnectionProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataSourceProps> {
        java.lang.Object alternateDataSourceParameters;
        java.lang.String awsAccountId;
        java.lang.Object credentials;
        java.lang.String dataSourceId;
        java.lang.Object dataSourceParameters;
        java.lang.Object errorInfo;
        java.lang.String name;
        java.lang.Object permissions;
        java.lang.Object sslProperties;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String type;
        java.lang.Object vpcConnectionProperties;

        /**
         * Sets the value of {@link CfnDataSourceProps#getAlternateDataSourceParameters}
         * @param alternateDataSourceParameters A set of alternate data source parameters that you want to share for the credentials stored with this data source.
         *                                      The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternateDataSourceParameters(software.amazon.awscdk.IResolvable alternateDataSourceParameters) {
            this.alternateDataSourceParameters = alternateDataSourceParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getAlternateDataSourceParameters}
         * @param alternateDataSourceParameters A set of alternate data source parameters that you want to share for the credentials stored with this data source.
         *                                      The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternateDataSourceParameters(java.util.List<? extends java.lang.Object> alternateDataSourceParameters) {
            this.alternateDataSourceParameters = alternateDataSourceParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getAwsAccountId}
         * @param awsAccountId The AWS account ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getCredentials}
         * @param credentials The credentials Amazon QuickSight that uses to connect to your underlying source.
         *                    Currently, only credentials based on user name and password are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceCredentialsProperty credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getCredentials}
         * @param credentials The credentials Amazon QuickSight that uses to connect to your underlying source.
         *                    Currently, only credentials based on user name and password are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.IResolvable credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataSourceId}
         * @param dataSourceId An ID for the data source.
         *                     This ID is unique per AWS Region for each AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceId(java.lang.String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataSourceParameters}
         * @param dataSourceParameters The parameters that Amazon QuickSight uses to connect to your underlying source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceParametersProperty dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataSourceParameters}
         * @param dataSourceParameters The parameters that Amazon QuickSight uses to connect to your underlying source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceParameters(software.amazon.awscdk.IResolvable dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getErrorInfo}
         * @param errorInfo Error information from the last update or the creation of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorInfo(software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceErrorInfoProperty errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getErrorInfo}
         * @param errorInfo Error information from the last update or the creation of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorInfo(software.amazon.awscdk.IResolvable errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getName}
         * @param name A display name for the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getPermissions}
         * @param permissions A list of resource permissions on the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(software.amazon.awscdk.IResolvable permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getPermissions}
         * @param permissions A list of resource permissions on the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<? extends java.lang.Object> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getSslProperties}
         * @param sslProperties Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslProperties(software.amazon.awscdk.services.quicksight.CfnDataSource.SslPropertiesProperty sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getSslProperties}
         * @param sslProperties Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslProperties(software.amazon.awscdk.IResolvable sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getTags}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getType}
         * @param type The type of the data source. To return a list of all data sources, use `ListDataSources` .
         *             Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getVpcConnectionProperties}
         * @param vpcConnectionProperties Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConnectionProperties(software.amazon.awscdk.services.quicksight.CfnDataSource.VpcConnectionPropertiesProperty vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getVpcConnectionProperties}
         * @param vpcConnectionProperties Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConnectionProperties(software.amazon.awscdk.IResolvable vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataSourceProps {
        private final java.lang.Object alternateDataSourceParameters;
        private final java.lang.String awsAccountId;
        private final java.lang.Object credentials;
        private final java.lang.String dataSourceId;
        private final java.lang.Object dataSourceParameters;
        private final java.lang.Object errorInfo;
        private final java.lang.String name;
        private final java.lang.Object permissions;
        private final java.lang.Object sslProperties;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String type;
        private final java.lang.Object vpcConnectionProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alternateDataSourceParameters = software.amazon.jsii.Kernel.get(this, "alternateDataSourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSourceId = software.amazon.jsii.Kernel.get(this, "dataSourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSourceParameters = software.amazon.jsii.Kernel.get(this, "dataSourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.errorInfo = software.amazon.jsii.Kernel.get(this, "errorInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sslProperties = software.amazon.jsii.Kernel.get(this, "sslProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcConnectionProperties = software.amazon.jsii.Kernel.get(this, "vpcConnectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alternateDataSourceParameters = builder.alternateDataSourceParameters;
            this.awsAccountId = builder.awsAccountId;
            this.credentials = builder.credentials;
            this.dataSourceId = builder.dataSourceId;
            this.dataSourceParameters = builder.dataSourceParameters;
            this.errorInfo = builder.errorInfo;
            this.name = builder.name;
            this.permissions = builder.permissions;
            this.sslProperties = builder.sslProperties;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.type = builder.type;
            this.vpcConnectionProperties = builder.vpcConnectionProperties;
        }

        @Override
        public final java.lang.Object getAlternateDataSourceParameters() {
            return this.alternateDataSourceParameters;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.Object getCredentials() {
            return this.credentials;
        }

        @Override
        public final java.lang.String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final java.lang.Object getDataSourceParameters() {
            return this.dataSourceParameters;
        }

        @Override
        public final java.lang.Object getErrorInfo() {
            return this.errorInfo;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.lang.Object getSslProperties() {
            return this.sslProperties;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getVpcConnectionProperties() {
            return this.vpcConnectionProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAlternateDataSourceParameters() != null) {
                data.set("alternateDataSourceParameters", om.valueToTree(this.getAlternateDataSourceParameters()));
            }
            if (this.getAwsAccountId() != null) {
                data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getDataSourceId() != null) {
                data.set("dataSourceId", om.valueToTree(this.getDataSourceId()));
            }
            if (this.getDataSourceParameters() != null) {
                data.set("dataSourceParameters", om.valueToTree(this.getDataSourceParameters()));
            }
            if (this.getErrorInfo() != null) {
                data.set("errorInfo", om.valueToTree(this.getErrorInfo()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getSslProperties() != null) {
                data.set("sslProperties", om.valueToTree(this.getSslProperties()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getVpcConnectionProperties() != null) {
                data.set("vpcConnectionProperties", om.valueToTree(this.getVpcConnectionProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataSourceProps.Jsii$Proxy that = (CfnDataSourceProps.Jsii$Proxy) o;

            if (this.alternateDataSourceParameters != null ? !this.alternateDataSourceParameters.equals(that.alternateDataSourceParameters) : that.alternateDataSourceParameters != null) return false;
            if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.dataSourceId != null ? !this.dataSourceId.equals(that.dataSourceId) : that.dataSourceId != null) return false;
            if (this.dataSourceParameters != null ? !this.dataSourceParameters.equals(that.dataSourceParameters) : that.dataSourceParameters != null) return false;
            if (this.errorInfo != null ? !this.errorInfo.equals(that.errorInfo) : that.errorInfo != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            if (this.sslProperties != null ? !this.sslProperties.equals(that.sslProperties) : that.sslProperties != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.vpcConnectionProperties != null ? this.vpcConnectionProperties.equals(that.vpcConnectionProperties) : that.vpcConnectionProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alternateDataSourceParameters != null ? this.alternateDataSourceParameters.hashCode() : 0;
            result = 31 * result + (this.awsAccountId != null ? this.awsAccountId.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.dataSourceId != null ? this.dataSourceId.hashCode() : 0);
            result = 31 * result + (this.dataSourceParameters != null ? this.dataSourceParameters.hashCode() : 0);
            result = 31 * result + (this.errorInfo != null ? this.errorInfo.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.sslProperties != null ? this.sslProperties.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.vpcConnectionProperties != null ? this.vpcConnectionProperties.hashCode() : 0);
            return result;
        }
    }
}
