package software.amazon.awscdk.services.rds;

/**
 * The versions for the PostgreSQL instance engines (those returned by {@link DatabaseInstanceEngine.postgres}).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * IInstanceEngine engine = DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_12_3).build());
 * Key myKey = new Key(this, "MyKey");
 * DatabaseInstance.Builder.create(this, "InstanceWithCustomizedSecret")
 *         .engine(engine)
 *         .vpc(vpc)
 *         .credentials(Credentials.fromGeneratedSecret("postgres", CredentialsBaseOptions.builder()
 *                 .secretName("my-cool-name")
 *                 .encryptionKey(myKey)
 *                 .excludeCharacters("!&amp;*^#&#64;()")
 *                 .replicaRegions(List.of(ReplicaRegion.builder().region("eu-west-1").build(), ReplicaRegion.builder().region("eu-west-2").build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.480Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.PostgresEngineVersion")
public class PostgresEngineVersion extends software.amazon.jsii.JsiiObject {

    protected PostgresEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PostgresEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_9_6_24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_9_6_24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
    }

    /**
     * Create a new PostgresEngineVersion with an arbitrary version.
     * <p>
     * @param postgresFullVersion the full version string, for example "13.11". This parameter is required.
     * @param postgresMajorVersion the major version of the engine, for example "13". This parameter is required.
     * @param postgresFeatures
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.PostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String postgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String postgresMajorVersion, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.PostgresEngineFeatures postgresFeatures) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(postgresFullVersion, "postgresFullVersion is required"), java.util.Objects.requireNonNull(postgresMajorVersion, "postgresMajorVersion is required"), postgresFeatures });
    }

    /**
     * Create a new PostgresEngineVersion with an arbitrary version.
     * <p>
     * @param postgresFullVersion the full version string, for example "13.11". This parameter is required.
     * @param postgresMajorVersion the major version of the engine, for example "13". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.PostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String postgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String postgresMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(postgresFullVersion, "postgresFullVersion is required"), java.util.Objects.requireNonNull(postgresMajorVersion, "postgresMajorVersion is required") });
    }

    /**
     * Version "10" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10;

    /**
     * Version "10.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_1;

    /**
     * Version "10.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_10;

    /**
     * Version "10.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_11;

    /**
     * Version "10.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_12;

    /**
     * Version "10.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_13;

    /**
     * Version "10.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_14;

    /**
     * Version "10.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_15;

    /**
     * Version "10.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_16;

    /**
     * Version "10.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_17;

    /**
     * Version "10.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_18;

    /**
     * Version "10.19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_19;

    /**
     * Version "10.20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_20;

    /**
     * Version "10.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_3;

    /**
     * Version "10.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_4;

    /**
     * Version "10.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_5;

    /**
     * Version "10.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_6;

    /**
     * Version "10.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_7;

    /**
     * Version "10.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_9;

    /**
     * Version "11" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11;

    /**
     * Version "11.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_1;

    /**
     * Version "11.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_10;

    /**
     * Version "11.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_11;

    /**
     * Version "11.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_12;

    /**
     * Version "11.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_13;

    /**
     * Version "11.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_14;

    /**
     * Version "11.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_15;

    /**
     * Version "11.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_16;

    /**
     * Version "11.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_2;

    /**
     * Version "11.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_4;

    /**
     * Version "11.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_5;

    /**
     * Version "11.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_6;

    /**
     * Version "11.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_7;

    /**
     * Version "11.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_8;

    /**
     * Version "11.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_9;

    /**
     * Version "12" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12;

    /**
     * Version "12.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_10;

    /**
     * Version "12.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_11;

    /**
     * Version "12.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_2;

    /**
     * Version "12.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_3;

    /**
     * Version "12.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_4;

    /**
     * Version "12.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_5;

    /**
     * Version "12.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_6;

    /**
     * Version "12.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_7;

    /**
     * Version "12.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_8;

    /**
     * Version "12.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_9;

    /**
     * Version "13" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13;

    /**
     * Version "13.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_1;

    /**
     * Version "13.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_2;

    /**
     * Version "13.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_3;

    /**
     * Version "13.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_4;

    /**
     * Version "13.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_5;

    /**
     * Version "13.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_6;

    /**
     * Version "13.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_7;

    /**
     * Version "14" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14;

    /**
     * Version "14.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_1;

    /**
     * Version "14.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_2;

    /**
     * Version "14.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_3;

    /**
     * Version "14.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_4;

    /**
     * (deprecated) Version "9.6.24".
     * <p>
     * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_9_6_24;

    /**
     * The full version string, for example, "13.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPostgresFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "postgresFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPostgresMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "postgresMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
