package software.amazon.awscdk.services.rds;

/**
 * Properties that describe an existing cluster instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.rds.*;
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Secret secret;
 * SecurityGroup securityGroup;
 * ServerlessClusterAttributes serverlessClusterAttributes = ServerlessClusterAttributes.builder()
 *         .clusterIdentifier("clusterIdentifier")
 *         // the properties below are optional
 *         .clusterEndpointAddress("clusterEndpointAddress")
 *         .port(123)
 *         .readerEndpointAddress("readerEndpointAddress")
 *         .secret(secret)
 *         .securityGroups(List.of(securityGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.497Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ServerlessClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(ServerlessClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerlessClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifier for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

    /**
     * Cluster endpoint address.
     * <p>
     * Default: - no endpoint address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpointAddress() {
        return null;
    }

    /**
     * The database port.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Reader endpoint address.
     * <p>
     * Default: - no reader address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReaderEndpointAddress() {
        return null;
    }

    /**
     * The secret attached to the database cluster.
     * <p>
     * Default: - no secret
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return null;
    }

    /**
     * The security groups of the database cluster.
     * <p>
     * Default: - no security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServerlessClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerlessClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerlessClusterAttributes> {
        java.lang.String clusterIdentifier;
        java.lang.String clusterEndpointAddress;
        java.lang.Number port;
        java.lang.String readerEndpointAddress;
        software.amazon.awscdk.services.secretsmanager.ISecret secret;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getClusterIdentifier}
         * @param clusterIdentifier Identifier for the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getClusterEndpointAddress}
         * @param clusterEndpointAddress Cluster endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterEndpointAddress(java.lang.String clusterEndpointAddress) {
            this.clusterEndpointAddress = clusterEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getPort}
         * @param port The database port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getReaderEndpointAddress}
         * @param readerEndpointAddress Reader endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readerEndpointAddress(java.lang.String readerEndpointAddress) {
            this.readerEndpointAddress = readerEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getSecret}
         * @param secret The secret attached to the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link ServerlessClusterAttributes#getSecurityGroups}
         * @param securityGroups The security groups of the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerlessClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerlessClusterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServerlessClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessClusterAttributes {
        private final java.lang.String clusterIdentifier;
        private final java.lang.String clusterEndpointAddress;
        private final java.lang.Number port;
        private final java.lang.String readerEndpointAddress;
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpointAddress = software.amazon.jsii.Kernel.get(this, "clusterEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readerEndpointAddress = software.amazon.jsii.Kernel.get(this, "readerEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
            this.clusterEndpointAddress = builder.clusterEndpointAddress;
            this.port = builder.port;
            this.readerEndpointAddress = builder.readerEndpointAddress;
            this.secret = builder.secret;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getClusterEndpointAddress() {
            return this.clusterEndpointAddress;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getReaderEndpointAddress() {
            return this.readerEndpointAddress;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            if (this.getClusterEndpointAddress() != null) {
                data.set("clusterEndpointAddress", om.valueToTree(this.getClusterEndpointAddress()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getReaderEndpointAddress() != null) {
                data.set("readerEndpointAddress", om.valueToTree(this.getReaderEndpointAddress()));
            }
            if (this.getSecret() != null) {
                data.set("secret", om.valueToTree(this.getSecret()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ServerlessClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerlessClusterAttributes.Jsii$Proxy that = (ServerlessClusterAttributes.Jsii$Proxy) o;

            if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
            if (this.clusterEndpointAddress != null ? !this.clusterEndpointAddress.equals(that.clusterEndpointAddress) : that.clusterEndpointAddress != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.readerEndpointAddress != null ? !this.readerEndpointAddress.equals(that.readerEndpointAddress) : that.readerEndpointAddress != null) return false;
            if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterIdentifier.hashCode();
            result = 31 * result + (this.clusterEndpointAddress != null ? this.clusterEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.readerEndpointAddress != null ? this.readerEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
