package software.amazon.awscdk.services.redshift;

/**
 * A CloudFormation `AWS::Redshift::EventSubscription`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * CfnEventSubscription cfnEventSubscription = CfnEventSubscription.Builder.create(this, "MyCfnEventSubscription")
 *         .subscriptionName("subscriptionName")
 *         // the properties below are optional
 *         .enabled(false)
 *         .eventCategories(List.of("eventCategories"))
 *         .severity("severity")
 *         .snsTopicArn("snsTopicArn")
 *         .sourceIds(List.of("sourceIds"))
 *         .sourceType("sourceType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.530Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnEventSubscription")
public class CfnEventSubscription extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEventSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.CfnEventSubscription.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Redshift::EventSubscription`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventSubscription(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.CfnEventSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The AWS account associated with the Amazon Redshift event notification subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCustomerAwsId() {
        return software.amazon.jsii.Kernel.get(this, "attrCustomerAwsId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Amazon Redshift event notification subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCustSubscriptionId() {
        return software.amazon.jsii.Kernel.get(this, "attrCustSubscriptionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The list of Amazon Redshift event categories specified in the event notification subscription.
     * <p>
     * Values: Configuration, Management, Monitoring, Security, Pending
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrEventCategoriesList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrEventCategoriesList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A list of the sources that publish events to the Amazon Redshift event notification subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrSourceIdsList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrSourceIdsList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The status of the Amazon Redshift event notification subscription.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can be one of the following: active | no-permission | topic-not-exist</li>
     * <li>The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time the Amazon Redshift event notification subscription was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSubscriptionCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrSubscriptionCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of tag instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the event subscription to be created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Cannot be null, empty, or blank.</li>
     * <li>Must contain from 1 to 255 alphanumeric characters or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubscriptionName() {
        return software.amazon.jsii.Kernel.get(this, "subscriptionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the event subscription to be created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Cannot be null, empty, or blank.</li>
     * <li>Must contain from 1 to 255 alphanumeric characters or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscriptionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subscriptionName", java.util.Objects.requireNonNull(value, "subscriptionName is required"));
    }

    /**
     * A boolean value;
     * <p>
     * set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A boolean value;
     * <p>
     * set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * A boolean value;
     * <p>
     * set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
     * <p>
     * Values: configuration, management, monitoring, security, pending
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEventCategories() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "eventCategories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
     * <p>
     * Values: configuration, management, monitoring, security, pending
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventCategories(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "eventCategories", value);
    }

    /**
     * Specifies the Amazon Redshift event severity to be published by the event notification subscription.
     * <p>
     * Values: ERROR, INFO
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSeverity() {
        return software.amazon.jsii.Kernel.get(this, "severity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Amazon Redshift event severity to be published by the event notification subscription.
     * <p>
     * Values: ERROR, INFO
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSeverity(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "severity", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications.
     * <p>
     * The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications.
     * <p>
     * The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnsTopicArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snsTopicArn", value);
    }

    /**
     * A list of one or more identifiers of Amazon Redshift source objects.
     * <p>
     * All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.
     * <p>
     * Example: my-cluster-1, my-cluster-2
     * <p>
     * Example: my-snapshot-20131010
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "sourceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of one or more identifiers of Amazon Redshift source objects.
     * <p>
     * All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.
     * <p>
     * Example: my-cluster-1, my-cluster-2
     * <p>
     * Example: my-snapshot-20131010
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "sourceIds", value);
    }

    /**
     * The type of source that will be generating the events.
     * <p>
     * For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your AWS account . You must specify a source type in order to specify source IDs.
     * <p>
     * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceType() {
        return software.amazon.jsii.Kernel.get(this, "sourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of source that will be generating the events.
     * <p>
     * For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your AWS account . You must specify a source type in order to specify source IDs.
     * <p>
     * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceType", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshift.CfnEventSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshift.CfnEventSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshift.CfnEventSubscriptionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshift.CfnEventSubscriptionProps.Builder();
        }

        /**
         * The name of the event subscription to be created.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Cannot be null, empty, or blank.</li>
         * <li>Must contain from 1 to 255 alphanumeric characters or hyphens.</li>
         * <li>First character must be a letter.</li>
         * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param subscriptionName The name of the event subscription to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionName(final java.lang.String subscriptionName) {
            this.props.subscriptionName(subscriptionName);
            return this;
        }

        /**
         * A boolean value;
         * <p>
         * set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it.
         * <p>
         * @return {@code this}
         * @param enabled A boolean value;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }
        /**
         * A boolean value;
         * <p>
         * set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it.
         * <p>
         * @return {@code this}
         * @param enabled A boolean value;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
         * <p>
         * Values: configuration, management, monitoring, security, pending
         * <p>
         * @return {@code this}
         * @param eventCategories Specifies the Amazon Redshift event categories to be published by the event notification subscription. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventCategories(final java.util.List<java.lang.String> eventCategories) {
            this.props.eventCategories(eventCategories);
            return this;
        }

        /**
         * Specifies the Amazon Redshift event severity to be published by the event notification subscription.
         * <p>
         * Values: ERROR, INFO
         * <p>
         * @return {@code this}
         * @param severity Specifies the Amazon Redshift event severity to be published by the event notification subscription. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder severity(final java.lang.String severity) {
            this.props.severity(severity);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications.
         * <p>
         * The ARN is created by Amazon SNS when you create a topic and subscribe to it.
         * <p>
         * @return {@code this}
         * @param snsTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArn(final java.lang.String snsTopicArn) {
            this.props.snsTopicArn(snsTopicArn);
            return this;
        }

        /**
         * A list of one or more identifiers of Amazon Redshift source objects.
         * <p>
         * All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.
         * <p>
         * Example: my-cluster-1, my-cluster-2
         * <p>
         * Example: my-snapshot-20131010
         * <p>
         * @return {@code this}
         * @param sourceIds A list of one or more identifiers of Amazon Redshift source objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIds(final java.util.List<java.lang.String> sourceIds) {
            this.props.sourceIds(sourceIds);
            return this;
        }

        /**
         * The type of source that will be generating the events.
         * <p>
         * For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your AWS account . You must specify a source type in order to specify source IDs.
         * <p>
         * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
         * <p>
         * @return {@code this}
         * @param sourceType The type of source that will be generating the events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceType(final java.lang.String sourceType) {
            this.props.sourceType(sourceType);
            return this;
        }

        /**
         * A list of tag instances.
         * <p>
         * @return {@code this}
         * @param tags A list of tag instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.redshift.CfnEventSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshift.CfnEventSubscription build() {
            return new software.amazon.awscdk.services.redshift.CfnEventSubscription(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
