package software.amazon.awscdk.services.route53resolver;

/**
 * Properties for defining a `CfnResolverRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * CfnResolverRuleProps cfnResolverRuleProps = CfnResolverRuleProps.builder()
 *         .domainName("domainName")
 *         .ruleType("ruleType")
 *         // the properties below are optional
 *         .name("name")
 *         .resolverEndpointId("resolverEndpointId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetIps(List.of(TargetAddressProperty.builder()
 *                 .ip("ip")
 *                 // the properties below are optional
 *                 .port("port")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.711Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.CfnResolverRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnResolverRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResolverRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * DNS queries for this domain name are forwarded to the IP addresses that are specified in `TargetIps` .
     * <p>
     * If a query matches multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name (www.example.com).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * When you want to forward DNS queries for specified domain name to resolvers on your network, specify `FORWARD` .
     * <p>
     * When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify <code>SYSTEM</code> .
     * <p>
     * For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code> for <code>RuleType</code> . To then have Resolver process queries for apex.example.com, you create a rule and specify <code>SYSTEM</code> for <code>RuleType</code> .
     * <p>
     * Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleType();

    /**
     * The name for the Resolver rule, which you specified when you created the Resolver rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The ID of the endpoint that the rule is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResolverEndpointId() {
        return null;
    }

    /**
     * Route 53 Resolver doesn't support updating tags through CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to.
     * <p>
     * Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetIps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResolverRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResolverRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResolverRuleProps> {
        java.lang.String domainName;
        java.lang.String ruleType;
        java.lang.String name;
        java.lang.String resolverEndpointId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object targetIps;

        /**
         * Sets the value of {@link CfnResolverRuleProps#getDomainName}
         * @param domainName DNS queries for this domain name are forwarded to the IP addresses that are specified in `TargetIps` . This parameter is required.
         *                   If a query matches multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name (www.example.com).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverRuleProps#getRuleType}
         * @param ruleType When you want to forward DNS queries for specified domain name to resolvers on your network, specify `FORWARD` . This parameter is required.
         *                 When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify <code>SYSTEM</code> .
         *                 <p>
         *                 For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code> for <code>RuleType</code> . To then have Resolver process queries for apex.example.com, you create a rule and specify <code>SYSTEM</code> for <code>RuleType</code> .
         *                 <p>
         *                 Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleType(java.lang.String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverRuleProps#getName}
         * @param name The name for the Resolver rule, which you specified when you created the Resolver rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverRuleProps#getResolverEndpointId}
         * @param resolverEndpointId The ID of the endpoint that the rule is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverEndpointId(java.lang.String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverRuleProps#getTags}
         * @param tags Route 53 Resolver doesn't support updating tags through CloudFormation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverRuleProps#getTargetIps}
         * @param targetIps An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to.
         *                  Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetIps(software.amazon.awscdk.IResolvable targetIps) {
            this.targetIps = targetIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverRuleProps#getTargetIps}
         * @param targetIps An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to.
         *                  Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetIps(java.util.List<? extends java.lang.Object> targetIps) {
            this.targetIps = targetIps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResolverRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResolverRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResolverRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResolverRuleProps {
        private final java.lang.String domainName;
        private final java.lang.String ruleType;
        private final java.lang.String name;
        private final java.lang.String resolverEndpointId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object targetIps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleType = software.amazon.jsii.Kernel.get(this, "ruleType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resolverEndpointId = software.amazon.jsii.Kernel.get(this, "resolverEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.targetIps = software.amazon.jsii.Kernel.get(this, "targetIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.ruleType = java.util.Objects.requireNonNull(builder.ruleType, "ruleType is required");
            this.name = builder.name;
            this.resolverEndpointId = builder.resolverEndpointId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.targetIps = builder.targetIps;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getRuleType() {
            return this.ruleType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getResolverEndpointId() {
            return this.resolverEndpointId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTargetIps() {
            return this.targetIps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("ruleType", om.valueToTree(this.getRuleType()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getResolverEndpointId() != null) {
                data.set("resolverEndpointId", om.valueToTree(this.getResolverEndpointId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetIps() != null) {
                data.set("targetIps", om.valueToTree(this.getTargetIps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53resolver.CfnResolverRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResolverRuleProps.Jsii$Proxy that = (CfnResolverRuleProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!ruleType.equals(that.ruleType)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.resolverEndpointId != null ? !this.resolverEndpointId.equals(that.resolverEndpointId) : that.resolverEndpointId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.targetIps != null ? this.targetIps.equals(that.targetIps) : that.targetIps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.ruleType.hashCode());
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.resolverEndpointId != null ? this.resolverEndpointId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetIps != null ? this.targetIps.hashCode() : 0);
            return result;
        }
    }
}
