package software.amazon.awscdk.services.s3;

/**
 * What kind of server-side encryption to apply to this bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Bucket bucket = Bucket.Builder.create(this, "MyEncryptedBucket")
 *         .encryption(BucketEncryption.KMS)
 *         .build();
 * // you can access the encryption key:
 * assert(bucket.getEncryptionKey() instanceof Key);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.738Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.BucketEncryption")
public enum BucketEncryption {
    /**
     * Objects in the bucket are not encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UNENCRYPTED,
    /**
     * Server-side KMS encryption with a master key managed by KMS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS_MANAGED,
    /**
     * Server-side encryption with a master key managed by S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_MANAGED,
    /**
     * Server-side encryption with a KMS key managed by the user.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
}
