package software.amazon.awscdk.services.s3;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Bucket sourceBucket = Bucket.Builder.create(this, "MyBucket")
 *         .versioned(true)
 *         .build();
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact sourceOutput = new Artifact();
 * S3SourceAction sourceAction = S3SourceAction.Builder.create()
 *         .actionName("S3Source")
 *         .bucket(sourceBucket)
 *         .bucketKey("path/to/file.zip")
 *         .output(sourceOutput)
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:05.739Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.BucketProps")
@software.amazon.jsii.Jsii.Proxy(BucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies a canned ACL that grants predefined permissions to the bucket.
     * <p>
     * Default: BucketAccessControl.PRIVATE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
        return null;
    }

    /**
     * Whether all objects should be automatically deleted when the bucket is removed from the stack or when the stack is deleted.
     * <p>
     * Requires the <code>removalPolicy</code> to be set to <code>RemovalPolicy.DESTROY</code>.
     * <p>
     * <strong>Warning</strong> if you have deployed a bucket with <code>autoDeleteObjects: true</code>,
     * switching this to <code>false</code> in a CDK version <em>before</em> <code>1.126.0</code> will lead to
     * all objects in the bucket being deleted. Be sure to update your bucket resources
     * by deploying with CDK version <code>1.126.0</code> or later <strong>before</strong> switching this value to <code>false</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoDeleteObjects() {
        return null;
    }

    /**
     * The block public access configuration of this bucket.
     * <p>
     * Default: - CloudFormation defaults will apply. New buckets and objects don't allow public access, but users can modify bucket policies or object permissions to allow public access
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BlockPublicAccess getBlockPublicAccess() {
        return null;
    }

    /**
     * Whether Amazon S3 should use its own intermediary key to generate data keys.
     * <p>
     * Only relevant when using KMS for encryption.
     * <p>
     * <ul>
     * <li>If not enabled, every object GET and PUT will cause an API call to KMS (with the
     * attendant cost implications of that).</li>
     * <li>If enabled, S3 will use its own time-limited key instead.</li>
     * </ul>
     * <p>
     * Only relevant, when Encryption is set to <code>BucketEncryption.KMS</code> or <code>BucketEncryption.KMS_MANAGED</code>.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBucketKeyEnabled() {
        return null;
    }

    /**
     * Physical name of this bucket.
     * <p>
     * Default: - Assigned by CloudFormation (recommended).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return null;
    }

    /**
     * The CORS configuration of this bucket.
     * <p>
     * Default: - No CORS configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.CorsRule> getCors() {
        return null;
    }

    /**
     * The kind of server-side encryption to apply to this bucket.
     * <p>
     * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
     * encryption key is not specified, a key will automatically be created.
     * <p>
     * Default: - `Kms` if `encryptionKey` is specified, or `Unencrypted` otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
        return null;
    }

    /**
     * External KMS key to use for bucket encryption.
     * <p>
     * The 'encryption' property must be either not specified or set to "Kms".
     * An error will be emitted if encryption is set to "Unencrypted" or
     * "Managed".
     * <p>
     * Default: - If encryption is set to "Kms" and this property is undefined,
     * a new KMS key will be created and associated with this bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Enforces SSL for requests.
     * <p>
     * S3.5 of the AWS Foundational Security Best Practices Regarding S3.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnforceSSL() {
        return null;
    }

    /**
     * Whether this bucket should send notifications to Amazon EventBridge or not.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEventBridgeEnabled() {
        return null;
    }

    /**
     * Inteligent Tiering Configurations.
     * <p>
     * Default: No Intelligent Tiiering Configurations.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering.html">https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.IntelligentTieringConfiguration> getIntelligentTieringConfigurations() {
        return null;
    }

    /**
     * The inventory configuration of the bucket.
     * <p>
     * Default: - No inventory configuration
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.Inventory> getInventories() {
        return null;
    }

    /**
     * Rules that define how Amazon S3 manages objects during their lifetime.
     * <p>
     * Default: - No lifecycle rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
        return null;
    }

    /**
     * The metrics configuration of this bucket.
     * <p>
     * Default: - No metrics configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> getMetrics() {
        return null;
    }

    /**
     * The role to be used by the notifications handler.
     * <p>
     * Default: - a new role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getNotificationsHandlerRole() {
        return null;
    }

    /**
     * The objectOwnership of the bucket.
     * <p>
     * Default: - No ObjectOwnership configuration, uploading account will own the object.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.ObjectOwnership getObjectOwnership() {
        return null;
    }

    /**
     * Grants public read access to all objects in the bucket.
     * <p>
     * Similar to calling <code>bucket.grantPublicAccess()</code>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublicReadAccess() {
        return null;
    }

    /**
     * Policy to apply when the bucket is removed from this stack.
     * <p>
     * Default: - The bucket will be orphaned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Destination bucket for the server access logs.
     * <p>
     * Default: - If "serverAccessLogsPrefix" undefined - access logs disabled, otherwise - log to current bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getServerAccessLogsBucket() {
        return null;
    }

    /**
     * Optional log file prefix to use for the bucket's access logs.
     * <p>
     * If defined without "serverAccessLogsBucket", enables access logs to current bucket with this prefix.
     * <p>
     * Default: - No log file prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerAccessLogsPrefix() {
        return null;
    }

    /**
     * Whether this bucket should have transfer acceleration turned on or not.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTransferAcceleration() {
        return null;
    }

    /**
     * Whether this bucket should have versioning turned on or not.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVersioned() {
        return null;
    }

    /**
     * The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
     * <p>
     * Default: - No error document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebsiteErrorDocument() {
        return null;
    }

    /**
     * The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
     * <p>
     * Default: - No index document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebsiteIndexDocument() {
        return null;
    }

    /**
     * Specifies the redirect behavior of all requests to a website endpoint of a bucket.
     * <p>
     * If you specify this property, you can't specify "websiteIndexDocument", "websiteErrorDocument" nor , "websiteRoutingRules".
     * <p>
     * Default: - No redirection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.RedirectTarget getWebsiteRedirect() {
        return null;
    }

    /**
     * Rules that define when a redirect is applied and the redirect behavior.
     * <p>
     * Default: - No redirection rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.RoutingRule> getWebsiteRoutingRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BucketProps> {
        software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        java.lang.Boolean autoDeleteObjects;
        software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess;
        java.lang.Boolean bucketKeyEnabled;
        java.lang.String bucketName;
        java.util.List<software.amazon.awscdk.services.s3.CorsRule> cors;
        software.amazon.awscdk.services.s3.BucketEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.Boolean enforceSsl;
        java.lang.Boolean eventBridgeEnabled;
        java.util.List<software.amazon.awscdk.services.s3.IntelligentTieringConfiguration> intelligentTieringConfigurations;
        java.util.List<software.amazon.awscdk.services.s3.Inventory> inventories;
        java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules;
        java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> metrics;
        software.amazon.awscdk.services.iam.IRole notificationsHandlerRole;
        software.amazon.awscdk.services.s3.ObjectOwnership objectOwnership;
        java.lang.Boolean publicReadAccess;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket;
        java.lang.String serverAccessLogsPrefix;
        java.lang.Boolean transferAcceleration;
        java.lang.Boolean versioned;
        java.lang.String websiteErrorDocument;
        java.lang.String websiteIndexDocument;
        software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect;
        java.util.List<software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules;

        /**
         * Sets the value of {@link BucketProps#getAccessControl}
         * @param accessControl Specifies a canned ACL that grants predefined permissions to the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getAutoDeleteObjects}
         * @param autoDeleteObjects Whether all objects should be automatically deleted when the bucket is removed from the stack or when the stack is deleted.
         *                          Requires the <code>removalPolicy</code> to be set to <code>RemovalPolicy.DESTROY</code>.
         *                          <p>
         *                          <strong>Warning</strong> if you have deployed a bucket with <code>autoDeleteObjects: true</code>,
         *                          switching this to <code>false</code> in a CDK version <em>before</em> <code>1.126.0</code> will lead to
         *                          all objects in the bucket being deleted. Be sure to update your bucket resources
         *                          by deploying with CDK version <code>1.126.0</code> or later <strong>before</strong> switching this value to <code>false</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeleteObjects(java.lang.Boolean autoDeleteObjects) {
            this.autoDeleteObjects = autoDeleteObjects;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getBlockPublicAccess}
         * @param blockPublicAccess The block public access configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockPublicAccess(software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getBucketKeyEnabled}
         * @param bucketKeyEnabled Whether Amazon S3 should use its own intermediary key to generate data keys.
         *                         Only relevant when using KMS for encryption.
         *                         <p>
         *                         <ul>
         *                         <li>If not enabled, every object GET and PUT will cause an API call to KMS (with the
         *                         attendant cost implications of that).</li>
         *                         <li>If enabled, S3 will use its own time-limited key instead.</li>
         *                         </ul>
         *                         <p>
         *                         Only relevant, when Encryption is set to <code>BucketEncryption.KMS</code> or <code>BucketEncryption.KMS_MANAGED</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketKeyEnabled(java.lang.Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getBucketName}
         * @param bucketName Physical name of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getCors}
         * @param cors The CORS configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder cors(java.util.List<? extends software.amazon.awscdk.services.s3.CorsRule> cors) {
            this.cors = (java.util.List<software.amazon.awscdk.services.s3.CorsRule>)cors;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getEncryption}
         * @param encryption The kind of server-side encryption to apply to this bucket.
         *                   If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         *                   encryption key is not specified, a key will automatically be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.s3.BucketEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for bucket encryption.
         *                      The 'encryption' property must be either not specified or set to "Kms".
         *                      An error will be emitted if encryption is set to "Unencrypted" or
         *                      "Managed".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getEnforceSsl}
         * @param enforceSsl Enforces SSL for requests.
         *                   S3.5 of the AWS Foundational Security Best Practices Regarding S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceSsl(java.lang.Boolean enforceSsl) {
            this.enforceSsl = enforceSsl;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getEventBridgeEnabled}
         * @param eventBridgeEnabled Whether this bucket should send notifications to Amazon EventBridge or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeEnabled(java.lang.Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getIntelligentTieringConfigurations}
         * @param intelligentTieringConfigurations Inteligent Tiering Configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder intelligentTieringConfigurations(java.util.List<? extends software.amazon.awscdk.services.s3.IntelligentTieringConfiguration> intelligentTieringConfigurations) {
            this.intelligentTieringConfigurations = (java.util.List<software.amazon.awscdk.services.s3.IntelligentTieringConfiguration>)intelligentTieringConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getInventories}
         * @param inventories The inventory configuration of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inventories(java.util.List<? extends software.amazon.awscdk.services.s3.Inventory> inventories) {
            this.inventories = (java.util.List<software.amazon.awscdk.services.s3.Inventory>)inventories;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getLifecycleRules}
         * @param lifecycleRules Rules that define how Amazon S3 manages objects during their lifetime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder lifecycleRules(java.util.List<? extends software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules) {
            this.lifecycleRules = (java.util.List<software.amazon.awscdk.services.s3.LifecycleRule>)lifecycleRules;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getMetrics}
         * @param metrics The metrics configuration of this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metrics(java.util.List<? extends software.amazon.awscdk.services.s3.BucketMetrics> metrics) {
            this.metrics = (java.util.List<software.amazon.awscdk.services.s3.BucketMetrics>)metrics;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getNotificationsHandlerRole}
         * @param notificationsHandlerRole The role to be used by the notifications handler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationsHandlerRole(software.amazon.awscdk.services.iam.IRole notificationsHandlerRole) {
            this.notificationsHandlerRole = notificationsHandlerRole;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getObjectOwnership}
         * @param objectOwnership The objectOwnership of the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectOwnership(software.amazon.awscdk.services.s3.ObjectOwnership objectOwnership) {
            this.objectOwnership = objectOwnership;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getPublicReadAccess}
         * @param publicReadAccess Grants public read access to all objects in the bucket.
         *                         Similar to calling <code>bucket.grantPublicAccess()</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicReadAccess(java.lang.Boolean publicReadAccess) {
            this.publicReadAccess = publicReadAccess;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the bucket is removed from this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getServerAccessLogsBucket}
         * @param serverAccessLogsBucket Destination bucket for the server access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverAccessLogsBucket(software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket) {
            this.serverAccessLogsBucket = serverAccessLogsBucket;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getServerAccessLogsPrefix}
         * @param serverAccessLogsPrefix Optional log file prefix to use for the bucket's access logs.
         *                               If defined without "serverAccessLogsBucket", enables access logs to current bucket with this prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverAccessLogsPrefix(java.lang.String serverAccessLogsPrefix) {
            this.serverAccessLogsPrefix = serverAccessLogsPrefix;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getTransferAcceleration}
         * @param transferAcceleration Whether this bucket should have transfer acceleration turned on or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transferAcceleration(java.lang.Boolean transferAcceleration) {
            this.transferAcceleration = transferAcceleration;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getVersioned}
         * @param versioned Whether this bucket should have versioning turned on or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioned(java.lang.Boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteErrorDocument}
         * @param websiteErrorDocument The name of the error document (e.g. "404.html") for the website. `websiteIndexDocument` must also be set if this is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteErrorDocument(java.lang.String websiteErrorDocument) {
            this.websiteErrorDocument = websiteErrorDocument;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteIndexDocument}
         * @param websiteIndexDocument The name of the index document (e.g. "index.html") for the website. Enables static website hosting for this bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteIndexDocument(java.lang.String websiteIndexDocument) {
            this.websiteIndexDocument = websiteIndexDocument;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteRedirect}
         * @param websiteRedirect Specifies the redirect behavior of all requests to a website endpoint of a bucket.
         *                        If you specify this property, you can't specify "websiteIndexDocument", "websiteErrorDocument" nor , "websiteRoutingRules".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRedirect(software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect) {
            this.websiteRedirect = websiteRedirect;
            return this;
        }

        /**
         * Sets the value of {@link BucketProps#getWebsiteRoutingRules}
         * @param websiteRoutingRules Rules that define when a redirect is applied and the redirect behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder websiteRoutingRules(java.util.List<? extends software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules) {
            this.websiteRoutingRules = (java.util.List<software.amazon.awscdk.services.s3.RoutingRule>)websiteRoutingRules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BucketProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketProps {
        private final software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        private final java.lang.Boolean autoDeleteObjects;
        private final software.amazon.awscdk.services.s3.BlockPublicAccess blockPublicAccess;
        private final java.lang.Boolean bucketKeyEnabled;
        private final java.lang.String bucketName;
        private final java.util.List<software.amazon.awscdk.services.s3.CorsRule> cors;
        private final software.amazon.awscdk.services.s3.BucketEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Boolean enforceSsl;
        private final java.lang.Boolean eventBridgeEnabled;
        private final java.util.List<software.amazon.awscdk.services.s3.IntelligentTieringConfiguration> intelligentTieringConfigurations;
        private final java.util.List<software.amazon.awscdk.services.s3.Inventory> inventories;
        private final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> lifecycleRules;
        private final java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> metrics;
        private final software.amazon.awscdk.services.iam.IRole notificationsHandlerRole;
        private final software.amazon.awscdk.services.s3.ObjectOwnership objectOwnership;
        private final java.lang.Boolean publicReadAccess;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.s3.IBucket serverAccessLogsBucket;
        private final java.lang.String serverAccessLogsPrefix;
        private final java.lang.Boolean transferAcceleration;
        private final java.lang.Boolean versioned;
        private final java.lang.String websiteErrorDocument;
        private final java.lang.String websiteIndexDocument;
        private final software.amazon.awscdk.services.s3.RedirectTarget websiteRedirect;
        private final java.util.List<software.amazon.awscdk.services.s3.RoutingRule> websiteRoutingRules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessControl = software.amazon.jsii.Kernel.get(this, "accessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketAccessControl.class));
            this.autoDeleteObjects = software.amazon.jsii.Kernel.get(this, "autoDeleteObjects", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.blockPublicAccess = software.amazon.jsii.Kernel.get(this, "blockPublicAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BlockPublicAccess.class));
            this.bucketKeyEnabled = software.amazon.jsii.Kernel.get(this, "bucketKeyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cors = software.amazon.jsii.Kernel.get(this, "cors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.CorsRule.class)));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.enforceSsl = software.amazon.jsii.Kernel.get(this, "enforceSSL", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.eventBridgeEnabled = software.amazon.jsii.Kernel.get(this, "eventBridgeEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.intelligentTieringConfigurations = software.amazon.jsii.Kernel.get(this, "intelligentTieringConfigurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IntelligentTieringConfiguration.class)));
            this.inventories = software.amazon.jsii.Kernel.get(this, "inventories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Inventory.class)));
            this.lifecycleRules = software.amazon.jsii.Kernel.get(this, "lifecycleRules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.LifecycleRule.class)));
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketMetrics.class)));
            this.notificationsHandlerRole = software.amazon.jsii.Kernel.get(this, "notificationsHandlerRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.objectOwnership = software.amazon.jsii.Kernel.get(this, "objectOwnership", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ObjectOwnership.class));
            this.publicReadAccess = software.amazon.jsii.Kernel.get(this, "publicReadAccess", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.serverAccessLogsBucket = software.amazon.jsii.Kernel.get(this, "serverAccessLogsBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.serverAccessLogsPrefix = software.amazon.jsii.Kernel.get(this, "serverAccessLogsPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transferAcceleration = software.amazon.jsii.Kernel.get(this, "transferAcceleration", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.versioned = software.amazon.jsii.Kernel.get(this, "versioned", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.websiteErrorDocument = software.amazon.jsii.Kernel.get(this, "websiteErrorDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.websiteIndexDocument = software.amazon.jsii.Kernel.get(this, "websiteIndexDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.websiteRedirect = software.amazon.jsii.Kernel.get(this, "websiteRedirect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.RedirectTarget.class));
            this.websiteRoutingRules = software.amazon.jsii.Kernel.get(this, "websiteRoutingRules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.RoutingRule.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessControl = builder.accessControl;
            this.autoDeleteObjects = builder.autoDeleteObjects;
            this.blockPublicAccess = builder.blockPublicAccess;
            this.bucketKeyEnabled = builder.bucketKeyEnabled;
            this.bucketName = builder.bucketName;
            this.cors = (java.util.List<software.amazon.awscdk.services.s3.CorsRule>)builder.cors;
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.enforceSsl = builder.enforceSsl;
            this.eventBridgeEnabled = builder.eventBridgeEnabled;
            this.intelligentTieringConfigurations = (java.util.List<software.amazon.awscdk.services.s3.IntelligentTieringConfiguration>)builder.intelligentTieringConfigurations;
            this.inventories = (java.util.List<software.amazon.awscdk.services.s3.Inventory>)builder.inventories;
            this.lifecycleRules = (java.util.List<software.amazon.awscdk.services.s3.LifecycleRule>)builder.lifecycleRules;
            this.metrics = (java.util.List<software.amazon.awscdk.services.s3.BucketMetrics>)builder.metrics;
            this.notificationsHandlerRole = builder.notificationsHandlerRole;
            this.objectOwnership = builder.objectOwnership;
            this.publicReadAccess = builder.publicReadAccess;
            this.removalPolicy = builder.removalPolicy;
            this.serverAccessLogsBucket = builder.serverAccessLogsBucket;
            this.serverAccessLogsPrefix = builder.serverAccessLogsPrefix;
            this.transferAcceleration = builder.transferAcceleration;
            this.versioned = builder.versioned;
            this.websiteErrorDocument = builder.websiteErrorDocument;
            this.websiteIndexDocument = builder.websiteIndexDocument;
            this.websiteRedirect = builder.websiteRedirect;
            this.websiteRoutingRules = (java.util.List<software.amazon.awscdk.services.s3.RoutingRule>)builder.websiteRoutingRules;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
            return this.accessControl;
        }

        @Override
        public final java.lang.Boolean getAutoDeleteObjects() {
            return this.autoDeleteObjects;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BlockPublicAccess getBlockPublicAccess() {
            return this.blockPublicAccess;
        }

        @Override
        public final java.lang.Boolean getBucketKeyEnabled() {
            return this.bucketKeyEnabled;
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.CorsRule> getCors() {
            return this.cors;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Boolean getEnforceSSL() {
            return this.enforceSsl;
        }

        @Override
        public final java.lang.Boolean getEventBridgeEnabled() {
            return this.eventBridgeEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IntelligentTieringConfiguration> getIntelligentTieringConfigurations() {
            return this.intelligentTieringConfigurations;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.Inventory> getInventories() {
            return this.inventories;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.LifecycleRule> getLifecycleRules() {
            return this.lifecycleRules;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.BucketMetrics> getMetrics() {
            return this.metrics;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getNotificationsHandlerRole() {
            return this.notificationsHandlerRole;
        }

        @Override
        public final software.amazon.awscdk.services.s3.ObjectOwnership getObjectOwnership() {
            return this.objectOwnership;
        }

        @Override
        public final java.lang.Boolean getPublicReadAccess() {
            return this.publicReadAccess;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getServerAccessLogsBucket() {
            return this.serverAccessLogsBucket;
        }

        @Override
        public final java.lang.String getServerAccessLogsPrefix() {
            return this.serverAccessLogsPrefix;
        }

        @Override
        public final java.lang.Boolean getTransferAcceleration() {
            return this.transferAcceleration;
        }

        @Override
        public final java.lang.Boolean getVersioned() {
            return this.versioned;
        }

        @Override
        public final java.lang.String getWebsiteErrorDocument() {
            return this.websiteErrorDocument;
        }

        @Override
        public final java.lang.String getWebsiteIndexDocument() {
            return this.websiteIndexDocument;
        }

        @Override
        public final software.amazon.awscdk.services.s3.RedirectTarget getWebsiteRedirect() {
            return this.websiteRedirect;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.RoutingRule> getWebsiteRoutingRules() {
            return this.websiteRoutingRules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessControl() != null) {
                data.set("accessControl", om.valueToTree(this.getAccessControl()));
            }
            if (this.getAutoDeleteObjects() != null) {
                data.set("autoDeleteObjects", om.valueToTree(this.getAutoDeleteObjects()));
            }
            if (this.getBlockPublicAccess() != null) {
                data.set("blockPublicAccess", om.valueToTree(this.getBlockPublicAccess()));
            }
            if (this.getBucketKeyEnabled() != null) {
                data.set("bucketKeyEnabled", om.valueToTree(this.getBucketKeyEnabled()));
            }
            if (this.getBucketName() != null) {
                data.set("bucketName", om.valueToTree(this.getBucketName()));
            }
            if (this.getCors() != null) {
                data.set("cors", om.valueToTree(this.getCors()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getEnforceSSL() != null) {
                data.set("enforceSSL", om.valueToTree(this.getEnforceSSL()));
            }
            if (this.getEventBridgeEnabled() != null) {
                data.set("eventBridgeEnabled", om.valueToTree(this.getEventBridgeEnabled()));
            }
            if (this.getIntelligentTieringConfigurations() != null) {
                data.set("intelligentTieringConfigurations", om.valueToTree(this.getIntelligentTieringConfigurations()));
            }
            if (this.getInventories() != null) {
                data.set("inventories", om.valueToTree(this.getInventories()));
            }
            if (this.getLifecycleRules() != null) {
                data.set("lifecycleRules", om.valueToTree(this.getLifecycleRules()));
            }
            if (this.getMetrics() != null) {
                data.set("metrics", om.valueToTree(this.getMetrics()));
            }
            if (this.getNotificationsHandlerRole() != null) {
                data.set("notificationsHandlerRole", om.valueToTree(this.getNotificationsHandlerRole()));
            }
            if (this.getObjectOwnership() != null) {
                data.set("objectOwnership", om.valueToTree(this.getObjectOwnership()));
            }
            if (this.getPublicReadAccess() != null) {
                data.set("publicReadAccess", om.valueToTree(this.getPublicReadAccess()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getServerAccessLogsBucket() != null) {
                data.set("serverAccessLogsBucket", om.valueToTree(this.getServerAccessLogsBucket()));
            }
            if (this.getServerAccessLogsPrefix() != null) {
                data.set("serverAccessLogsPrefix", om.valueToTree(this.getServerAccessLogsPrefix()));
            }
            if (this.getTransferAcceleration() != null) {
                data.set("transferAcceleration", om.valueToTree(this.getTransferAcceleration()));
            }
            if (this.getVersioned() != null) {
                data.set("versioned", om.valueToTree(this.getVersioned()));
            }
            if (this.getWebsiteErrorDocument() != null) {
                data.set("websiteErrorDocument", om.valueToTree(this.getWebsiteErrorDocument()));
            }
            if (this.getWebsiteIndexDocument() != null) {
                data.set("websiteIndexDocument", om.valueToTree(this.getWebsiteIndexDocument()));
            }
            if (this.getWebsiteRedirect() != null) {
                data.set("websiteRedirect", om.valueToTree(this.getWebsiteRedirect()));
            }
            if (this.getWebsiteRoutingRules() != null) {
                data.set("websiteRoutingRules", om.valueToTree(this.getWebsiteRoutingRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.BucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketProps.Jsii$Proxy that = (BucketProps.Jsii$Proxy) o;

            if (this.accessControl != null ? !this.accessControl.equals(that.accessControl) : that.accessControl != null) return false;
            if (this.autoDeleteObjects != null ? !this.autoDeleteObjects.equals(that.autoDeleteObjects) : that.autoDeleteObjects != null) return false;
            if (this.blockPublicAccess != null ? !this.blockPublicAccess.equals(that.blockPublicAccess) : that.blockPublicAccess != null) return false;
            if (this.bucketKeyEnabled != null ? !this.bucketKeyEnabled.equals(that.bucketKeyEnabled) : that.bucketKeyEnabled != null) return false;
            if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
            if (this.cors != null ? !this.cors.equals(that.cors) : that.cors != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.enforceSsl != null ? !this.enforceSsl.equals(that.enforceSsl) : that.enforceSsl != null) return false;
            if (this.eventBridgeEnabled != null ? !this.eventBridgeEnabled.equals(that.eventBridgeEnabled) : that.eventBridgeEnabled != null) return false;
            if (this.intelligentTieringConfigurations != null ? !this.intelligentTieringConfigurations.equals(that.intelligentTieringConfigurations) : that.intelligentTieringConfigurations != null) return false;
            if (this.inventories != null ? !this.inventories.equals(that.inventories) : that.inventories != null) return false;
            if (this.lifecycleRules != null ? !this.lifecycleRules.equals(that.lifecycleRules) : that.lifecycleRules != null) return false;
            if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
            if (this.notificationsHandlerRole != null ? !this.notificationsHandlerRole.equals(that.notificationsHandlerRole) : that.notificationsHandlerRole != null) return false;
            if (this.objectOwnership != null ? !this.objectOwnership.equals(that.objectOwnership) : that.objectOwnership != null) return false;
            if (this.publicReadAccess != null ? !this.publicReadAccess.equals(that.publicReadAccess) : that.publicReadAccess != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.serverAccessLogsBucket != null ? !this.serverAccessLogsBucket.equals(that.serverAccessLogsBucket) : that.serverAccessLogsBucket != null) return false;
            if (this.serverAccessLogsPrefix != null ? !this.serverAccessLogsPrefix.equals(that.serverAccessLogsPrefix) : that.serverAccessLogsPrefix != null) return false;
            if (this.transferAcceleration != null ? !this.transferAcceleration.equals(that.transferAcceleration) : that.transferAcceleration != null) return false;
            if (this.versioned != null ? !this.versioned.equals(that.versioned) : that.versioned != null) return false;
            if (this.websiteErrorDocument != null ? !this.websiteErrorDocument.equals(that.websiteErrorDocument) : that.websiteErrorDocument != null) return false;
            if (this.websiteIndexDocument != null ? !this.websiteIndexDocument.equals(that.websiteIndexDocument) : that.websiteIndexDocument != null) return false;
            if (this.websiteRedirect != null ? !this.websiteRedirect.equals(that.websiteRedirect) : that.websiteRedirect != null) return false;
            return this.websiteRoutingRules != null ? this.websiteRoutingRules.equals(that.websiteRoutingRules) : that.websiteRoutingRules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessControl != null ? this.accessControl.hashCode() : 0;
            result = 31 * result + (this.autoDeleteObjects != null ? this.autoDeleteObjects.hashCode() : 0);
            result = 31 * result + (this.blockPublicAccess != null ? this.blockPublicAccess.hashCode() : 0);
            result = 31 * result + (this.bucketKeyEnabled != null ? this.bucketKeyEnabled.hashCode() : 0);
            result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
            result = 31 * result + (this.cors != null ? this.cors.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.enforceSsl != null ? this.enforceSsl.hashCode() : 0);
            result = 31 * result + (this.eventBridgeEnabled != null ? this.eventBridgeEnabled.hashCode() : 0);
            result = 31 * result + (this.intelligentTieringConfigurations != null ? this.intelligentTieringConfigurations.hashCode() : 0);
            result = 31 * result + (this.inventories != null ? this.inventories.hashCode() : 0);
            result = 31 * result + (this.lifecycleRules != null ? this.lifecycleRules.hashCode() : 0);
            result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
            result = 31 * result + (this.notificationsHandlerRole != null ? this.notificationsHandlerRole.hashCode() : 0);
            result = 31 * result + (this.objectOwnership != null ? this.objectOwnership.hashCode() : 0);
            result = 31 * result + (this.publicReadAccess != null ? this.publicReadAccess.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.serverAccessLogsBucket != null ? this.serverAccessLogsBucket.hashCode() : 0);
            result = 31 * result + (this.serverAccessLogsPrefix != null ? this.serverAccessLogsPrefix.hashCode() : 0);
            result = 31 * result + (this.transferAcceleration != null ? this.transferAcceleration.hashCode() : 0);
            result = 31 * result + (this.versioned != null ? this.versioned.hashCode() : 0);
            result = 31 * result + (this.websiteErrorDocument != null ? this.websiteErrorDocument.hashCode() : 0);
            result = 31 * result + (this.websiteIndexDocument != null ? this.websiteIndexDocument.hashCode() : 0);
            result = 31 * result + (this.websiteRedirect != null ? this.websiteRedirect.hashCode() : 0);
            result = 31 * result + (this.websiteRoutingRules != null ? this.websiteRoutingRules.hashCode() : 0);
            return result;
        }
    }
}
