package software.amazon.awscdk.services.secretsmanager;

/**
 * A CloudFormation `AWS::SecretsManager::RotationSchedule`.
 * <p>
 * Sets the rotation schedule and Lambda rotation function for a secret. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation works</a> . For the rotation function, you have two options:
 * <p>
 * <ul>
 * <li>You can create a new rotation function based on one of the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html">Secrets Manager rotation function templates</a> by using <code>HostedRotationLambda</code> .</li>
 * <li>You can choose an existing rotation function by using <code>RotationLambdaARN</code> .</li>
 * </ul>
 * <p>
 * For Amazon RDS , Amazon Redshift , Amazon DocumentDB secrets, if you define both the secret and the database or service in the AWS CloudFormation template, then you need to define the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html">AWS::SecretsManager::SecretTargetAttachment</a> resource to populate the secret with the connection details of the database or service before you attempt to configure rotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * CfnRotationSchedule cfnRotationSchedule = CfnRotationSchedule.Builder.create(this, "MyCfnRotationSchedule")
 *         .secretId("secretId")
 *         // the properties below are optional
 *         .hostedRotationLambda(HostedRotationLambdaProperty.builder()
 *                 .rotationType("rotationType")
 *                 // the properties below are optional
 *                 .excludeCharacters("excludeCharacters")
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .masterSecretArn("masterSecretArn")
 *                 .masterSecretKmsKeyArn("masterSecretKmsKeyArn")
 *                 .rotationLambdaName("rotationLambdaName")
 *                 .superuserSecretArn("superuserSecretArn")
 *                 .superuserSecretKmsKeyArn("superuserSecretKmsKeyArn")
 *                 .vpcSecurityGroupIds("vpcSecurityGroupIds")
 *                 .vpcSubnetIds("vpcSubnetIds")
 *                 .build())
 *         .rotateImmediatelyOnUpdate(false)
 *         .rotationLambdaArn("rotationLambdaArn")
 *         .rotationRules(RotationRulesProperty.builder()
 *                 .automaticallyAfterDays(123)
 *                 .duration("duration")
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.068Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule")
public class CfnRotationSchedule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRotationSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRotationSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SecretsManager::RotationSchedule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRotationSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ARN or name of the secret to rotate.
     * <p>
     * To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretId() {
        return software.amazon.jsii.Kernel.get(this, "secretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN or name of the secret to rotate.
     * <p>
     * To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecretId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "secretId", java.util.Objects.requireNonNull(value, "secretId is required"));
    }

    /**
     * Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHostedRotationLambda() {
        return software.amazon.jsii.Kernel.get(this, "hostedRotationLambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedRotationLambda(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty value) {
        software.amazon.jsii.Kernel.set(this, "hostedRotationLambda", value);
    }

    /**
     * Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedRotationLambda(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hostedRotationLambda", value);
    }

    /**
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
     * <p>
     * The rotation schedule is defined in <code>RotationRules</code> .
     * <p>
     * If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
     * <p>
     * If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRotateImmediatelyOnUpdate() {
        return software.amazon.jsii.Kernel.get(this, "rotateImmediatelyOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
     * <p>
     * The rotation schedule is defined in <code>RotationRules</code> .
     * <p>
     * If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
     * <p>
     * If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotateImmediatelyOnUpdate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "rotateImmediatelyOnUpdate", value);
    }

    /**
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
     * <p>
     * The rotation schedule is defined in <code>RotationRules</code> .
     * <p>
     * If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
     * <p>
     * If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotateImmediatelyOnUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rotateImmediatelyOnUpdate", value);
    }

    /**
     * The ARN of an existing Lambda rotation function.
     * <p>
     * To specify a rotation function that is also defined in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function.
     * <p>
     * To create a new rotation function based on one of the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html">Secrets Manager rotation function templates</a> , specify <code>HostedRotationLambda</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaArn() {
        return software.amazon.jsii.Kernel.get(this, "rotationLambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of an existing Lambda rotation function.
     * <p>
     * To specify a rotation function that is also defined in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function.
     * <p>
     * To create a new rotation function based on one of the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html">Secrets Manager rotation function templates</a> , specify <code>HostedRotationLambda</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationLambdaArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "rotationLambdaArn", value);
    }

    /**
     * A structure that defines the rotation configuration for this secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRotationRules() {
        return software.amazon.jsii.Kernel.get(this, "rotationRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that defines the rotation configuration for this secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty value) {
        software.amazon.jsii.Kernel.set(this, "rotationRules", value);
    }

    /**
     * A structure that defines the rotation configuration for this secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rotationRules", value);
    }
    /**
     * Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) .
     * <p>
     * You must specify <code>Transform: AWS::SecretsManager-2020-07-23</code> at the beginning of the CloudFormation template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.secretsmanager.*;
     * HostedRotationLambdaProperty hostedRotationLambdaProperty = HostedRotationLambdaProperty.builder()
     *         .rotationType("rotationType")
     *         // the properties below are optional
     *         .excludeCharacters("excludeCharacters")
     *         .kmsKeyArn("kmsKeyArn")
     *         .masterSecretArn("masterSecretArn")
     *         .masterSecretKmsKeyArn("masterSecretKmsKeyArn")
     *         .rotationLambdaName("rotationLambdaName")
     *         .superuserSecretArn("superuserSecretArn")
     *         .superuserSecretKmsKeyArn("superuserSecretKmsKeyArn")
     *         .vpcSecurityGroupIds("vpcSecurityGroupIds")
     *         .vpcSubnetIds("vpcSubnetIds")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty")
    @software.amazon.jsii.Jsii.Proxy(HostedRotationLambdaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostedRotationLambdaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rotation template to base the rotation function on, one of the following:.
         * <p>
         * <ul>
         * <li><code>MySQLSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mysql-singleuser">SecretsManagerRDSMySQLRotationSingleUser</a> .</li>
         * <li><code>MySQLMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mysql-multiuser">SecretsManagerRDSMySQLRotationMultiUser</a> .</li>
         * <li><code>PostgreSQLSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-postgre-singleuser">SecretsManagerRDSPostgreSQLRotationSingleUser</a></li>
         * <li><code>PostgreSQLMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-postgre-multiuser">SecretsManagerRDSPostgreSQLRotationMultiUser</a> .</li>
         * <li><code>OracleSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-oracle-singleuser">SecretsManagerRDSOracleRotationSingleUser</a> .</li>
         * <li><code>OracleMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-oracle-multiuser">SecretsManagerRDSOracleRotationMultiUser</a> .</li>
         * <li><code>MariaDBSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mariadb-singleuser">SecretsManagerRDSMariaDBRotationSingleUser</a> .</li>
         * <li><code>MariaDBMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mariadb-multiuser">SecretsManagerRDSMariaDBRotationMultiUser</a> .</li>
         * <li><code>SQLServerSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-sqlserver-singleuser">SecretsManagerRDSSQLServerRotationSingleUser</a> .</li>
         * <li><code>SQLServerMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-sqlserver-multiuser">SecretsManagerRDSSQLServerRotationMultiUser</a> .</li>
         * <li><code>RedshiftSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-redshift-singleuser">SecretsManagerRedshiftRotationSingleUsr</a> .</li>
         * <li><code>RedshiftMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-redshift-multiuser">SecretsManagerRedshiftRotationMultiUser</a> .</li>
         * <li><code>MongoDBSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mongodb-singleuser">SecretsManagerMongoDBRotationSingleUser</a> .</li>
         * <li><code>MongoDBMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mongodb-multiuser">SecretsManagerMongoDBRotationMultiUser</a> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRotationType();

        /**
         * A string of the characters that you don't want in the password.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
            return null;
        }

        /**
         * The ARN of the KMS key that Secrets Manager uses to encrypt the secret.
         * <p>
         * If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code> . If <code>aws/secretsmanager</code> doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * The ARN of the secret that contains elevated credentials.
         * <p>
         * You must create the elevated secret before you can set this property. The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterSecretArn() {
            return null;
        }

        /**
         * The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterSecretKmsKeyArn() {
            return null;
        }

        /**
         * The name of the Lambda rotation function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaName() {
            return null;
        }

        /**
         * The ARN of the secret that contains elevated credentials.
         * <p>
         * You must create the superuser secret before you can set this property. The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuperuserSecretArn() {
            return null;
        }

        /**
         * The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuperuserSecretKmsKeyArn() {
            return null;
        }

        /**
         * A comma-separated list of security group IDs applied to the target database.
         * <p>
         * The templates applies the same security groups as on the Lambda rotation function that is created as part of this stack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcSecurityGroupIds() {
            return null;
        }

        /**
         * A comma separated list of VPC subnet IDs of the target database network.
         * <p>
         * The Lambda rotation function is in the same subnet group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostedRotationLambdaProperty> {
            java.lang.String rotationType;
            java.lang.String excludeCharacters;
            java.lang.String kmsKeyArn;
            java.lang.String masterSecretArn;
            java.lang.String masterSecretKmsKeyArn;
            java.lang.String rotationLambdaName;
            java.lang.String superuserSecretArn;
            java.lang.String superuserSecretKmsKeyArn;
            java.lang.String vpcSecurityGroupIds;
            java.lang.String vpcSubnetIds;

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getRotationType}
             * @param rotationType The rotation template to base the rotation function on, one of the following:. This parameter is required.
             *                     <ul>
             *                     <li><code>MySQLSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mysql-singleuser">SecretsManagerRDSMySQLRotationSingleUser</a> .</li>
             *                     <li><code>MySQLMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mysql-multiuser">SecretsManagerRDSMySQLRotationMultiUser</a> .</li>
             *                     <li><code>PostgreSQLSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-postgre-singleuser">SecretsManagerRDSPostgreSQLRotationSingleUser</a></li>
             *                     <li><code>PostgreSQLMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-postgre-multiuser">SecretsManagerRDSPostgreSQLRotationMultiUser</a> .</li>
             *                     <li><code>OracleSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-oracle-singleuser">SecretsManagerRDSOracleRotationSingleUser</a> .</li>
             *                     <li><code>OracleMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-oracle-multiuser">SecretsManagerRDSOracleRotationMultiUser</a> .</li>
             *                     <li><code>MariaDBSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mariadb-singleuser">SecretsManagerRDSMariaDBRotationSingleUser</a> .</li>
             *                     <li><code>MariaDBMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mariadb-multiuser">SecretsManagerRDSMariaDBRotationMultiUser</a> .</li>
             *                     <li><code>SQLServerSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-sqlserver-singleuser">SecretsManagerRDSSQLServerRotationSingleUser</a> .</li>
             *                     <li><code>SQLServerMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-sqlserver-multiuser">SecretsManagerRDSSQLServerRotationMultiUser</a> .</li>
             *                     <li><code>RedshiftSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-redshift-singleuser">SecretsManagerRedshiftRotationSingleUsr</a> .</li>
             *                     <li><code>RedshiftMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-redshift-multiuser">SecretsManagerRedshiftRotationMultiUser</a> .</li>
             *                     <li><code>MongoDBSingleUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mongodb-singleuser">SecretsManagerMongoDBRotationSingleUser</a> .</li>
             *                     <li><code>MongoDBMultiUser</code> to use the template <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html#sar-template-mongodb-multiuser">SecretsManagerMongoDBRotationMultiUser</a> .</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rotationType(java.lang.String rotationType) {
                this.rotationType = rotationType;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getExcludeCharacters}
             * @param excludeCharacters A string of the characters that you don't want in the password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeCharacters(java.lang.String excludeCharacters) {
                this.excludeCharacters = excludeCharacters;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getKmsKeyArn}
             * @param kmsKeyArn The ARN of the KMS key that Secrets Manager uses to encrypt the secret.
             *                  If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code> . If <code>aws/secretsmanager</code> doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getMasterSecretArn}
             * @param masterSecretArn The ARN of the secret that contains elevated credentials.
             *                        You must create the elevated secret before you can set this property. The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterSecretArn(java.lang.String masterSecretArn) {
                this.masterSecretArn = masterSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getMasterSecretKmsKeyArn}
             * @param masterSecretKmsKeyArn The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterSecretKmsKeyArn(java.lang.String masterSecretKmsKeyArn) {
                this.masterSecretKmsKeyArn = masterSecretKmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getRotationLambdaName}
             * @param rotationLambdaName The name of the Lambda rotation function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rotationLambdaName(java.lang.String rotationLambdaName) {
                this.rotationLambdaName = rotationLambdaName;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getSuperuserSecretArn}
             * @param superuserSecretArn The ARN of the secret that contains elevated credentials.
             *                           You must create the superuser secret before you can set this property. The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder superuserSecretArn(java.lang.String superuserSecretArn) {
                this.superuserSecretArn = superuserSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getSuperuserSecretKmsKeyArn}
             * @param superuserSecretKmsKeyArn The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder superuserSecretKmsKeyArn(java.lang.String superuserSecretKmsKeyArn) {
                this.superuserSecretKmsKeyArn = superuserSecretKmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getVpcSecurityGroupIds}
             * @param vpcSecurityGroupIds A comma-separated list of security group IDs applied to the target database.
             *                            The templates applies the same security groups as on the Lambda rotation function that is created as part of this stack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSecurityGroupIds(java.lang.String vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds = vpcSecurityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getVpcSubnetIds}
             * @param vpcSubnetIds A comma separated list of VPC subnet IDs of the target database network.
             *                     The Lambda rotation function is in the same subnet group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSubnetIds(java.lang.String vpcSubnetIds) {
                this.vpcSubnetIds = vpcSubnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostedRotationLambdaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostedRotationLambdaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedRotationLambdaProperty {
            private final java.lang.String rotationType;
            private final java.lang.String excludeCharacters;
            private final java.lang.String kmsKeyArn;
            private final java.lang.String masterSecretArn;
            private final java.lang.String masterSecretKmsKeyArn;
            private final java.lang.String rotationLambdaName;
            private final java.lang.String superuserSecretArn;
            private final java.lang.String superuserSecretKmsKeyArn;
            private final java.lang.String vpcSecurityGroupIds;
            private final java.lang.String vpcSubnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rotationType = software.amazon.jsii.Kernel.get(this, "rotationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterSecretArn = software.amazon.jsii.Kernel.get(this, "masterSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterSecretKmsKeyArn = software.amazon.jsii.Kernel.get(this, "masterSecretKmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rotationLambdaName = software.amazon.jsii.Kernel.get(this, "rotationLambdaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.superuserSecretArn = software.amazon.jsii.Kernel.get(this, "superuserSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.superuserSecretKmsKeyArn = software.amazon.jsii.Kernel.get(this, "superuserSecretKmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcSubnetIds = software.amazon.jsii.Kernel.get(this, "vpcSubnetIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rotationType = java.util.Objects.requireNonNull(builder.rotationType, "rotationType is required");
                this.excludeCharacters = builder.excludeCharacters;
                this.kmsKeyArn = builder.kmsKeyArn;
                this.masterSecretArn = builder.masterSecretArn;
                this.masterSecretKmsKeyArn = builder.masterSecretKmsKeyArn;
                this.rotationLambdaName = builder.rotationLambdaName;
                this.superuserSecretArn = builder.superuserSecretArn;
                this.superuserSecretKmsKeyArn = builder.superuserSecretKmsKeyArn;
                this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
                this.vpcSubnetIds = builder.vpcSubnetIds;
            }

            @Override
            public final java.lang.String getRotationType() {
                return this.rotationType;
            }

            @Override
            public final java.lang.String getExcludeCharacters() {
                return this.excludeCharacters;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public final java.lang.String getMasterSecretArn() {
                return this.masterSecretArn;
            }

            @Override
            public final java.lang.String getMasterSecretKmsKeyArn() {
                return this.masterSecretKmsKeyArn;
            }

            @Override
            public final java.lang.String getRotationLambdaName() {
                return this.rotationLambdaName;
            }

            @Override
            public final java.lang.String getSuperuserSecretArn() {
                return this.superuserSecretArn;
            }

            @Override
            public final java.lang.String getSuperuserSecretKmsKeyArn() {
                return this.superuserSecretKmsKeyArn;
            }

            @Override
            public final java.lang.String getVpcSecurityGroupIds() {
                return this.vpcSecurityGroupIds;
            }

            @Override
            public final java.lang.String getVpcSubnetIds() {
                return this.vpcSubnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rotationType", om.valueToTree(this.getRotationType()));
                if (this.getExcludeCharacters() != null) {
                    data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getMasterSecretArn() != null) {
                    data.set("masterSecretArn", om.valueToTree(this.getMasterSecretArn()));
                }
                if (this.getMasterSecretKmsKeyArn() != null) {
                    data.set("masterSecretKmsKeyArn", om.valueToTree(this.getMasterSecretKmsKeyArn()));
                }
                if (this.getRotationLambdaName() != null) {
                    data.set("rotationLambdaName", om.valueToTree(this.getRotationLambdaName()));
                }
                if (this.getSuperuserSecretArn() != null) {
                    data.set("superuserSecretArn", om.valueToTree(this.getSuperuserSecretArn()));
                }
                if (this.getSuperuserSecretKmsKeyArn() != null) {
                    data.set("superuserSecretKmsKeyArn", om.valueToTree(this.getSuperuserSecretKmsKeyArn()));
                }
                if (this.getVpcSecurityGroupIds() != null) {
                    data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
                }
                if (this.getVpcSubnetIds() != null) {
                    data.set("vpcSubnetIds", om.valueToTree(this.getVpcSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostedRotationLambdaProperty.Jsii$Proxy that = (HostedRotationLambdaProperty.Jsii$Proxy) o;

                if (!rotationType.equals(that.rotationType)) return false;
                if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                if (this.masterSecretArn != null ? !this.masterSecretArn.equals(that.masterSecretArn) : that.masterSecretArn != null) return false;
                if (this.masterSecretKmsKeyArn != null ? !this.masterSecretKmsKeyArn.equals(that.masterSecretKmsKeyArn) : that.masterSecretKmsKeyArn != null) return false;
                if (this.rotationLambdaName != null ? !this.rotationLambdaName.equals(that.rotationLambdaName) : that.rotationLambdaName != null) return false;
                if (this.superuserSecretArn != null ? !this.superuserSecretArn.equals(that.superuserSecretArn) : that.superuserSecretArn != null) return false;
                if (this.superuserSecretKmsKeyArn != null ? !this.superuserSecretKmsKeyArn.equals(that.superuserSecretKmsKeyArn) : that.superuserSecretKmsKeyArn != null) return false;
                if (this.vpcSecurityGroupIds != null ? !this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds != null) return false;
                return this.vpcSubnetIds != null ? this.vpcSubnetIds.equals(that.vpcSubnetIds) : that.vpcSubnetIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rotationType.hashCode();
                result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.masterSecretArn != null ? this.masterSecretArn.hashCode() : 0);
                result = 31 * result + (this.masterSecretKmsKeyArn != null ? this.masterSecretKmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.rotationLambdaName != null ? this.rotationLambdaName.hashCode() : 0);
                result = 31 * result + (this.superuserSecretArn != null ? this.superuserSecretArn.hashCode() : 0);
                result = 31 * result + (this.superuserSecretKmsKeyArn != null ? this.superuserSecretKmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
                result = 31 * result + (this.vpcSubnetIds != null ? this.vpcSubnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The rotation schedule and window.
     * <p>
     * We recommend you use <code>ScheduleExpression</code> to set a cron or rate expression for the schedule and <code>Duration</code> to set the length of the rotation window.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.secretsmanager.*;
     * RotationRulesProperty rotationRulesProperty = RotationRulesProperty.builder()
     *         .automaticallyAfterDays(123)
     *         .duration("duration")
     *         .scheduleExpression("scheduleExpression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.RotationRulesProperty")
    @software.amazon.jsii.Jsii.Proxy(RotationRulesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RotationRulesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of days between automatic scheduled rotations of the secret.
         * <p>
         * You can use this value to check that your secret meets your compliance guidelines for how often secrets must be rotated.
         * <p>
         * In <code>DescribeSecret</code> and <code>ListSecrets</code> , this value is calculated from the rotation schedule after every successful rotation. In <code>RotateSecret</code> , you can set the rotation schedule in <code>RotationRules</code> with <code>AutomaticallyAfterDays</code> or <code>ScheduleExpression</code> , but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticallyAfterDays() {
            return null;
        }

        /**
         * The length of the rotation window in hours, for example `3h` for a three hour window.
         * <p>
         * Secrets Manager rotates your secret at any time during this window. The window must not go into the next UTC day. If you don't specify this value, the window automatically ends at the end of the UTC day. The window begins according to the <code>ScheduleExpression</code> . For more information, including examples, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule expressions in Secrets Manager rotation</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDuration() {
            return null;
        }

        /**
         * A `cron()` or `rate()` expression that defines the schedule for rotating your secret.
         * <p>
         * Secrets Manager rotation schedules use UTC time zone.
         * <p>
         * Secrets Manager <code>rate()</code> expressions represent the interval in days that you want to rotate your secret, for example <code>rate(10 days)</code> . If you use a <code>rate()</code> expression, the rotation window opens at midnight, and Secrets Manager rotates your secret any time that day after midnight. You can set a <code>Duration</code> to shorten the rotation window.
         * <p>
         * You can use a <code>cron()</code> expression to create rotation schedules that are more detailed than a rotation interval. For more information, including examples, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule expressions in Secrets Manager rotation</a> . If you use a <code>cron()</code> expression, Secrets Manager rotates your secret any time during that day after the window opens. For example, <code>cron(0 8 1 * ? *)</code> represents a rotation window that occurs on the first day of every month beginning at 8:00 AM UTC. Secrets Manager rotates the secret any time that day after 8:00 AM. You can set a <code>Duration</code> to shorten the rotation window.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RotationRulesProperty> {
            java.lang.Number automaticallyAfterDays;
            java.lang.String duration;
            java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link RotationRulesProperty#getAutomaticallyAfterDays}
             * @param automaticallyAfterDays The number of days between automatic scheduled rotations of the secret.
             *                               You can use this value to check that your secret meets your compliance guidelines for how often secrets must be rotated.
             *                               <p>
             *                               In <code>DescribeSecret</code> and <code>ListSecrets</code> , this value is calculated from the rotation schedule after every successful rotation. In <code>RotateSecret</code> , you can set the rotation schedule in <code>RotationRules</code> with <code>AutomaticallyAfterDays</code> or <code>ScheduleExpression</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticallyAfterDays(java.lang.Number automaticallyAfterDays) {
                this.automaticallyAfterDays = automaticallyAfterDays;
                return this;
            }

            /**
             * Sets the value of {@link RotationRulesProperty#getDuration}
             * @param duration The length of the rotation window in hours, for example `3h` for a three hour window.
             *                 Secrets Manager rotates your secret at any time during this window. The window must not go into the next UTC day. If you don't specify this value, the window automatically ends at the end of the UTC day. The window begins according to the <code>ScheduleExpression</code> . For more information, including examples, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule expressions in Secrets Manager rotation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder duration(java.lang.String duration) {
                this.duration = duration;
                return this;
            }

            /**
             * Sets the value of {@link RotationRulesProperty#getScheduleExpression}
             * @param scheduleExpression A `cron()` or `rate()` expression that defines the schedule for rotating your secret.
             *                           Secrets Manager rotation schedules use UTC time zone.
             *                           <p>
             *                           Secrets Manager <code>rate()</code> expressions represent the interval in days that you want to rotate your secret, for example <code>rate(10 days)</code> . If you use a <code>rate()</code> expression, the rotation window opens at midnight, and Secrets Manager rotates your secret any time that day after midnight. You can set a <code>Duration</code> to shorten the rotation window.
             *                           <p>
             *                           You can use a <code>cron()</code> expression to create rotation schedules that are more detailed than a rotation interval. For more information, including examples, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html">Schedule expressions in Secrets Manager rotation</a> . If you use a <code>cron()</code> expression, Secrets Manager rotates your secret any time during that day after the window opens. For example, <code>cron(0 8 1 * ? *)</code> represents a rotation window that occurs on the first day of every month beginning at 8:00 AM UTC. Secrets Manager rotates the secret any time that day after 8:00 AM. You can set a <code>Duration</code> to shorten the rotation window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RotationRulesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RotationRulesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationRulesProperty {
            private final java.lang.Number automaticallyAfterDays;
            private final java.lang.String duration;
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automaticallyAfterDays = software.amazon.jsii.Kernel.get(this, "automaticallyAfterDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.duration = software.amazon.jsii.Kernel.get(this, "duration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automaticallyAfterDays = builder.automaticallyAfterDays;
                this.duration = builder.duration;
                this.scheduleExpression = builder.scheduleExpression;
            }

            @Override
            public final java.lang.Number getAutomaticallyAfterDays() {
                return this.automaticallyAfterDays;
            }

            @Override
            public final java.lang.String getDuration() {
                return this.duration;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomaticallyAfterDays() != null) {
                    data.set("automaticallyAfterDays", om.valueToTree(this.getAutomaticallyAfterDays()));
                }
                if (this.getDuration() != null) {
                    data.set("duration", om.valueToTree(this.getDuration()));
                }
                if (this.getScheduleExpression() != null) {
                    data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.RotationRulesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RotationRulesProperty.Jsii$Proxy that = (RotationRulesProperty.Jsii$Proxy) o;

                if (this.automaticallyAfterDays != null ? !this.automaticallyAfterDays.equals(that.automaticallyAfterDays) : that.automaticallyAfterDays != null) return false;
                if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) return false;
                return this.scheduleExpression != null ? this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automaticallyAfterDays != null ? this.automaticallyAfterDays.hashCode() : 0;
                result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
                result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps.Builder();
        }

        /**
         * The ARN or name of the secret to rotate.
         * <p>
         * To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
         * <p>
         * @return {@code this}
         * @param secretId The ARN or name of the secret to rotate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretId(final java.lang.String secretId) {
            this.props.secretId(secretId);
            return this;
        }

        /**
         * Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
         * <p>
         * @return {@code this}
         * @param hostedRotationLambda Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(final software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty hostedRotationLambda) {
            this.props.hostedRotationLambda(hostedRotationLambda);
            return this;
        }
        /**
         * Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead.
         * <p>
         * @return {@code this}
         * @param hostedRotationLambda Creates a new Lambda rotation function based on one of the [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . To use a rotation function that already exists, specify `RotationLambdaARN` instead. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(final software.amazon.awscdk.IResolvable hostedRotationLambda) {
            this.props.hostedRotationLambda(hostedRotationLambda);
            return this;
        }

        /**
         * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         * <p>
         * The rotation schedule is defined in <code>RotationRules</code> .
         * <p>
         * If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
         * <p>
         * If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
         * <p>
         * @return {@code this}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(final java.lang.Boolean rotateImmediatelyOnUpdate) {
            this.props.rotateImmediatelyOnUpdate(rotateImmediatelyOnUpdate);
            return this;
        }
        /**
         * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         * <p>
         * The rotation schedule is defined in <code>RotationRules</code> .
         * <p>
         * If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"><code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.
         * <p>
         * If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.
         * <p>
         * @return {@code this}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(final software.amazon.awscdk.IResolvable rotateImmediatelyOnUpdate) {
            this.props.rotateImmediatelyOnUpdate(rotateImmediatelyOnUpdate);
            return this;
        }

        /**
         * The ARN of an existing Lambda rotation function.
         * <p>
         * To specify a rotation function that is also defined in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function.
         * <p>
         * To create a new rotation function based on one of the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html">Secrets Manager rotation function templates</a> , specify <code>HostedRotationLambda</code> instead.
         * <p>
         * @return {@code this}
         * @param rotationLambdaArn The ARN of an existing Lambda rotation function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambdaArn(final java.lang.String rotationLambdaArn) {
            this.props.rotationLambdaArn(rotationLambdaArn);
            return this;
        }

        /**
         * A structure that defines the rotation configuration for this secret.
         * <p>
         * @return {@code this}
         * @param rotationRules A structure that defines the rotation configuration for this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(final software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty rotationRules) {
            this.props.rotationRules(rotationRules);
            return this;
        }
        /**
         * A structure that defines the rotation configuration for this secret.
         * <p>
         * @return {@code this}
         * @param rotationRules A structure that defines the rotation configuration for this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(final software.amazon.awscdk.IResolvable rotationRules) {
            this.props.rotationRules(rotationRules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule build() {
            return new software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
